/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.shapeMethods.PhotonicsDiscRingPulleys;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;

public class Spirals {
    public static ArrayList spiralArchimedes(double width, int turns, double separation, double inc, int gdsLayer) {
        double y;
        double x;
        double r;
        double upperLim = Math.PI * 2 * (double)turns;
        double a = (separation + width) / (Math.PI * 2);
        int numPts = (int)(upperLim / inc) + 1;
        double[] valX1 = new double[numPts + 1];
        double[] valY1 = new double[numPts + 1];
        double[] valX2 = new double[numPts + 1];
        double[] valY2 = new double[numPts + 1];
        ArrayList<GArea> archimedes = new ArrayList<GArea>();
        int up = 0;
        for (double i = 0.0; i <= upperLim; i += inc) {
            r = a * i;
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            valX1[up] = x;
            valY1[up] = y;
            ++up;
        }
        int down = up - 1;
        for (double j = upperLim; j >= 0.0; j -= inc) {
            r = a * j;
            x = (r + width) * Math.cos(j);
            y = (r + width) * Math.sin(j);
            valX2[down] = x;
            valY2[down] = y;
            --down;
        }
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        for (int i = 0; i < valX1.length - 1; ++i) {
            if (i == 0) {
                pathOut.moveTo(valX1[i], valY1[i]);
                pathBack.moveTo(valX2[i], valY2[i]);
            }
            pathOut.lineTo(valX1[i], valY1[i]);
            pathBack.lineTo(valX2[i], valY2[i]);
            if (!(i % 80 == 0 | i == valX1.length - 2)) continue;
            pathOut.append(GArea.reversePath(pathBack), true);
            pathOut.closePath();
            archimedes.add(new GArea(pathOut, gdsLayer));
            pathOut = new Path2D.Double();
            pathBack = new Path2D.Double();
            pathOut.moveTo(valX1[i], valY1[i]);
            pathBack.moveTo(valX2[i], valY2[i]);
        }
        return archimedes;
    }

    public static ArrayList spiralFermat(double width, int turns, double a, double inc, int gdsLayer) {
        double y;
        double x;
        double r;
        double upperLim = Math.PI * 2 * (double)turns;
        int numPts = (int)(upperLim / inc) + 1;
        double[] valX1 = new double[numPts + 1];
        double[] valY1 = new double[numPts + 1];
        double[] valX2 = new double[numPts + 1];
        double[] valY2 = new double[numPts + 1];
        ArrayList<GArea> fermat = new ArrayList<GArea>();
        int up = 0;
        for (double i = 0.0; i <= upperLim; i += inc) {
            r = Math.sqrt(a * a * i);
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            valX1[up] = x;
            valY1[up] = y;
            ++up;
        }
        int down = up - 1;
        for (double j = upperLim; j >= 0.0; j -= inc) {
            r = Math.sqrt(a * a * j);
            x = (r + width) * Math.cos(j);
            y = (r + width) * Math.sin(j);
            valX2[down] = x;
            valY2[down] = y;
            --down;
        }
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        for (int i = 0; i < valX1.length - 1; ++i) {
            if (i == 0) {
                pathOut.moveTo(valX1[i], valY1[i]);
                pathBack.moveTo(valX2[i], valY2[i]);
            }
            pathOut.lineTo(valX1[i], valY1[i]);
            pathBack.lineTo(valX2[i], valY2[i]);
            if (!(i % 80 == 0 | i == valX1.length - 2)) continue;
            pathOut.append(GArea.reversePath(pathBack), true);
            pathOut.closePath();
            fermat.add(new GArea(pathOut, gdsLayer));
            pathOut = new Path2D.Double();
            pathBack = new Path2D.Double();
            pathOut.moveTo(valX1[i], valY1[i]);
            pathBack.moveTo(valX2[i], valY2[i]);
        }
        return fermat;
    }

    public static ArrayList spiralLogarithmic(double width, int turns, double a, double b, double inc, int gdsLayer) {
        double y;
        double x;
        double r;
        double upperLim = Math.PI * 2 * (double)turns;
        int numPts = (int)(upperLim / inc) + 1;
        double[] valX1 = new double[numPts + 1];
        double[] valY1 = new double[numPts + 1];
        double[] valX2 = new double[numPts + 1];
        double[] valY2 = new double[numPts + 1];
        ArrayList<GArea> log = new ArrayList<GArea>();
        int up = 0;
        for (double i = 0.0; i <= upperLim; i += inc) {
            r = a * Math.exp(b * i);
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            valX1[up] = x;
            valY1[up] = y;
            ++up;
        }
        int down = up - 1;
        for (double j = upperLim; j >= 0.0; j -= inc) {
            r = a * Math.exp(b * j);
            x = (r + width) * Math.cos(j);
            y = (r + width) * Math.sin(j);
            valX2[down] = x;
            valY2[down] = y;
            --down;
        }
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        for (int i = 0; i < valX1.length - 1; ++i) {
            if (i == 0) {
                pathOut.moveTo(valX1[i], valY1[i]);
                pathBack.moveTo(valX2[i], valY2[i]);
            }
            pathOut.lineTo(valX1[i], valY1[i]);
            pathBack.lineTo(valX2[i], valY2[i]);
            if (!(i % 80 == 0 | i == valX1.length - 2)) continue;
            pathOut.append(GArea.reversePath(pathBack), true);
            pathOut.closePath();
            log.add(new GArea(pathOut, gdsLayer));
            pathOut = new Path2D.Double();
            pathBack = new Path2D.Double();
            pathOut.moveTo(valX1[i], valY1[i]);
            pathBack.moveTo(valX2[i], valY2[i]);
        }
        return log;
    }

    public static ArrayList<GArea> archimedesSpiralDelayLine(double Tx, double Ty, double width, int turns, double separation, double inc, double length, double THETA, int ENDCAP, int layer) {
        double r;
        double a = (separation + width) / (Math.PI * 2);
        double x = 0.0;
        double y = 0.0;
        ArrayList<Point2D.Double> spiral1 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> spiral2 = new ArrayList<Point2D.Double>();
        for (double i = 0.0; i <= 2.0 * (double)turns * Math.PI; i += inc) {
            r = a * i;
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            spiral1.add(new Point2D.Double(x, y));
        }
        spiral1.add(new Point2D.Double(((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).x, ((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).y + length));
        for (double j = 0.0; j <= 2.0 * (double)turns * Math.PI; j += inc) {
            r = -a * j;
            x = r * Math.cos(j);
            y = r * Math.sin(j);
            spiral2.add(new Point2D.Double(x, y));
        }
        spiral2.add(new Point2D.Double(((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).x, ((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).y - length));
        Collections.reverse(spiral2);
        spiral2.addAll(spiral1);
        return Spirals.createFracturedSpiralDelayLines(spiral2, Tx, Ty, width, THETA, ENDCAP, layer);
    }

    public static Point2D.Double addSpiralDelayLineLength(ArrayList<Point2D.Double> spiral2, double length) {
        Point2D.Double p = new Point2D.Double();
        return p;
    }

    public static ArrayList<GArea> archimedesSpiralDelayLineV2(double width, int turns, double pitch, int stepsPerTurn, int skippedTurns, double length, int ENDCAP, int layer) {
        double halfwidth = width / 2.0;
        ArrayList<GArea> archimedes = new ArrayList<GArea>();
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        pathOut.moveTo(0.0, 0.0);
        pathBack.moveTo(0.0, 0.0);
        Point2D.Double endPoint1 = new Point2D.Double();
        Point2D.Double endPoint2 = new Point2D.Double();
        Point2D.Double po = new Point2D.Double(0.0, 0.0);
        double fAng = 0.0;
        pitch /= Math.PI * 2;
        for (int j = skippedTurns; j < turns + skippedTurns; ++j) {
            for (int i = 0; i <= stepsPerTurn + 1; ++i) {
                double t = (1.0 * (double)i / (double)stepsPerTurn + (double)j) * Math.PI * 2.0;
                Point2D.Double pt = new Point2D.Double(t * pitch * Math.cos(t), t * pitch * Math.sin(t));
                if (i > 0) {
                    double ang = Math.atan2(((Point2D)pt).getY() - ((Point2D)po).getY(), ((Point2D)pt).getX() - ((Point2D)po).getX());
                    if (i == 1 && j == skippedTurns) {
                        fAng = ang;
                    }
                    Point2D.Double pt2 = pt;
                    pt = new Point2D.Double(-halfwidth * Math.sin(ang), halfwidth * Math.cos(ang));
                    pathOut.lineTo(((Point2D)po).getX() + ((Point2D)pt).getX(), ((Point2D)po).getY() + ((Point2D)pt).getY());
                    pathBack.lineTo(((Point2D)po).getX() - ((Point2D)pt).getX(), ((Point2D)po).getY() - ((Point2D)pt).getY());
                    if (j == turns + skippedTurns - 1 && i == stepsPerTurn + 1) {
                        endPoint1 = new Point2D.Double(pathOut.getCurrentPoint().getX(), pathOut.getCurrentPoint().getY());
                        endPoint2 = new Point2D.Double(pathBack.getCurrentPoint().getX(), pathBack.getCurrentPoint().getY());
                    }
                    po = pt2;
                    continue;
                }
                po = pt;
                pathOut = new Path2D.Double();
                pathBack = new Path2D.Double();
                pathOut.moveTo(((Point2D)po).getX(), ((Point2D)po).getY());
                pathBack.moveTo(((Point2D)po).getX(), ((Point2D)po).getY());
            }
            pathOut.append(GArea.reversePath(pathBack), true);
            pathOut.closePath();
            archimedes.add(new GArea(pathOut, layer));
            if (skippedTurns <= 0 || j != skippedTurns) continue;
            pathOut = new Path2D.Double();
            pathOut.moveTo(0.0, 0.0);
            double igp = (double)skippedTurns * pitch * Math.PI * 2.0;
            pathOut.curveTo(0.0, igp * 0.8, -igp * (1.0 - 0.8 * Math.cos(fAng)), 0.8 * igp * Math.sin(fAng), -igp, 0.0);
            BasicStroke s = new BasicStroke((float)halfwidth * 2.0f, 0, 0);
            archimedes.add(new GArea(s.createStrokedShape(pathOut), layer));
        }
        pathOut.moveTo(endPoint1.x, endPoint1.y);
        pathOut.lineTo(endPoint2.x, endPoint2.y);
        pathOut.lineTo(endPoint2.x, length);
        pathOut.lineTo(endPoint1.x, length);
        pathOut.closePath();
        archimedes.add(new GArea(pathOut, layer));
        if (ENDCAP != 0) {
            archimedes.add(PhotonicsDiscRingPulleys.createLeftEndCap((endPoint1.x + endPoint2.x) / 2.0, length, width, 90.0));
        }
        return archimedes;
    }

    public static ArrayList<GArea> archimedesSpiralDelayLineInvV2(double width, int turns, double pitch, int stepsPerTurn, int skippedTurns, double sleeveWidth, double length, int ENDCAP, int layer) {
        double halfwidth = width / 2.0;
        ArrayList<GArea> archimedes = new ArrayList<GArea>();
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        pathOut.moveTo(0.0, 0.0);
        pathBack.moveTo(0.0, 0.0);
        Point2D.Double endPoint1 = new Point2D.Double();
        Point2D.Double endPoint2 = new Point2D.Double();
        Point2D.Double po = new Point2D.Double(0.0, 0.0);
        double fAng = 0.0;
        pitch /= Math.PI * 2;
        for (int j = skippedTurns; j < turns + skippedTurns; ++j) {
            for (int i = 0; i <= stepsPerTurn + 1; ++i) {
                double t = (1.0 * (double)i / (double)stepsPerTurn + (double)j) * Math.PI * 2.0;
                Point2D.Double pt = new Point2D.Double(t * pitch * Math.cos(t), t * pitch * Math.sin(t));
                if (i > 0) {
                    double ang = Math.atan2(((Point2D)pt).getY() - ((Point2D)po).getY(), ((Point2D)pt).getX() - ((Point2D)po).getX());
                    if (i == 1 && j == skippedTurns) {
                        fAng = ang;
                    }
                    Point2D.Double pt2 = pt;
                    pt = new Point2D.Double(-halfwidth * Math.sin(ang), halfwidth * Math.cos(ang));
                    pathOut.lineTo(((Point2D)po).getX() + ((Point2D)pt).getX(), ((Point2D)po).getY() + ((Point2D)pt).getY());
                    pathBack.lineTo(((Point2D)po).getX() - ((Point2D)pt).getX(), ((Point2D)po).getY() - ((Point2D)pt).getY());
                    if (j == turns + skippedTurns - 1 && i == stepsPerTurn + 1) {
                        endPoint1 = new Point2D.Double(pathOut.getCurrentPoint().getX(), pathOut.getCurrentPoint().getY());
                        endPoint2 = new Point2D.Double(pathBack.getCurrentPoint().getX(), pathBack.getCurrentPoint().getY());
                    }
                    po = pt2;
                    continue;
                }
                po = pt;
                pathOut = new Path2D.Double();
                pathBack = new Path2D.Double();
                pathOut.moveTo(((Point2D)po).getX(), ((Point2D)po).getY());
                pathBack.moveTo(((Point2D)po).getX(), ((Point2D)po).getY());
            }
            pathOut.append(GArea.reversePath(pathBack), true);
            pathOut.closePath();
            archimedes.add(new GArea(pathOut, layer));
            if (skippedTurns <= 0 || j != skippedTurns) continue;
            pathOut = new Path2D.Double();
            pathOut.moveTo(0.0, 0.0);
            double igp = (double)skippedTurns * pitch * Math.PI * 2.0;
            pathOut.curveTo(0.0, igp * 0.8, -igp * (1.0 - 0.8 * Math.cos(fAng)), 0.8 * igp * Math.sin(fAng), -igp, 0.0);
            BasicStroke s = new BasicStroke((float)halfwidth * 2.0f, 0, 0);
            archimedes.add(new GArea(s.createStrokedShape(pathOut), layer));
        }
        pathOut.moveTo(endPoint1.x, endPoint1.y);
        pathOut.lineTo(endPoint2.x, endPoint2.y);
        pathOut.lineTo(endPoint2.x, length);
        pathOut.lineTo(endPoint1.x, length);
        pathOut.closePath();
        archimedes.add(new GArea(pathOut, layer));
        if (ENDCAP != 0) {
            archimedes.add(PhotonicsDiscRingPulleys.createLeftEndCap((endPoint1.x + endPoint2.x - width + sleeveWidth) / 2.0, length, sleeveWidth, 90.0));
            archimedes.add(PhotonicsDiscRingPulleys.createLeftEndCap((endPoint1.x + endPoint2.x + width - sleeveWidth) / 2.0, length, sleeveWidth, 90.0));
        }
        return archimedes;
    }

    public static ArrayList<GArea> fermatSpiralDelayLine(double Tx, double Ty, double width, int turns, double a, double inc, double length, double THETA, int ENDCAP, int layer) {
        double r;
        double x = 0.0;
        double y = 0.0;
        ArrayList<Point2D.Double> spiral1 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> spiral2 = new ArrayList<Point2D.Double>();
        for (double i = 0.0; i <= 2.0 * (double)turns * Math.PI; i += inc) {
            r = a * Math.sqrt(i);
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            spiral1.add(new Point2D.Double(x, y));
        }
        spiral1.add(new Point2D.Double(((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).x, ((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).y + length));
        for (double j = 0.0; j <= 2.0 * (double)turns * Math.PI; j += inc) {
            r = -a * Math.sqrt(j);
            x = r * Math.cos(j);
            y = r * Math.sin(j);
            spiral2.add(new Point2D.Double(x, y));
        }
        spiral2.add(new Point2D.Double(((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).x, ((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).y - length));
        Collections.reverse(spiral2);
        spiral2.addAll(spiral1);
        return Spirals.createFracturedSpiralDelayLines(spiral2, Tx, Ty, width, THETA, ENDCAP, layer);
    }

    public static ArrayList<GArea> archimedesSpiralDelayLineINVERSE(double Tx, double Ty, double width, double sleeveWidth, int turns, double separation, double inc, double length, double THETA, int ENDCAP, int layer) {
        double r;
        double a = (separation + width) / (Math.PI * 2);
        double x = 0.0;
        double y = 0.0;
        ArrayList<Point2D.Double> spiral1 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> spiral2 = new ArrayList<Point2D.Double>();
        for (double i = 0.0; i <= 2.0 * (double)turns * Math.PI; i += inc) {
            r = a * i;
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            spiral1.add(new Point2D.Double(x, y));
        }
        spiral1.add(new Point2D.Double(((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).x, ((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).y + length));
        for (double j = 0.0; j <= 2.0 * (double)turns * Math.PI; j += inc) {
            r = -a * j;
            x = r * Math.cos(j);
            y = r * Math.sin(j);
            spiral2.add(new Point2D.Double(x, y));
        }
        spiral2.add(new Point2D.Double(((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).x, ((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).y - length));
        Collections.reverse(spiral2);
        spiral2.addAll(spiral1);
        return Spirals.createFracturedSpiralDelayLineINVERSE(spiral2, Tx, Ty, width, sleeveWidth, THETA, ENDCAP, layer);
    }

    public static ArrayList<GArea> fermatSpiralDelayLineINVERSE(double Tx, double Ty, double width, double sleeveWidth, int turns, double a, double inc, double length, double THETA, int ENDCAP, int layer) {
        double r;
        double x = 0.0;
        double y = 0.0;
        ArrayList<Point2D.Double> spiral1 = new ArrayList<Point2D.Double>();
        ArrayList<Point2D.Double> spiral2 = new ArrayList<Point2D.Double>();
        for (double i = 0.0; i <= 2.0 * (double)turns * Math.PI; i += inc) {
            r = a * Math.sqrt(i);
            x = r * Math.cos(i);
            y = r * Math.sin(i);
            spiral1.add(new Point2D.Double(x, y));
        }
        spiral1.add(new Point2D.Double(((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).x, ((Point2D.Double)spiral1.get((int)(spiral1.size() - 1))).y + length));
        for (double j = 0.0; j <= 2.0 * (double)turns * Math.PI; j += inc) {
            r = -a * Math.sqrt(j);
            x = r * Math.cos(j);
            y = r * Math.sin(j);
            spiral2.add(new Point2D.Double(x, y));
        }
        spiral2.add(new Point2D.Double(((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).x, ((Point2D.Double)spiral2.get((int)(spiral2.size() - 1))).y - length));
        Collections.reverse(spiral2);
        spiral2.addAll(spiral1);
        return Spirals.createFracturedSpiralDelayLineINVERSE(spiral2, Tx, Ty, width, sleeveWidth, THETA, ENDCAP, layer);
    }

    public static ArrayList<GArea> createFracturedSpiralDelayLineINVERSE(ArrayList<Point2D.Double> alP2D, double Tx, double Ty, double width, double sleeveWidth, double THETA, int ENDCAP, int layer) {
        ArrayList<GArea> spiralDelayLine = new ArrayList<GArea>();
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(alP2D.get((int)0).x, alP2D.get((int)0).y);
        for (int i = 1; i < alP2D.size(); ++i) {
            poly.lineTo(alP2D.get((int)i).x, alP2D.get((int)i).y);
        }
        BasicStroke wg = new BasicStroke((float)width, 0, 0);
        wg.createStrokedShape(poly);
        GArea gaWG = new GArea(wg.createStrokedShape(poly), layer);
        BasicStroke sleeve = new BasicStroke((float)sleeveWidth, 0, 0);
        sleeve.createStrokedShape(poly);
        GArea gaSLEEVE = new GArea(sleeve.createStrokedShape(poly), layer);
        gaSLEEVE.subtract(gaWG);
        if (ENDCAP != 0) {
            double sleeveWidthAsDefined = (sleeveWidth - width) / 2.0;
            gaSLEEVE.or(PhotonicsDiscRingPulleys.createLeftEndCap(alP2D.get((int)0).x - (width + sleeveWidthAsDefined) / 2.0, alP2D.get((int)0).y, sleeveWidthAsDefined, -90.0));
            gaSLEEVE.or(PhotonicsDiscRingPulleys.createLeftEndCap(alP2D.get((int)0).x + (width + sleeveWidthAsDefined) / 2.0, alP2D.get((int)0).y, sleeveWidthAsDefined, -90.0));
            gaSLEEVE.or(PhotonicsDiscRingPulleys.createLeftEndCap(alP2D.get((int)(alP2D.size() - 1)).x - (width + sleeveWidthAsDefined) / 2.0, alP2D.get((int)(alP2D.size() - 1)).y, sleeveWidthAsDefined, 90.0));
            gaSLEEVE.or(PhotonicsDiscRingPulleys.createLeftEndCap(alP2D.get((int)(alP2D.size() - 1)).x + (width + sleeveWidthAsDefined) / 2.0, alP2D.get((int)(alP2D.size() - 1)).y, sleeveWidthAsDefined, 90.0));
        }
        Area a = new Area(gaSLEEVE.getArea());
        Rectangle2D rec = a.getBounds2D();
        Rect r = new Rect(0.0, rec.getMinY(), rec.getMaxX(), rec.getMaxY(), 7);
        gaSLEEVE.and(r);
        GArea leftSide = new GArea(a, layer);
        r = new Rect(rec.getMinX(), rec.getMinY(), 0.0, rec.getMaxY(), 7);
        leftSide.and(r);
        gaSLEEVE.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        leftSide.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        gaSLEEVE.transform(AffineTransform.getRotateInstance(THETA, Tx, Ty));
        leftSide.transform(AffineTransform.getRotateInstance(THETA, Tx, Ty));
        spiralDelayLine.add(gaSLEEVE);
        spiralDelayLine.add(leftSide);
        return spiralDelayLine;
    }

    public static ArrayList<GArea> archimedesV2FracturedDelayLineINVERSE(ArrayList<GArea> waveguide, ArrayList<GArea> sleeve, double Tx, double Ty, double THETA, int layer) {
        int i;
        ArrayList<GArea> inverseStructure = new ArrayList<GArea>();
        Area wg = new Area();
        Area wgRotated = new Area();
        Area sl = new Area();
        Area slRotated = new Area();
        for (i = 0; i < waveguide.size(); ++i) {
            wg.add(waveguide.get(i).getArea());
            wgRotated.add(waveguide.get(i).getArea());
        }
        wgRotated.transform(AffineTransform.getRotateInstance(Math.PI));
        wg.add(wgRotated);
        for (i = 0; i < sleeve.size(); ++i) {
            sl.add(sleeve.get(i).getArea());
            slRotated.add(sleeve.get(i).getArea());
        }
        slRotated.transform(AffineTransform.getRotateInstance(Math.PI));
        sl.add(slRotated);
        sl.subtract(wg);
        GArea inverse = new GArea(sl, layer);
        Area invArea = new Area(inverse.getArea());
        Rectangle2D rec = invArea.getBounds2D();
        Rect r = new Rect(0.0, rec.getMinY(), rec.getMaxX(), rec.getMaxY(), layer);
        inverse.and(r);
        GArea leftSide = new GArea(invArea, layer);
        r = new Rect(rec.getMinX(), rec.getMinY(), 0.0, rec.getMaxY(), layer);
        leftSide.and(r);
        inverse.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        leftSide.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        inverse.transform(AffineTransform.getRotateInstance(THETA, Tx, Ty));
        leftSide.transform(AffineTransform.getRotateInstance(THETA, Tx, Ty));
        inverseStructure.add(inverse);
        inverseStructure.add(leftSide);
        return inverseStructure;
    }

    public static ArrayList<GArea> createFracturedSpiralDelayLines(ArrayList<Point2D.Double> alP2D, double Tx, double Ty, double width, double THETA, int ENDCAP, int layer) {
        ArrayList<GArea> spiralDelayLine = new ArrayList<GArea>();
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(alP2D.get((int)0).x, alP2D.get((int)0).y);
        for (int i = 1; i < alP2D.size(); ++i) {
            poly.lineTo(alP2D.get((int)i).x, alP2D.get((int)i).y);
        }
        int endCap = ENDCAP == 0 ? 0 : 1;
        BasicStroke s = new BasicStroke((float)width, endCap, 0);
        s.createStrokedShape(poly);
        GArea gaSpiral = new GArea(s.createStrokedShape(poly), layer);
        Area a = new Area(gaSpiral.getArea());
        Rectangle2D rec = a.getBounds2D();
        Rect r = new Rect(0.0, rec.getMinY(), rec.getMaxX(), rec.getMaxY(), 7);
        gaSpiral.and(r);
        GArea leftSide = new GArea(a, layer);
        r = new Rect(rec.getMinX(), rec.getMinY(), 0.0, rec.getMaxY(), 7);
        leftSide.and(r);
        gaSpiral.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        leftSide.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        gaSpiral.transform(AffineTransform.getRotateInstance(THETA, Tx, Ty));
        leftSide.transform(AffineTransform.getRotateInstance(THETA, Tx, Ty));
        spiralDelayLine.add(gaSpiral);
        spiralDelayLine.add(leftSide);
        return spiralDelayLine;
    }
}

