/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.FunctionPlot;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class MeanderChannels {
    public static ArrayList<GArea> createMeanderChannels(double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, int numCurveSegments, double x1, double x2, double x3, int FUNCTION) {
        double startX = L1 / 2.0;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(startX, 0.0);
        path.lineTo(startX + x1, 0.0);
        switch (FUNCTION) {
            case 0: {
                MeanderChannels.funcSine(path, startX, amplitude, numPeriods, x1, x2, numCurveSegments);
                break;
            }
            case 1: {
                MeanderChannels.funcRamp(path, startX, amplitude, numPeriods, x1, x2);
                break;
            }
            case 2: {
                MeanderChannels.funcTriangle(path, startX, amplitude, numPeriods, x1, x2);
                break;
            }
            case 3: {
                MeanderChannels.funcSquare(path, startX, amplitude, numPeriods, x1, x2);
                break;
            }
            default: {
                System.out.println("ERROR MESSAGE!!");
            }
        }
        path.lineTo(startX + x1 + x2, 0.0);
        path.lineTo(startX + x1 + x2 + x3, 0.0);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea mGA = new GArea(bs.createStrokedShape(path), CNSTscriptingController.getGdsLayer());
        Rect rL = new Rect(-L1 / 2.0, -H1 / 2.0, L1 / 2.0, H1 / 2.0, CNSTscriptingController.getGdsLayer());
        double centerR2 = startX + x1 + x2 + x3 + L2 / 2.0;
        Rect rR = new Rect(centerR2 - L2 / 2.0, -H2 / 2.0, centerR2 + L2 / 2.0, H2 / 2.0, CNSTscriptingController.getGdsLayer());
        GArea r = new GArea();
        mGA.or(rL);
        mGA.or(rR);
        ArrayList<GArea> gaAL = FunctionPlot.fractureShape(mGA);
        return gaAL;
    }

    public static Path2D.Double funcSine(Path2D.Double path, double startX, double amplitude, int periods, double x1, double x2, double numCurveSegments) {
        double n = 1.0 / (x2 / (double)periods);
        for (double i = 0.0; i <= x2; i += x2 / numCurveSegments) {
            path.lineTo(i + startX + x1, amplitude * Math.sin(Math.PI * 2 * n * i));
        }
        return path;
    }

    public static void funcRamp(Path2D.Double path, double startX, double amplitude, int periods, double x1, double x2) {
        double delta;
        for (double i = delta = x2 / (double)(periods * 2); i <= x2; i += delta) {
            path.lineTo(i + startX + x1, amplitude);
            path.lineTo(i + startX + x1, -amplitude);
            path.lineTo((i += delta) + startX + x1, 0.0);
        }
    }

    public static void funcTriangle(Path2D.Double path, double startX, double amplitude, int periods, double x1, double x2) {
        double delta;
        for (double i = delta = x2 / (double)(periods * 3); i <= x2; i += delta) {
            path.lineTo(i + startX + x1, amplitude);
            path.lineTo(i + delta + startX + x1, -amplitude);
            path.lineTo(i + 2.0 * delta + startX + x1, 0.0);
            i += 2.0 * delta;
        }
    }

    public static void funcSquare(Path2D.Double path, double startX, double amplitude, int periods, double x1, double x2) {
        double delta = x2 / (double)(periods * 2);
        for (double i = 0.0; i < x2; i += delta) {
            path.lineTo(i + startX + x1, amplitude);
            path.lineTo(i + delta + startX + x1, amplitude);
            path.lineTo(i + delta + startX + x1, -amplitude);
            path.lineTo(i + 2.0 * delta + startX + x1, -amplitude);
            path.lineTo(i + 2.0 * delta + startX + x1, 0.0);
            i += delta;
        }
    }
}

