/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Array;
import JGDS2.BarCode;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class GenericReticleFrameController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    final int ASMLPAS5500300CDUV = 1;
    final int CONTACT5INCH = 2;
    final int CONTACT7INCH = 3;
    final int ASMLPAS5000ANL = 4;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfBarcode;
    @FXML
    private TextField tfLabel;
    @FXML
    private ComboBox<String> cbTargetList;
    @FXML
    private ComboBox<String> cbFontList;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Generic Reticle Frame Module", "This module creates reticle frames for several platforms including the GCA Autostep 200 (AS200) and 6300 DSW, ASML PAS5500 300C DUV, various contact aligners and the ASML PAS5000 i-line (currently at Argonne National Laboratory). GCA option creates a label, the AS200 barode and RMS marks, along with reticle marks for the 6300 DSW (for either the 5X or 10X reduction tools).");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.cbFontList.getItems().add((Object)fontFamilies[i]);
        }
        this.cbFontList.setValue((Object)"Serif");
        this.cbFontList.setVisibleRowCount(11);
        this.cbTargetList.getItems().addAll((Object[])new String[]{"GCA AS200 - GCA 6300 DSW", "ASML PAS5500300C DUV", "Contact 5 Inch", "Contact 7 Inch", "ASML PAS5000 (ANL)"});
        this.cbTargetList.setValue((Object)"GCA AS200 - GCA 6300 DSW");
        this.cbTargetList.setVisibleRowCount(5);
        this.tfFileName.setText(this.getDate());
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(GenericReticleFrameController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) throws FileNotFoundException {
        String fileName = this.tfFileName.getText();
        String barcode = this.tfBarcode.getText();
        String label = this.tfLabel.getText();
        String fontType = (String)this.cbFontList.getValue();
        int toolIndex = this.cbTargetList.getSelectionModel().selectedIndexProperty().intValue();
        Lib lib = new Lib();
        lib.add(new Ref(this.frame(toolIndex, barcode, label, fontType), 875.0, -875.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    public Struct frame(int tool, String barcode, String label, String font) throws FileNotFoundException {
        Struct f = null;
        switch (tool) {
            case 0: {
                Struct line = new Struct("l", new Rect(30.0, 10.0, 285.0, 20.0, 1));
                Struct al = new Struct("al", new Array(line, 0.0, 0.0, 1, 10, 1.0, 300.0));
                Struct sqr = new Struct("sqr", new Rect(-1000.0, -1000.0, 1000.0, 1000.0, 1));
                Struct mx = new Struct("Mx");
                mx.add(new Ref(al, 0.0, 0.0));
                mx.add(new Ref(al, 0.0, 0.0, 0, 90.0));
                mx.add(new Ref(al, 0.0, 0.0, 0, 180.0));
                mx.add(new Ref(al, 0.0, 0.0, 0, 270.0));
                Struct sqr2 = new Struct("sqr2", new Rect(12.5, 12.5, 312.5, 312.5, 1));
                Struct m2 = new Struct("M2");
                m2.add(new Ref(sqr2, 0.0, 0.0));
                m2.add(new Ref(sqr2, 0.0, 0.0, 0, 90.0));
                m2.add(new Ref(sqr2, 0.0, 0.0, 0, 180.0));
                m2.add(new Ref(sqr2, 0.0, 0.0, 0, 270.0));
                BarCode bc = new BarCode(barcode.substring(0, barcode.length() < 10 ? barcode.length() : 10), 0, 1);
                Struct brcd = new Struct("barcode", bc);
                Text lb = new Text(label.substring(0, label.length() < 10 ? label.length() : 10), 1, 2500.0);
                lb.setFont(font);
                Struct lbl = new Struct("label", lb);
                f = new Struct("frame");
                f.add(new Ref(mx, -48000.0, 0.0));
                f.add(new Ref(mx, 48000.0, 0.0));
                f.add(new Ref(mx, 0.0, 48000.0));
                f.add(new Ref(mx, 0.0, -48000.0));
                f.add(new Ref(m2, 51500.0, 0.0));
                f.add(new Ref(m2, -51500.0, 0.0));
                f.add(new Ref(sqr, 0.0, 57500.0));
                f.add(new Ref(sqr, 0.0, -57500.0));
                f.add(new Ref(sqr, -11000.0, 57500.0));
                f.add(new Ref(brcd, -50000.0, 56000.0));
                f.add(new Ref(lbl, -50000.0, -58500.0));
                break;
            }
            case 1: {
                GArea pr = new GArea(new Rect(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                Rect r = new Rect(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new Rect(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new Rect(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new Rect(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct line = new Struct("l", new Rect(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new Rect(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(line, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new Rect(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new Rect(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new Rect(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new Rect(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode.substring(0, barcode.length() < 12 ? barcode.length() : 12), 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label.substring(0, label.length() < 14 ? label.length() : 14), 1, 3500.0);
                lb.setFont(font);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f = new Struct("frame");
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
                break;
            }
            case 2: {
                Font fnt = new Font(font, 0, 3500);
                Text lb = new Text(label.substring(0, label.length() < 22 ? label.length() : 22), 1, fnt);
                lb.setFontSize(3200.0);
                lb.setRenderReso(1.0);
                Struct lbl = new Struct("label", lb);
                Area a = new Area(lbl.getArea());
                Rectangle2D rec = a.getBounds2D();
                f = new Struct("frame");
                f.add(new Ref(lbl, -rec.getCenterX(), -58000.0));
                break;
            }
            case 3: {
                Font fnt = new Font(font, 0, 3500);
                Text lb = new Text(label.substring(0, label.length() < 22 ? label.length() : 22), 1, fnt);
                lb.setFontSize(3500.0);
                lb.setRenderReso(1.0);
                Struct lbl = new Struct("label", lb);
                Area a = new Area(lbl.getArea());
                Rectangle2D rec = a.getBounds2D();
                f = new Struct("frame");
                f.add(new Ref(lbl, -rec.getCenterX(), -83900.0));
                break;
            }
            case 4: {
                GArea pr = new GArea(new Rect(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                Rect r = new Rect(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new Rect(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new Rect(-12.5, -2.5, 12.5, 2.5, 1));
                pr.subtract(new Rect(-2.5, -12.5, 2.5, 12.5, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct line = new Struct("l", new Rect(100.0, 100.0, 920.0, 120.0, 1));
                Struct l2 = new Struct("l2", new Rect(-122.0, 100.0, -100.0, 920.0, 1));
                Struct al = new Struct("al", new Array(line, 0.0, 0.0, 1, 21, 1.0, 840.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -836.0, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new Rect(-80.0, -80.0, 80.0, 80.0, 1));
                m.subtract(new Rect(-12.5, -2.5, 12.5, 2.5, 1));
                m.subtract(new Rect(-2.5, -12.5, 2.5, 12.5, 1));
                m.and(new Rect(-914.0, -914.0, 920.0, 920.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode.substring(0, barcode.length() < 12 ? barcode.length() : 12), 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label.substring(0, label.length() < 14 ? label.length() : 14), 1, 3500.0);
                lb.setFont(font);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f = new Struct("frame");
                f.add(new Ref(pre, -55000.0, 55500.0));
                f.add(new Ref(pre, 55000.0, 55500.0));
                f.add(new Ref(mx, -48000.0, 0.0));
                f.add(new Ref(mx, 48000.0, 0.0));
                f.add(new Ref(mx, -55500.0, 0.0));
                f.add(new Ref(mx, 55500.0, 0.0));
                f.add(new Ref(brcd, 55500.0, 27150.0));
                f.add(new Ref(lbl, -55500.0, 27150.0));
                f.add(new Rect(20300.0, 55000.0, 25300.0, 55300.0, 1));
                f.add(new Rect(43500.0, 30000.0, 43800.0, 35000.0, 1));
                f.add(new Rect(-19700.0, -55300.0, -14700.0, -55000.0, 1));
                f.add(new Rect(-43800.0, -35000.0, -43500.0, -30000.0, 1));
            }
        }
        return f;
    }

    public String getDate() {
        Date date = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
        String dateStr = ft.format(date);
        return dateStr;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

