/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.machineResources.CNSTReticleLogoEPS;
import JGDS2.GArea;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;

public class CNSTReticleLogo
implements CNSTReticleLogoEPS {
    static Struct createLogo() throws FileNotFoundException {
        Struct CNSTlogo = new Struct("LogoCNST");
        double circRad = 100.0;
        int layer = 1;
        double offset = 4.0;
        GArea invQuarterCircle = CNSTReticleLogo.createInvQuarterCircle(0.0, 0.0, circRad, circRad, offset, 88, layer);
        GArea gaUR = CNSTReticleLogo.createEllipse(circRad * 0.45, circRad * 0.45, circRad / 4.0, circRad / 4.0, 88, layer);
        gaUR.or(new Rect(circRad * 0.45 - circRad * 0.17 / 4.0, 0.0, circRad * 0.45 + circRad * 0.17 / 4.0, circRad / 4.0, layer));
        gaUR.or(new Rect(0.0, circRad * 0.45 - circRad * 0.17 / 4.0, circRad / 4.0, circRad * 0.45 + circRad * 0.17 / 4.0, layer));
        Area aUR = new Area(gaUR.getArea());
        Area invQuarCir = new Area(invQuarterCircle.getArea());
        aUR.add(invQuarCir);
        aUR.transform(AffineTransform.getTranslateInstance(offset, offset));
        GArea upperRight = new GArea(aUR, layer);
        CNSTlogo.add(upperRight);
        GArea quarterCircle = CNSTReticleLogo.createQuarterCircle(0.0, 0.0, circRad, circRad, 88, 4);
        Area aQC = new Area(quarterCircle.getArea());
        Area aUL = new Area(gaUR.getArea());
        aQC.subtract(aUL);
        GArea genRect = new GArea(new Rect(0.0, -offset * 2.0, circRad * 0.45 - circRad * 0.17 / 4.0, 0.0, layer), layer);
        Area genArea = new Area(genRect.getArea());
        aQC.add(genArea);
        genRect = new GArea(new Rect(circRad * 0.45 + circRad * 0.17 / 4.0, -offset * 2.0, circRad * 1.6, 0.0, layer), layer);
        genArea = new Area(genRect.getArea());
        aQC.add(genArea);
        genRect = new GArea(new Rect(-offset * 2.0, -offset * 2.0, 0.0, circRad * 0.45 - circRad * 0.17 / 4.0, layer), layer);
        genArea = new Area(genRect.getArea());
        aQC.add(genArea);
        genRect = new GArea(new Rect(-offset * 2.0, circRad * 0.45 + circRad * 0.17 / 4.0, 0.0, circRad * 1.6, layer), layer);
        genArea = new Area(genRect.getArea());
        aQC.add(genArea);
        aQC.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        aQC.transform(AffineTransform.getTranslateInstance(-offset, offset));
        GArea upperLeft = new GArea(aQC, layer);
        CNSTlogo.add(upperLeft);
        genArea = new Area(upperLeft.getArea());
        genArea.transform(AffineTransform.getRotateInstance(Math.PI));
        GArea lowerRight = new GArea(genArea, layer);
        CNSTlogo.add(lowerRight);
        genArea = new Area(upperRight.getArea());
        genArea.transform(AffineTransform.getRotateInstance(Math.PI));
        GArea lowerLeft = new GArea(genArea, layer);
        CNSTlogo.add(lowerLeft);
        Struct CNSTlogoLetters = new Struct("LogoCNSTletters");
        CNSTlogoLetters.add(CNSTReticleLogo.createCNSTlogo(layer));
        Struct NISTlogo = new Struct("LogoNISTletters");
        NISTlogo.add(CNSTReticleLogo.createNISTlogo(layer));
        Struct logo = new Struct("logo");
        logo.add(new Ref(NISTlogo, -9000.0, 0.0, 0, 32.0, 0.0));
        logo.add(new Ref(CNSTlogo, 0.0, 0.0, 0, 22.0, 0.0));
        logo.add(new Ref(CNSTlogoLetters, 9800.0, 0.0, 0, 32.0, 0.0));
        return logo;
    }

    public static GArea createEllipse(double x, double y, double radiusX, double radiusY, int numSides, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + radiusX, y);
        int steps = numSides;
        double c = Math.PI * 2 / (double)numSides;
        for (int i = 0; i < steps; ++i) {
            poly.lineTo(x + radiusX * Math.cos((double)i * c), y + radiusY * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static GArea createQuarterCircle(double x, double y, double radiusX, double radiusY, int NumSides, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x, y);
        poly.lineTo(x + radiusX, y);
        int steps = NumSides;
        double c = Math.PI / (double)(2 * NumSides);
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(radiusX * Math.cos((double)i * c), radiusY * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static GArea createInvQuarterCircle(double x, double y, double radiusX, double radiusY, double offset, int NumSides, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + radiusX, y);
        int steps = NumSides;
        double c = Math.PI / (double)(2 * NumSides);
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(radiusX * Math.cos((double)i * c), radiusY * Math.sin((double)i * c));
        }
        poly.lineTo(0.0, 1.05 * radiusY + offset);
        poly.lineTo(1.05 * radiusX + offset, 1.05 * radiusY + offset);
        poly.lineTo(1.05 * radiusX + offset, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static GArea createNISTlogo(int layer) throws FileNotFoundException {
        double pixelValue = 1.0;
        int gdsLayer = layer;
        double resolutionGrid = 0.001;
        ArrayList<Path2D.Double> nistEPS = CNSTReticleLogo.readData("15.391 10.263 m 15.281 10.541 15.242 24.369 15.305 40.99 c 15.414 71.021\n 15.418 71.228 16.262 73.287 c 18.09 77.748 21.402 80.947 26.102 82.787 c 27.781 83.447 29.148 83.654 31.996 83.673 c 36.109 83.705 38.465 83.083 41.449 81.193 c 42.523 80.513 52.695 69.806 67.477 53.791 c 80.824 39.337 92.156 27.177 92.664 26.775 c 93.176 26.369 93.867 26.142 94.207 26.275 c 94.758 26.486 94.82 29.337 94.82 54.201 c 94.82 78.849 94.887 81.955 95.434 82.501 c 95.949 83.013 97.207 83.115 103.141 83.111 c 107.043 83.107 110.457 82.962 110.73 82.791 c 111.125 82.541 111.203 76.33 111.121 52.259 c 111.016 22.048 l 109.914 19.802 l 108.242 16.4 105.387 13.513 102.102 11.912 c 95.695 8.783 89.711 9.369 82.992 13.787 c 81.836 14.548 72.137 24.779 57.719 40.443 c 44.848 54.423 33.996 65.943 33.602 66.048 c 33.211 66.15 32.602 66.072 32.246 65.876 c 31.664 65.548 31.605 63.138 31.605 38.392 c 31.605 20.439 31.469 11.009 31.203 10.509 c 30.824 9.802 30.313 9.755 23.191 9.755 c 17.313 9.755 15.539 9.869 15.391 10.263 c h 136.379 10.33 m 130.105 11.708 124.738 15.443 122.242 20.173 c 119.645 25.087 119.598 25.701 119.598 55.521 c 119.598 78.955 119.676 82.412 120.184 82.732 c 120.949 83.216 134.641 83.216 135.402 82.732 c 135.91 82.412 136.016 78.787 136.184 55.291 c 136.34 33.556 136.48 28.091 136.898 27.591 c 138.246 25.966 138.68 25.951 176.25 25.951 c 212.133 25.951 212.219 25.951 213.32 26.767 c 216.117 28.837 216.887 31.806 215.391 34.74 c 213.82 37.818 215.457 37.63 188.098 37.865 c 161.223 38.099 162.512 37.982 157.031 40.654 c 151.621 43.291 146.879 48.076 145.109 52.677 c 142.391 59.755 143.809 68.771 148.582 74.771 c 151.602 78.572 157.566 81.74 163.5 82.701 c 166.23 83.142 287.395 83.314 288.527 82.876 c 289.063 82.673 289.145 81.58 289.145 74.685 c 289.145 70.306 289.102 66.689 289.047 66.638 c 288.996 66.591 282.102 66.462 273.734 66.349 c 258.516 66.142 l 258.32 38.044 l 258.125 9.951 l 242.516 9.951 l 242.414 38.142 l 242.316 66.337 l 165.566 66.337 l 164.25 65.447 l 159.984 62.576 159.809 57.677 163.887 55.412 c 165.645 54.435 l 191.398 54.24 l 216.688 54.048 217.188 54.029 219.215 53.201 c 225.48 50.63 229.602 45.982 231.633 39.197 c 232.547 36.146 232.559 28.955 231.66 25.271 c 229.848 17.841 225.191 12.462 218.871 10.494 c 216.605 9.791 214.73 9.755 177.609 9.787 c 146.98 9.81 138.223 9.927 136.379 10.33 c h".split(" "), pixelValue);
        Area a = new Area();
        for (int i = 0; i < nistEPS.size(); ++i) {
            a.add(new GArea(nistEPS.get(i), layer).getArea());
        }
        Rectangle2D rec = a.getBounds2D();
        a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
        GArea nistLogo = new GArea(a, layer);
        return nistLogo;
    }

    public static GArea createCNSTlogo(int layer) throws FileNotFoundException {
        double pixelValue = 1.0;
        int gdsLayer = layer;
        double resolutionGrid = 0.001;
        ArrayList<Path2D.Double> nistEPS = CNSTReticleLogo.readData("73.469 67.147 m 66.336 73.831 56.469 77.928 46.125 77.928 c 26.156 77.928 9.984 62.19 9.984 44.299 c 9.984 26.405 26.273 10.674 46.363 10.674 c 56.465 10.674 66.332 14.983 73.469 21.448 c 73.469 10.237 l 65.738 5.178 56.23 2.264 46.723 2.264 c 21.398 2.26 0 20.909 0 43.971 c 0 67.257 21.043 86.335 46.723 86.335 c 56.707 86.335 65.504 83.745 73.469 78.358 c h 90.941 88.382 m 160.84 21.987 l 160.84 84.932 l 170.828 84.932 l 170.828 -0.001 l 100.926 66.288 l 100.926 3.663 l 90.941 3.663 l h 230.145 69.089 m 226.578 74.694 222.301 77.928 214.695 77.928 c 206.727 77.928 199.832 72.753 199.832 65.319 c 199.832 58.307 207.797 55.077 213.859 52.6 c 219.805 50.225 l 231.457 45.589 241.316 40.311 241.316 27.374 c 241.316 13.147 228.719 2.264 213.145 2.264 c 198.762 2.264 188.063 10.671 185.207 23.28 c 194.957 25.757 l 196.266 17.46 203.277 10.671 212.91 10.671 c 222.539 10.671 231.332 17.354 231.332 26.51 c 231.332 35.995 223.133 39.229 214.813 42.682 c 209.348 44.839 l 198.887 49.147 189.848 53.995 189.848 65.639 c 189.848 78.249 201.617 86.335 214.934 86.335 c 224.918 86.335 233.355 81.698 238.113 73.725 c h 279.719 3.663 m 269.73 3.663 l 269.73 76.53 l 248.094 76.53 l 248.094 84.932 l 301.59 84.932 l 301.59 76.53 l 279.719 76.53 l h".split(" "), pixelValue);
        Area a = new Area();
        for (int i = 0; i < nistEPS.size(); ++i) {
            a.add(new GArea(nistEPS.get(i), layer).getArea());
        }
        Rectangle2D rec = a.getBounds2D();
        a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
        GArea nistLogo = new GArea(a, layer);
        return nistLogo;
    }

    public static ArrayList<Path2D.Double> readData(Scanner input, double pixelValue) {
        ArrayList<Path2D.Double> path = new ArrayList<Path2D.Double>();
        Path2D.Double p2dTemp = new Path2D.Double();
        while (input.hasNext()) {
            ArrayList<Double> al = new ArrayList<Double>();
            while (input.hasNextDouble()) {
                double d = (double)Math.round(pixelValue * input.nextDouble() * 1000.0) / 1000.0;
                al.add(d);
            }
            String s = input.next();
            p2dTemp = CNSTReticleLogo.parseData(al, s, p2dTemp, pixelValue);
            if (s.equals("h")) {
                path.add(p2dTemp);
                p2dTemp = new Path2D.Double();
            }
            if (!s.equals("p")) continue;
            path.add(p2dTemp);
            p2dTemp = new Path2D.Double();
        }
        return path;
    }

    public static ArrayList<Path2D.Double> readData(String[] sa, double pixelValue) {
        ArrayList<Path2D.Double> path = new ArrayList<Path2D.Double>();
        Path2D.Double p2dTemp = new Path2D.Double();
        ArrayList<Double> al = new ArrayList<Double>();
        for (int i = 0; i < sa.length; ++i) {
            if (!(sa[i].equals("m") || sa[i].equals("l") || sa[i].equals("c") || sa[i].equals("h") || sa[i].equals("p"))) {
                al.add(Double.parseDouble(sa[i]));
                continue;
            }
            String s = sa[i];
            p2dTemp = CNSTReticleLogo.parseData(al, s, p2dTemp, pixelValue);
            if (s.equals("h")) {
                path.add(p2dTemp);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("p")) {
                path.add(p2dTemp);
                p2dTemp = new Path2D.Double();
            }
            al = new ArrayList();
        }
        return path;
    }

    public static Path2D.Double parseData(ArrayList<Double> al, String s, Path2D.Double p2d, double pixelValue) {
        switch (s) {
            case "p": {
                return CNSTReticleLogo.mergePoints(al, p2d, pixelValue);
            }
            case "m": {
                p2d.moveTo(al.get(0), al.get(1));
                return p2d;
            }
            case "l": {
                p2d.lineTo(al.get(0), al.get(1));
                return p2d;
            }
            case "c": {
                p2d.curveTo(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5));
                return p2d;
            }
            case "h": {
                p2d.closePath();
                return p2d;
            }
            case "moveto": {
                p2d.moveTo(al.get(0), al.get(1));
                return p2d;
            }
            case "lineto": {
                p2d.lineTo(al.get(0), al.get(1));
                return p2d;
            }
            case "curveto": {
                p2d.curveTo(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5));
                return p2d;
            }
            case "closepath": {
                p2d.closePath();
                return p2d;
            }
        }
        return p2d;
    }

    public static Path2D.Double mergePoints(ArrayList<Double> al, Path2D.Double p2d, double pixelValue) {
        p2d.moveTo(CNSTReticleLogo.rescalePoints(al.get(0), pixelValue), CNSTReticleLogo.rescalePoints(al.get(1), pixelValue));
        for (int i = 2; i < al.size() - 1; i += 2) {
            p2d.lineTo(CNSTReticleLogo.rescalePoints(al.get(i), pixelValue), CNSTReticleLogo.rescalePoints(al.get(i + 1), pixelValue));
        }
        p2d.closePath();
        return p2d;
    }

    public static double rescalePoints(double d, double pixelValue) {
        return Math.round(d * 1000.0 / (pixelValue * 1000.0));
    }
}

