/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.machineResources.CNSTReticleLogo;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Array;
import JGDS2.BarCode;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class CNSTReticleFrameController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    final int ASMLPAS5500NIST = 0;
    final int CONTACT5INCH = 1;
    final int CONTACT7INCH = 2;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfBarcode;
    @FXML
    private TextField tfLabel;
    @FXML
    private ComboBox<String> cbTargetList;
    @FXML
    private ComboBox<String> cbFontList;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    CNST Reticle Frame Module", "This module creates reticle frames for the NIST CNST ASML PAS5500 i-line stepper and contact aligners. Stepper frame includes a barcode and label, whereas for contact tools include only labels. Both types of reticle frames include a NIST and a CNST logo");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.cbFontList.getItems().add((Object)fontFamilies[i]);
        }
        this.cbFontList.setValue((Object)"Serif");
        this.cbFontList.setVisibleRowCount(11);
        this.cbTargetList.getItems().addAll((Object[])new String[]{"NIST - CNST - ASMLPAS5500", "NIST - CNST - Contact 5 Inch", "NIST - CNST - Contact 7 Inch"});
        this.cbTargetList.setValue((Object)"NIST - CNST - ASMLPAS5500");
        this.cbTargetList.setVisibleRowCount(4);
        this.tfFileName.setText(this.getDate());
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(CNSTReticleFrameController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) throws FileNotFoundException {
        String fileName = this.tfFileName.getText();
        String barcode = this.tfBarcode.getText();
        String label = this.tfLabel.getText();
        String fontType = (String)this.cbFontList.getValue();
        int toolIndex = this.cbTargetList.getSelectionModel().selectedIndexProperty().intValue();
        Lib lib = new Lib();
        lib.add(new Ref(this.frame(toolIndex, barcode, label, fontType), 875.0, -875.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    public Struct frame(int tool, String barcode, String label, String font) throws FileNotFoundException {
        Struct f = null;
        switch (tool) {
            case 0: {
                GArea pr = new GArea(new Rect(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                Rect r = new Rect(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new Rect(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new Rect(-12.5, -2.5, 12.5, 2.5, 1));
                pr.subtract(new Rect(-2.5, -12.5, 2.5, 12.5, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct line = new Struct("l", new Rect(100.0, 100.0, 920.0, 120.0, 1));
                Struct l2 = new Struct("l2", new Rect(-122.0, 100.0, -100.0, 920.0, 1));
                Struct al = new Struct("al", new Array(line, 0.0, 0.0, 1, 21, 1.0, 840.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -836.0, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new Rect(-80.0, -80.0, 80.0, 80.0, 1));
                m.subtract(new Rect(-12.5, -2.5, 12.5, 2.5, 1));
                m.subtract(new Rect(-2.5, -12.5, 2.5, 12.5, 1));
                m.and(new Rect(-914.0, -914.0, 920.0, 920.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode.substring(0, barcode.length() < 12 ? barcode.length() : 12), 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Font fnt = new Font(font, 0, 3500);
                Text lb = new Text(label.substring(0, label.length() < 14 ? label.length() : 14), 1, fnt);
                lb.setFontSize(3500.0);
                lb.setRenderReso(1.0);
                Struct lbl = new Struct("label", lb);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                f = new Struct("frame");
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -69500.0, 0.0));
                f.add(new Ref(mx, 69500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0, 0, 1.0, -90.0));
                f.add(new Ref(CNSTReticleLogo.createLogo(), -68500.0, -37000.0, 0, 1.0, -90.0));
                break;
            }
            case 1: {
                Font fnt = new Font(font, 0, 3500);
                Text lb = new Text(label.substring(0, label.length() < 22 ? label.length() : 22), 1, fnt);
                lb.setFontSize(3200.0);
                lb.setRenderReso(1.0);
                Struct lbl = new Struct("label", lb);
                Area a = new Area(lbl.getArea());
                Rectangle2D rec = a.getBounds2D();
                f = new Struct("frame");
                f.add(new Ref(lbl, -rec.getCenterX(), -58000.0));
                f.add(new Ref(CNSTReticleLogo.createLogo(), 15000.0 + rec.getCenterX(), -58000.0 + rec.getCenterY()));
                break;
            }
            case 2: {
                Font fnt = new Font(font, 0, 3500);
                Text lb = new Text(label.substring(0, label.length() < 22 ? label.length() : 22), 1, fnt);
                lb.setFontSize(3500.0);
                lb.setRenderReso(1.0);
                Struct lbl = new Struct("label", lb);
                Area a = new Area(lbl.getArea());
                Rectangle2D rec = a.getBounds2D();
                f = new Struct("frame");
                f.add(new Ref(lbl, -rec.getCenterX(), -83900.0));
                f.add(new Ref(CNSTReticleLogo.createLogo(), 15000.0 + rec.getCenterX(), -83900.0 + rec.getCenterY()));
            }
        }
        return f;
    }

    public String getDate() {
        Date date = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd");
        String dateStr = ft.format(date);
        return dateStr;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

