/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class CNSTnano
extends Application {
    public void start(Stage stage) throws Exception {
        Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("CNSTnanofxml.fxml"));
        Scene scene = new Scene(root);
        stage.setTitle("NIST CNST Nanolithography Toolbox Version 2016.10.01");
        stage.setScene(scene);
        stage.show();
    }

    public static void main(String[] args) throws IOException, Exception {
        if (args.length == 0) {
            CNSTnano.launch((String[])args);
        }
        if (args.length > 0) {
            CNSTnano.defineScriptingOption(args);
        }
    }

    static void defineScriptingOption(String[] mod) throws FileNotFoundException, IOException, Exception {
        switch (mod[0].toLowerCase()) {
            case "cnstscripting": {
                CNSTnano.cnstScriptingOption(mod);
                System.exit(0);
                break;
            }
            case "getfonts": {
                CNSTnano.getFontNamesOption();
                System.exit(0);
                break;
            }
            default: {
                System.out.println("\nCOMMAND LINE ERROR! [option] " + mod[0] + "is NOT available. Use:\n");
                System.out.println(CNSTnano.commandLineError());
                System.exit(0);
            }
        }
    }

    public static void cnstScriptingOption(String[] s) throws FileNotFoundException, IOException, Exception {
        if (s.length == 3) {
            File f = new File(s[1]);
            if (f.exists()) {
                Scanner input = new Scanner(new File(f.getPath()));
                CNSTscriptingController.commandLineExportGDS(input, s);
            } else {
                System.out.println("\n\tERROR: File " + f.getAbsolutePath() + " does NOT exist!\n");
            }
        } else {
            System.out.println("\nCOMMAND LINE ERROR! Use:\n");
            System.out.println(CNSTnano.commandLineError());
        }
    }

    public static void getFontNamesOption() throws IOException {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Date date = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd-hhmmssa");
        String logFile = "systemFonts" + ft.format(date) + ".txt";
        FileWriter fstream = new FileWriter(logFile);
        BufferedWriter out = new BufferedWriter(fstream);
        for (String font : fonts) {
            out.write(font + "\n");
        }
        out.close();
        System.out.println("\n\t" + logFile + " successfully created.\n");
    }

    public static String commandLineError() {
        return "\t\tjava -jar jarFileName.jar [option]\n\n[option]\n\n\tcnstscripting inputFileName.cnst outputFileName.gds\n\t\tProcess a CNST scripting inputFileName.cnst file and cast\n\t\tresulting structures into an outputFileName.gds file.\n\n\tgetfonts\n\t\tObtain system fonts and stores them into a time/date stamp file.\n\n";
    }
}

