/*
 * Decompiled with CFR 0.152.
 */
package CNST;

import CNST.CircleThree;
import CNSTnanoToolbox.scripting.CNSTscriptingArrays;
import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.AlignmentMarks;
import CNSTnanoToolbox.shapeMethods.AlignmentMarksCustom;
import CNSTnanoToolbox.shapeMethods.CNSTnistLogos;
import CNSTnanoToolbox.shapeMethods.CNSTreticleFrames;
import CNSTnanoToolbox.shapeMethods.Fractals;
import CNSTnanoToolbox.shapeMethods.FunctionPlot;
import CNSTnanoToolbox.shapeMethods.Grayscale;
import CNSTnanoToolbox.shapeMethods.LabelMaker;
import CNSTnanoToolbox.shapeMethods.MEMSactuators;
import CNSTnanoToolbox.shapeMethods.MEMSbeams;
import CNSTnanoToolbox.shapeMethods.MEMScoupledArrays;
import CNSTnanoToolbox.shapeMethods.MEMSflexureHinges;
import CNSTnanoToolbox.shapeMethods.MISCobjects;
import CNSTnanoToolbox.shapeMethods.MeanderChannels;
import CNSTnanoToolbox.shapeMethods.Photonics;
import CNSTnanoToolbox.shapeMethods.PhotonicsDiscRingPulleys;
import CNSTnanoToolbox.shapeMethods.PhotonicsGratingCouplers;
import CNSTnanoToolbox.shapeMethods.PhotonicsWaveGuides;
import CNSTnanoToolbox.shapeMethods.PhotonicsWgDcThomasVladimir;
import CNSTnanoToolbox.shapeMethods.PostScript;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.shapeMethods.RegularPolygon;
import CNSTnanoToolbox.shapeMethods.Spirals;
import CNSTnanoToolbox.shapeMethods.StarPolygon;
import CNSTnanoToolbox.shapeMethods.TextOutline;
import CNSTnanoToolbox.shapeMethods.Verniers;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.GDS2Element;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.script.ScriptException;

public class Scripting {
    public static void main(String[] args) {
    }

    public static GArea createEllipse(double x, double y, double radiusX, double radiusY, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createEllipse(x, y, radiusX, radiusY, numSides, gdsLayer), x, y, THETA);
    }

    public static GArea createEllipseVector(double x, double y, double radiusX, double radiusY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Ellipse2D.Double s = new Ellipse2D.Double(x - radiusX, y - radiusY, 2.0 * radiusX, 2.0 * radiusY);
        Area a = new Area(s);
        GArea v = new GArea(a, gdsLayer);
        v.setRenderReso(shapeReso);
        v.setDataType(CNSTscriptingController.getDataType());
        return PrimitiveShapes.rotateGArea(v, x, y, THETA);
    }

    public static GArea createCircleThree(double x1, double y1, double x2, double y2, double x3, double y3, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        CircleThree.Point p1 = new CircleThree.Point(x1, y1);
        CircleThree.Point p2 = new CircleThree.Point(x2, y2);
        CircleThree.Point p3 = new CircleThree.Point(x3, y3);
        CircleThree.Circle c = CircleThree.circleFromPoints(p1, p2, p3);
        return Scripting.createEllipse(c.center.x, c.center.y, c.radius, c.radius, numSides, THETA, gdsLayer);
    }

    public static GArea createCircleWave(double x, double y, double r, int n, double A, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea ga = PrimitiveShapes.createCircleWave(r, n, A, numSides);
        ga.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(ga, x, y, THETA);
    }

    public static GArea createCross(double x, double y, double W, double L, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createCross(x, y, W, L, gdsLayer), x, y, THETA);
    }

    public static GArea createLshape(double x, double y, double W1, double L1, double W2, double L2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createLshape(x, y, W1, L1, W2, L2, gdsLayer), x, y, THETA);
    }

    public static GArea createArc(double x, double y, double rX, double rY, double angleStart, double angleEnd, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createArc(x, y, rX, rY, angleStart, angleEnd, numSides, gdsLayer), x, y, THETA);
    }

    public static GArea createArcVector(double x, double y, double rX, double rY, double angleStart, double angleEnd, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        angleStart = angleStart >= 90.0 ? angleStart - 360.0 : angleStart;
        double angleExtent = angleEnd - angleStart;
        Arc2D.Double s = new Arc2D.Double(0.0, 0.0, 2.0 * rX, 2.0 * rY, angleStart, angleExtent, 2);
        Area a = new Area(s);
        GArea v = new GArea(a, gdsLayer);
        v.setRenderReso(shapeReso);
        v.transform(AffineTransform.getTranslateInstance(-rX, -rY));
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0}));
        v.transform(AffineTransform.getRotateInstance(Math.PI));
        v.transform(AffineTransform.getTranslateInstance(0.0, 2.0 * y));
        return PrimitiveShapes.rotateGArea(v, x, y, THETA);
    }

    public static GArea createPolygon(double x, double y, double r, int numSides, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        RegularPolygon s = new RegularPolygon(0, 0, CNSTscriptingController.um2nmConversion(r), numSides, Scripting.degreeToRadians(THETA));
        Area a = new Area(s);
        GArea v = new GArea(a, gdsLayer);
        v.setRenderReso(shapeReso);
        v.transform(AffineTransform.getScaleInstance(0.001, 0.001));
        v.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(v, x, y, THETA);
    }

    public static GArea createRectangle(double xLL, double yLL, double xUR, double yUR, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        ArrayList<Double> al = new ArrayList<Double>(Arrays.asList(xLL, yLL, xUR, yUR));
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createRectangle(al, gdsLayer), xLL, yLL, THETA);
    }

    public static GArea createRectangleLH(double xLL, double yLL, double L, double H, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        ArrayList<Double> al = new ArrayList<Double>(Arrays.asList(xLL, yLL, L, H));
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createRectangleLH(al, gdsLayer), xLL, yLL, THETA);
    }

    public static GArea createRectangleC(double xC, double yC, double L, double H, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        ArrayList<Double> al = new ArrayList<Double>(Arrays.asList(xC, yC, L, H));
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createRectangleC(al, gdsLayer), xC, yC, THETA);
    }

    public static GArea createRoundRect(double xLL, double yLL, double L, double H, double rX, double rY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        RoundRectangle2D.Double s = new RoundRectangle2D.Double(xLL, yLL, L, H, rX, rY);
        Area a = new Area(s);
        GArea v = new GArea(a, gdsLayer);
        v.setRenderReso(shapeReso);
        return PrimitiveShapes.rotateGArea(v, xLL, yLL, THETA);
    }

    public static GArea createRoundRectC(double xLL, double yLL, double L, double H, double rX, double rY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        RoundRectangle2D.Double s = new RoundRectangle2D.Double(xLL, yLL, L, H, rX, rY);
        Area a = new Area(s);
        GArea v = new GArea(a, gdsLayer);
        v.setRenderReso(shapeReso);
        v.transform(AffineTransform.getTranslateInstance(-L / 2.0, -H / 2.0));
        return PrimitiveShapes.rotateGArea(v, xLL, yLL, THETA);
    }

    public static GArea createRectSUshape(double x, double y, double L1, double L2, double L3, double W, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea ga = PrimitiveShapes.createRectangularSUshape(L1, L2, L3, W);
        ga.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(ga, x, y, THETA);
    }

    public static GArea createRectTaper(double x, double y, double w1, double L1, double w2, double L2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea ga = MISCobjects.createRectangleTaper(w1, L1, w2, L2);
        ga.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(ga, x, y, THETA);
    }

    public static GArea createStar(double x, double y, double rIn, double rOut, int numPoints, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        StarPolygon s = new StarPolygon(0, 0, CNSTscriptingController.um2nmConversion(rIn), CNSTscriptingController.um2nmConversion(rOut), numPoints, Scripting.degreeToRadians(THETA));
        Area a = new Area(s);
        GArea v = new GArea(a, gdsLayer);
        v.setRenderReso(shapeReso);
        v.transform(AffineTransform.getScaleInstance(0.001, 0.001));
        v.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(v, x, y, THETA);
    }

    public static GArea createTorus(double x, double y, double rIn, double rOut, double angleStart, double angleEnd, int numPoints, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createTorus(x, y, rIn, rOut, angleStart, angleEnd, numPoints, gdsLayer), x, y, THETA);
    }

    public static GArea createTorusW(double x, double y, double r, double width, double angleStart, double angleEnd, int numPoints, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createTorusW(x, y, r, width, angleStart, angleEnd, numPoints, gdsLayer), x, y, THETA);
    }

    public static GArea createTorusEllipseW(double x, double y, double radiusX, double radiusY, double width, double angleStart, double angleEnd, int numPoints, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createTorusEllipseW(x, y, radiusX, radiusY, width, angleStart, angleEnd, numPoints, gdsLayer), x, y, THETA);
    }

    public static GArea createTorusEllipseFocusW(double x, double y, double radiusX, double radiusY, double width, double angleStart, double angleEnd, int numPoints, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PrimitiveShapes.rotateGArea(PrimitiveShapes.createTorusEllipseFocusW(x, y, radiusX, radiusY, width, angleStart, angleEnd, numPoints, gdsLayer), x, y, THETA);
    }

    public static GArea createTorusVector(double x, double y, double rIn, double rOut, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Ellipse2D.Double sBig = new Ellipse2D.Double(x - rOut, y - rOut, 2.0 * rOut, 2.0 * rOut);
        Ellipse2D.Double sSmall = new Ellipse2D.Double(x - rIn, y - rIn, 2.0 * rIn, 2.0 * rIn);
        Area a1 = new Area(sBig);
        Area a2 = new Area(sSmall);
        a1.subtract(a2);
        GArea v = new GArea(a1, gdsLayer);
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createTorusWaveIn(double x, double y, double rIn, double rOut, int n, double A, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea ga = PrimitiveShapes.createTorusWaveIN(rIn, rOut, n, A, numSides);
        ga.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(ga, x, y, THETA);
    }

    public static GArea createTorusWaveOut(double x, double y, double rIn, double rOut, int n, double A, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea ga = PrimitiveShapes.createTorusWaveOUT(rIn, rOut, n, A, numSides);
        ga.transform(AffineTransform.getTranslateInstance(x, y));
        return PrimitiveShapes.rotateGArea(ga, x, y, THETA);
    }

    public static void createArrayRectV1(Struct structToBeArrayed, Struct currentStruct, double x, double y, int numColumns, int numRows, double dx, double dy) {
        String[] s = new String[]{"", "" + x, "" + y, "" + numColumns, "" + numRows, "" + dx, "" + dy, "1"};
        CNSTscriptingArrays.rectangularArray(s, currentStruct, structToBeArrayed);
    }

    public static void createArrayRectV2(Struct structToBeArrayed, Struct currentStruct, double x, double y, int numColumns, int numRows, double xE, double yE) {
        String[] s = new String[]{"", "" + x, "" + y, "" + numColumns, "" + numRows, "" + xE, "" + yE, "2"};
        CNSTscriptingArrays.rectangularArray(s, currentStruct, structToBeArrayed);
    }

    public static void createArrayHex(Struct structToBeArrayed, Struct currentStruct, double x, double y, int numColumns, int numRows, double ds) {
        String[] s = new String[]{"", "" + x, "" + y, "" + numColumns, "" + numRows, "" + ds};
        CNSTscriptingArrays.hexagonalArray(s, currentStruct, structToBeArrayed);
    }

    public static void createArrayPolarV1(Struct structToBeArrayed, Struct currentStruct, double angleStart, double angleEnd, double deltaAngle, double radiusStart, double radiusEnd, double deltaRadius) {
        String[] s = new String[]{"", "" + angleStart, "" + angleEnd, "" + deltaAngle, "" + radiusStart, "" + radiusEnd, "" + deltaRadius, "1"};
        CNSTscriptingArrays.polarArray(s, currentStruct, structToBeArrayed);
    }

    public static void createArrayPolarV1R(Struct structToBeArrayed, Struct currentStruct, double angleStart, double angleEnd, double deltaAngle, double radiusStart, double radiusEnd, double deltaRadius) {
        String[] s = new String[]{"", "" + angleStart, "" + angleEnd, "" + deltaAngle, "" + radiusStart, "" + radiusEnd, "" + deltaRadius, "1R"};
        CNSTscriptingArrays.polarArray(s, currentStruct, structToBeArrayed);
    }

    public static void createArrayPolarV2(Struct structToBeArrayed, Struct currentStruct, double angleStart, double angleEnd, int numberOfAngles, double radiusStart, double radiusEnd, int numberOfRadii) {
        String[] s = new String[]{"", "" + angleStart, "" + angleEnd, "" + numberOfAngles, "" + radiusStart, "" + radiusEnd, "" + numberOfRadii, "2"};
        CNSTscriptingArrays.polarArray(s, currentStruct, structToBeArrayed);
    }

    public static void createArrayPolarV2R(Struct structToBeArrayed, Struct currentStruct, double angleStart, double angleEnd, int numberOfAngles, double radiusStart, double radiusEnd, int numberOfRadii) {
        String[] s = new String[]{"", "" + angleStart, "" + angleEnd, "" + numberOfAngles, "" + radiusStart, "" + radiusEnd, "" + numberOfRadii, "2R"};
        CNSTscriptingArrays.polarArray(s, currentStruct, structToBeArrayed);
    }

    public static void createSqrPillar(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, pitchY, numElementsX, numElementsY, THETA, false, true, false, false);
    }

    public static void createHexPillar(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, 0.0, numElementsX, numElementsY, THETA, false, true, true, false);
    }

    public static void createSqrHole(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, pitchY, numElementsX, numElementsY, THETA, false, false, false, false);
    }

    public static void createHexHole(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, 0.0, numElementsX, numElementsY, THETA, false, false, true, false);
    }

    public static void createSqrPillarC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, pitchY, numElementsX, numElementsY, THETA, false, true, false, true);
    }

    public static void createHexPillarC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, 0.0, numElementsX, numElementsY, THETA, false, true, true, true);
    }

    public static void createSqrHoleC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, pitchY, numElementsX, numElementsY, THETA, false, false, false, true);
    }

    public static void createHexHoleC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, int numSides, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, numSides, pitchX, 0.0, numElementsX, numElementsY, THETA, false, false, true, true);
    }

    public static void createSqrPillarV(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, pitchY, numElementsX, numElementsY, THETA, true, true, false, false);
    }

    public static void createHexPillarV(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, 0.0, numElementsX, numElementsY, THETA, true, true, true, false);
    }

    public static void createSqrHoleV(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, pitchY, numElementsX, numElementsY, THETA, true, false, false, false);
    }

    public static void createHexHoleV(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, 0.0, numElementsX, numElementsY, THETA, true, false, true, false);
    }

    public static void createSqrPillarVC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, pitchY, numElementsX, numElementsY, THETA, true, true, false, true);
    }

    public static void createHexPillarVC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, 0.0, numElementsX, numElementsY, THETA, true, true, true, true);
    }

    public static void createSqrHoleVC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, double pitchY, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, pitchY, numElementsX, numElementsY, THETA, true, false, false, true);
    }

    public static void createHexHoleVC(String uniqueStructName, Struct currentStruct, double x, double y, double rX, double rY, double pitchX, int numElementsX, int numElementsY, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPillarHoleArray(currentStruct, uniqueStructName, x, y, rX, rY, 0, pitchX, 0.0, numElementsX, numElementsY, THETA, false, false, true, true);
    }

    public static GArea createTextGds(String textString, String fontName, double fontSize, double x, double y, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        String[] textParameters = new String[]{"" + fontSize, "" + x, "" + y};
        return Scripting.rotateGArea(CNSTscriptingArrays.createText(textString, fontName, textParameters, gdsLayer, false), THETA, x, y);
    }

    public static GArea createTextGdsC(String textString, String fontName, double fontSize, double x, double y, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        String[] textParameters = new String[]{"" + fontSize, "" + x, "" + y};
        return Scripting.rotateGArea(CNSTscriptingArrays.createText(textString, fontName, textParameters, gdsLayer, true), THETA, x, y);
    }

    public static ArrayList<GArea> createTextOutline(String textString, String fontName, double fontSize, double x, double y, double THETA, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.rotateArrayListGArea(TextOutline.textOutline(textString, fontName, fontSize, x, y, shapeReso, gdsLayer, false), THETA, x, y);
    }

    public static void createTextOutline(Struct currentStruct, String textString, String fontName, double fontSize, double x, double y, double fontOutlineWidth, int gdsLayer, double shapeReso, double THETA) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructRotate(currentStruct, TextOutline.textOutline(textString, fontName, fontSize, x, y, shapeReso, gdsLayer, false), THETA, x, y);
    }

    public static ArrayList<GArea> createTextOutlineC(String textString, String fontName, double fontSize, double x, double y, double THETA, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.rotateArrayListGArea(TextOutline.textOutline(textString, fontName, fontSize, x, y, shapeReso, gdsLayer, true), THETA, x, y);
    }

    public static void createTextOutlineC(Struct currentStruct, String textString, String fontName, double fontSize, double x, double y, double fontOutlineWidth, int gdsLayer, double shapeReso, double THETA) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructRotate(currentStruct, TextOutline.textOutline(textString, fontName, fontSize, x, y, shapeReso, gdsLayer, true), THETA, x, y);
    }

    public static void createLabelMakerAutoOut(int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct currentStruct, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoOuter(rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, currentStruct, false);
    }

    public static void createLabelMakerAutoRowCol(int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct currentStruct, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoRowColumn(rows, columns, fontName, fontSize, x, y, pitchX, pitchY, currentStruct, false);
    }

    public static void createLabelMakerAutoOutLett(int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct currentStruct, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoOuterLetters(rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, currentStruct, false);
    }

    public static void createLabelMakerAutoRowColLett(int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct currentStruct, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoRowColumnLetters(rows, columns, fontName, fontSize, x, y, pitchX, pitchY, currentStruct, false);
    }

    public static void createLabelMakerCustomOuter(String[] stringArray, int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct str, int gdsLayer, double shapeReso) {
        if (stringArray.length == rows + columns) {
            Scripting.setGdsLayer(gdsLayer);
            Scripting.setShapeReso(shapeReso);
            LabelMaker.createOuter(stringArray, rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, str, false);
        } else {
            System.out.println("Label Maker Custom Outer ERROR: stringArray length is not equal to (rows + columns)");
        }
    }

    public static void createLabelMakerCustomRowColumn(String[] stringArray, int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct str, int gdsLayer, double shapeReso) {
        if (stringArray.length == rows * columns) {
            Scripting.setGdsLayer(gdsLayer);
            Scripting.setShapeReso(shapeReso);
            LabelMaker.createRowColumn(stringArray, rows, columns, fontName, fontSize, x, y, pitchX, pitchY, str, false);
        } else {
            System.out.println("Label Maker Custom Outer ERROR: stringArray length is not equal to (rows * columns)");
        }
    }

    public static void createLabelOutlineAutoOut(int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct currentStruct, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoOuter(rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, currentStruct, true);
    }

    public static void createLabelOutlineAutoRowCol(int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct currentStruct, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoRowColumn(rows, columns, fontName, fontSize, x, y, pitchX, pitchY, currentStruct, true);
    }

    public static void createLabelOutlineAutoOutLett(int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct currentStruct, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoOuterLetters(rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, currentStruct, true);
    }

    public static void createLabelOutlineAutoRowColLett(int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct currentStruct, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        Scripting.setFontOutline(fontOutlineWidth);
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        LabelMaker.createAutoRowColumnLetters(rows, columns, fontName, fontSize, x, y, pitchX, pitchY, currentStruct, true);
    }

    public static void createLabelOutlineCustomOuter(String[] stringArray, int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct str, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        if (stringArray.length == rows + columns) {
            Scripting.setFontOutline(fontOutlineWidth);
            Scripting.setGdsLayer(gdsLayer);
            Scripting.setShapeReso(shapeReso);
            LabelMaker.createOuter(stringArray, rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, str, true);
        } else {
            System.out.println("Label Maker OUTLINE Custom Outer ERROR: stringArray length is not equal to (rows + columns)");
        }
    }

    public static void createLabelOutlineCustomRowColumn(String[] stringArray, int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct str, double fontOutlineWidth, int gdsLayer, double shapeReso) {
        if (stringArray.length == rows * columns) {
            Scripting.setFontOutline(fontOutlineWidth);
            Scripting.setGdsLayer(gdsLayer);
            Scripting.setShapeReso(shapeReso);
            LabelMaker.createRowColumn(stringArray, rows, columns, fontName, fontSize, x, y, pitchX, pitchY, str, true);
        } else {
            System.out.println("Label Maker OUTLINE Custom Outer ERROR: stringArray length is not equal to (rows * columns)");
        }
    }

    public static ArrayList<GArea> createPostScript(double x, double y, String s, int fractureSegments, double THETA, double shapeReso, double pixelValue, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.setPixelValue(pixelValue);
        return Scripting.transformArrayListGArea(PostScript.createPostScript(s, fractureSegments), THETA, x, y);
    }

    public static void createPostScript(Struct currentStruct, double x, double y, String s, int fractureSegments, double THETA, double shapeReso, double pixelValue, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.setPixelValue(pixelValue);
        Scripting.createStructRotate(currentStruct, PostScript.createPostScript(s, fractureSegments), THETA, x, y);
    }

    public static GArea createCnstEmblemLogo(double x, double y, double scale, double THETA, double shapeReso, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.rotateGArea(CNSTnistLogos.getCNSTemblemLogo(x, y, scale, shapeReso, gdsLayer), THETA, x, y);
    }

    public static GArea createCnstLogo(double x, double y, double scale, double THETA, double shapeReso, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.rotateGArea(CNSTnistLogos.getCnstLogo(x, y, scale, shapeReso, gdsLayer), THETA, x, y);
    }

    public static GArea createNistLogo(double x, double y, double scale, double THETA, double shapeReso, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.rotateGArea(CNSTnistLogos.getNistLogo(x, y, scale, shapeReso, gdsLayer), THETA, x, y);
    }

    public static GArea createNistCnstLogo(double x, double y, double scale, double THETA, double shapeReso, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.rotateGArea(CNSTnistLogos.getNistCnstLogo(x, y, scale, shapeReso, gdsLayer), THETA, x, y);
    }

    public static void createArcSquareFill(Struct currentStruct, String uniqueStructName, double x, double y, double rIn, double rOut, double angleStart, double angleEnd, int numSides, double THETA, double rSmallObject, int numSidesSmallObject, double pitchX, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        MISCobjects.arcSquareHexFill(currentStruct, uniqueStructName, x, y, rIn, rOut, angleStart, angleEnd, numSides, THETA, rSmallObject, numSidesSmallObject, pitchX, true, false);
    }

    public static void createArcSquareFillV(Struct currentStruct, String uniqueStructName, double x, double y, double rIn, double rOut, double angleStart, double angleEnd, int numSides, double THETA, double rSmallObject, double pitchX, double shapeReso, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        MISCobjects.arcSquareHexFill(currentStruct, uniqueStructName, x, y, rIn, rOut, angleStart, angleEnd, numSides, THETA, rSmallObject, 0, pitchX, true, true);
    }

    public static void createArcHexFill(Struct currentStruct, String uniqueStructName, double x, double y, double rIn, double rOut, double angleStart, double angleEnd, int numSides, double THETA, double rSmallObject, int numSidesSmallObject, double pitchX, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        MISCobjects.arcSquareHexFill(currentStruct, uniqueStructName, x, y, rIn, rOut, angleStart, angleEnd, numSides, THETA, rSmallObject, numSidesSmallObject, pitchX, false, false);
    }

    public static void createArcHexFillV(Struct currentStruct, String uniqueStructName, double x, double y, double rIn, double rOut, double angleStart, double angleEnd, int numSides, double THETA, double rSmallObject, double pitchX, double shapeReso, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        MISCobjects.arcSquareHexFill(currentStruct, uniqueStructName, x, y, rIn, rOut, angleStart, angleEnd, numSides, THETA, rSmallObject, 0, pitchX, false, true);
    }

    public static GArea createBezierCurve(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double width, double shapeReso, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createBezierCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2, width, shapeReso, THETA, gdsLayer);
    }

    public static GArea createBezierCurveInv(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double sleeveWidth, double slotWidth, double shapeReso, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createBezierCurveInv(x1, y1, cx1, cy1, cx2, cy2, x2, y2, sleeveWidth, slotWidth, shapeReso, THETA, gdsLayer);
    }

    public static GArea createBezierCurveInvSlot(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double sleeveWidth, double slotWidth, double gap, double shapeReso, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createBezierCurveInvSlot(x1, y1, cx1, cy1, cx2, cy2, x2, y2, sleeveWidth, slotWidth, gap, shapeReso, THETA, gdsLayer);
    }

    public static void createSierpinskiTriangle(Struct currentStruct, String shortStructName, double x, double y, int iterations, double length, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.createSierpinskiTriangle(iterations, length, gdsLayer, shortStructName), x, y));
    }

    public static void createSierpinskiCarpet(Struct currentStruct, String shortStructName, double x, double y, int iterations, double length, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.createSierpinskiCarpet(iterations, length, gdsLayer, shortStructName), x, y));
    }

    public static void createVicsekSaltire(Struct currentStruct, String shortStructName, double x, double y, int iterations, double length, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.createVicsekSaltire(iterations, length, gdsLayer, shortStructName), x, y));
    }

    public static void createVicsekCross(Struct currentStruct, String shortStructName, double x, double y, int iterations, double length, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.createVicsekCross(iterations, length, gdsLayer, shortStructName), x, y));
    }

    public static void createCurvedTree(Struct currentStruct, String shortStructName, double x, double y, double length, double width, int iterations, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.createCurvedTree(shortStructName, width, length, iterations, gdsLayer), x, y));
    }

    public static void createAnotherTree(Struct currentStruct, String shortStructName, double x, double y, int iterations, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.createAnotherTree(shortStructName, iterations, gdsLayer), x, y));
    }

    public static void createTree(Struct currentStruct, String shortStructName, double x, double y, double d, double ang, double ratio, int depth, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        currentStruct.add(new Ref(Fractals.tree(d, ang, ratio, depth, shortStructName, gdsLayer), x, y));
    }

    public static ArrayList<GArea> createFunctionXY(String function, double x, double y, double xLowerLimit, double xUpperLimit, int N, double W, int CAP, int JOIN, double THETA, int gdsLayer) throws ScriptException {
        String[] s = new String[]{"", "", "" + xLowerLimit, "" + xUpperLimit, "" + N, "" + W, "" + CAP, "" + JOIN};
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(FunctionPlot.createFunctionPlot(true, function, s), THETA, x, y);
    }

    public static void createFunctionXY(Struct currentStruct, String function, double x, double y, double xLowerLimit, double xUpperLimit, int N, double W, int CAP, int JOIN, double THETA, int gdsLayer) throws ScriptException {
        String[] s = new String[]{"", "", "" + xLowerLimit, "" + xUpperLimit, "" + N, "" + W, "" + CAP, "" + JOIN};
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, FunctionPlot.createFunctionPlot(true, function, s), THETA, x, y);
    }

    public static ArrayList<GArea> createFunctionRTheta(String function, double x, double y, double thetaLowerLimit, double thetaUpperLimit, int N, double W, int CAP, int JOIN, double THETA, int gdsLayer) throws ScriptException {
        String[] s = new String[]{"", "", "" + thetaLowerLimit, "" + thetaUpperLimit, "" + N, "" + W, "" + CAP, "" + JOIN};
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.rotateArrayListGArea(FunctionPlot.createFunctionPlot(false, function, s), THETA, x, y);
    }

    public static void createFunctionRTheta(Struct currentStruct, String function, double x, double y, double thetaLowerLimit, double thetaUpperLimit, int N, double W, int CAP, int JOIN, double THETA, int gdsLayer) throws ScriptException {
        String[] s = new String[]{"", "", "" + thetaLowerLimit, "" + thetaUpperLimit, "" + N, "" + W, "" + CAP, "" + JOIN};
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, FunctionPlot.createFunctionPlot(false, function, s), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayERamp(double x, double y, double dX, double dY, int numberOfSegments, double THETA) {
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleLinearRECT(dY, dY, numberOfSegments), THETA, x, y);
    }

    public static void createGrayERamp(Struct currentStruct, double x, double y, double dX, double dY, int numberOfSegments, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleLinearRECT(dY, dY, numberOfSegments), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayENgon(double x, double y, double radX, double radY, int numberOfSegments, int numSides, double THETA) {
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleLinearNGON(radX, radY, numberOfSegments, numSides), THETA, x, y);
    }

    public static void createGrayENgon(Struct currentStruct, double x, double y, double radX, double radY, int numberOfSegments, int numSides, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleLinearNGON(radX, radY, numberOfSegments, numSides), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayUDR(double x, double y, ArrayList<Double> al, double THETA) {
        al.add(0, 0.0);
        al.add(1, 0.0);
        al.add(0.0);
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleCustomRECT(al), THETA, x, x);
    }

    public static void createGrayUDR(Struct currentStruct, double x, double y, ArrayList<Double> al, double THETA) {
        al.add(0, 0.0);
        al.add(1, 0.0);
        al.add(0.0);
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleCustomRECT(al), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayUDNgon(double x, double y, ArrayList<Double> al, int numSides, double THETA) {
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(Double.valueOf(numSides));
        al.add(0.0);
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleCustomNGON(al), THETA, x, y);
    }

    public static void createGrayUDNgon(Struct currentStruct, double x, double y, ArrayList<Double> al, int numSides, double THETA) {
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(Double.valueOf(numSides));
        al.add(0.0);
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleCustomNGON(al), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayERamp(double x, double y, double dX, double dY, int numberOfSegments, boolean UP, double THETA) {
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleLinearRAMPupDown(dX, dY, numberOfSegments, UP), THETA, x, y);
    }

    public static void createGrayERamp(Struct currentStruct, double x, double y, double dX, double dY, int numberOfSegments, boolean UP, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleLinearRAMPupDown(dX, dY, numberOfSegments, UP), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayERamp2(double x, double y, double dX, double dY, int numberOfSegments, double THETA) {
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleLinearRAMP(dX, dY, numberOfSegments), THETA, x, y);
    }

    public static void createGrayERamp2(Struct currentStruct, double x, double y, double dX, double dY, int numberOfSegments, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleLinearRAMP(dX, dY, numberOfSegments), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayUDRamp(double x, double y, ArrayList<Double> al, double dY, boolean UP, double THETA) {
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(dY);
        al.add(0.0);
        al.add(0.0);
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleCustomRAMPupDown(al, UP), THETA, x, y);
    }

    public static void createGrayUDRamp(Struct currentStruct, double x, double y, ArrayList<Double> al, double dY, boolean UP, double THETA) {
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(dY);
        al.add(0.0);
        al.add(0.0);
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleCustomRAMPupDown(al, UP), THETA, x, y);
    }

    public static ArrayList<GArea> createGrayUDRamp2(double x, double y, ArrayList<Double> al, double dY, double THETA) {
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(dY);
        al.add(0.0);
        return Scripting.transformArrayListGArea(Grayscale.createGrayScaleCustomRAMP(al), THETA, x, y);
    }

    public static void createGrayUDRamp2(Struct currentStruct, double x, double y, ArrayList<Double> al, double dY, double THETA) {
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(dY);
        al.add(0.0);
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.createGrayScaleCustomRAMP(al), THETA, x, y);
    }

    public static void createGraySpiralStairOverlap(Struct currentStruct, double x, double y, double rIn, double rOut, int numSegments, int numSides, double THETA) {
        for (int segment2 = 0; segment2 < numSegments; ++segment2) {
            Scripting.createStructTranslateRotate(currentStruct, Grayscale.grayScaleOverlappingARCs(rIn, rOut, segment2, numSegments, numSides), THETA, x, y);
        }
    }

    public static ArrayList<GArea> createSpiralStair(double x, double y, double rIn, double rOut, int numSegments, int numSides, double THETA) {
        return Scripting.transformArrayListGArea(Grayscale.grayScaleARCs(rIn, rOut, numSegments, numSides), THETA, x, y);
    }

    public static void createGraySpiralStair(Struct currentStruct, double x, double y, double rIn, double rOut, int numSegments, int numSides, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, Grayscale.grayScaleARCs(rIn, rOut, numSegments, numSides), THETA, x, y);
    }

    public static ArrayList<GArea> createIntElec1(double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createInteElectrodesV1(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static void createIntElec1(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createInteElectrodesV1(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static ArrayList<GArea> createIntElec2(double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createInteElectrodesV2(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static void createIntElec2(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createInteElectrodesV2(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static ArrayList<GArea> createIntElec3(double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createInteElectrodesV3(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static void createIntElec3(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createInteElectrodesV3(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static ArrayList<GArea> createIntElec4(double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createInteElectrodesV4(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static void createIntElec4(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createInteElectrodesV4(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static ArrayList<GArea> createIntElec5(double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createInteElectrodesV5(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static void createIntElec5(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createInteElectrodesV5(width1, width2, length1, length2, overlap, numElectrodes, pitch, baseHeight, baseWidth), THETA, x, y);
    }

    public static ArrayList<GArea> createTjunction(double x, double y, double w1, double w2, double L1, double L2, double rad, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createTjunction(w1, w2, L1, L2, rad, numSides), THETA, x, y);
    }

    public static void createTjunction(Struct currentStruct, double x, double y, double w1, double w2, double L1, double L2, double rad, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createTjunction(w1, w2, L1, L2, rad, numSides), THETA, x, y);
    }

    public static ArrayList<GArea> createHjunction(double x, double y, double w1, double w2, double L1, double L2, double rad, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createHjunction(w1, w2, L1, L2, rad, numSides), THETA, x, y);
    }

    public static void createHjunction(Struct currentStruct, double x, double y, double w1, double w2, double L1, double L2, double rad, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createHjunction(w1, w2, L1, L2, rad, numSides), THETA, x, y);
    }

    public static ArrayList<GArea> createArrowJunction(double x, double y, double w1, double w2, double L1, double L2, double rad, int numSides, double junctionAngle, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createArrowJunction(w1, w2, L1, L2, rad, numSides, junctionAngle), THETA, x, y);
    }

    public static void createArrowJunction(Struct currentStruct, double x, double y, double w1, double w2, double L1, double L2, double rad, int numSides, double junctionAngle, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createArrowJunction(w1, w2, L1, L2, rad, numSides, junctionAngle), THETA, x, y);
    }

    public static ArrayList<GArea> createMeanderSin(double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, int numCurveSegments, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, numCurveSegments, a, b, c, 0), THETA, x, y);
    }

    public static void createMeanderSin(Struct currentStruct, double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, int numCurveSegments, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, numCurveSegments, a, b, c, 0), THETA, x, y);
    }

    public static ArrayList<GArea> createMeanderSqr(double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, 0, a, b, c, 3), THETA, x, y);
    }

    public static void createMeanderSqr(Struct currentStruct, double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, 0, a, b, c, 3), THETA, x, y);
    }

    public static ArrayList<GArea> createMeanderRamp(double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, 0, a, b, c, 1), THETA, x, y);
    }

    public static void createMeanderRamp(Struct currentStruct, double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, 0, a, b, c, 1), THETA, x, y);
    }

    public static ArrayList<GArea> createMeanderTri(double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, 0, a, b, c, 2), THETA, x, y);
    }

    public static void createMeanderTri(Struct currentStruct, double x, double y, double L1, double H1, double L2, double H2, double width, double amplitude, int numPeriods, double a, double b, double c, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MeanderChannels.createMeanderChannels(L1, H1, L2, H2, width, amplitude, numPeriods, 0, a, b, c, 2), THETA, x, y);
    }

    public static GArea createPoints2Shape(double x, double y, ArrayList<Double> al, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Path2D.Double p2dTemp = new Path2D.Double();
        p2dTemp = CNSTscriptingController.parseData(al, "points2shape", p2dTemp);
        GArea v = new GArea(p2dTemp, gdsLayer);
        return Scripting.transformGArea(v, THETA, x, y);
    }

    public static GArea createPolyPath(double x, double y, ArrayList<Double> al, double width, int CAP, int JOIN, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(width);
        al.add(Double.valueOf(CAP));
        al.add(Double.valueOf(JOIN));
        return Scripting.transformGArea(CNSTscriptingController.createPolyPathGArea(al), THETA, x, y);
    }

    public static void createRandomPolygons(Struct currentStruct, String uniqueStructName, double x, double y, double width, double height, double radius, int numSides, double separation, int numElements, int iterations, boolean RANDOMROTATION, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        MISCobjects.createRandomPolygons(currentStruct, uniqueStructName, x, y, width, height, radius, numSides, separation, numElements, iterations, RANDOMROTATION);
    }

    public static void createRandomEllipses(Struct currentStruct, String uniqueStructName, double x, double y, double width, double height, double radiusX, double radiusY, int numSides, double separation, int numElements, int iterations, boolean RANDOMROTATION, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        MISCobjects.createRandomEllipses(currentStruct, uniqueStructName, x, y, width, height, radiusX, radiusY, numSides, separation, numElements, iterations, RANDOMROTATION);
    }

    public static void createRandomEllipsesV(Struct currentStruct, String uniqueStructName, double x, double y, double width, double height, double radiusX, double radiusY, double separation, int numElements, int iterations, boolean RANDOMROTATION, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        MISCobjects.createRandomEllipsesV(currentStruct, uniqueStructName, x, y, width, height, radiusX, radiusY, separation, numElements, iterations, RANDOMROTATION);
    }

    public static ArrayList<GArea> createResoPattern(double x, double y, double rad, double width, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createResoTestPatterns(rad, width, 0, false), THETA, x, y);
    }

    public static void createResoPattern(Struct currentStruct, double x, double y, double rad, double width, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createResoTestPatterns(rad, width, 0, false), THETA, x, y);
    }

    public static ArrayList<GArea> createResoPatternPi(double x, double y, double rad, double width, int n, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createResoTestPatterns(rad, width, n, true), THETA, x, y);
    }

    public static void createResoPatternPi(Struct currentStruct, double x, double y, double rad, double width, int n, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createResoTestPatterns(rad, width, n, true), THETA, x, y);
    }

    public static GArea createResoPatternRS(double x, double y, double W, double H, int numberOfLines, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformGArea(MISCobjects.createResoPatternRS(W, H, numberOfLines), THETA, x, y);
    }

    public static void createResoPatternRS(Struct currentStruct, double x, double y, double W, double H, int numberOfLines, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        currentStruct.add(Scripting.transformGArea(MISCobjects.createResoPatternRS(W, H, numberOfLines), THETA, x, y));
    }

    public static ArrayList<GArea> createResoPatternRSA(double x, double y, double startW, double endW, double delta, double H, int numberOfLines, double space, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(MISCobjects.createResoPatternRSA(startW, endW, delta, H, numberOfLines, space), THETA, x, y);
    }

    public static void createResoPatternRSA(Struct currentStruct, double x, double y, double startW, double endW, double delta, double H, int numberOfLines, double space, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createResoPatternRSA(startW, endW, delta, H, numberOfLines, space), THETA, x, y);
    }

    public static GArea createResoPatternLS(double x, double y, double W, double H, int numberOfLines, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformGArea(MISCobjects.createResoPatternLS(W, H, numberOfLines), THETA, x, y);
    }

    public static void createResoPatternLS(Struct currentStruct, double x, double y, double W, double H, int numberOfLines, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        currentStruct.add(Scripting.transformGArea(MISCobjects.createResoPatternLS(W, H, numberOfLines), THETA, x, y));
    }

    public static ArrayList<GArea> createResoPatternLSA(double x, double y, double startW, double endW, double delta, double H, int numberOfLines, double space, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(MISCobjects.createResoPatternLSA(startW, endW, delta, H, numberOfLines, space), THETA, x, y);
    }

    public static void createResoPatternLSA(Struct currentStruct, double x, double y, double startW, double endW, double delta, double H, int numberOfLines, double space, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createResoPatternLSA(startW, endW, delta, H, numberOfLines, space), THETA, x, y);
    }

    public static ArrayList<GArea> createSpiralArch(double x, double y, double width, int turns, double separation, double inc, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(Spirals.spiralArchimedes(width, turns, separation, inc, gdsLayer), THETA, x, y);
    }

    public static void createSpiralArch(Struct currentStruct, double x, double y, double width, int turns, double separation, double inc, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, Spirals.spiralArchimedes(width, turns, separation, inc, gdsLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createSpiralFermat(double x, double y, double width, int turns, double a, double inc, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(Spirals.spiralFermat(width, turns, a, inc, gdsLayer), THETA, x, y);
    }

    public static void createSpiralFermat(Struct currentStruct, double x, double y, double width, int turns, double a, double inc, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, Spirals.spiralFermat(width, turns, a, inc, gdsLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createSpiralLog(double x, double y, double width, int turns, double a, double b, double inc, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(Spirals.spiralLogarithmic(width, turns, a, b, inc, gdsLayer), THETA, x, y);
    }

    public static void createSpiralLog(Struct currentStruct, double x, double y, double width, int turns, double a, double b, double inc, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, Spirals.spiralLogarithmic(width, turns, a, b, inc, gdsLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createSpiralRect(double x, double y, double width, double len, double pitch, int numTurns, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MISCobjects.createRectangularSpiral(width, len, pitch, numTurns), THETA, x, y);
    }

    public static void createSpiralRect(Struct currentStruct, double x, double y, double width, double len, double pitch, int numTurns, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MISCobjects.createRectangularSpiral(width, len, pitch, numTurns), THETA, x, y);
    }

    public static void createSpinIceA(Struct currentStruct, String uniqueStructName, double x, double y, double radiusX, double radiusY, double space, double percentEmpty, int numSides, int numElementsX, int numElementsY, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        MISCobjects.spinIceA(currentStruct, uniqueStructName, x, y, radiusX, radiusY, space, percentEmpty, numSides, numElementsX, numElementsY, false);
    }

    public static void createSpinIceVectorA(Struct currentStruct, String uniqueStructName, double x, double y, double radiusX, double radiusY, double space, double percentEmpty, int numElementsX, int numElementsY, double shapeReso, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        MISCobjects.spinIceA(currentStruct, uniqueStructName, x, y, radiusX, radiusY, space, percentEmpty, 0, numElementsX, numElementsY, true);
    }

    public static ArrayList<GArea> createAlignFFFB1(double x, double y, int layerCross, int layerSquare, double THETA) {
        return Scripting.transformArrayListGArea(AlignmentMarks.createAlignFFFB1(layerCross, layerSquare), THETA, x, y);
    }

    public static void createAlignFFFB1(Struct currentStruct, double x, double y, int layerCross, int layerSquare, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarks.createAlignFFFB1(layerCross, layerSquare), THETA, x, y);
    }

    public static ArrayList<GArea> createAlignFFFB2(double x, double y, int layerCross, int layerSquare, double THETA) {
        return Scripting.transformArrayListGArea(AlignmentMarks.createAlignFFFB2(layerCross, layerSquare), THETA, x, y);
    }

    public static void createAlignFFFB2(Struct currentStruct, double x, double y, int layerCross, int layerSquare, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarks.createAlignFFFB2(layerCross, layerSquare), THETA, x, y);
    }

    public static ArrayList<GArea> createAlign3Level(double x, double y, int layerA, int layerB, int layerC, double THETA) {
        return Scripting.transformArrayListGArea(AlignmentMarks.createAlign3Level(layerA, layerB, layerC), THETA, x, y);
    }

    public static void createAlign3Level(Struct currentStruct, double x, double y, int layerA, int layerB, int layerC, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarks.createAlign3Level(layerA, layerB, layerC), THETA, x, y);
    }

    public static ArrayList<GArea> createAlignVern(double x, double y, int layer1, int layer2, double vernReso, boolean L1INV, boolean L2INV, double invL, double invW, double THETA) {
        return Scripting.transformArrayListGArea(AlignmentMarks.createAlignVern(layer1, layer2, vernReso, L1INV, L2INV, invL, invW), THETA, x, y);
    }

    public static void createAlignVern(Struct currentStruct, double x, double y, int layer1, int layer2, double vernReso, boolean L1INV, boolean L2INV, double invL, double invW, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarks.createAlignVern(layer1, layer2, vernReso, L1INV, L2INV, invL, invW), THETA, x, y);
    }

    public static ArrayList<GArea> createAlignVernLb1(double x, double y, int layer1, int layer2, double vernReso, double THETA) {
        return Scripting.transformArrayListGArea(AlignmentMarks.createAlignVernLb1(layer1, layer2, vernReso), THETA, x, y);
    }

    public static void createAlignVernLb1(Struct currentStruct, double x, double y, int layer1, int layer2, double vernReso, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarks.createAlignVernLb1(layer1, layer2, vernReso), THETA, x, y);
    }

    public static ArrayList<GArea> createAlignVernLb2(double x, double y, int layer1, int layer2, double vernReso, double THETA) {
        return Scripting.transformArrayListGArea(AlignmentMarks.createAlignVernLb2(layer1, layer2, vernReso), THETA, x, y);
    }

    public static void createAlignVernLb2(Struct currentStruct, double x, double y, int layer1, int layer2, double vernReso, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarks.createAlignVernLb2(layer1, layer2, vernReso), THETA, x, y);
    }

    public static GArea createCustomCrossC1(double x, double y, double L1, double W1, double L2, boolean INVERSE, double IL, double IW, int TYPE, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(AlignmentMarksCustom.createCustomCross(L1, W1, L2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, INVERSE, IL, IW, TYPE), THETA, x, y);
    }

    public static GArea createCustomCrossC2(double x, double y, double L1, double W1, double PL, double PW, boolean INVERSE, double IL, double IW, int TYPE, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(AlignmentMarksCustom.createCustomCross(L1, W1, 0.0, PL, PW, 0.0, 0.0, 0.0, 0.0, INVERSE, IL, IW, TYPE), THETA, x, y);
    }

    public static GArea createCustomCrossC3(double x, double y, double L1, double W1, double PL, double PW, double LX, boolean INVERSE, double IL, double IW, int TYPE, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(AlignmentMarksCustom.createCustomCross(L1, W1, 0.0, PL, PW, LX, 0.0, 0.0, 0.0, INVERSE, IL, IW, TYPE), THETA, x, y);
    }

    public static GArea createCustomCrossC4(double x, double y, double L1, double W1, double L2, double d, double BL, double BW, boolean INVERSE, double IL, double IW, int TYPE, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(AlignmentMarksCustom.createCustomCross(L1, W1, L2, 0.0, 0.0, 0.0, d, BL, BW, INVERSE, IL, IW, TYPE), THETA, x, y);
    }

    public static ArrayList<GArea> createCnstASML(String label, String barcode, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        return CNSTreticleFrames.createReticleFrame(0, barcode, label, "Serif", gdsLayer);
    }

    public static void createCnstASML(Struct currentStruct, String label, String barcode, boolean MIRROR, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, CNSTreticleFrames.createReticleFrame(0, barcode, label, "Serif", gdsLayer), MIRROR);
    }

    public static ArrayList<GArea> createCnstContact5(String label, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        return CNSTreticleFrames.createReticleFrame(1, "", label, "Serif", gdsLayer);
    }

    public static void createCnstContact5(Struct currentStruct, String label, boolean MIRROR, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, CNSTreticleFrames.createReticleFrame(1, "", label, "Serif", gdsLayer), MIRROR);
    }

    public static ArrayList<GArea> createCnstContact7(String label, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        return CNSTreticleFrames.createReticleFrame(2, "", label, "Serif", gdsLayer);
    }

    public static void createCnstContact7(Struct currentStruct, String label, boolean MIRROR, int gdsLayer) throws FileNotFoundException {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, CNSTreticleFrames.createReticleFrame(2, "", label, "Serif", gdsLayer), MIRROR);
    }

    public static ArrayList<GArea> createCustomVerniers(double x, double y, int layer1, int layer2, double L, double W, double pitch, double vernReso, double spacing, boolean INVERSE1, boolean INVERSE2, double IL, double IW, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(AlignmentMarksCustom.createCustomVerniers(layer1, layer2, L, W, pitch, vernReso, spacing, INVERSE1, INVERSE2, IL, IW), THETA, x, y);
    }

    public static void createCustomVerniers(Struct currentStruct, double x, double y, int layer1, int layer2, double L, double W, double pitch, double vernReso, double spacing, boolean INVERSE1, boolean INVERSE2, double IL, double IW, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, AlignmentMarksCustom.createCustomVerniers(layer1, layer2, L, W, pitch, vernReso, spacing, INVERSE1, INVERSE2, IL, IW), THETA, x, y);
    }

    public static ArrayList<GArea> createVerniers(double x, double y, int layer1, int layer2, double vernierReso, int ticks, String label1, String label2, double fontSize, double fontReso, double lineWidth, double lineLength, double pitch, double THETA) {
        return Scripting.transformArrayListGArea(Verniers.createVerniers(layer1, layer2, vernierReso, ticks, label1, label2, fontSize, fontReso, lineWidth, lineLength, pitch), THETA, x, y);
    }

    public static void createVerniers(Struct currentStruct, double x, double y, int layer1, int layer2, double vernierReso, int ticks, String label1, String label2, double fontSize, double fontReso, double lineWidth, double lineLength, double pitch, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, Verniers.createVerniers(layer1, layer2, vernierReso, ticks, label1, label2, fontSize, fontReso, lineWidth, lineLength, pitch), THETA, x, y);
    }

    public static GArea createArrowHead(double x, double y, double arrowW, double arrowL, double width, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PrimitiveShapes.createArrowHead(arrowW, arrowL, width), THETA, x, y);
    }

    public static GArea createArrow(double x, double y, double arrowW, double arrowL, double width, double length, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PrimitiveShapes.createArrow(arrowW, arrowL, width, length), THETA, x, y);
    }

    public static GArea createArrowLinearArray(double x, double y, double arrowW, double arrowL, double width, double length, int numberOfArrows, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PrimitiveShapes.createArrowLinearArray(arrowW, arrowL, width, length, numberOfArrows), THETA, x, y);
    }

    public static GArea createWaveGuide(double x1, double y1, double x2, double y2, double w, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createWaveGuide(x1, y1, x2, y2, w, THETA, ENDCAPLEFT, ENDCAPRIGHT, gdsLayer);
    }

    public static GArea createWaveGuideSlot(double x1, double y1, double x2, double y2, double w, double slotWidth, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createWaveGuideSlot(x1, y1, x2, y2, w, slotWidth, THETA, ENDCAPLEFT, ENDCAPRIGHT, gdsLayer);
    }

    public static GArea createWaveGuideInv(double x1, double y1, double x2, double y2, double w, double invWidth, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createWaveGuideInv(x1, y1, x2, y2, w, invWidth, THETA, ENDCAPLEFT, ENDCAPRIGHT, gdsLayer);
    }

    public static GArea createWaveGuideInvSlot(double x1, double y1, double x2, double y2, double w, double slotWidth, double invWidth, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createWaveGuideInvSlot(x1, y1, x2, y2, w, slotWidth, invWidth, THETA, ENDCAPLEFT, ENDCAPRIGHT, gdsLayer);
    }

    public static GArea createWaveGuideExpander(double x, double y, double width, double length, double deltaLength, double a, double b, double angle, double w0, double lambda, double baseHeight, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PhotonicsWaveGuides.createWaveGuideExpander(width, length, deltaLength, a, b, angle, w0, lambda, baseHeight), THETA, x, y);
    }

    public static GArea createLinearTaper(double x1, double y1, double x2, double y2, double w1, double w2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createLinearTaper(x1, y1, x2, y2, w1, w2, THETA, gdsLayer);
    }

    public static ArrayList<GArea> createLinearTaperSlot(double x1, double y1, double x2, double y2, double w1, double w2, double slotWidth1, double slotWidth2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createLinearTaperSlot(x1, y1, x2, y2, w1, w2, slotWidth1, slotWidth2, THETA, gdsLayer);
    }

    public static void createLinearTaperSlot(Struct currentStruct, double x1, double y1, double x2, double y2, double w1, double w2, double slotWidth1, double slotWidth2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, Photonics.createLinearTaperSlot(x1, y1, x2, y2, w1, w2, slotWidth1, slotWidth2, THETA, gdsLayer));
    }

    public static ArrayList<GArea> createLinearTaperInvSlot(double x1, double y1, double x2, double y2, double w1, double w2, double gap, double slotWidth1, double slotWidth2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Photonics.createLinearTaperInvSlot(x1, y1, x2, y2, w1, w2, gap, slotWidth1, slotWidth2, THETA, gdsLayer);
    }

    public static void createLinearTaperInvSlot(Struct currentStruct, double x1, double y1, double x2, double y2, double w1, double w2, double gap, double slotWidth1, double slotWidth2, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, Photonics.createLinearTaperInvSlot(x1, y1, x2, y2, w1, w2, gap, slotWidth1, slotWidth2, THETA, gdsLayer));
    }

    public static GArea createExponentialTaper(double x1, double y1, double L, double W1, double W2, int numPoints, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        ArrayList<Double> alExpTaper = Photonics.nonLinStartEnd(L, W1, W2, numPoints);
        return Photonics.createExponentialTaper(alExpTaper, x1, y1, shapeReso, THETA, gdsLayer);
    }

    public static ArrayList<GArea> createExpTaperInv(double x1, double y1, double length, double wStart, double wEnd, int nPoints, double widthAround, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createExpTaperInv(x1, y1, length, wStart, wEnd, nPoints, widthAround, THETA);
    }

    public static void createExpTaperInv(Struct currentStruct, double x1, double y1, double length, double wStart, double wEnd, int nPoints, double widthAround, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStruct(currentStruct, Photonics.createExpTaperInv(x1, y1, length, wStart, wEnd, nPoints, widthAround, THETA));
    }

    public static ArrayList<GArea> createExpTaperInvSlot(double x1, double y1, double length, double wStart, double wEnd, int nPoints, double inverseWidth, double slotW1, double slotW2, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createExpTaperInvSlot(x1, y1, length, wStart, wEnd, nPoints, inverseWidth, slotW1, slotW2, THETA);
    }

    public static void createExpTaperInvSlot(Struct currentStruct, double x1, double y1, double length, double wStart, double wEnd, int nPoints, double inverseWidth, double slotW1, double slotW2, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        Scripting.createStruct(currentStruct, Photonics.createExpTaperInvSlot(x1, y1, length, wStart, wEnd, nPoints, inverseWidth, slotW1, slotW2, THETA));
    }

    public static GArea createCustomTaper(ArrayList<Double> al, double Tx, double Ty, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(Tx);
        al.add(Ty);
        al.add(THETA);
        return Photonics.createCustomTaper(al, gdsLayer);
    }

    public static GArea createDirectionalCoupler1(double x, double y, double L1, double w1, double we1, double L2, double L3, double w2, double we2, double g, double r, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PhotonicsGratingCouplers.createDirectionalCoupler1(L1, w1, we1, L2, L3, w2, we2, g, r, numSides), THETA, x, y);
    }

    public static GArea createDirectionalCoupler2(double x, double y, double L1, double w1, double we1, double L2, double L3, double w2, double we2, double g, double r, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PhotonicsGratingCouplers.createDirectionalCoupler2(L1, w1, we1, L2, L3, w2, we2, g, r, numSides), THETA, x, y);
    }

    public static GArea createDirectionalCoupler3(double x, double y, double w, double wE, double g, double L1, double L2, double r, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PhotonicsGratingCouplers.createDirectionalCoupler3(w, wE, g, L1, L2, r, numSides), THETA, x, y);
    }

    public static GArea createDirectionalCoupler4(double x, double y, double w, double wE, double g, double L1, double LB, double HB, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PhotonicsGratingCouplers.createDirectionalCoupler4(w, wE, g, L1, LB, HB), THETA, x, y);
    }

    public static GArea createSbendTaper(double x, double y, double L, double H, double wStart, double wEnd, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createSbendTaper(0.0, 0.0, L / 2.0, 0.0, L / 2.0, H, L, H, wStart, wEnd, x, y, THETA, shapeReso, gdsLayer);
    }

    public static GArea createSbendFunnel(double x, double y, double L, double H, double W, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createSbendFunnel(0.0, 0.0, L / 2.0, 0.0, L / 2.0, H, L, H, W, x, y, THETA, shapeReso, gdsLayer);
    }

    public static GArea createSbend(double x1, double y1, double x2, double y2, double width, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createSbend(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), width, shapeReso, THETA, gdsLayer);
    }

    public static GArea createSbendLH(double x1, double y1, double length, double height, double width, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createSbend(new Point2D.Double(x1, y1), length, height, width, shapeReso, THETA, gdsLayer);
    }

    public static GArea createSbendInv(double x1, double y1, double length, double height, double width, double sleeve, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createSbendInv(x1, y1, length, height, width, sleeve, THETA);
    }

    public static GArea createSbendInvSlot(double x, double y, double length, double height, double slotWidth, double gap, double sleeve, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createSbendInvSlot(x, y, length, height, slotWidth, gap, sleeve, THETA);
    }

    public static GArea createYbend(double x1, double y1, double x2, double y2, double x3, double y3, double width, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createYbend(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3), width, shapeReso, THETA, gdsLayer);
    }

    public static GArea createYbendLH(double x1, double y1, double length2, double height2, double length3, double height3, double width, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createYbend(new Point2D.Double(x1, y1), length2, height2, length3, height3, width, shapeReso, THETA, gdsLayer);
    }

    public static GArea createYbendInv(double x1, double y1, double length2, double height2, double length3, double height3, double width, double sleeve, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createYbendInv(x1, y1, length2, height2, length3, height3, width, sleeve, THETA);
    }

    public static GArea createYBend90(double x, double y, double r1, double r2, double w, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(Photonics.createYBend90(r1, r2, w, numSides), THETA, x, y);
    }

    public static GArea createYBendInv90(double x, double y, double r1, double r2, double w, double we, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(Photonics.createYBendInv90(r1, r2, w, we, numSides), THETA, x, y);
    }

    public static GArea createYBendInvSlot90(double x, double y, double r1, double r2, double ws, double g, double we, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(Photonics.createYBendInvSlot90(r1, r2, ws, g, we, numSides), THETA, x, y);
    }

    public static GArea createYbendInvSlot(double x1, double y1, double length2, double height2, double length3, double height3, double slotWidth, double gap, double sleeve, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.createYbendInvSlot(x1, y1, length2, height2, length3, height3, slotWidth, gap, sleeve, THETA);
    }

    public static GArea create90degreeBend(double x1, double y1, double x2, double y2, double width, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.create90degreeBend(x1, y1, x2, y2, width, shapeReso, THETA, gdsLayer);
    }

    public static GArea create90degreeBendLH(double x1, double y1, double length, double height, double width, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.create90degreeBendLH(x1, y1, length, height, width, shapeReso, THETA, gdsLayer);
    }

    public static GArea create90degreeInv(double x1, double y1, double length, double height, double width, double sleeve, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.create90degreeInv(x1, y1, length, height, width, sleeve, THETA);
    }

    public static GArea create90degreeInvSlot(double x1, double y1, double length, double height, double slotWidth, double gap, double sleeve, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Photonics.create90degreeInvSlot(x1, y1, length, height, slotWidth, gap, sleeve, THETA);
    }

    public static GArea create180bend(double x, double y, double L1, double L2, double D, double W, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(Photonics.create180bend(L1, L2, D, W, numSides), THETA, x, y);
    }

    public static GArea create180bendInv(double x, double y, double L1, double L2, double D, double W, double We, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(Photonics.create180bendInverse(L1, L2, D, W, We, numSides), THETA, x, y);
    }

    public static GArea create180bendInvSlot(double x, double y, double L1, double L2, double D, double W, double gap, double We, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(Photonics.create180bendInverseSlot(L1, L2, D, W, gap, We, numSides), THETA, x, y);
    }

    public static GArea createRaceTrack(double x, double y, double length, double width, double radiusInner, double THETA, int numSides, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return PhotonicsWaveGuides.createRaceTrack(x, y, length, width, radiusInner, THETA, numSides, gdsLayer);
    }

    public static ArrayList<GArea> createSpiralDelayLineArch(double x, double y, double width, int turns, double separation, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Spirals.archimedesSpiralDelayLine(x, y, width, turns, separation, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer);
    }

    public static void createSpiralDelayLineArch(Struct currentStruct, double x, double y, double width, int turns, double separation, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, Spirals.archimedesSpiralDelayLine(x, y, width, turns, separation, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer));
    }

    public static ArrayList<GArea> createSpiralDelayLineFermat(double x, double y, double width, int turns, double a, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Spirals.fermatSpiralDelayLine(x, y, width, turns, a, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer);
    }

    public static void createSpiralDelayLineFermat(Struct currentStruct, double x, double y, double width, int turns, double a, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, Spirals.fermatSpiralDelayLine(x, y, width, turns, a, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer));
    }

    public static void createSpiralDelayLineArchV2(Struct currentStruct, double x, double y, double width, int turns, double pitch, int stepsPerTurn, int skippedTurns, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, Spirals.archimedesSpiralDelayLineV2(width, turns, pitch, stepsPerTurn, skippedTurns, length, ENDCAP, gdsLayer), THETA, x, y);
        Scripting.createStructTranslateRotate(currentStruct, Spirals.archimedesSpiralDelayLineV2(width, turns, pitch, stepsPerTurn, skippedTurns, length, ENDCAP, gdsLayer), THETA + 180.0, x, y);
    }

    public static ArrayList<GArea> createSpiralDelayLineArchInv(double x, double y, double width, double sleeveWidth, int turns, double separation, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Spirals.archimedesSpiralDelayLineINVERSE(x, y, width, sleeveWidth, turns, separation, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer);
    }

    public static void createSpiralDelayLineArchInv(Struct currentStruct, double x, double y, double width, double sleeveWidth, int turns, double separation, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStruct(currentStruct, Spirals.archimedesSpiralDelayLineINVERSE(x, y, width, sleeveWidth, turns, separation, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer));
    }

    public static ArrayList<GArea> createSpiralDelayLineFermatInv(double x, double y, double width, double sleeveWidth, int turns, double a, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Spirals.fermatSpiralDelayLineINVERSE(x, y, width, sleeveWidth, turns, a, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer);
    }

    public static void createSpiralDelayLineFermatInv(Struct currentStruct, double x, double y, double width, double sleeveWidth, int turns, double a, double deltaR, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, Spirals.fermatSpiralDelayLineINVERSE(x, y, width, sleeveWidth, turns, a, deltaR, length, Scripting.degreeToRadians(THETA), ENDCAP, gdsLayer), THETA, x, y);
    }

    public static void createSpiralDelayLineArchV2Inv(Struct currentStruct, double x, double y, double width, double sleeveWidth, int turns, double pitch, int stepsPerTurn, int skippedTurns, double length, double THETA, int ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        ArrayList<GArea> archV2INVwg = Spirals.archimedesSpiralDelayLineInvV2(width, turns, pitch, stepsPerTurn, skippedTurns, 0.0, length, 0, gdsLayer);
        ArrayList<GArea> archV2INVsleeve = Spirals.archimedesSpiralDelayLineInvV2(width + 2.0 * sleeveWidth, turns, pitch, stepsPerTurn, skippedTurns, sleeveWidth, length, ENDCAP, gdsLayer);
        Scripting.createStruct(currentStruct, Spirals.archimedesV2FracturedDelayLineINVERSE(archV2INVwg, archV2INVsleeve, x, y, Scripting.degreeToRadians(THETA), gdsLayer));
    }

    public static void createGrating(Struct currentStruct, String name, double x, double y, double width, double length, double pitch, int numberOfLines, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createGratings(currentStruct, name, x, y, width, length, pitch, numberOfLines, gdsLayer);
    }

    public static void createGratingCoupler(Struct currentStruct, double x, double y, double r, double W, double pitch, double angleStart, double angleEnd, int numSides, int numElements, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        for (int i = 0; i < numElements; ++i) {
            currentStruct.add(PrimitiveShapes.createTorusW(x, y, W + (double)i * pitch, W, angleStart, angleEnd, numSides, gdsLayer));
        }
    }

    public static GArea createApodizedGrating(double x, double y, double gratingLength, double increment, double height, double dutyCycleCutoff, double p1, double p2, double p3, double p4, double d1, double d2, double d3, double d4, double d5, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(PhotonicsGratingCouplers.createApodizedGrating(gratingLength, increment, height, dutyCycleCutoff, p1, p2, p3, p4, d1, d2, d3, d4, d5), THETA, x, y);
    }

    public static ArrayList<GArea> createGratingCWG(double x, double y, double wgWidth, double Length, double Height, double sleeve, double lambda0, double nEff, double nCladding, double thetaC, double R1, double gratingPeriod, double ratio, int numberOfElements, int numSides, int layerWaveGuide, int layerGrating, boolean ENDCAPS, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(PhotonicsGratingCouplers.createGratingCouplerWaveguideEC(wgWidth, Length, Height, sleeve, lambda0, nEff, nCladding, thetaC, R1, gratingPeriod, ratio, numberOfElements, numSides, layerWaveGuide, layerGrating, false, ENDCAPS), THETA, x, y);
    }

    public static void createGratingCWG(Struct currentStruct, double x, double y, double wgWidth, double Length, double Height, double sleeve, double lambda0, double nEff, double nCladding, double thetaC, double R1, double gratingPeriod, double ratio, int numberOfElements, int numSides, int layerWaveGuide, int layerGrating, boolean ENDCAPS, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, PhotonicsGratingCouplers.createGratingCouplerWaveguideEC(wgWidth, Length, Height, sleeve, lambda0, nEff, nCladding, thetaC, R1, gratingPeriod, ratio, numberOfElements, numSides, layerWaveGuide, layerGrating, false, ENDCAPS), THETA, x, y);
    }

    public static ArrayList<GArea> createGratingCWGinv(double x, double y, double wgWidth, double Length, double Height, double sleeve, double lambda0, double nEff, double nCladding, double thetaC, double R1, double gratingPeriod, double ratio, int numberOfElements, int numSides, int layerWaveGuide, int layerGrating, boolean ENDCAPS, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(PhotonicsGratingCouplers.createGratingCouplerWaveguideEC(wgWidth, Length, Height, sleeve, lambda0, nEff, nCladding, thetaC, R1, gratingPeriod, ratio, numberOfElements, numSides, layerWaveGuide, layerGrating, true, ENDCAPS), THETA, x, y);
    }

    public static void createGratingCWGinv(Struct currentStruct, double x, double y, double wgWidth, double Length, double Height, double sleeve, double lambda0, double nEff, double nCladding, double thetaC, double R1, double gratingPeriod, double ratio, int numberOfElements, int numSides, int layerWaveGuide, int layerGrating, boolean ENDCAPS, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, PhotonicsGratingCouplers.createGratingCouplerWaveguideEC(wgWidth, Length, Height, sleeve, lambda0, nEff, nCladding, thetaC, R1, gratingPeriod, ratio, numberOfElements, numSides, layerWaveGuide, layerGrating, true, ENDCAPS), THETA, x, y);
    }

    public static void createPhC(Struct currentStuct, String uniqueStructName, double x, double y, double radius, double pitchX, int elementsX, int elementsY, int numberOfSides, double arrayPitchDelta, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPhC(currentStuct, uniqueStructName, x, y, radius, pitchX, elementsX, elementsY, numberOfSides, arrayPitchDelta, true, false);
    }

    public static void createPhCV(Struct currentStuct, String uniqueStructName, double x, double y, double radius, double pitchX, int elementsX, int elementsY, int numberOfSides, double arrayPitchDelta, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPhC(currentStuct, uniqueStructName, x, y, radius, pitchX, elementsX, elementsY, numberOfSides, arrayPitchDelta, true, true);
    }

    public static void createHex(Struct currentStuct, String uniqueStructName, double x, double y, double radius, double pitchX, int elementsX, int elementsY, int numberOfSides, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PrimitiveShapes.createPhC(currentStuct, uniqueStructName, x, y, radius, pitchX, elementsX, elementsY, numberOfSides, 0.0, false, false);
    }

    public static void createHexV(Struct currentStuct, String uniqueStructName, double x, double y, double radius, double pitchX, int elementsX, int elementsY, int numberOfSides, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PrimitiveShapes.createPhC(currentStuct, uniqueStructName, x, y, radius, pitchX, elementsX, elementsY, numberOfSides, 0.0, false, true);
    }

    public static void createDiscInfinite(Struct currentStuct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfiniteRingDisc(currentStuct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, true, ENDCAP, gdsLayer);
    }

    public static void createRingInfinite(Struct currentStuct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfiniteRingDisc(currentStuct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, false, ENDCAP, gdsLayer);
    }

    public static void createDiscInfDS(Struct currentStuct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double gap2, double length2, double width2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfRingDiscDS(currentStuct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, gap2, length2, width2, true, ENDCAP, gdsLayer);
    }

    public static void createRingInfDS(Struct currentStuct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double gap2, double length2, double width2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfRingDiscDS(currentStuct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, gap2, length2, width2, false, ENDCAP, gdsLayer);
    }

    public static void createDiscInfiniteInv(Struct currentStuct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfiniteRingDiscInverse(currentStuct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, true, ENDCAP, gdsLayer);
    }

    public static void createRingInfiniteInv(Struct currentStuct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfiniteRingDiscInverse(currentStuct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, false, ENDCAP, gdsLayer);
    }

    public static void createDiscInfInvDS(Struct currentStuct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, double gap2, double length2, double width2, double sleeve2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfRingDiscInvDS(currentStuct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, gap2, length2, width2, sleeve2, true, ENDCAP, gdsLayer);
    }

    public static void createRingInfInvDS(Struct currentStuct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, double gap2, double length2, double width2, double sleeve2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfRingDiscInvDS(currentStuct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, gap2, length2, width2, sleeve2, false, ENDCAP, gdsLayer);
    }

    public static void createDiscInfiniteInvPos(Struct currentStuct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfiniteRingDiscInversePos(currentStuct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, true, ENDCAP, gdsLayer);
    }

    public static void createRingInfiniteInvPos(Struct currentStuct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfiniteRingDiscInversePos(currentStuct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, false, ENDCAP, gdsLayer);
    }

    public static void createDiscInfInvPosDS(Struct currentStuct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, double gap2, double length2, double width2, double sleeve2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfRingDiscInvPosDS(currentStuct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, gap2, length2, width2, sleeve2, true, ENDCAP, gdsLayer);
    }

    public static void createRingInfInvPosDS(Struct currentStuct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, double gap2, double length2, double width2, double sleeve2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createInfRingDiscInvPosDS(currentStuct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideLength, waveguideWidth, sleeveWidth, gap2, length2, width2, sleeve2, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetric(Struct currentStuct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymmetricRingDisc(currentStuct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetric(Struct currentStuct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymmetricRingDisc(currentStuct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricLC(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymmetricRingDisc(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricLC(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymmetricRingDisc(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymLCDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymLCDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymLCPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymLCPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + ringWidth + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + ringWidth + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymmetricA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymmetricA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double angle2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle2, width2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double angle2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle2, width2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricLCA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymmetricA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricLCA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymmetricA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymLCADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymLCADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymLCAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double Lc2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle22, width2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymLCAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double Lc2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + ringWidth + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + ringWidth + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle22, width2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInv(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInv(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInvLC(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInvLC(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvLCDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvLCDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvLCPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0 + sleeveWidth);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0 + sleeve2);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvLCPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + ringWidth + gap + waveguideWidth / 2.0 + sleeveWidth);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + ringWidth + gap2 + width2 / 2.0 + sleeve2);
        PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInvA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymmetricInvA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInvA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymmetricInvA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInvLCA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymmetricInvA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInvLCA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymmetricInvA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvLCADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvLCADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvLCAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + sleeve2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvLCAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + ringWidth + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + ringWidth + gap2 + sleeve2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInvPos(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInvPos(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosDS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosDS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInversePosLC(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInversePosLC(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosLCDS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosLCDS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosLCPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosLCPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInvPosA(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInvPosA(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosADS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosADS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosAPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymmetricInvPosLCA(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymmetricInvPosLCA(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosLCADS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosLCADS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscSymInvPosLCAPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingSymInvPosLCAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulley(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulleyRingDisc(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulley(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulleyRingDisc(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double length2, double heigth2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, length2, heigth2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double length2, double heigth2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, length2, heigth2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyLC(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulleyRingDisc(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyLC(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulleyRingDisc(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulLCDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulLCDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulLCPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double length2, double heigth2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, length2, heigth2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulLCPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double length2, double heigth2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + ringWidth + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + ringWidth + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createPulRingDiscDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, length2, heigth2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulleyA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulleyA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double angle2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle2, width2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double angle2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle2, width2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyLCA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulleyA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyLCA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulleyA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulLCADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulLCADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, 0.0, width2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulLCAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double Lc2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle22, width2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulLCAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double Lc2, double width2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + ringWidth + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + ringWidth + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, waveguideLength, gap2, angle22, width2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInverse(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInverse(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvLC(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvLC(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvLCDS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvLCDS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + ringWidth + gap + waveguideWidth / 2.0 + sleeveWidth);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvLCPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0 + sleeveWidth);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0 + sleeve2);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvLCPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + ringWidth + gap + waveguideWidth / 2.0 + sleeveWidth);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + ringWidth + gap2 + width2 / 2.0 + sleeve2);
        PhotonicsDiscRingPulleys.createPulRDInvDSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulleyInvA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulleyInvA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvLCA(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulleyInvA(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvLCA(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulleyInvA(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvLCADS(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvLCADS(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + ringWidth + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvLCAPul(Struct currentStruct, double x, double y, double radius, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + sleeve2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, 0.0, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvLCAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + ringWidth + gap + sleeveWidth + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + ringWidth + gap2 + sleeve2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvADSPul(currentStruct, x, y, radius, ringWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvPos(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvPos(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPDS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPDS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle2, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvPosLC(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvPosLC(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPLCDS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPLCDS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double thetaWG = 1.5707963267948966 - 0.5 * Lc / (radius + gap + waveguideWidth / 2.0);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, 0.0, width2, sleeve2, length2, 0.0, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPLCPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPLCPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double Lc2, double width2, double sleeve2, double length2, double height2, boolean ENDCAP, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        double angle1 = 1.5707963267948966 - 0.5 * Lc1 / (radius + gap + waveguideWidth / 2.0);
        double angle22 = 1.5707963267948966 - 0.5 * Lc2 / (radius + gap2 + width2 / 2.0);
        PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1 * 180.0 / Math.PI, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, waveguideHeight, gap2, angle22 * 180.0 / Math.PI, width2, sleeve2, length2, height2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvPosA(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulleyInvPosA(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvPosA(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulleyInvPosA(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPADS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPADS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPAPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, waveguideAngle, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle2, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulleyInvPosLCA(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulleyInvPosA(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulleyInvPosLCA(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulleyInvPosA(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, true, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPLCADS(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPLCADS(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double thetaWG = 0.5 * (Math.PI - Lc / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, thetaWG, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, 0.0, width2, sleeve2, length2, true, false, ENDCAP, gdsLayer);
    }

    public static void createDiscPulInvPLCAPul(Struct currentStruct, double x, double y, double radius, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, 0.0, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, true, ENDCAP, gdsLayer);
    }

    public static void createRingPulInvPLCAPul(Struct currentStruct, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double Lc1, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double Lc2, double width2, double sleeve2, double length2, boolean ENDCAP, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        double angle1 = 0.5 * (Math.PI - Lc1 / (radius + gap + waveguideWidth / 2.0)) * 57.29577951308232;
        double angle22 = 0.5 * (Math.PI - Lc2 / (radius + gap2 + width2 / 2.0)) * 57.29577951308232;
        PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(currentStruct, x, y, radius, ringWidth, ringDiscSleeveWidth, numberOfSidesDiscRing, gap, angle1, numberOfSidesCouplingRegion, waveguideWidth, sleeveWidth, waveguideLength, gap2, angle22, width2, sleeve2, length2, false, false, ENDCAP, gdsLayer);
    }

    public static ArrayList<GArea> createWaveGuideInvPhC(ArrayList<Double> al, double x, double y, double a, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        return PhotonicsWaveGuides.createWgInvPhC(al, gdsLayer);
    }

    public static void createWaveGuideInvPhC(Struct currentStruct, ArrayList<Double> al, double x, double y, double a, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgInvPhC(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideInvPhCvary(ArrayList<Double> al, double x, double y, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        return PhotonicsWaveGuides.createWgInvPhCvary(al, gdsLayer);
    }

    public static void createWaveGuideInvPhCvary(Struct currentStruct, ArrayList<Double> al, double x, double y, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgInvPhCvary(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuidePhC(ArrayList<Double> al, double x, double y, double a, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        al.add(So);
        al.add(Sh);
        return PhotonicsWaveGuides.createWgPhC(al, gdsLayer);
    }

    public static void createWaveGuidePhC(Struct currentStruct, ArrayList<Double> al, double x, double y, double a, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        al.add(So);
        al.add(Sh);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgPhC(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuidePhCvary(ArrayList<Double> al, double x, double y, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(So);
        al.add(Sh);
        return PhotonicsWaveGuides.createWgPhCvary(al, gdsLayer);
    }

    public static void createWaveGuidePhCvary(Struct currentStruct, ArrayList<Double> al, double x, double y, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(So);
        al.add(Sh);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgPhCvary(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideInvRectPhC(ArrayList<Double> al, double x, double y, double a, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        return PhotonicsWaveGuides.createWgInvRectPhC(al, gdsLayer);
    }

    public static void createWaveGuideInvRectPhC(Struct currentStruct, ArrayList<Double> al, double x, double y, double a, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgInvRectPhC(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideInvRectPhCvary(ArrayList<Double> al, double x, double y, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        return PhotonicsWaveGuides.createWgInvRectPhCvary(al, gdsLayer);
    }

    public static void createWaveGuideInvRectPhCvary(Struct currentStruct, ArrayList<Double> al, double x, double y, double W, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgInvRectPhCvary(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideRectPhC(ArrayList<Double> al, double x, double y, double a, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        al.add(So);
        al.add(Sh);
        return PhotonicsWaveGuides.createWgRectPhC(al, gdsLayer);
    }

    public static void createWaveGuideRectPhC(Struct currentStruct, ArrayList<Double> al, double x, double y, double a, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(a);
        al.add(W);
        al.add(So);
        al.add(Sh);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgRectPhC(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideRectPhCvary(ArrayList<Double> al, double x, double y, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(So);
        al.add(Sh);
        return PhotonicsWaveGuides.createWgRectPhCvary(al, gdsLayer);
    }

    public static void createWaveGuideRectPhCvary(Struct currentStruct, ArrayList<Double> al, double x, double y, double W, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(So);
        al.add(Sh);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgRectPhCvary(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideInvRectFlushPhCvary(ArrayList<Double> al, double x, double y, double W, double d, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(d);
        return PhotonicsWaveGuides.createWgInvRectFlushPhC(al, gdsLayer);
    }

    public static void createWaveGuideInvRectFlushPhCvary(Struct currentStruct, ArrayList<Double> al, double x, double y, double W, double d, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(d);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgInvRectFlushPhC(al, gdsLayer));
    }

    public static ArrayList<GArea> createWaveGuideRectFlushPhCvary(ArrayList<Double> al, double x, double y, double W, double d, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(d);
        al.add(So);
        al.add(Sh);
        return PhotonicsWaveGuides.createWgRectFlushPhC(al, gdsLayer);
    }

    public static void createWaveGuideRectFlushPhCvary(Struct currentStruct, ArrayList<Double> al, double x, double y, double W, double d, double So, double Sh, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(x);
        al.add(y);
        al.add(W);
        al.add(d);
        al.add(So);
        al.add(Sh);
        Scripting.createStruct(currentStruct, PhotonicsWaveGuides.createWgRectFlushPhC(al, gdsLayer));
    }

    public static GArea createWgdcd1(double x, double y, double rad, int numSides, double dx, double dy, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double ry, double dEllipse, double cutWidth, double cutPosition, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd1(rad, numSides, dx, dy, wgWidth, wgLength, wgRad, sleeve, gap, ry, dEllipse, cutWidth, cutPosition);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea createWgdcd2(double x, double y, double rad, int numSides, double dx, double dy, double H2, double W2, double tipH, double tipW, double tipS, double tipY, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double cutWidth, double cutPosition, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd2(rad, numSides, dx, dy, H2, W2, tipH, tipW, tipS, tipY, wgWidth, wgLength, wgRad, sleeve, gap, cutWidth, cutPosition);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea createWgdcd3(double x, double y, double rad, int numSides, double dx, double dy, double dBoxBelowGap, double H2, double W2, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double cutWidth, double cutPosition, double distance, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd3(rad, numSides, dx, dy, dBoxBelowGap, H2, W2, wgWidth, wgLength, wgRad, sleeve, gap, cutWidth, cutPosition, distance);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea createWgdcd4(double x, double y, double rad, int numSides, double dx, double dy, double dBoxBelowGap, double H2, double triH, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double cutWidth, double cutPosition, double distance, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd4(rad, numSides, dx, dy, dBoxBelowGap, H2, triH, wgWidth, wgLength, wgRad, sleeve, gap, cutWidth, cutPosition, distance);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea createWgdcd5(double x, double y, double rad, int numSides, double dx, double dy, double dBoxBelowGap, double triH, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double cutWidth, double cutPositionUpper, double cutPositionLower, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd5(rad, numSides, dx, dy, dBoxBelowGap, triH, wgWidth, wgLength, wgRad, sleeve, gap, cutWidth, cutPositionUpper, cutPositionLower);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea createWgdcd6(double x, double y, double rad, int numSides, double dx, double dy, double dBoxBelowGap, double triCutH, double triH, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double cutWidth, double cutPositionUpper, double cutPositionLower, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd6(rad, numSides, dx, dy, dBoxBelowGap, triCutH, triH, wgWidth, wgLength, wgRad, sleeve, gap, cutWidth, cutPositionUpper, cutPositionLower);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea createWgdcd7(double x, double y, double rad, double rad2, int numSides, double dx, double dy, double wgWidth, double wgLength, double wgRad, double sleeve, double gap, double cutWidth, double cutPosition, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        GArea v = PhotonicsWgDcThomasVladimir.createWgdcd7(rad, rad2, numSides, dx, dy, wgWidth, wgLength, wgRad, sleeve, gap, cutWidth, cutPosition);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static ArrayList<GArea> createWgdcd8(double x, double y, double bottomTaperWidth, double frameWidth, double bottomInteriorWidth, double sleeve, double wgWidthTop, double wgWidthBottom, double wgStraightLengthTop, double wgTaperedLength, double gap, double cutWidth, double dCut, double largeBoxW, double largeBoxH, int L1, int L2, int L3, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(PhotonicsWgDcThomasVladimir.createWgdcd8(bottomTaperWidth, frameWidth, bottomInteriorWidth, sleeve, wgWidthTop, wgWidthBottom, wgStraightLengthTop, wgTaperedLength, gap, cutWidth, dCut, largeBoxW, largeBoxH, L1, L2, L3), THETA, x, y);
    }

    public static ArrayList<GArea> createBentBeam(double x, double y, double width, double length1, double length2, double length3, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createBentBeam(width, length1, length2, length3, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createBentBeam(Struct currentStruct, double x, double y, double width, double length1, double length2, double length3, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createBentBeam(width, length1, length2, length3, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createBentBeamArray(double x, double y, double width, double length1, double length2, double length3, double length4, double hOffset, double pitch, int numElements, double centralBeamWidth, double dimpleHeight, double dimpleWidth, int dimpleLayer, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createBentBeamArray(width, length1, length2, length3, length4, hOffset, pitch, numElements, centralBeamWidth, dimpleHeight, dimpleWidth, dimpleLayer, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createBentBeamArray(Struct currentStruct, double x, double y, double width, double length1, double length2, double length3, double length4, double hOffset, double pitch, int numElements, double centralBeamWidth, double dimpleHeight, double dimpleWidth, int dimpleLayer, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createBentBeamArray(width, length1, length2, length3, length4, hOffset, pitch, numElements, centralBeamWidth, dimpleHeight, dimpleWidth, dimpleLayer, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createBiMorph(double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double pitch, double dimpleHeight, double dimpleWidth, int dimpleLayer, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createBiMorphThermal(width1, width2, width3, width4, length1, length2, length3, pitch, dimpleHeight, dimpleWidth, dimpleLayer, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createBiMorph(Struct currentStruct, double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double pitch, double dimpleHeight, double dimpleWidth, int dimpleLayer, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createBiMorphThermal(width1, width2, width3, width4, length1, length2, length3, pitch, dimpleHeight, dimpleWidth, dimpleLayer, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCombDriveV1(double x, double y, double width1, double width2, double length1, double length2, int numElectrodes, double pitch, double baseHeight, int baseLayer, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createCombDriveV1(width1, width2, length1, length2, numElectrodes, pitch, baseHeight, baseLayer, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCombDriveV1(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, int numElectrodes, double pitch, double baseHeight, int baseLayer, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createCombDriveV1(width1, width2, length1, length2, numElectrodes, pitch, baseHeight, baseLayer, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createLinearDriveV1(double x, double y, double width1, double length1, double length2, double length3, double gap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double rotorPitch, int rotorLayer, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createLinearDriveV1(width1, length1, length2, length3, gap, numElectrodes, pitch, baseHeight, baseWidth, rotorPitch, rotorLayer, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createLinearDriveV1(Struct currentStruct, double x, double y, double width1, double length1, double length2, double length3, double gap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double rotorPitch, int rotorLayer, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createLinearDriveV1(width1, length1, length2, length3, gap, numElectrodes, pitch, baseHeight, baseWidth, rotorPitch, rotorLayer, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring1A(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring1A2A(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, false), THETA, x, y);
    }

    public static void createFoldedSpring1A(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring1A2A(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, false), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2A(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring1A2A(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, true), THETA, x, y);
    }

    public static void createFoldedSpring2A(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring1A2A(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, true), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring1B(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring1B2B(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, false), THETA, x, y);
    }

    public static void createFoldedSpring1B(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring1B2B(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, false), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2B(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring1B2B(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, true), THETA, x, y);
    }

    public static void createFoldedSpring2B(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring1B2B(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer, true), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2C(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2C(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2C(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2C(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2D(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2D(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2D(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2D(width, length1, length2, pitch, amplitude, numberOfPeriods, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2E(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2E(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2E(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2E(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2F(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2F(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2F(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2F(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2G(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2G(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2G(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2G(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2H(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2H(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2H(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2H(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2I(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double diameter, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2I(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, diameter, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2I(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double diameter, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2I(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, diameter, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFoldedSpring2J(double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double diameter, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createFoldedSpring2J(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, diameter, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFoldedSpring2J(Struct currentStruct, double x, double y, double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double diameter, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFoldedSpring2J(width, length1, length2, pitch, amplitude, numberOfPeriods, numSides, diameter, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createBolometerL(double x, double y, double w1, double w2, double w3, double g1, double g2, double g3, double L1, double L2, double r, double ri, int numSides, double a, double b, double c, double d, double e, double f, int La, int Lb, int Lc, int Ld, int Le, int Lf, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(MEMSactuators.createBolometerL(w1, w2, w3, g1, g2, g3, L1, L2, r, ri, numSides, a, b, c, d, e, f, La, Lb, Lc, Ld, Le, Lf), THETA, x, y);
    }

    public static void createBolometerL(Struct currentStruct, double x, double y, double w1, double w2, double w3, double g1, double g2, double g3, double L1, double L2, double r, double ri, int numSides, double a, double b, double c, double d, double e, double f, int La, int Lb, int Lc, int Ld, int Le, int Lf, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createBolometerL(w1, w2, w3, g1, g2, g3, L1, L2, r, ri, numSides, a, b, c, d, e, f, La, Lb, Lc, Ld, Le, Lf), THETA, x, y);
    }

    public static ArrayList<GArea> createBolometerU(double x, double y, double w1, double w2, double w3, double g1, double g2, double g3, double L1, double L2, double r, double ri, int numSides, double a, double b, double c, double d, double e, double f, int La, int Lb, int Lc, int Ld, int Le, int Lf, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(MEMSactuators.createBolometerU(w1, w2, w3, g1, g2, g3, L1, L2, r, ri, numSides, a, b, c, d, e, f, La, Lb, Lc, Ld, Le, Lf), THETA, x, y);
    }

    public static void createBolometerU(Struct currentStruct, double x, double y, double w1, double w2, double w3, double g1, double g2, double g3, double L1, double L2, double r, double ri, int numSides, double a, double b, double c, double d, double e, double f, int La, int Lb, int Lc, int Ld, int Le, int Lf, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createBolometerU(w1, w2, w3, g1, g2, g3, L1, L2, r, ri, numSides, a, b, c, d, e, f, La, Lb, Lc, Ld, Le, Lf), THETA, x, y);
    }

    public static ArrayList<GArea> createGear(double x, double y, double rad, double width, double height, int numberOfGears, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createGear(rad, width, height, numberOfGears, 0.0, numSides), THETA, x, y);
    }

    public static void createGear(Struct currentStruct, double x, double y, double rad, double width, double height, int numberOfGears, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createGear(rad, width, height, numberOfGears, 0.0, numSides), THETA, x, y);
    }

    public static ArrayList<GArea> createGearT(double x, double y, double rad, double width, double height, int numberOfGears, double triangleL, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createGear(rad, width, height, numberOfGears, triangleL, numSides), THETA, x, y);
    }

    public static void createGearT(Struct currentStruct, double x, double y, double rad, double width, double height, int numberOfGears, double triangleL, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createGear(rad, width, height, numberOfGears, triangleL, numSides), THETA, x, y);
    }

    public static ArrayList<GArea> createStraightSpring(double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createStraightSpring(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createStraightSpring(Struct currentStruct, double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createStraightSpring(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCircularSpring(double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createCircularSpring(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCircularSpring(Struct currentStruct, double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createCircularSpring(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createStraightSpringE(double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double gap, double electrodeWidth, int numElectrodes, double gapFraction, double anchorElectrodeDistance, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createStraightSpringElectrodes(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, gap, electrodeWidth, numElectrodes, gapFraction, anchorElectrodeDistance, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createtraightSpringE(Struct currentStruct, double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double gap, double electrodeWidth, int numElectrodes, double gapFraction, double anchorElectrodeDistance, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createStraightSpringElectrodes(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, gap, electrodeWidth, numElectrodes, gapFraction, anchorElectrodeDistance, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCircularSpringE(double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double gap, double electrodeWidth, int numElectrodes, double gapFraction, double anchorElectrodeDistance, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createCircularSpringElectrode(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, gap, electrodeWidth, numElectrodes, gapFraction, anchorElectrodeDistance, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCircularSpringE(Struct currentStruct, double x, double y, double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double gap, double electrodeWidth, int numElectrodes, double gapFraction, double anchorElectrodeDistance, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createCircularSpringElectrode(width, radiusCenterHub, widthRing, radiusRing, numSides, numElements, gap, electrodeWidth, numElectrodes, gapFraction, anchorElectrodeDistance, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCombRadialV1(double x, double y, double w1, double r1, double w2, double r2, double wc, double gap, int numElements, int numSides, double thetaComb, double thetaOverlap, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createRadialCombDriveV1(w1, r1, w2, r2, wc, gap, numElements, numSides, thetaComb, thetaOverlap, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCombRadialV1(Struct currentStruct, double x, double y, double w1, double r1, double w2, double r2, double wc, double gap, int numElements, int numSides, double thetaComb, double thetaOverlap, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createRadialCombDriveV1(w1, r1, w2, r2, wc, gap, numElements, numSides, thetaComb, thetaOverlap, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCombRadialV2(double x, double y, double w1, double r1, double w2, double r2, double wc, double gap, int numElements, int numSides, double thetaComb, double thetaOverlap, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSactuators.createRadialCombDriveV2(w1, r1, w2, r2, wc, gap, numElements, numSides, thetaComb, thetaOverlap, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCombRadialV2(Struct currentStruct, double x, double y, double w1, double r1, double w2, double r2, double wc, double gap, int numElements, int numSides, double thetaComb, double thetaOverlap, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createRadialCombDriveV2(w1, r1, w2, r2, wc, gap, numElements, numSides, thetaComb, thetaOverlap, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure2A(double x, double y, double width, double length1, double length2, double widthMass, double lengthMass, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges2A(width, length1, length2, widthMass, lengthMass, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure2A(Struct currentStruct, double x, double y, double width, double length1, double length2, double widthMass, double lengthMass, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges2A(width, length1, length2, widthMass, lengthMass, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure2B(double x, double y, double width, double length1, double length2, double widthMass, double lengthMass, double connectorHeight, double connectorWidth, double squareHeight, double squareWidth, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges2B(width, length1, length2, widthMass, lengthMass, connectorHeight, connectorWidth, squareHeight, squareWidth, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure2B(Struct currentStruct, double x, double y, double width, double length1, double length2, double widthMass, double lengthMass, double connectorHeight, double connectorWidth, double squareHeight, double squareWidth, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges2B(width, length1, length2, widthMass, lengthMass, connectorHeight, connectorWidth, squareHeight, squareWidth, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure2C(double x, double y, double width, double length1, double length2, double length3, double widthMass, double lengthMass, double amplitude, int periods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges2C(width, length1, length2, length3, widthMass, lengthMass, amplitude, periods, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure2C(Struct currentStruct, double x, double y, double width, double length1, double length2, double length3, double widthMass, double lengthMass, double amplitude, int periods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges2C(width, length1, length2, length3, widthMass, lengthMass, amplitude, periods, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure2D(double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double length4, double length5, double length6, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges2D(width1, width2, width3, width4, length1, length2, length3, length4, length5, length6, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure2D(Struct currentStruct, double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double length4, double length5, double length6, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges2D(width1, width2, width3, width4, length1, length2, length3, length4, length5, length6, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure2E(double x, double y, double width1, double width2, double width3, double width4, double width5, double length1, double length2, double length3, double length4, double gap, double baseExtent, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges2E(width1, width2, width3, width4, width5, length1, length2, length3, length4, gap, baseExtent, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure2E(Struct currentStruct, double x, double y, double width1, double width2, double width3, double width4, double width5, double length1, double length2, double length3, double length4, double gap, double baseExtent, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges2E(width1, width2, width3, width4, width5, length1, length2, length3, length4, gap, baseExtent, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure4A(double x, double y, double width, double length1, double length2, double widthMass, double lengthMass, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges4A(width, length1, length2, widthMass, lengthMass, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure4A(Struct currentStruct, double x, double y, double width, double length1, double length2, double widthMass, double lengthMass, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges4A(width, length1, length2, widthMass, lengthMass, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure4B(double x, double y, double width, double length1, double length2, double widthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges4B(width, length1, length2, widthMass, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure4B(Struct currentStruct, double x, double y, double width, double length1, double length2, double widthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges4B(width, length1, length2, widthMass, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure4C(double x, double y, double width, double length1, double length2, double length3, double length4, double widthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges4C(width, length1, length2, length3, length4, widthMass, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure4C(Struct currentStruct, double x, double y, double width, double length1, double length2, double length3, double length4, double widthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges4C(width, length1, length2, length3, length4, widthMass, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure4D(double x, double y, double width1, double width2, double width3, double length1, double length2, double widthMass, double lengthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges4D(width1, width2, width3, length1, length2, widthMass, lengthMass, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure4D(Struct currentStruct, double x, double y, double width1, double width2, double width3, double length1, double length2, double widthMass, double lengthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges4D(width1, width2, width3, length1, length2, widthMass, lengthMass, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFlexure4E(double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double length4, double length5, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSflexureHinges.createFlexureHinges4E(width1, width2, width3, width4, length1, length2, length3, length4, length5, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createFlexure4E(Struct currentStruct, double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double length4, double length5, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSflexureHinges.createFlexureHinges4E(width1, width2, width3, width4, length1, length2, length3, length4, length5, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverL(double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double linearVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createCantileverLinear(width, startL, pitch, numElements, baseHeight, baseExtent, linearVar), THETA, x, y);
    }

    public static void createCantileverL(Struct currentStruct, double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double linearVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createCantileverLinear(width, startL, pitch, numElements, baseHeight, baseExtent, linearVar), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverP(double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double percentageVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createCantileverPercentage(width, startL, pitch, numElements, baseHeight, baseExtent, percentageVar), THETA, x, y);
    }

    public static void createCantileverP(Struct currentStruct, double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double percentageVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createCantileverPercentage(width, startL, pitch, numElements, baseHeight, baseExtent, percentageVar), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSine(double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double sineAmplitude, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createCantileverSinusoid(width, startL, pitch, numElements, baseHeight, baseExtent, sineAmplitude), THETA, x, y);
    }

    public static void createCantileverSine(Struct currentStruct, double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double sineAmplitude, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createCantileverSinusoid(width, startL, pitch, numElements, baseHeight, baseExtent, sineAmplitude), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverLSE(double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createCantileverLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static void createCantileverLSE(Struct currentStruct, double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createCantileverLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverNLSE(double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createCantileverNonLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static void createCantileverNLSE(Struct currentStruct, double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createCantileverNonLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverCustom(double x, double y, ArrayList<Double> al, double sEnd, double bH, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(sEnd);
        al.add(bH);
        al.add(0.0);
        return Scripting.transformArrayListGArea(MEMSbeams.createCantileverCustom(al), THETA, x, y);
    }

    public static void createCantileverCustom(Struct currentStruct, double x, double y, ArrayList<Double> al, double sEnd, double bH, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(0, y);
        al.add(0, x);
        al.add(sEnd);
        al.add(bH);
        al.add(THETA);
        Scripting.createStructRotate(currentStruct, MEMSbeams.createCantileverCustom(al), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSR(double x, double y, double width, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverSRect(width, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverSR(Struct currentStruct, double x, double y, double width, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverSRect(width, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSTri(double x, double y, double width, double length, double triangleHeight, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverSTriangle(width, length, triangleHeight, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverSTri(Struct currentStruct, double x, double y, double width, double length, double triangleHeight, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverSTriangle(width, length, triangleHeight, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSTrap(double x, double y, double widthBottom, double widthTop, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverSTrapezoid(widthBottom, widthTop, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverSTrap(Struct currentStruct, double x, double y, double widthBottom, double widthTop, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverSTrapezoid(widthBottom, widthTop, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSPaddle(double x, double y, double widthBot, double widthTop, double lengthBot, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverSPaddle(widthBot, widthTop, lengthBot, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverSPaddle(Struct currentStruct, double x, double y, double widthBot, double widthTop, double lengthBot, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverSPaddle(widthBot, widthTop, lengthBot, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSCH(double x, double y, double width, double radius, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverSCurvedHalf(width, radius, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverSCH(Struct currentStruct, double x, double y, double width, double radius, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverSCurvedHalf(width, radius, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverSCF(double x, double y, double width, double radius, int numSides, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverSCurvedFull(width, radius, numSides, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverSCF(Struct currentStruct, double x, double y, double width, double radius, int numSides, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverSCurvedFull(width, radius, numSides, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverHR(double x, double y, double width, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverHRect(width, length, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverHR(Struct currentStruct, double x, double y, double width, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverHRect(width, length, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverHTri(double x, double y, double width, double length, double triangleHeight, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverHTriangle(width, length, triangleHeight, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverHTri(Struct currentStruct, double x, double y, double width, double length, double triangleHeight, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverHTriangle(width, length, triangleHeight, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverHTrap(double x, double y, double widthBottom, double widthTop, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverHTrapezoid(widthBottom, widthTop, length, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverHTrap(Struct currentStruct, double x, double y, double widthBottom, double widthTop, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverHTrapezoid(widthBottom, widthTop, length, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverHPaddle(double x, double y, double widthBot, double widthTop, double lengthBot, double lengthTop, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverHPaddle(widthBot, widthTop, lengthBot, lengthTop, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverHPaddle(Struct currentStruct, double x, double y, double widthBot, double widthTop, double lengthBot, double lengthTop, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverHPaddle(widthBot, widthTop, lengthBot, lengthTop, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverHCH(double x, double y, double width, double radius, int numSides, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverHCurvedHalf(width, radius, numSides, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverHCH(Struct currentStruct, double x, double y, double width, double radius, int numSides, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverHCurvedHalf(width, radius, numSides, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverHCF(double x, double y, double width, double radius, int numSides, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverHCurvedFull(width, radius, numSides, length, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverHCF(Struct currentStruct, double x, double y, double width, double radius, int numSides, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverHCurvedFull(width, radius, numSides, length, hollowW, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverPB2(double x, double y, double width, double length1, double length2, double lengthTop, double gap, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverPB2(width, length1, length2, lengthTop, gap, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverPB2(Struct currentStruct, double x, double y, double width, double length1, double length2, double lengthTop, double gap, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverPB2(width, length1, length2, lengthTop, gap, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverPB3(double x, double y, double width, double length1, double length2, double length3, double lengthTop, double gap, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverPB3(width, length1, length2, length3, lengthTop, gap, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverPB3(Struct currentStruct, double x, double y, double width, double length1, double length2, double length3, double lengthTop, double gap, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverPB3(width, length1, length2, length3, lengthTop, gap, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverUR(double x, double y, double width, double length1, double length2, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverUR(width, length1, length2, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverUR(Struct currentStruct, double x, double y, double width, double length1, double length2, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverUR(width, length1, length2, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverUCF(double x, double y, double width, double length1, double length2, double lengthTop, double radius, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverUCF(width, length1, length2, lengthTop, radius, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverUCF(Struct currentStruct, double x, double y, double width, double length1, double length2, double lengthTop, double radius, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverUCF(width, length1, length2, lengthTop, radius, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverUC(double x, double y, double width, double length1, double length2, double diameter, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverUC(width, length1, length2, diameter, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverUC(Struct currentStruct, double x, double y, double width, double length1, double length2, double diameter, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverUC(width, length1, length2, diameter, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverUCC(double x, double y, double width1, double width2, double length1, double length2, double length3, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverUCC(width1, width2, length1, length2, length3, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverUCC(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2, double length3, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverUCC(width1, width2, length1, length2, length3, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverUCP(double x, double y, double width1, double width2, double length1, double length2a, double length2b, double length3, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverUCP(width1, width2, length1, length2a, length2b, length3, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverUCP(Struct currentStruct, double x, double y, double width1, double width2, double length1, double length2a, double length2b, double length3, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverUCP(width1, width2, length1, length2a, length2b, length3, lengthTop, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCantileverCE(double x, double y, double width, double length, double rX, double rY, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverCE(width, length, rX, rY, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCantileverCE(Struct currentStruct, double x, double y, double width, double length, double rX, double rY, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverCE(width, length, rX, rY, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createCnntileverCEPaddle(double x, double y, double width, double length, double rX1, double rY1, double rX2, double rY2, int numSides, double paddleW, double paddleL, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createLeverCEPaddle(width, length, rX1, rY1, rX2, rY2, numSides, paddleW, paddleL, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createCnntileverCEPaddle(Struct currentStruct, double x, double y, double width, double length, double rX1, double rY1, double rX2, double rY2, int numSides, double paddleW, double paddleL, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createLeverCEPaddle(width, length, rX1, rY1, rX2, rY2, numSides, paddleW, paddleL, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static GArea createBeamCurvedEnds(double x, double y, double L, double W, double r, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(MEMSbeams.createBeamCurvedEnds(L, W, r, numSides, false, false), THETA, x, y);
    }

    public static GArea createBeamCurvedEndsV(double x, double y, double L, double W, double r, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformGArea(MEMSbeams.createBeamCurvedEnds(L, W, r, 0, false, true), THETA, x, y);
    }

    public static GArea createBeamCurvedEndsC(double x, double y, double L, double W, double r, int numSides, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformGArea(MEMSbeams.createBeamCurvedEnds(L, W, r, numSides, true, false), THETA, x, y);
    }

    public static GArea createBeamCurvedEndsCV(double x, double y, double L, double W, double r, double THETA, int gdsLayer, double shapeReso) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformGArea(MEMSbeams.createBeamCurvedEnds(L, W, r, 0, true, true), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamL(double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double linearVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamLinear(width, startL, pitch, numElements, baseHeight, baseExtent, linearVar), THETA, x, y);
    }

    public static void createDcBeamL(Struct currentStruct, double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double linearVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamLinear(width, startL, pitch, numElements, baseHeight, baseExtent, linearVar), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamP(double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double percentageVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamPercentage(width, startL, pitch, numElements, baseHeight, baseExtent, percentageVar), THETA, x, y);
    }

    public static void createDcBeamP(Struct currentStruct, double x, double y, double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double percentageVar, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamPercentage(width, startL, pitch, numElements, baseHeight, baseExtent, percentageVar), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamLSE(double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static void createDcBeamLSE(Struct currentStruct, double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamNLSE(double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamNonLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static void createDcBeamNLSE(Struct currentStruct, double x, double y, double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamNonLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamCustom(double x, double y, ArrayList<Double> al, double sEnd, double bH, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(0, 0.0);
        al.add(0, 0.0);
        al.add(sEnd);
        al.add(bH);
        al.add(0.0);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamCustom(al), THETA, x, y);
    }

    public static void createDcBeamCustom(Struct currentStruct, double x, double y, ArrayList<Double> al, double sEnd, double bH, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        al.add(0, y);
        al.add(0, x);
        al.add(sEnd);
        al.add(bH);
        al.add(THETA);
        Scripting.createStructRotate(currentStruct, MEMSbeams.createDcBeamCustom(al), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamR(double x, double y, double width, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamR(width, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createDcBeamR(Struct currentStruct, double x, double y, double width, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamR(width, length, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamT(double x, double y, double width1, double length1, double width2, double length2, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamTorsional(width1, length1, width2, length2, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createDcBeamT(Struct currentStruct, double x, double y, double width1, double length1, double width2, double length2, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamTorsional(width1, length1, width2, length2, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamT2(double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamTorsional2(width1, width2, width3, width4, length1, length2, length3, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createDcBeamT2(Struct currentStruct, double x, double y, double width1, double width2, double width3, double width4, double length1, double length2, double length3, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamTorsional2(width1, width2, width3, width4, length1, length2, length3, gap, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamCB(double x, double y, double width, double lengthStart, double lengthEnd, int numElements, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamCoupledBeams(width, lengthStart, lengthEnd, numElements, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createDcBeamCB(Struct currentStruct, double x, double y, double width, double lengthStart, double lengthEnd, int numElements, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamCoupledBeams(width, lengthStart, lengthEnd, numElements, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createDcBeamC(double x, double y, double width, double length, double rX1, double rY1, double rX2, double rY2, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDcBeamC(width, length, rX1, rY1, rX2, rY2, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createDcBeamC(Struct currentStruct, double x, double y, double width, double length, double rX1, double rY1, double rX2, double rY2, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDcBeamC(width, length, rX1, rY1, rX2, rY2, numSides, baseHeight, baseExtent, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createMARAs(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1, double L2, double W2, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRectElectrodeSTR(currentStruct, id, x, y, numElements, L1, W1, L2, W2, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA);
    }

    public static ArrayList<GArea> createMARA(double x, double y, int numElements, double L1, double W1, double L2, double W2, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRectElectrode(numElements, L1, W1, L2, W2, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMARA(Struct currentStruct, double x, double y, int numElements, double L1, double W1, double L2, double W2, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRectElectrode(numElements, L1, W1, L2, W2, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMATALWs(Struct currentStruct, String id, double x, double y, int numElements, double L, double Wa, double Wb, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createTrapElectrodesCONSTSTR(currentStruct, id, x, y, numElements, L, Wa, Wb, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA);
    }

    public static ArrayList<GArea> createMATALW(double x, double y, int numElements, double L, double Wa, double Wb, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createTrapElectrodesCONST(numElements, L, Wa, Wb, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMATALW(Struct currentStruct, double x, double y, int numElements, double L, double Wa, double Wb, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createTrapElectrodesCONST(numElements, L, Wa, Wb, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMATAs(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createTrapElectrodesVLWSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA);
    }

    public static ArrayList<GArea> createMATA(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createTrapElectrodesVLW(numElements, L1, W1a, W1b, L2, W2a, W2b, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMATA(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createTrapElectrodesVLW(numElements, L1, W1a, W1b, L2, W2a, W2b, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMAR2s(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRT2CoupledBeamsSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, lengthSide, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA);
    }

    public static ArrayList<GArea> createMAR2(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRT2CoupledBeams(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, lengthSide, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMAR2(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRT2CoupledBeams(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, lengthSide, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMAR3s(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRTElectrodeSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA, false);
    }

    public static ArrayList<GArea> createMAR3(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, false), THETA, x, y);
    }

    public static void createMAR3(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, false), THETA, x, y);
    }

    public static void createMARCs(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRTElectrodeSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA, true);
    }

    public static ArrayList<GArea> createMARC(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, true), THETA, x, y);
    }

    public static void createMARC(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, true), THETA, x, y);
    }

    public static void createMAT2s(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRT2CoupledBeamsSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, lengthSide, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA);
    }

    public static ArrayList<GArea> createMAT2(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRT2CoupledBeams(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, lengthSide, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMAT2(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRT2CoupledBeams(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, lengthSide, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal), THETA, x, y);
    }

    public static void createMAT3s(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRTElectrodeSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA, false);
    }

    public static ArrayList<GArea> createMAT3(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, false), THETA, x, y);
    }

    public static void createMAT3(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, false), THETA, x, y);
    }

    public static void createMATCs(Struct currentStruct, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRTElectrodeSTR(currentStruct, id, x, y, numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA, true);
    }

    public static ArrayList<GArea> createMATC(double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, true), THETA, x, y);
    }

    public static void createMATC(Struct currentStruct, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRTElectrode(numElements, L1, W1a, W1b, L2, W2a, W2b, space, lowerSpace, hOverlap, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, true), THETA, x, y);
    }

    public static void createMARALINEARs(Struct currentStruct, String id, double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        MEMScoupledArrays.createRectVaryingElectrodeSTR(currentStruct, id, x, y, numElements, L, dL, W, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA, true);
    }

    public static ArrayList<GArea> createMARALINEAR(double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRectVaryingElectrode(numElements, L, dL, W, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, true), THETA, x, y);
    }

    public static void createMARALINEAR(Struct currentStruct, double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal) {
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRectVaryingElectrode(numElements, L, dL, W, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, true), HB, x, y);
    }

    public static void createMARACURVEs(Struct currentStruct, String id, double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        MEMScoupledArrays.createRectVaryingElectrodeSTR(currentStruct, id, x, y, numElements, L, dL, W, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, THETA, false);
    }

    public static ArrayList<GArea> createMARACURVE(double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(MEMScoupledArrays.createRectVaryingElectrode(numElements, L, dL, W, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, false), THETA, x, y);
    }

    public static void createMARACURVE(Struct currentStruct, double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, MEMScoupledArrays.createRectVaryingElectrode(numElements, L, dL, W, space, hOverlap, lengthSide, hElectrode, LB, HB, diameter, numSides, layerFront, layerBack, layerMetal, false), THETA, x, y);
    }

    public static ArrayList<GArea> createGuckelRing(double x, double y, double ringWidth, double radius, int numOfSides, double beamWidth, double base, double connectorLegth, double connectorWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createGuckelRing(ringWidth, radius, numOfSides, beamWidth, base, connectorLegth, connectorWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createGuckelRing(Struct currentStruct, double x, double y, double ringWidth, double radius, int numOfSides, double beamWidth, double base, double connectorLegth, double connectorWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createGuckelRing(ringWidth, radius, numOfSides, beamWidth, base, connectorLegth, connectorWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createGuckelRingArray(double x, double y, double ringWidth, double radiusStart, double radiusEnd, double deltaRadius, int numOfSides, double beamWidth, double base, double connectorLegth, double connectorWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createGuckelRingArray(ringWidth, radiusStart, radiusEnd, deltaRadius, numOfSides, beamWidth, base, connectorLegth, connectorWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createGuckelRingArray(Struct currentStruct, double x, double y, double ringWidth, double radiusStart, double radiusEnd, double deltaRadius, int numOfSides, double beamWidth, double base, double connectorLegth, double connectorWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createGuckelRingArray(ringWidth, radiusStart, radiusEnd, deltaRadius, numOfSides, beamWidth, base, connectorLegth, connectorWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createDiamondRing(double x, double y, double width1, double width2, double width3, double length1, double length2, double length3, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        return Scripting.transformArrayListGArea(MEMSbeams.createDiamondRing(width1, width2, width3, length1, length2, length3, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static void createDiamondRing(Struct currentStruct, double x, double y, double width1, double width2, double width3, double length1, double length2, double length3, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, double THETA, int gdsLayer) {
        Scripting.setGdsLayer(gdsLayer);
        Scripting.createStructTranslateRotate(currentStruct, MEMSbeams.createDiamondRing(width1, width2, width3, length1, length2, length3, baseHeight, baseWidth, anchorDistance, anchorLayer), THETA, x, y);
    }

    public static ArrayList<GArea> createFluidCell(double x, double y, double w1, double w2, double w2T, double w3, double w4, double L1, double L2, double r, double r1, double r2, double r3, int numSides, double a, double b, double c, double d, double e, double f, double g, double h, double i, int La, int Lb, int Lc, int Ld, int Le, int Lf, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        return Scripting.transformArrayListGArea(MEMSactuators.createFluidCell(w1, w2, w2T, w3, w4, L1, L2, r, r1, r2, r3, numSides, a, b, c, d, e, f, g, h, i, La, Lb, Lc, Ld, Le, Lf), THETA, x, y);
    }

    public static void createFluidCell(Struct currentStruct, double x, double y, double w1, double w2, double w2T, double w3, double w4, double L1, double L2, double r, double r1, double r2, double r3, int numSides, double a, double b, double c, double d, double e, double f, double g, double h, double i, int La, int Lb, int Lc, int Ld, int Le, int Lf, double THETA, double shapeReso) {
        Scripting.setShapeReso(shapeReso);
        Scripting.createStructTranslateRotate(currentStruct, MEMSactuators.createFluidCell(w1, w2, w2T, w3, w4, L1, L2, r, r1, r2, r3, numSides, a, b, c, d, e, f, g, h, i, La, Lb, Lc, Ld, Le, Lf), THETA, x, y);
    }

    public static double getFontOutline() {
        return CNSTscriptingController.getFontOutline();
    }

    public static int getFracElements() {
        return CNSTscriptingController.getFracElements();
    }

    public static double getGDSreso() {
        return CNSTscriptingController.getGDSreso();
    }

    public static int getGdsLayer() {
        return CNSTscriptingController.getGdsLayer();
    }

    public static int getLayer() {
        return CNSTscriptingController.getGdsLayer();
    }

    public static int getDataType() {
        return CNSTscriptingController.getDataType();
    }

    public static double getPixelValue() {
        return CNSTscriptingController.getPixelValue();
    }

    public static double getShapeReso() {
        return CNSTscriptingController.getShapeReso();
    }

    public static void setFontOutline(double fontOutlineWidth) {
        CNSTscriptingController.setFontOutline(fontOutlineWidth);
    }

    public static void setFracElements(int fracElements) {
        CNSTscriptingController.setFracElements(fracElements);
    }

    public static void setGDSreso(double gdsReso) {
        GDS2.setReso(gdsReso);
    }

    public static void setGdsLayer(int layer) {
        layer = layer < 0 || layer > 255 ? 0 : layer;
        CNSTscriptingController.setGdsLayer(layer);
    }

    public static void setLayer(int layer) {
        layer = layer < 0 || layer > 255 ? 0 : layer;
        CNSTscriptingController.setGdsLayer(layer);
    }

    public static void setDataType(int layer) {
        layer = layer < 0 || layer > 255 ? 0 : layer;
        CNSTscriptingController.setDataType(layer);
    }

    public static void setPixelValue(double pixelValue) {
        CNSTscriptingController.setPixelValue(pixelValue);
    }

    public static void setShapeReso(double shapeReso) {
        CNSTscriptingController.setShapeReso(shapeReso);
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static void createStructRotate(Struct currentStruct, ArrayList<GArea> ga, double THETA, double x, double y) {
        for (int i = 0; i < ga.size(); ++i) {
            ga.get(i).setDataType(CNSTscriptingController.getDataType());
            currentStruct.add((GDS2Element)ga.get(i).transform(AffineTransform.getRotateInstance(Scripting.degreeToRadians(THETA), x, y)));
        }
    }

    public static void createStructTranslateRotate(Struct currentStruct, ArrayList<GArea> ga, double THETA, double x, double y) {
        for (int i = 0; i < ga.size(); ++i) {
            ga.get(i).setDataType(CNSTscriptingController.getDataType());
            ga.get(i).transform(AffineTransform.getTranslateInstance(x, y));
            currentStruct.add((GDS2Element)ga.get(i).transform(AffineTransform.getRotateInstance(Scripting.degreeToRadians(THETA), x, y)));
        }
    }

    public static void createStruct(Struct currentStruct, ArrayList<GArea> ga) {
        for (int i = 0; i < ga.size(); ++i) {
            ga.get(i).setDataType(CNSTscriptingController.getDataType());
            currentStruct.add(ga.get(i));
        }
    }

    public static void createStruct(Struct currentStruct, ArrayList<GArea> ga, boolean MIRROR) {
        if (MIRROR) {
            AffineTransform mirroGArea = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(CNSTscriptingController.getDataType());
                currentStruct.add((GDS2Element)ga.get(i).transform(mirroGArea));
            }
        } else {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(CNSTscriptingController.getDataType());
                currentStruct.add(ga.get(i));
            }
        }
    }

    public static GArea transformGArea(GArea v, double THETA, double x, double y) {
        THETA = Scripting.degreeToRadians(THETA);
        v.setDataType(CNSTscriptingController.getDataType());
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static GArea rotateGArea(GArea v, double THETA, double x, double y) {
        THETA = Scripting.degreeToRadians(THETA);
        v.setDataType(CNSTscriptingController.getDataType());
        v.transform(AffineTransform.getRotateInstance(THETA, x, y));
        return v;
    }

    public static ArrayList<GArea> transformArrayListGArea(ArrayList<GArea> ga, double THETA, double x, double y) {
        THETA = Scripting.degreeToRadians(THETA);
        for (int i = 0; i < ga.size(); ++i) {
            ga.get(i).setDataType(CNSTscriptingController.getDataType());
            ga.get(i).transform(AffineTransform.getTranslateInstance(x, y));
            ga.get(i).transform(AffineTransform.getRotateInstance(THETA, x, y));
        }
        return ga;
    }

    public static ArrayList<GArea> rotateArrayListGArea(ArrayList<GArea> ga, double THETA, double x, double y) {
        THETA = Scripting.degreeToRadians(THETA);
        for (int i = 0; i < ga.size(); ++i) {
            ga.get(i).setDataType(CNSTscriptingController.getDataType());
            ga.get(i).transform(AffineTransform.getRotateInstance(THETA, x, y));
        }
        return ga;
    }
}

