/*
 * Decompiled with CFR 0.152.
 */
package CNST;

public class CircleThree {
    static final double TOL = 1.0E-7;

    public static Circle circleFromPoints(Point p1, Point p2, Point p3) {
        double offset = Math.pow(p2.x, 2.0) + Math.pow(p2.y, 2.0);
        double bc = (Math.pow(p1.x, 2.0) + Math.pow(p1.y, 2.0) - offset) / 2.0;
        double cd = (offset - Math.pow(p3.x, 2.0) - Math.pow(p3.y, 2.0)) / 2.0;
        double det = (p1.x - p2.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p2.y);
        if (Math.abs(det) < 1.0E-7) {
            throw new IllegalArgumentException("");
        }
        double idet = 1.0 / det;
        double centerx = (bc * (p2.y - p3.y) - cd * (p1.y - p2.y)) * idet;
        double centery = (cd * (p1.x - p2.x) - bc * (p2.x - p3.x)) * idet;
        double radius = Math.sqrt(Math.pow(p2.x - centerx, 2.0) + Math.pow(p2.y - centery, 2.0));
        return new Circle(new Point(centerx, centery), radius);
    }

    public static class Point {
        final double x;
        final double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }

    public static class Circle {
        final Point center;
        final double radius;

        public Circle(Point center, double radius) {
            this.center = center;
            this.radius = radius;
        }

        public double getRadius() {
            return this.radius;
        }

        public Point getCenter() {
            return this.center;
        }

        public String toString() {
            return "Center= " + this.center + ", r=" + this.radius;
        }
    }
}

