/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.Const;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import PartLib.M;
import PartLib.MoParts;
import java.awt.BasicStroke;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.File;

public class Motest
implements Const {
    static MoParts L;

    public static void main(String[] args) {
        int i;
        Lib lib = new Lib();
        Struct top = new Struct("top");
        lib.add(new Ref(top, 0.0, 0.0));
        top.add(new Ref(MoParts.bufOsc(0.6, 1.5, 25, 20.0), 0.0, -35.0));
        Struct[] c = new Struct[4];
        double inSize = 560.0;
        double gap = inSize / 28.0;
        for (i = 0; i < 4; ++i) {
            c[i] = new Struct("cell" + i);
            top.add(new Ref(c[i], 1250 * (i % 2 * 2 - 1), 1250 * (i / 2 * 2 - 1)));
            c[i].add(new Ref(MoParts.leads3(inSize, gap), 0.0, 0.0));
        }
        for (i = 0; i < 180; i += 20) {
            c[0].add(new Ref(Motest.tArray(true, 1.0 + (double)i * 0.04, 20.0, 0.1, 4, 0.5, gap), 0.0, inSize / 4.0 + (double)i));
            c[0].add(new Ref(Motest.tArray(true, 1.0 + (double)i * 0.04, 20.0, 0.5, 22, 0.5, gap), 80.0, inSize / 4.0 + (double)i));
        }
        for (i = 0; i < 180; i += 20) {
            c[0].add(new Ref(Motest.tArray(false, 1.0 + (double)i * 0.04, 20.0, 0.1, 4, 0.5, gap), 0.0, -inSize / 4.0 + (double)i));
            c[0].add(new Ref(Motest.tArray(false, 1.0 + (double)i * 0.04, 20.0, 0.5, 22, 0.5, gap), 80.0, -inSize / 4.0 + (double)i));
        }
        top.add(new Array(L.zero(), -5000.0, -5000.0, 2, 2, 20000.0, 20000.0));
        File f = lib.GDSOut("motest.gds");
        System.out.println(" Saved to " + f.getAbsolutePath());
    }

    static Struct tArray(boolean nFet, double w, double py, double startSize, int num, double incr, double gap) {
        Struct r = new Struct("" + (nFet ? "N" : "P") + "ta" + GDS2.val(Math.random() * 100.0));
        for (int i = 0; i < num; ++i) {
            double l = startSize + incr * (double)i;
            r.add(new Ref(MoParts.xFet(w, l, 1, nFet), py * (double)i, -w / 2.0));
        }
        r.add(new Array(nFet ? L.pCt() : L.nCt(), 0.4 + startSize / 2.0, 1.4 + w / 2.0, num, 1, (double)num * (py + incr / 2.0), 1.0));
        BasicStroke bs = new BasicStroke(0.3f, 0, 0, 2.5f);
        Path2D.Double poly3 = new Path2D.Double();
        ((Path2D)poly3).moveTo(-0.35, -w / 2.0 - 0.5);
        ((Path2D)poly3).lineTo(-2.4, -(gap /= 2.92));
        GArea fa = new GArea(bs.createStrokedShape(poly3), M.M1);
        poly3 = new Path2D.Double();
        ((Path2D)poly3).moveTo(-0.05, 1.5 + w / 2.0);
        ((Path2D)poly3).lineTo(-2.4, gap);
        fa.or(new Area(bs.createStrokedShape(poly3)));
        poly3 = new Path2D.Double();
        ((Path2D)poly3).moveTo(-0.05, 1.6 + w / 2.0);
        ((Path2D)poly3).lineTo(-0.05, w / 2.0);
        Struct sl = new Struct("sLd" + GDS2.val(w), fa);
        Struct slt = new Struct("sLdt" + GDS2.val(w), new GArea(bs.createStrokedShape(poly3), M.M1));
        r.add(new Array(sl, -incr / 2.0 - startSize / 2.0, 0.0, num, 1, (double)num * (py - incr / 2.0), 1.0));
        r.add(new Array(slt, -incr / 2.0 - startSize / 2.0, 0.0, num, 1, (double)num * (py - incr / 2.0), 1.0));
        r.add(new Array(sl, incr / 2.0 + startSize / 2.0, 0.0, num, 1, (double)num * (py + incr / 2.0), 1.0, 32768, 180.0));
        return r;
    }

    static Struct grate(double duty) {
        double pitch = 0.667;
        double extent = 5000.0;
        int number = (int)(extent / pitch);
        extent = (double)number * pitch;
        System.out.println(" ext= " + extent);
        Struct abar = new Struct("Bar_" + GDS2.val(duty), new RectArea(0.0, 0.0, pitch * duty, 5000.0, 2));
        Array abg = new Array(abar, -extent / 2.0, -extent / 2.0, number, 1, extent, 1.0);
        Struct barGrate = new Struct("Grate_" + GDS2.val(duty), abg);
        return barGrate;
    }
}

