/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import JGDS2.Const;
import JGDS2.GDS2Element;
import JGDS2.GDSWriter;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.IOException;

public class Ref
extends GDS2Element
implements Const {
    Struct sref;
    double angle = 0.0;
    double mag = 1.0;
    int mirror = 0;
    double x;
    double y;

    public Ref() {
    }

    public Ref(Struct structure, double x, double y) {
        this.init(structure, x, y, 0, 1.0, 0.0);
    }

    public Ref(Struct structure, double x, double y, int mirror) {
        this.init(structure, x, y, mirror, 1.0, 0.0);
    }

    public Ref(Struct structure, double x, double y, int mirror, double angle) {
        this.init(structure, x, y, mirror, 1.0, angle);
    }

    public Ref(Struct structure, double x, double y, int mirror, double mag, double angle) {
        this.init(structure, x, y, mirror, mag, angle);
    }

    void init(Struct s, double x, double y, int mirror, double mag, double angle) {
        if (!list.contains(s)) {
            list.add(s);
            ++structNum;
        } else if (s.name.charAt(0) == '?') {
            System.err.println("Struct name " + s.name + " in use already");
            System.exit(1);
        }
        this.sref = s;
        this.x = x;
        this.y = y;
        this.mirror = mirror;
        if (mag == 0.0) {
            mag = 1.0;
        }
        this.mag = mag;
        this.angle = angle;
    }

    @Override
    protected void GDSII(GDSWriter g) throws IOException {
        g.adds(this.refType());
        g.write();
        g.adds(4614);
        g.add(this.sref.getName());
        g.write();
        g.adds(6657);
        g.add((short)this.mirror);
        g.write();
        if (this.mag != 0.0 && this.mag != 1.0) {
            g.adds(6917);
            g.add(this.mag);
            g.write();
        }
        if (this.angle != 0.0) {
            g.adds(7173);
            g.add(this.angle);
            g.write();
        }
        this.colRow(g);
        g.adds(4099);
        g.addInt(Ref.val(this.x));
        g.addInt(Ref.val(this.y));
        this.delta(g);
        g.write();
        g.adds(4352);
        g.write();
    }

    short refType() {
        return 2560;
    }

    void colRow(GDSWriter g) throws IOException {
    }

    void delta(GDSWriter g) throws IOException {
    }

    public void flip() {
        this.mirror ^= 0x8000;
    }

    public void setMag(double magnification) {
        this.mag = magnification;
    }

    public void setAngle(double angleDeg) {
        this.angle = angleDeg;
    }

    @Override
    public Area getArea() {
        return this.refArea(this.sref.getArea());
    }

    @Override
    public Area getArea(int lr) {
        return this.refArea(this.sref.getArea(lr));
    }

    Area refArea(Area ra) {
        AffineTransform at = AffineTransform.getTranslateInstance(this.x, this.y);
        at.rotate(this.angle / 180.0 * Math.PI);
        at.scale(this.mag, this.mag * (double)(this.mirror == 32768 ? -1 : 1));
        return ra.createTransformedArea(at);
    }
}

