/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import java.awt.Polygon;

public class StarPolygon
extends Polygon {
    public StarPolygon(int x, int y, int r, int innerR, int vertexCount) {
        this(x, y, r, innerR, vertexCount, 0.0);
    }

    public StarPolygon(int x, int y, int r, int innerR, int vertexCount, double startAngle) {
        super(StarPolygon.getXCoordinates(x, y, r, innerR, vertexCount, startAngle), StarPolygon.getYCoordinates(x, y, r, innerR, vertexCount, startAngle), vertexCount * 2);
    }

    protected static int[] getXCoordinates(int x, int y, int r, int innerR, int vertexCount, double startAngle) {
        int[] res = new int[vertexCount * 2];
        double addAngle = Math.PI * 2 / (double)vertexCount;
        double angle = startAngle;
        double innerAngle = startAngle + Math.PI / (double)vertexCount;
        for (int i = 0; i < vertexCount; ++i) {
            res[i * 2] = (int)Math.round((double)r * Math.cos(angle)) + x;
            angle += addAngle;
            res[i * 2 + 1] = (int)Math.round((double)innerR * Math.cos(innerAngle)) + x;
            innerAngle += addAngle;
        }
        return res;
    }

    protected static int[] getYCoordinates(int x, int y, int r, int innerR, int vertexCount, double startAngle) {
        int[] res = new int[vertexCount * 2];
        double addAngle = Math.PI * 2 / (double)vertexCount;
        double angle = startAngle;
        double innerAngle = startAngle + Math.PI / (double)vertexCount;
        for (int i = 0; i < vertexCount; ++i) {
            res[i * 2] = (int)Math.round((double)r * Math.sin(angle)) + y;
            angle += addAngle;
            res[i * 2 + 1] = (int)Math.round((double)innerR * Math.sin(innerAngle)) + y;
            innerAngle += addAngle;
        }
        return res;
    }
}

