/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.PhotonicsDiscRingPulleys;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Photonics {
    public static GArea createSbend(Point2D.Double p1, Point2D.Double p2, double width, double shapeReso, double THETA, int layer) {
        Point2D.Double c1 = new Point2D.Double();
        Point2D.Double c2 = new Point2D.Double();
        c1.x = p1.x + (p2.x - p1.x) / 2.0;
        c1.y = p1.y;
        c2.x = p2.x - (p2.x - p1.x) / 2.0;
        c2.y = p2.y;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(p1.x, p1.y);
        poly.curveTo(c1.x, c1.y, c2.x, c2.y, p2.x, p2.y);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea v = new GArea(bs.createStrokedShape(poly), layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), p1.x, p1.y));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createSbend(Point2D.Double p1, double length, double height, double width, double shapeReso, double THETA, int layer) {
        Point2D.Double p2 = new Point2D.Double(p1.x + length, p1.y + height);
        Point2D.Double c1 = new Point2D.Double();
        Point2D.Double c2 = new Point2D.Double();
        c1.x = p1.x + (p2.x - p1.x) / 2.0;
        c1.y = p1.y;
        c2.x = p2.x - (p2.x - p1.x) / 2.0;
        c2.y = p2.y;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(p1.x, p1.y);
        poly.curveTo(c1.x, c1.y, c2.x, c2.y, p2.x, p2.y);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea v = new GArea(bs.createStrokedShape(poly), layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), p1.x, p1.y));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createSbendInv(double x, double y, double length, double height, double width, double sleeve, double THETA) {
        GArea sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length, height, width + sleeve * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length, height, width, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalStructure = Photonics.subtractGareas(sBend1, sBend2, CNSTscriptingController.getGdsLayer());
        totalStructure.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        return totalStructure;
    }

    public static GArea createSbendInvSlot(double x, double y, double length, double height, double slotWidth, double gap, double sleeve, double THETA) {
        GArea sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length, height, slotWidth + (gap + sleeve) * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length, height, slotWidth + gap * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalDIFFERENCE = Photonics.subtractGareas(sBend1, sBend2, CNSTscriptingController.getGdsLayer());
        GArea sBendSlot = Photonics.createSbend(new Point2D.Double(x, y), length, height, slotWidth, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalStructure = Photonics.addGareas(totalDIFFERENCE, sBendSlot, CNSTscriptingController.getGdsLayer());
        totalStructure.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        return totalStructure;
    }

    public static GArea createYbend(Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double width, double shapeReso, double THETA, int layer) {
        GArea v = Photonics.createSbend(p1, p2, width, shapeReso, 0.0, layer);
        v.or(Photonics.createSbend(p1, p3, width, shapeReso, 0.0, layer));
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), p1.x, p1.y));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createYbend(Point2D.Double p1, double length2, double height2, double length3, double height3, double width, double shapeReso, double THETA, int layer) {
        GArea v = Photonics.createSbend(new Point2D.Double(0.0, 0.0), length2, height2, width, shapeReso, 0.0, layer);
        v.or(Photonics.createSbend(new Point2D.Double(0.0, 0.0), length3, height3, width, shapeReso, 0.0, layer));
        v.transform(AffineTransform.getTranslateInstance(p1.x, p1.y));
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), p1.x, p1.y));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createYbendInv(double x, double y, double length2, double height2, double length3, double height3, double width, double sleeve, double THETA) {
        GArea sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length2, height2, width + sleeve * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length3, height3, width + sleeve * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalBIG = Photonics.addGareas(sBend1, sBend2, CNSTscriptingController.getGdsLayer());
        sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length2, height2, width, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length3, height3, width, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalSMALL = Photonics.addGareas(sBend1, sBend2, 7);
        GArea totalStructure = Photonics.subtractGareas(totalBIG, totalSMALL, CNSTscriptingController.getGdsLayer());
        totalStructure.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        return totalStructure;
    }

    public static GArea createYbendInvSlot(double x, double y, double length2, double height2, double length3, double height3, double slotWidth, double gap, double sleeve, double THETA) {
        GArea sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length2, height2, slotWidth + (gap + sleeve) * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length3, height3, slotWidth + (gap + sleeve) * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalBIG = Photonics.addGareas(sBend1, sBend2, CNSTscriptingController.getGdsLayer());
        sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length2, height2, 2.0 * gap + slotWidth, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length3, height3, 2.0 * gap + slotWidth, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalSMALL = Photonics.addGareas(sBend1, sBend2, 7);
        GArea totalBigMinusSmall = Photonics.subtractGareas(totalBIG, totalSMALL, CNSTscriptingController.getGdsLayer());
        sBend1 = Photonics.createSbend(new Point2D.Double(x, y), length2, height2, slotWidth, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        sBend2 = Photonics.createSbend(new Point2D.Double(x, y), length3, height3, slotWidth, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea addedYbendSlot = Photonics.addGareas(sBend1, sBend2, CNSTscriptingController.getGdsLayer());
        GArea totalStructure = Photonics.addGareas(totalBigMinusSmall, addedYbendSlot, CNSTscriptingController.getGdsLayer());
        totalStructure.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        return totalStructure;
    }

    public static GArea create90degreeBend(double x1, double y1, double x2, double y2, double width, double shapeReso, double THETA, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x1, y1);
        poly.curveTo(x1 + (x2 - x1) / 2.0, y1, x2, y2 - (y2 - y1) / 2.0, x2, y2);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea v = new GArea(bs.createStrokedShape(poly), layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea create90degreeBendLH(double x, double y, double length, double height, double width, double shapeReso, double THETA, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x, y);
        poly.curveTo(x + length / 2.0, y, x + length, y + height / 2.0, x + length, y + height);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea v = new GArea(bs.createStrokedShape(poly), layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createYBend90(double r1, double r2, double w, int numSides) {
        GArea ga = new GArea(PrimitiveShapes.createTorusW(0.0, r1, r1, w, 270.0, 360.0, numSides, CNSTscriptingController.getGdsLayer()));
        ga.or(PrimitiveShapes.createTorusW(0.0, -r2, r2, w, 0.0, 90.0, numSides, CNSTscriptingController.getGdsLayer()));
        return ga;
    }

    public static GArea createYBendInv90(double r1, double r2, double w, double we, int numSides) {
        GArea ga = Photonics.createYBend90(r1, r2, w + 2.0 * we, numSides);
        ga.subtract(Photonics.createYBend90(r1, r2, w, numSides));
        return ga;
    }

    public static GArea createYBendInvSlot90(double r1, double r2, double ws, double g, double we, int numSides) {
        GArea ga = Photonics.createYBend90(r1, r2, ws + 2.0 * we + 2.0 * g, numSides);
        ga.subtract(Photonics.createYBend90(r1, r2, ws + 2.0 * g, numSides));
        ga.or(Photonics.createYBend90(r1, r2, ws, numSides));
        return ga;
    }

    public static GArea create90degreeInv(double x, double y, double length, double height, double width, double sleeve, double THETA) {
        GArea bend1 = Photonics.create90degreeBendLH(x, y, length, height, width + sleeve * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea bend2 = Photonics.create90degreeBendLH(x, y, length, height, width, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalStructure = Photonics.subtractGareas(bend1, bend2, CNSTscriptingController.getGdsLayer());
        totalStructure.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        return totalStructure;
    }

    public static GArea create90degreeInvSlot(double x, double y, double length, double height, double slotWidth, double gap, double sleeve, double THETA) {
        GArea bend1 = Photonics.create90degreeBendLH(x, y, length, height, slotWidth + (sleeve + gap) * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea bend2 = Photonics.create90degreeBendLH(x, y, length, height, slotWidth + gap * 2.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalDIFFERENCE = Photonics.subtractGareas(bend1, bend2, CNSTscriptingController.getGdsLayer());
        GArea bendSlot = Photonics.create90degreeBendLH(x, y, length, height, slotWidth, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        GArea totalStructure = Photonics.addGareas(totalDIFFERENCE, bendSlot, CNSTscriptingController.getGdsLayer());
        totalStructure.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x, y));
        return totalStructure;
    }

    public static GArea create180bend(double L1, double L2, double D, double W, int numSides) {
        GArea ga = new GArea(new Rect(-W / 2.0, 0.0, W / 2.0, L1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        double R = D / 2.0;
        GArea torus = PrimitiveShapes.createTorusW(0.0, 0.0, R, W, 0.0, 180.0, numSides, CNSTscriptingController.getGdsLayer());
        torus.transform(AffineTransform.getTranslateInstance(R, L1));
        ga.or(torus);
        ga.or(new GArea(new Rect(2.0 * R - W / 2.0, L1 - L2, 2.0 * R + W / 2.0, L1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        return ga;
    }

    public static GArea create180bendInverse(double L1, double L2, double D, double W, double We, int numSides) {
        GArea ga = Photonics.create180bend(L1, L2, D, 2.0 * We + W, numSides);
        ga.subtract(Photonics.create180bend(L1, L2, D, W, numSides));
        return ga;
    }

    public static GArea create180bendInverseSlot(double L1, double L2, double D, double W, double gap, double We, int numSides) {
        GArea ga = Photonics.create180bend(L1, L2, D, 2.0 * We + 2.0 * gap + W, numSides);
        ga.subtract(Photonics.create180bend(L1, L2, D, 2.0 * gap + W, numSides));
        ga.or(Photonics.create180bend(L1, L2, D, W, numSides));
        return ga;
    }

    public static GArea createLinearTaper(double x1, double y1, double x2, double y2, double w1, double w2, double THETA, int layer) {
        Path2D.Double poly = new Path2D.Double();
        if (y1 == y2) {
            poly.moveTo(x1, y1 + w1 / 2.0);
            poly.lineTo(x2, y2 + w2 / 2.0);
            poly.lineTo(x2, y2 - w2 / 2.0);
            poly.lineTo(x1, y1 - w1 / 2.0);
            poly.closePath();
        }
        if (x1 == x2) {
            poly.moveTo(x1 + w1 / 2.0, y1);
            poly.lineTo(x2 + w2 / 2.0, y2);
            poly.lineTo(x2 - w2 / 2.0, y2);
            poly.lineTo(x1 - w1 / 2.0, y1);
            poly.closePath();
        }
        GArea v = new GArea(poly, layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        }
        return v;
    }

    public static ArrayList<GArea> createLinearTaperSlot(double x1, double y1, double x2, double y2, double w1, double w2, double slotWidth1, double slotWidth2, double THETA, int layer) {
        ArrayList<GArea> ga = new ArrayList<GArea>();
        ga.add(PrimitiveShapes.rotateGArea(PrimitiveShapes.createTrapezoid(x1, y1 + slotWidth1 / 2.0, x2, y2 + slotWidth2 / 2.0, x2, y2 + w2 / 2.0, x1, y1 + w1 / 2.0, layer), x1, y1, THETA));
        ga.add(PrimitiveShapes.rotateGArea(PrimitiveShapes.createTrapezoid(x1, y1 - slotWidth1 / 2.0, x2, y2 - slotWidth2 / 2.0, x2, y2 - w2 / 2.0, x1, y1 - w1 / 2.0, layer), x1, y1, THETA));
        return ga;
    }

    public static ArrayList<GArea> createLinearTaperInvSlot(double x1, double y1, double x2, double y2, double w1, double w2, double gap, double slotWidth1, double slotWidth2, double THETA, int layer) {
        ArrayList<GArea> ga = new ArrayList<GArea>();
        ga.add(PrimitiveShapes.rotateGArea(Photonics.createLinearTaper(x1, y1, x2, y2, slotWidth1, slotWidth2, 0.0, layer), x1, y1, THETA));
        ga.add(PrimitiveShapes.rotateGArea(PrimitiveShapes.createTrapezoid(x1, y1 + gap + slotWidth1 / 2.0, x2, y2 + gap + slotWidth2 / 2.0, x2, y2 + w2 / 2.0, x1, y1 + w1 / 2.0, layer), x1, y1, THETA));
        ga.add(PrimitiveShapes.rotateGArea(PrimitiveShapes.createTrapezoid(x1, y1 - gap - slotWidth1 / 2.0, x2, y2 - gap - slotWidth2 / 2.0, x2, y2 - w2 / 2.0, x1, y1 - w1 / 2.0, layer), x1, y1, THETA));
        return ga;
    }

    public static GArea createWaveGuide(double x1, double y1, double x2, double y2, double w, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int layer) {
        GArea v = new GArea(Photonics.createLinearTaper(x1, y1, x2, y2, w, w, 0.0, layer), layer);
        if (ENDCAPLEFT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1, w, 180.0));
        }
        if (ENDCAPRIGHT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2, w, 0.0));
        }
        v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        return v;
    }

    public static GArea createWaveGuideSlot(double x1, double y1, double x2, double y2, double w, double slotWidth, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int layer) {
        GArea v = new GArea(new GArea(new Rect(x1, y1 + slotWidth / 2.0, x2, y2 + w / 2.0, layer), layer));
        v.or(new GArea(new Rect(x1, y1 - w / 2.0, x2, y2 - slotWidth / 2.0, layer), layer));
        if (ENDCAPLEFT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1 + w / 4.0 + slotWidth / 4.0, w / 2.0 - slotWidth / 2.0, 180.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1 - w / 4.0 - slotWidth / 4.0, w / 2.0 - slotWidth / 2.0, 180.0));
        }
        if (ENDCAPRIGHT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2 + w / 4.0 + slotWidth / 4.0, w / 2.0 - slotWidth / 2.0, 0.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2 - w / 4.0 - slotWidth / 4.0, w / 2.0 - slotWidth / 2.0, 0.0));
        }
        v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        return v;
    }

    public static GArea createWaveGuideInv(double x1, double y1, double x2, double y2, double w, double invWidth, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int layer) {
        GArea v = new GArea(new Rect(x1, y1 + w / 2.0, x2, y2 + w / 2.0 + invWidth, layer), layer);
        v.or(new GArea(new Rect(x1, y1 - w / 2.0 - invWidth, x2, y2 - w / 2.0, layer), layer));
        if (ENDCAPLEFT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1 + w / 2.0 + invWidth / 2.0, invWidth, 180.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1 - w / 2.0 - invWidth / 2.0, invWidth, 180.0));
        }
        if (ENDCAPRIGHT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2 + w / 2.0 + invWidth / 2.0, invWidth, 0.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2 - w / 2.0 - invWidth / 2.0, invWidth, 0.0));
        }
        v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        return v;
    }

    public static GArea createWaveGuideInvSlot(double x1, double y1, double x2, double y2, double w, double slotWidth, double invWidth, double THETA, int ENDCAPLEFT, int ENDCAPRIGHT, int layer) {
        ArrayList<GArea> ga = new ArrayList<GArea>();
        ga.add(PrimitiveShapes.rotateGArea(new GArea(new Rect(x1, y1 - slotWidth / 2.0, x2, y2 + slotWidth / 2.0, layer), layer), x1, y1, THETA));
        ga.add(PrimitiveShapes.rotateGArea(new GArea(new Rect(x1, y1 + w / 2.0, x2, y2 + w / 2.0 + invWidth, layer), layer), x1, y1, THETA));
        ga.add(PrimitiveShapes.rotateGArea(new GArea(new Rect(x1, y1 - w / 2.0 - invWidth, x2, y2 - w / 2.0, layer), layer), x1, y1, THETA));
        GArea v = new GArea(new Rect(x1, y1 - slotWidth / 2.0, x2, y2 + slotWidth / 2.0, layer), layer);
        v.or(new GArea(new Rect(x1, y1 + w / 2.0, x2, y2 + w / 2.0 + invWidth, layer), layer));
        v.or(new GArea(new Rect(x1, y1 - w / 2.0 - invWidth, x2, y2 - w / 2.0, layer), layer));
        if (ENDCAPLEFT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1 + w / 2.0 + invWidth / 2.0, invWidth, 180.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1, slotWidth, 180.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x1, y1 - w / 2.0 - invWidth / 2.0, invWidth, 180.0));
        }
        if (ENDCAPRIGHT != 0) {
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2 + w / 2.0 + invWidth / 2.0, invWidth, 0.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2, slotWidth, 0.0));
            v.or(PhotonicsDiscRingPulleys.createLeftEndCap(x2, y2 - w / 2.0 - invWidth / 2.0, invWidth, 0.0));
        }
        v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        return v;
    }

    public static GArea createCustomTaper(ArrayList<Double> al, int layer) {
        int i;
        double THETA = al.get(al.size() - 1);
        int arrLng = al.size() / 2 - 1;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(al.get(0), al.get(1));
        for (i = 1; i < arrLng; ++i) {
            poly.lineTo(al.get(i * 2), al.get(i * 2 + 1));
        }
        for (i = arrLng - 1; i >= 0; --i) {
            poly.lineTo(al.get(i * 2), -1.0 * al.get(i * 2 + 1));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), 0.0, 0.0));
        }
        v.transform(AffineTransform.getTranslateInstance(al.get(al.size() - 3), al.get(al.size() - 2)));
        return v;
    }

    public static GArea createExponentialTaper(ArrayList<Double> alD, double tX, double tY, double shapeReso, double THETA, int layer) {
        int i;
        int alDhalfSize = alD.size() / 2;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(alD.get(0), alD.get(1));
        for (i = 0; i < alDhalfSize; ++i) {
            poly.lineTo(alD.get(i * 2), alD.get(i * 2 + 1));
        }
        for (i = alDhalfSize - 1; i >= 0; --i) {
            poly.lineTo(alD.get(i * 2), -1.0 * alD.get(i * 2 + 1));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), 0.0, 0.0));
        }
        v.transform(AffineTransform.getTranslateInstance(tX, tY));
        v.setRenderReso(shapeReso);
        return v;
    }

    public static ArrayList<GArea> createExpTaperInvSlot(double x1, double y1, double length, double wStart, double wEnd, int nPoints, double inverseWidth, double slotW1, double slotW2, double THETA) {
        GArea gaExpTaperInvSlot = new GArea();
        ArrayList<GArea> result = Photonics.createExpTaperInv(x1, y1, length, wStart, wEnd, nPoints, inverseWidth, THETA);
        if (slotW1 != slotW2) {
            ArrayList<Double> alExpTaperInvSlot = Photonics.nonLinStartEnd(length, slotW1, slotW2, nPoints);
            gaExpTaperInvSlot = Photonics.createExponentialTaper(alExpTaperInvSlot, x1, y1, CNSTscriptingController.getShapeReso(), THETA, CNSTscriptingController.getGdsLayer());
        } else {
            gaExpTaperInvSlot = new GArea(new Rect(x1, -slotW1 / 2.0, x1 + length, y1 + slotW1 / 2.0, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        }
        result.add(gaExpTaperInvSlot);
        return result;
    }

    public static ArrayList<GArea> createExpTaperInv(double x1, double y1, double length, double wStart, double wEnd, int nPoints, double widthAround, double THETA) {
        ArrayList<Double> alExpTaper1 = Photonics.nonLinStartEnd(length, wStart, wEnd, nPoints);
        GArea gaExpTaper1 = Photonics.createExponentialTaper(alExpTaper1, 0.0, 0.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        Area aExpTaper1 = new Area(gaExpTaper1.getArea());
        ArrayList<Double> alExpTaper2 = Photonics.addConstYValue(alExpTaper1, widthAround);
        GArea gaExpTaper2 = Photonics.createExponentialTaper(alExpTaper2, 0.0, 0.0, CNSTscriptingController.getShapeReso(), 0.0, CNSTscriptingController.getGdsLayer());
        Area aExpTaper2 = new Area(gaExpTaper2.getArea());
        aExpTaper2.subtract(aExpTaper1);
        GArea gaTop1 = new GArea(aExpTaper1, CNSTscriptingController.getGdsLayer());
        gaTop1.and(new Rect(0.0, 0.0, 0.0 + length, 0.0 + wEnd / 2.0 + widthAround, CNSTscriptingController.getGdsLayer()));
        GArea gaTop2 = new GArea(aExpTaper2, CNSTscriptingController.getGdsLayer());
        gaTop2.and(new Rect(0.0, 0.0, 0.0 + length, 0.0 + wEnd / 2.0 + widthAround, CNSTscriptingController.getGdsLayer()));
        Area aTop1 = new Area(gaTop1.getArea());
        Area aTop2 = new Area(gaTop2.getArea());
        aTop2.subtract(aTop1);
        aTop2.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA)));
        aTop2.transform(AffineTransform.getTranslateInstance(x1, y1));
        GArea gaTOP = new GArea(aTop2, CNSTscriptingController.getGdsLayer());
        aExpTaper1 = new Area(gaExpTaper1.getArea());
        aExpTaper2 = new Area(gaExpTaper2.getArea());
        GArea gaBot1 = new GArea(aExpTaper1, CNSTscriptingController.getGdsLayer());
        gaBot1.and(new Rect(0.0, 0.0 - wEnd / 2.0 - widthAround, 0.0 + length, 0.0, CNSTscriptingController.getGdsLayer()));
        GArea gaBot2 = new GArea(aExpTaper2, CNSTscriptingController.getGdsLayer());
        gaBot2.and(new Rect(0.0, 0.0 - wEnd / 2.0 - widthAround, 0.0 + length, 0.0, CNSTscriptingController.getGdsLayer()));
        Area aBot1 = new Area(gaBot1.getArea());
        Area aBot2 = new Area(gaBot2.getArea());
        aBot2.subtract(aBot1);
        aBot2.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA)));
        aBot2.transform(AffineTransform.getTranslateInstance(x1, y1));
        GArea gaBOTTOM = new GArea(aBot2, CNSTscriptingController.getGdsLayer());
        ArrayList<GArea> result = new ArrayList<GArea>();
        result.add(gaTOP);
        result.add(gaBOTTOM);
        return result;
    }

    public static ArrayList<Double> addConstYValue(ArrayList<Double> al, Double yVal) {
        for (int i = 0; i < al.size() / 2; ++i) {
            al.set(i * 2 + 1, al.get(i * 2 + 1) + yVal);
        }
        return al;
    }

    public static ArrayList<Double> nonLinStartEnd(double length, double startWidth, double endWidth, int numElements) {
        double ratio;
        double startW = startWidth / 2.0;
        double endW = endWidth / 2.0;
        double root = numElements == 1 ? 1.0 : 1.0 / (double)(numElements - 1);
        if (startW == 0.0) {
            ratio = endW;
            startW = 1.0;
        } else {
            ratio = Math.abs(endW / startW);
        }
        double startX = 0.0;
        double endX = length;
        double incrementX = (endX - startX) / (double)(numElements - 1);
        ArrayList<Double> dataAl = new ArrayList<Double>();
        for (int i = 0; i < numElements - 1; ++i) {
            dataAl.add(startX);
            dataAl.add(startW);
            startW *= Math.pow(ratio, root);
            startX += incrementX;
        }
        dataAl.add(endX);
        dataAl.add(endW);
        return dataAl;
    }

    public static GArea createBezierCurve(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double width, double shapeReso, double THETA, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x1, y1);
        poly.curveTo(cx1, cy1, cx2, cy2, x2, y2);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea v = new GArea(bs.createStrokedShape(poly), layer);
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), x1, y1));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea createBezierCurveInv(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double sleeveWidth, double slotWidth, double shapeReso, double THETA, int layer) {
        double width = 2.0 * sleeveWidth + slotWidth;
        GArea v = Photonics.createBezierCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2, width, shapeReso, THETA, layer);
        v.subtract(Photonics.createBezierCurve(x1 - 0.1, y1, cx1, cy1, cx2, cy2, x2 + 0.1, y2, slotWidth, shapeReso, THETA, layer));
        return v;
    }

    public static GArea createBezierCurveInvSlot(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double sleeveWidth, double slotWidth, double gap, double shapeReso, double THETA, int layer) {
        double width = 2.0 * sleeveWidth + 2.0 * gap + slotWidth;
        GArea v = Photonics.createBezierCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2, width, shapeReso, THETA, layer);
        v.subtract(Photonics.createBezierCurve(x1 - 0.1, y1, cx1, cy1, cx2, cy2, x2 + 0.1, y2, 2.0 * gap + slotWidth, shapeReso, THETA, layer));
        v.or(Photonics.createBezierCurve(x1, y1, cx1, cy1, cx2, cy2, x2, y2, slotWidth, shapeReso, THETA, layer));
        return v;
    }

    public static GArea createSbendTaper(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double w1, double w2, double tX, double tY, double THETA, double shapeReso, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x1, y1 + w1 / 2.0);
        poly.curveTo(cx1, cy1, cx2, cy2, x2, y2 + w2 / 2.0);
        ArrayList<Double> alPoly = Photonics.flattenPath(poly, shapeReso);
        Path2D.Double poly2 = new Path2D.Double();
        poly2.moveTo(x1, y1 - w1 / 2.0);
        poly2.curveTo(cx1, cy1, cx2, cy2, x2, y2 - w2 / 2.0);
        ArrayList<Double> alPoly2 = Photonics.flattenPath(poly2, shapeReso);
        GArea v = Photonics.getGAreaSBendTaper(alPoly, alPoly2, layer);
        if (THETA == 0.0) {
            v.transform(AffineTransform.getTranslateInstance(tX, tY));
        }
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA)));
            v.transform(AffineTransform.getTranslateInstance(tX, tY));
        }
        return v;
    }

    public static GArea createSbendFunnel(double x1, double y1, double cx1, double cy1, double cx2, double cy2, double x2, double y2, double w1, double tX, double tY, double THETA, double shapeReso, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x1, y1 + w1 / 2.0);
        poly.curveTo(cx1, cy1 + w1 / 2.0, cx2, cy2 - w1 / 2.0, x2, y2);
        ArrayList<Double> alPoly = Photonics.flattenPath(poly, shapeReso);
        GArea v = Photonics.gAreaFromArrayList(alPoly, layer);
        v.transform(AffineTransform.getTranslateInstance(tX, tY));
        if (THETA != 0.0) {
            v.transform(AffineTransform.getRotateInstance(Photonics.degreeToRadians(THETA), tX, tY));
        }
        v.setRenderReso(shapeReso);
        return v;
    }

    public static GArea getGAreaSBendTaper(ArrayList<Double> al1, ArrayList<Double> al2, int layer) {
        int i;
        int alHalfSize1 = al1.size() / 2;
        int alHalfSize2 = al2.size() / 2;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(al1.get(0), al1.get(1));
        for (i = 1; i < alHalfSize1; ++i) {
            poly.lineTo(al1.get(i * 2), al1.get(i * 2 + 1));
        }
        for (i = alHalfSize2 - 1; i >= 0; --i) {
            poly.lineTo(al2.get(i * 2), al2.get(i * 2 + 1));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static GArea gAreaFromArrayList(ArrayList<Double> al, int layer) {
        int i;
        int alHalfSize = al.size() / 2;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(al.get(0), al.get(1));
        for (i = 1; i < alHalfSize; ++i) {
            poly.lineTo(al.get(i * 2), al.get(i * 2 + 1));
        }
        for (i = alHalfSize - 1; i >= 0; --i) {
            poly.lineTo(al.get(i * 2), -1.0 * al.get(i * 2 + 1));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static ArrayList<Double> flattenPath(Path2D.Double poly, double reso) {
        FlatteningPathIterator fpi = new FlatteningPathIterator(poly.getPathIterator(new AffineTransform()), reso);
        ArrayList<Double> alPts = new ArrayList<Double>();
        double[] coords = new double[6];
        int cnt = 0;
        while (!fpi.isDone()) {
            fpi.currentSegment(coords);
            alPts.add(coords[0]);
            alPts.add(coords[1]);
            fpi.next();
            ++cnt;
        }
        return alPts;
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static GArea addGareas(GArea ga1, GArea ga2, int layer) {
        Area a1 = new Area(ga1.getArea());
        Area a2 = new Area(ga2.getArea());
        a1.add(a2);
        GArea v = new GArea(a1, layer);
        return v;
    }

    public static GArea subtractGareas(GArea ga1, GArea ga2, int layer) {
        Area a1 = new Area(ga1.getArea());
        Area a2 = new Area(ga2.getArea());
        a1.subtract(a2);
        GArea v = new GArea(a1, layer);
        return v;
    }
}

