/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.TextOutline;
import JGDS2.GArea;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;

public class LabelMaker {
    public static void parseLabel(String[] sArr, String s, Struct str) {
        int rows = Integer.parseInt(sArr[sArr.length - 12]);
        int columns = Integer.parseInt(sArr[sArr.length - 11]);
        String fontName = sArr[sArr.length - 10];
        double fontSize = Double.parseDouble(sArr[sArr.length - 9]);
        double x = Double.parseDouble(sArr[sArr.length - 8]);
        double y = Double.parseDouble(sArr[sArr.length - 7]);
        double xRow = Double.parseDouble(sArr[sArr.length - 6]);
        double yRow = Double.parseDouble(sArr[sArr.length - 5]);
        double pitchX = Double.parseDouble(sArr[sArr.length - 4]);
        double pitchY = Double.parseDouble(sArr[sArr.length - 3]);
        boolean OUTLINE = sArr[sArr.length - 1].equalsIgnoreCase("labelOutline");
        if (!Arrays.asList(CNSTscriptingController.getFontNames()).contains(fontName)) {
            String fontError = "FONT NAME '" + fontName + "' does NOT exist in line: " + s;
            if (!Arrays.asList(CNSTscriptingController.getFontNames()).contains("Serif")) {
                fontName = CNSTscriptingController.getFontNames()[0];
                fontError = fontError + " '" + fontName + "' is used and may not be a vector font!!";
            } else {
                fontName = "Serif";
                fontError = fontError + " '" + fontName + "' is used instead!!";
            }
            CNSTscriptingController.addToErrorLog(fontError);
        }
        if (sArr[sArr.length - 2].equalsIgnoreCase("autoOut") && CNSTscriptingController.lineError(sArr, 12, s)) {
            LabelMaker.createAutoOuter(rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, str, OUTLINE);
        }
        if (sArr[sArr.length - 2].equalsIgnoreCase("autoRowCol") && CNSTscriptingController.lineError(sArr, 12, s)) {
            LabelMaker.createAutoRowColumn(rows, columns, fontName, fontSize, x, y, pitchX, pitchY, str, OUTLINE);
        }
        if (sArr[sArr.length - 2].equalsIgnoreCase("autoOutLett") && CNSTscriptingController.lineError(sArr, 12, s)) {
            LabelMaker.createAutoOuterLetters(rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, str, OUTLINE);
        }
        if (sArr[sArr.length - 2].equalsIgnoreCase("autoRowColLett") && CNSTscriptingController.lineError(sArr, 12, s)) {
            LabelMaker.createAutoRowColumnLetters(rows, columns, fontName, fontSize, x, y, pitchX, pitchY, str, OUTLINE);
        }
        if (sArr[sArr.length - 2].equalsIgnoreCase("out") && CNSTscriptingController.parameterError(rows + columns, sArr.length - 12, s)) {
            LabelMaker.createOuter(sArr, rows, columns, fontName, fontSize, x, y, xRow, yRow, pitchX, pitchY, str, OUTLINE);
        }
        if (sArr[sArr.length - 2].equalsIgnoreCase("rowCol") && CNSTscriptingController.parameterError(rows * columns, sArr.length - 12, s)) {
            LabelMaker.createRowColumn(sArr, rows, columns, fontName, fontSize, x, y, pitchX, pitchY, str, OUTLINE);
        }
    }

    public static void createAutoOuterLetters(int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct str, boolean OUTLINE) {
        int i;
        String[] cols = LabelMaker.letterArray(columns);
        for (i = 0; i < rows; ++i) {
            String s = "" + (i + 1);
            if (OUTLINE) {
                LabelMaker.createOutlineStruct(TextOutline.textOutline(s, fontName, fontSize, xRow, yRow - pitchY * (double)i, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                continue;
            }
            str.add(LabelMaker.createTextAreas(s, fontName, fontSize, xRow, yRow - pitchY * (double)i));
        }
        for (i = rows; i < rows + columns; ++i) {
            if (OUTLINE) {
                LabelMaker.createOutlineStruct(TextOutline.textOutline(cols[i - rows], fontName, fontSize, x + pitchX * (double)(i - rows), y, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                continue;
            }
            str.add(LabelMaker.createTextAreas(cols[i - rows], fontName, fontSize, x + pitchX * (double)(i - rows), y));
        }
    }

    public static void createAutoRowColumnLetters(int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct str, boolean OUTLINE) {
        int counter = 0;
        String[] colArray = LabelMaker.letterArray(columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                String s = "" + colArray[j] + "" + (i + 1);
                if (OUTLINE) {
                    LabelMaker.createOutlineStruct(TextOutline.textOutline(s, fontName, fontSize, x + pitchX * (double)j, y - pitchY * (double)i, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                } else {
                    str.add(LabelMaker.createTextAreas(s, fontName, fontSize, x + pitchX * (double)j, y - pitchY * (double)i));
                }
                ++counter;
            }
        }
    }

    public static void createAutoOuter(int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct str, boolean OUTLINE) {
        String s;
        int i;
        for (i = 0; i < rows; ++i) {
            s = "" + (i + 1);
            if (OUTLINE) {
                LabelMaker.createOutlineStruct(TextOutline.textOutline(s, fontName, fontSize, xRow, yRow - pitchY * (double)i, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                continue;
            }
            str.add(LabelMaker.createTextAreas(s, fontName, fontSize, xRow, yRow - pitchY * (double)i));
        }
        for (i = rows; i < rows + columns; ++i) {
            s = "" + (i - rows + 1);
            if (OUTLINE) {
                LabelMaker.createOutlineStruct(TextOutline.textOutline(s, fontName, fontSize, x + pitchX * (double)(i - rows), y, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                continue;
            }
            str.add(LabelMaker.createTextAreas(s, fontName, fontSize, x + pitchX * (double)(i - rows), y));
        }
    }

    public static void createAutoRowColumn(int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct str, boolean OUTLINE) {
        int counter = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                String s = "" + (i + 1) + "," + (j + 1);
                if (OUTLINE) {
                    LabelMaker.createOutlineStruct(TextOutline.textOutline(s, fontName, fontSize, x + pitchX * (double)j, y - pitchY * (double)i, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                } else {
                    str.add(LabelMaker.createTextAreas(s, fontName, fontSize, x + pitchX * (double)j, y - pitchY * (double)i));
                }
                ++counter;
            }
        }
    }

    public static void createOuter(String[] sArr, int rows, int columns, String fontName, double fontSize, double x, double y, double xRow, double yRow, double pitchX, double pitchY, Struct str, boolean OUTLINE) {
        int i;
        for (i = 0; i < rows; ++i) {
            if (OUTLINE) {
                LabelMaker.createOutlineStruct(TextOutline.textOutline(sArr[i], fontName, fontSize, xRow, yRow - pitchY * (double)i, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                continue;
            }
            str.add(LabelMaker.createTextAreas(sArr[i], fontName, fontSize, xRow, yRow - pitchY * (double)i));
        }
        for (i = rows; i < rows + columns; ++i) {
            if (OUTLINE) {
                LabelMaker.createOutlineStruct(TextOutline.textOutline(sArr[i], fontName, fontSize, x + pitchX * (double)(i - rows), y, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                continue;
            }
            str.add(LabelMaker.createTextAreas(sArr[i], fontName, fontSize, x + pitchX * (double)(i - rows), y));
        }
    }

    public static void createRowColumn(String[] sArr, int rows, int columns, String fontName, double fontSize, double x, double y, double pitchX, double pitchY, Struct str, boolean OUTLINE) {
        int counter = 0;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                if (OUTLINE) {
                    LabelMaker.createOutlineStruct(TextOutline.textOutline(sArr[counter], fontName, fontSize, x + pitchX * (double)j, y - pitchY * (double)i, CNSTscriptingController.getShapeReso(), CNSTscriptingController.getGdsLayer(), false), str);
                } else {
                    str.add(LabelMaker.createTextAreas(sArr[counter], fontName, fontSize, x + pitchX * (double)j, y - pitchY * (double)i));
                }
                ++counter;
            }
        }
    }

    public static String[] letterArray(int length) {
        String[] result = new String[length];
        String colName = "";
        for (int i = 0; i < length; ++i) {
            char c = (char)(65 + i % 26);
            colName = c + "";
            if (i > 25) {
                colName = result[i / 26 - 1] + "" + c;
            }
            result[i] = colName;
        }
        return result;
    }

    public static GArea createTextAreas(String s, String fontName, double fontSize, double posX, double posY) {
        Font f = new Font(fontName, 0, 1000);
        Text lb = new Text(s, CNSTscriptingController.getGdsLayer(), f);
        lb.setFontSize(fontSize);
        lb.setRenderReso(CNSTscriptingController.getShapeReso());
        Area a = new Area(lb.getArea());
        a.transform(AffineTransform.getTranslateInstance(posX, posY));
        GArea g = new GArea(a, CNSTscriptingController.getGdsLayer());
        g.setRenderReso(CNSTscriptingController.getShapeReso());
        g.setDataType(CNSTscriptingController.getDataType());
        return g;
    }

    public static void createOutlineStruct(ArrayList<GArea> ga, Struct str) {
        for (GArea ga1 : ga) {
            ga1.setDataType(CNSTscriptingController.getDataType());
            str.add(ga1);
        }
    }
}

