/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class JEOLAlignmentOffsetController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    @FXML
    private TextField tfDesignedX;
    @FXML
    private TextField tfDesignedY;
    @FXML
    private TextField tfWaferCenterX;
    @FXML
    private TextField tfWaferCenterY;
    @FXML
    private TextField tfObservedX;
    @FXML
    private TextField tfObservedY;
    @FXML
    private TextField tfOffsetX;
    @FXML
    private TextField tfOffsetY;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    JEOL Alignment Offset Module", "This module calculates the alignment offset based on the designed and observed mark positions. The calculated OFFSET parameter values are placed in the JEOL schedule file.");
        ActionEvent event = new ActionEvent();
        try {
            this.calculateOffset(event);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JEOLAlignmentOffsetController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void calculateOffset(ActionEvent event) throws FileNotFoundException {
        DecimalFormat df0 = new DecimalFormat("#");
        DecimalFormat df2 = new DecimalFormat("#.##");
        double designedX = Double.parseDouble(this.tfDesignedX.getText());
        double designedY = Double.parseDouble(this.tfDesignedY.getText());
        double waferCenterX = Double.parseDouble(this.tfWaferCenterX.getText());
        double waferCenterY = Double.parseDouble(this.tfWaferCenterY.getText());
        double observedX = Double.parseDouble(this.tfObservedX.getText());
        double observedY = Integer.parseInt(this.tfObservedY.getText());
        double offsetX = observedX - (designedX + waferCenterX);
        String strX = Double.toString(offsetX);
        this.tfOffsetX.setText(strX);
        double offsetY = -(observedY - waferCenterY + designedY);
        String strY = Double.toString(offsetY);
        this.tfOffsetY.setText(strY);
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

