/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.JEOL6300plotJdfSdfActions;
import CNSTnanoToolbox.JEOL6300showJdfSdfActions;
import CNSTnanoToolbox.machineResources.JEOL6300DoseTableData;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class JEOL6300JdfSdfController
implements Initializable,
AboutInterface {
    static File file = null;
    Stage about = new Stage();
    Stage showJdfSdf = new Stage();
    Stage plotJdfSdf = new Stage();
    String openDir;
    String saveToDir;
    ArrayList<ArrayList> generateArr = new ArrayList();
    int displayColor = 0;
    int displayColor2 = 0;
    int displayColor3 = 0;
    int generateArrayIndex = 0;
    String GENERATEARRAY_VALUE;
    boolean GENERATE = true;
    boolean SHOW = false;
    final int GENERATEJDF = 0;
    final int GENERATESDF = 1;
    final int SHOWJDFSDF = 2;
    final ObservableList<JEOL6300DoseTableData> ol = FXCollections.observableArrayList();
    @FXML
    private Label lXMLstatus;
    @FXML
    private Label lStatus;
    @FXML
    private Label lDoseMatixStatus;
    @FXML
    private TextField tfSubstrateSize;
    @FXML
    private TextField tfJdfFile;
    @FXML
    private TextField tfSdfFile;
    @FXML
    private TextField tfRESISTarea;
    @FXML
    private TextField tfRESISTline;
    @FXML
    private TextField tfSHOT;
    @FXML
    private TextField tfOFFSETx;
    @FXML
    private TextField tfOFFSETy;
    @FXML
    private TextField tfSTDCUR;
    @FXML
    private ComboBox<String> cbSubstratePosition;
    @FXML
    private ComboBox<String> cbALDPosition;
    @FXML
    private ComboBox<String> cbLens;
    @FXML
    private ComboBox<String> cbLBC;
    @FXML
    private ComboBox<String> cbCALPRM;
    @FXML
    private ComboBox<String> cbAlignmentGlobal;
    @FXML
    private ComboBox<String> cbAlignmentChip;
    @FXML
    private ComboBox<String> cbHSWITCHglobal;
    @FXML
    private ComboBox<String> cbHSWITCHchip;
    @FXML
    private ComboBox<String> cbGLMDET;
    @FXML
    private ComboBox<String> cbCHIPAL;
    @FXML
    private ComboBox<String> cbPATH;
    @FXML
    private TextField tfPX;
    @FXML
    private TextField tfPY;
    @FXML
    private TextField tfQX;
    @FXML
    private TextField tfQY;
    @FXML
    private TextField tfM1X;
    @FXML
    private TextField tfM1Y;
    @FXML
    private TextField tfM2X;
    @FXML
    private TextField tfM2Y;
    @FXML
    private TextField tfM3X;
    @FXML
    private TextField tfM3Y;
    @FXML
    private TextField tfM4X;
    @FXML
    private TextField tfM4Y;
    @FXML
    private TextField tfGLMPW;
    @FXML
    private TextField tfGLMPL;
    @FXML
    private TextField tfGLMQRSW;
    @FXML
    private TextField tfGLMQRSL;
    @FXML
    private TextField tfCHMARKW;
    @FXML
    private TextField tfCHMARKL;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfElementsX;
    @FXML
    private TextField tfElementsY;
    @FXML
    private TextField tfPitchX;
    @FXML
    private TextField tfPitchY;
    @FXML
    private TextField tfDoseModulation;
    @FXML
    private ComboBox<String> cbPatternFiles;
    @FXML
    private ComboBox<String> cbGeneratedArrays;
    @FXML
    private TextField tfDosePatternFile;
    @FXML
    private TextField tfDosePosX;
    @FXML
    private TextField tfDosePosY;
    @FXML
    private TextField tfDoseElementsX;
    @FXML
    private TextField tfDoseElementsY;
    @FXML
    private TextField tfDosePitchX;
    @FXML
    private TextField tfDosePitchY;
    @FXML
    private TextField tfDoseStart;
    @FXML
    private TextField tfDoseEnd;
    @FXML
    private TextField tfDoseLinear;
    @FXML
    private TextField tfDosePercentage;
    @FXML
    private ComboBox<String> cbDoseMethod;
    @FXML
    private ComboBox<String> cbDoseRamp;
    @FXML
    private ComboBox<String> cbDoseType;
    @FXML
    private TableView<JEOL6300DoseTableData> tDoseTable;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    JEOL 6300 JDF/SDF Module", "This module generates job and schedule files for the JEOL 6300 electron beam lithography tool.");
        this.setParameters();
        int maxNumDoses = 1024;
        this.generateNullDoseTable(this.ol, maxNumDoses);
        this.tDoseTable.setItems(this.ol);
        final TableColumn c1 = new TableColumn("Shot Rank");
        c1.setCellValueFactory((Callback)new PropertyValueFactory("shotRank"));
        c1.setCellFactory((Callback)new TextFieldCellFactory());
        c1.setPrefWidth(121.0);
        c1.setSortable(false);
        c1.setResizable(false);
        final TableColumn c2 = new TableColumn("Modulation");
        c2.setCellValueFactory((Callback)new PropertyValueFactory("modulation"));
        c2.setCellFactory((Callback)new TextFieldCellFactory());
        c2.setPrefWidth(121.0);
        c2.setSortable(false);
        c2.setResizable(false);
        this.tDoseTable.getColumns().addAll((Object[])new TableColumn[]{c1, c2});
        this.tDoseTable.getColumns().addListener(new ListChangeListener(){
            public boolean suspended;

            public void onChanged(ListChangeListener.Change change) {
                change.next();
                if (change.wasReplaced() && !this.suspended) {
                    this.suspended = true;
                    JEOL6300JdfSdfController.this.tDoseTable.getColumns().setAll((Object[])new TableColumn[]{c1, c2});
                    this.suspended = false;
                }
            }
        });
    }

    @FXML
    private void setComboBoxMethod(ActionEvent event) {
        if (((String)this.cbDoseMethod.getValue()).equals("Dose Matrix")) {
            this.cbDoseType.setValue((Object)"Dose");
        }
        if (((String)this.cbDoseMethod.getValue()).equals("Base Dose")) {
            this.setFourValsDoseRamp();
        }
    }

    @FXML
    private void setComboBoxType(ActionEvent event) {
        if (((String)this.cbDoseType.getValue()).equals("Dose Table") && ((String)this.cbDoseMethod.getValue()).equals("Dose Matrix")) {
            this.setTwoValsDoseRamp();
        }
        if (((String)this.cbDoseType.getValue()).equals("Dose")) {
            this.setFourValsDoseRamp();
        }
    }

    public void setTwoValsDoseRamp() {
        this.cbDoseRamp.getItems().clear();
        this.cbDoseRamp.getItems().addAll((Object[])new String[]{"Linear", "Percentage"});
        this.cbDoseRamp.setValue((Object)"Linear");
        this.cbDoseRamp.setVisibleRowCount(4);
    }

    public void setFourValsDoseRamp() {
        this.cbDoseRamp.getItems().clear();
        this.cbDoseRamp.getItems().addAll((Object[])new String[]{"Linear", "Percentage", "Linear SE", "Nonlinear SE"});
        this.cbDoseRamp.setValue((Object)"Linear");
        this.cbDoseRamp.setVisibleRowCount(4);
    }

    @FXML
    private void addPatternFile(ActionEvent event) {
        String patVal = (String)this.cbPatternFiles.getValue();
        if (patVal != null) {
            this.cbPatternFiles.getItems().add((Object)patVal);
            this.lStatus.setText(patVal + " added to the pattern file list.");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        } else {
            this.lStatus.setText("ERROR in pattern file name = " + patVal);
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void generateArray(ActionEvent event) {
        if (this.cbPatternFiles.getItems().size() > 0) {
            this.GENERATEARRAY_VALUE = "GENERATE";
            this.generateArr.add(new ArrayList());
            int patIndex = this.cbPatternFiles.getSelectionModel().selectedIndexProperty().intValue();
            this.generateArr.get(this.generateArr.size() - 1).add(this.cbPatternFiles.getItems().get(patIndex));
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfPosX.getText());
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfPosY.getText());
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfElementsX.getText());
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfElementsY.getText());
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfPitchX.getText());
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfPitchY.getText());
            this.generateArr.get(this.generateArr.size() - 1).add(this.tfDoseModulation.getText());
            String genArrays = (String)this.cbPatternFiles.getItems().get(patIndex) + "_" + (this.generateArr.size() - 1);
            this.cbGeneratedArrays.getItems().add((Object)genArrays);
            this.cbGeneratedArrays.setValue((Object)genArrays);
            this.cbPatternFiles.setValue((Object)this.generateArr.get(this.generateArr.size() - 1).get(0).toString());
            this.tfPosX.setText(this.generateArr.get(this.generateArr.size() - 1).get(1).toString());
            this.tfPosY.setText(this.generateArr.get(this.generateArr.size() - 1).get(2).toString());
            this.tfElementsX.setText(this.generateArr.get(this.generateArr.size() - 1).get(3).toString());
            this.tfElementsY.setText(this.generateArr.get(this.generateArr.size() - 1).get(4).toString());
            this.tfPitchX.setText(this.generateArr.get(this.generateArr.size() - 1).get(5).toString());
            this.tfPitchY.setText(this.generateArr.get(this.generateArr.size() - 1).get(6).toString());
            this.tfDoseModulation.setText(this.generateArr.get(this.generateArr.size() - 1).get(7).toString());
            this.cbPatternFiles.setValue((Object)this.generateArr.get(this.generateArr.size() - 1).get(0).toString());
            this.lStatus.setText("STATUS: Generating Arrays");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        } else {
            this.lStatus.setText("ERROR: PATTERN FILES ARE MISSING!");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void generatedArrayLoadValues(ActionEvent event) {
        if (this.cbGeneratedArrays.getItems().size() >= 1) {
            int genArrIndex = this.cbGeneratedArrays.getSelectionModel().selectedIndexProperty().intValue();
            if (this.GENERATEARRAY_VALUE.equals("GENERATE")) {
                int n = genArrIndex = genArrIndex == -1 ? genArrIndex + 1 : genArrIndex;
            }
            if (this.GENERATEARRAY_VALUE.equals("DELETE")) {
                int tmpDelete = this.generateArrayIndex >= 1 ? this.generateArrayIndex - 1 : 0;
                genArrIndex = genArrIndex == -1 ? tmpDelete : genArrIndex;
            }
            int patIndex = this.cbPatternFiles.getSelectionModel().selectedIndexProperty().intValue();
            this.cbPatternFiles.setValue((Object)this.generateArr.get(genArrIndex).get(0).toString());
            this.tfPosX.setText(this.generateArr.get(genArrIndex).get(1).toString());
            this.tfPosY.setText(this.generateArr.get(genArrIndex).get(2).toString());
            this.tfElementsX.setText(this.generateArr.get(genArrIndex).get(3).toString());
            this.tfElementsY.setText(this.generateArr.get(genArrIndex).get(4).toString());
            this.tfPitchX.setText(this.generateArr.get(genArrIndex).get(5).toString());
            this.tfPitchY.setText(this.generateArr.get(genArrIndex).get(6).toString());
            this.tfDoseModulation.setText(this.generateArr.get(genArrIndex).get(7).toString());
        }
    }

    @FXML
    private void updateArray(ActionEvent event) {
        if (this.cbGeneratedArrays.getItems().size() > 0) {
            this.GENERATEARRAY_VALUE = "UPDATE";
            int genArrIndex = this.cbGeneratedArrays.getSelectionModel().selectedIndexProperty().intValue();
            int patIndex = this.cbPatternFiles.getSelectionModel().selectedIndexProperty().intValue();
            String pattern = this.generateArr.get(genArrIndex).get(0).toString();
            this.generateArr.get(genArrIndex).set(0, this.cbPatternFiles.getItems().get(patIndex));
            this.generateArr.get(genArrIndex).set(1, this.tfPosX.getText());
            this.generateArr.get(genArrIndex).set(2, this.tfPosY.getText());
            this.generateArr.get(genArrIndex).set(3, this.tfElementsX.getText());
            this.generateArr.get(genArrIndex).set(4, this.tfElementsY.getText());
            this.generateArr.get(genArrIndex).set(5, this.tfPitchX.getText());
            this.generateArr.get(genArrIndex).set(6, this.tfPitchY.getText());
            this.generateArr.get(genArrIndex).set(7, this.tfDoseModulation.getText());
            String genArraysName = (String)this.cbPatternFiles.getItems().get(patIndex) + "_" + genArrIndex;
            this.cbGeneratedArrays.getItems().set(genArrIndex, (Object)genArraysName);
            this.cbGeneratedArrays.setValue((Object)genArraysName);
            this.cbPatternFiles.setValue((Object)this.generateArr.get(genArrIndex).get(0).toString());
            this.tfPosX.setText(this.generateArr.get(genArrIndex).get(1).toString());
            this.tfPosY.setText(this.generateArr.get(genArrIndex).get(2).toString());
            this.tfElementsX.setText(this.generateArr.get(genArrIndex).get(3).toString());
            this.tfElementsY.setText(this.generateArr.get(genArrIndex).get(4).toString());
            this.tfPitchX.setText(this.generateArr.get(genArrIndex).get(5).toString());
            this.tfPitchY.setText(this.generateArr.get(genArrIndex).get(6).toString());
            this.tfDoseModulation.setText(this.generateArr.get(genArrIndex).get(7).toString());
            this.lStatus.setText("STATUS: Updating" + (String)this.cbGeneratedArrays.getSelectionModel().getSelectedItem() + " Arrays");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        } else {
            this.lStatus.setText("ERROR: PATTERN FILES ARE MISSING!");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void deleteArray(ActionEvent event) {
        if (this.generateArr.size() > 0) {
            this.GENERATEARRAY_VALUE = "DELETE";
            int genArrIndex = this.cbGeneratedArrays.getSelectionModel().getSelectedIndex();
            this.generateArrayIndex = genArrIndex = genArrIndex == -1 ? 0 : genArrIndex;
            this.generateArr.remove(genArrIndex);
            this.cbGeneratedArrays.getItems().clear();
            Object[] updatedArrays = this.updateGeneratedArraysList(this.generateArr);
            this.cbGeneratedArrays.getItems().addAll(updatedArrays);
            this.lStatus.setText("STATUS: Deleting Arrays");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            int n = this.displayColor = this.displayColor == 0 ? 1 : 0;
            if (this.generateArr.size() > 0) {
                genArrIndex = genArrIndex == 0 ? 1 : genArrIndex;
                this.cbGeneratedArrays.setValue(updatedArrays[genArrIndex - 1]);
            } else {
                this.cbGeneratedArrays.setValue(null);
                this.lStatus.setText("STATUS: Generated array list is EMPTY.");
                this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                this.displayColor = this.displayColor == 0 ? 1 : 0;
            }
        } else {
            this.lStatus.setText("STATUS: Generated array list is EMPTY.");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    public String[] updateGeneratedArraysList(ArrayList<ArrayList> al) {
        String[] s = new String[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            s[i] = al.get(i).get(0).toString() + "_" + i;
        }
        return s;
    }

    void printArrList(ArrayList<ArrayList> al) {
        System.out.println("\n");
        for (int i = 0; i < al.size(); ++i) {
            System.out.println("al(" + i + ") = " + al.get(i));
        }
    }

    @FXML
    private void generateSdfJdf(ActionEvent event) {
        if (this.generateArr.size() > 0) {
            this.lStatus.setText(this.tfJdfFile.getText() + ".jdf and " + this.tfSdfFile.getText() + ".sdf files saved to: " + this.saveToDir);
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
            String jdfText = this.constructJdfSdfFile(this.GENERATE, 0, "OFF");
            this.saveJDFSDF(this.tfJdfFile.getText() + ".jdf", jdfText);
            String sdfText = this.constructJdfSdfFile(this.GENERATE, 1, "OFF");
            this.saveJDFSDF(this.tfSdfFile.getText() + ".sdf", sdfText);
        } else {
            this.lStatus.setText("STATUS: Generated array list is EMPTY, nothing to generate.");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void showSdfJdf(ActionEvent event) {
        String title = "CNST JEOL 6300 JDF-SDF files";
        if (this.generateArr.size() > 0) {
            this.lStatus.setText("STATUS: Showing JDF and SDF files.");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
            String jdfSdfText = this.constructJdfSdfFile(this.SHOW, 2, "OFF");
            JEOL6300showJdfSdfActions.initShowJdfSdf(this.showJdfSdf, title, jdfSdfText);
            JEOL6300showJdfSdfActions.showJdfSdf(this.showJdfSdf);
            title = "CNST JEOL 6300 Array Check";
            JEOL6300plotJdfSdfActions.initPlotJdfSdf(this.plotJdfSdf, title, this.plotPattern());
            JEOL6300plotJdfSdfActions.plotJdfSdf(this.plotJdfSdf);
        } else {
            this.lStatus.setText("STATUS: Generated array list is EMPTY, nothing to show.");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void generateSdfJdfDose(ActionEvent event) {
        this.lDoseMatixStatus.setText(this.tfJdfFile.getText() + ".jdf and " + this.tfSdfFile.getText() + ".sdf files saved to: " + this.saveToDir);
        this.lDoseMatixStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor3));
        this.displayColor3 = this.displayColor3 == 0 ? 1 : 0;
        this.lStatus.setTextFill((Paint)LabelColors.getLabelColor());
        String jdfText = this.constructJdfSdfFile(this.GENERATE, 0, (String)this.cbDoseMethod.getValue());
        this.saveJDFSDF(this.tfJdfFile.getText() + ".jdf", jdfText);
        String sdfText = this.constructJdfSdfFile(this.GENERATE, 1, (String)this.cbDoseMethod.getValue());
        this.saveJDFSDF(this.tfSdfFile.getText() + ".sdf", sdfText);
    }

    @FXML
    private void showSdfJdfDose(ActionEvent event) {
        this.lDoseMatixStatus.setText("STATUS: Showing JDF and SDF dose matrix files.");
        this.lDoseMatixStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor3));
        this.displayColor3 = this.displayColor3 == 0 ? 1 : 0;
        String title = "CNST JEOL 6300 JDF-SDF dose and base dose matrix files";
        String jdfSdfText = this.constructJdfSdfFile(this.SHOW, 2, (String)this.cbDoseMethod.getValue());
        JEOL6300showJdfSdfActions.initShowJdfSdf(this.showJdfSdf, title, jdfSdfText);
        JEOL6300showJdfSdfActions.showJdfSdf(this.showJdfSdf);
    }

    public String constructJdfSdfFile(boolean generateShow, int type, String doseMatrixMethod) {
        double[] ramp;
        int doseElementsY = Integer.parseInt(this.tfDoseElementsY.getText());
        int doseElementsX = Integer.parseInt(this.tfDoseElementsX.getText());
        int numberOfElements = doseElementsX * doseElementsY;
        double dosePosX = Double.parseDouble(this.tfDosePosX.getText());
        double dosePosY = Double.parseDouble(this.tfDosePosY.getText());
        double dosePitchX = Double.parseDouble(this.tfDosePitchX.getText());
        double dosePitchY = Double.parseDouble(this.tfDosePitchY.getText());
        DecimalFormat df = new DecimalFormat("#.##");
        String s = "";
        String sdf = "";
        String jdf = "";
        String temp = "";
        String[] marks = this.checkGlobalMarks();
        String sSDF = "****The following information will be saved in " + this.tfSdfFile.getText() + ".sdf:\n\n";
        temp = generateShow ? "" : sSDF;
        sdf = temp + "MAGAZIN 'CNST'\n\n";
        switch (doseMatrixMethod) {
            case "OFF": {
                sdf = sdf + this.sdfFile(this.tfRESISTarea.getText());
                sdf = sdf + "OFFSET " + "(" + this.tfOFFSETx.getText() + "," + this.tfOFFSETy.getText() + ")\n\n";
                break;
            }
            case "Dose Matrix": {
                sdf = sdf + this.sdfFile(this.tfDoseStart.getText());
                sdf = sdf + "OFFSET " + "(" + this.tfOFFSETx.getText() + "," + this.tfOFFSETy.getText() + ")\n\n";
                break;
            }
            case "Base Dose": {
                int count = 0;
                ramp = this.checkRamp();
                for (int i = 0; i < doseElementsY; ++i) {
                    for (int j = 0; j < doseElementsX; ++j) {
                        double x = dosePosX + (double)j * dosePitchX;
                        double y = dosePosY + (double)i * dosePitchY;
                        sdf = sdf + this.sdfFile(df.format(ramp[count]));
                        sdf = sdf + "OFFSET " + "(" + df.format(x) + "," + df.format(y) + ")\n\n";
                        ++count;
                    }
                }
                break;
            }
        }
        sdf = sdf + "END " + (String)this.cbALDPosition.getValue();
        String sJDF = "\n\n****The following information will be saved in " + this.tfJdfFile.getText() + ".jdf:\n\n";
        temp = generateShow ? "" : sJDF;
        jdf = temp + "JOB/W  'CNST'," + this.tfSubstrateSize.getText() + "\n\n";
        jdf = jdf + marks[1];
        jdf = jdf + "\tPATH " + (String)this.cbPATH.getValue() + "\n";
        switch (doseMatrixMethod) {
            case "OFF": {
                int i;
                for (i = 0; i < this.generateArr.size(); ++i) {
                    jdf = jdf + "\t\tARRAY (" + this.generateArr.get(i).get(1).toString() + "," + this.generateArr.get(i).get(3).toString() + "," + this.generateArr.get(i).get(5).toString() + ")/(" + this.generateArr.get(i).get(2).toString() + "," + this.generateArr.get(i).get(4).toString() + "," + this.generateArr.get(i).get(6).toString() + ")\n";
                    jdf = jdf + marks[2];
                    s = i < 9 ? "0" : "";
                    jdf = jdf + "\t\t\tASSIGN\tP( " + (i + 1) + " ) -> ((*,*),S" + s + (i + 1) + ")\n";
                    jdf = jdf + "\t\tAEND\n";
                }
                jdf = jdf + "\tPEND\n";
                jdf = jdf + ";----------------------------------------------------\n" + ";       Layer Definition\n" + ";----------------------------------------------------\n";
                jdf = jdf + "\tLAYER\t1\n";
                for (i = 0; i < this.generateArr.size(); ++i) {
                    jdf = jdf + "\tP( " + (i + 1) + " )\t'" + this.generateArr.get(i).get(0).toString() + "'\n";
                }
                jdf = jdf + "\n";
                for (i = 0; i < this.generateArr.size(); ++i) {
                    s = i < 9 ? "0" : "";
                    jdf = jdf + "\tS" + s + (i + 1) + ": MODULAT((0, " + this.generateArr.get(i).get(7).toString() + "))\n";
                }
                break;
            }
            case "Dose Matrix": {
                int i;
                ramp = this.checkRamp();
                jdf = jdf + "\t\tARRAY (" + this.tfDosePosX.getText() + "," + this.tfDoseElementsX.getText() + "," + this.tfDosePitchX.getText() + ")/(" + this.tfDosePosY.getText() + "," + this.tfDoseElementsY.getText() + "," + this.tfDosePitchY.getText() + ")\n";
                jdf = jdf + marks[2];
                int cnt = 0;
                for (i = 0; i < doseElementsY; ++i) {
                    for (int j = 0; j < doseElementsX; ++j) {
                        s = cnt < 9 ? "0" : "";
                        jdf = jdf + "\t\t\tASSIGN\tP( 1 ) -> ((" + (j + 1) + "," + (i + 1) + "),S" + s + (cnt + 1) + ")\n";
                        ++cnt;
                    }
                }
                jdf = jdf + "\t\tAEND\n";
                jdf = jdf + "\tPEND\n";
                jdf = jdf + ";----------------------------------------------------\n" + ";       Layer Definition\n" + ";----------------------------------------------------\n";
                jdf = jdf + "\tLAYER\t1\n";
                jdf = jdf + "\tP( 1 )\t'" + this.tfDosePatternFile.getText() + "'\n\n";
                if (((String)this.cbDoseType.getValue()).equals("Dose Table")) {
                    jdf = jdf + this.doseTable();
                    break;
                }
                for (i = 0; i < numberOfElements; ++i) {
                    s = numberOfElements < 9 ? "0" : "";
                    jdf = jdf + "\tS" + s + (i + 1) + ": MODULAT((0, " + df.format(ramp[i]) + "))\n";
                }
                break;
            }
            case "Base Dose": {
                jdf = jdf + "\t\tARRAY (" + this.tfDosePosX.getText() + "," + this.tfDoseElementsX.getText() + "," + this.tfDosePitchX.getText() + ")/(" + this.tfDosePosY.getText() + "," + this.tfDoseElementsY.getText() + "," + this.tfDosePitchY.getText() + ")\n";
                jdf = jdf + marks[2];
                jdf = jdf + "\t\t\tASSIGN\tP( 1 ) -> ((*,*),S01)\n";
                jdf = jdf + "\t\tAEND\n";
                jdf = jdf + "\tPEND\n";
                jdf = jdf + ";----------------------------------------------------\n" + ";       Layer Definition\n" + ";----------------------------------------------------\n";
                jdf = jdf + "\tLAYER\t1\n";
                jdf = jdf + "\tP( 1 )\t'" + this.tfDosePatternFile.getText() + "'\n\n";
                jdf = ((String)this.cbDoseType.getValue()).equals("Dose Table") ? jdf + this.doseTable() : jdf + "\tS01: MODULAT((0, 0))\n";
            }
        }
        jdf = jdf + "\n\tSTDCUR " + this.tfSTDCUR.getText() + "\n\n";
        jdf = jdf + "END\n";
        switch (type) {
            case 0: {
                s = jdf;
                break;
            }
            case 1: {
                s = sdf;
                break;
            }
            case 2: {
                s = sdf + jdf;
            }
        }
        return s;
    }

    public String doseTable() {
        ArrayList<Integer> shotRank = new ArrayList<Integer>();
        ArrayList<Double> modulation = new ArrayList<Double>();
        for (int i = 0; i < this.tDoseTable.getItems().size(); ++i) {
            if (!this.checkNullValues(((JEOL6300DoseTableData)this.tDoseTable.getItems().get(i)).getShotRank(), ((JEOL6300DoseTableData)this.tDoseTable.getItems().get(i)).getModulation())) continue;
            shotRank.add(Integer.parseInt(((JEOL6300DoseTableData)this.tDoseTable.getItems().get(i)).getShotRank()));
            modulation.add(Double.parseDouble(((JEOL6300DoseTableData)this.tDoseTable.getItems().get(i)).getModulation()));
        }
        ArrayList<double[]> modulationArray = new ArrayList<double[]>();
        double linearIncrement = Double.parseDouble(this.tfDoseLinear.getText());
        double percentangeIncrement = Double.parseDouble(this.tfDosePercentage.getText());
        for (int i = 0; i < modulation.size(); ++i) {
            if (((String)this.cbDoseRamp.getValue()).equals("Percentage")) {
                modulationArray.add(this.rampPercentage((Double)modulation.get(i), percentangeIncrement));
                continue;
            }
            modulationArray.add(this.rampLinear((Double)modulation.get(i), linearIncrement));
        }
        if (shotRank.size() > 0) {
            return this.doseTableShotRanks(shotRank, modulationArray);
        }
        this.lDoseMatixStatus.setText("STATUS: Dose Table Error: Shot Rank values are missing.");
        this.lDoseMatixStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor3));
        this.displayColor3 = this.displayColor3 == 0 ? 1 : 0;
        return "Dose Table Error: Shot Rank values are missing.";
    }

    public String doseTableShotRanks(ArrayList<Integer> shotRank, ArrayList<double[]> modulationArray) {
        DecimalFormat df = new DecimalFormat("#.##");
        String str = "";
        System.out.println("");
        int iterations = ((String)this.cbDoseMethod.getValue()).equals("Base Dose") ? 1 : modulationArray.get(0).length;
        for (int i = 0; i < iterations; ++i) {
            String s = i < 9 ? "0" : "";
            str = str + "S" + s + (i + 1) + ": MODULAT(";
            for (int j = 0; j < shotRank.size(); ++j) {
                s = (j + 1) % 4 == 0 ? ",\n-     " : ",";
                s = j == shotRank.size() - 1 ? ")\n" : s;
                str = str + "(" + shotRank.get(j) + ", " + df.format(modulationArray.get(j)[i]) + ")" + s;
            }
            str = str + "\n";
        }
        return str;
    }

    public boolean checkNullValues(String sr, String mod) {
        return sr != null && mod != null;
    }

    public String sdfFile(String AreaDose) {
        String[] marks = this.checkGlobalMarks();
        String sdf = "#" + (String)this.cbALDPosition.getValue() + "\n";
        sdf = sdf + "%" + (String)this.cbSubstratePosition.getValue() + "\n";
        sdf = sdf + "JDF     '" + this.tfJdfFile.getText() + "',1\n";
        sdf = sdf + "EOS " + (String)this.cbLens.getValue() + ",'" + (String)this.cbCALPRM.getValue() + "'\n";
        sdf = sdf + "LBC " + (String)this.cbLBC.getValue() + "\n";
        sdf = sdf + marks[0];
        sdf = sdf + "RESIST " + AreaDose + "," + this.tfRESISTline.getText() + "\n";
        sdf = sdf + "SHOT A," + this.tfSHOT.getText() + "\n";
        return sdf;
    }

    public String[] checkGlobalMarks() {
        String chipJDF;
        String globalJDF;
        String marksSdf;
        String[] s = new String[3];
        if (((String)this.cbAlignmentGlobal.getValue()).equals("Global")) {
            marksSdf = "HSWITCH " + (String)this.cbHSWITCHglobal.getValue() + "," + (String)this.cbHSWITCHchip.getValue() + "\n" + "GLMDET " + (String)this.cbGLMDET.getValue() + "\n" + "CHIPAL " + (String)this.cbCHIPAL.getValue() + "\n";
            globalJDF = "GLMPOS\tP=(" + this.tfPX.getText() + "," + this.tfPY.getText() + "),Q=(" + this.tfQX.getText() + "," + this.tfQY.getText() + ")\n" + "GLMP\t" + this.tfGLMPW.getText() + "," + this.tfGLMPL.getText() + ",0,0\n" + "GLMQRS\t" + this.tfGLMQRSW.getText() + "," + this.tfGLMQRSL.getText() + ",0,0\n\n";
            chipJDF = this.checkChipMarks();
        } else {
            marksSdf = "";
            globalJDF = "";
            chipJDF = "";
        }
        s[0] = marksSdf;
        s[1] = globalJDF;
        s[2] = chipJDF;
        return s;
    }

    public String checkChipMarks() {
        String s = "";
        if (((String)this.cbCHIPAL.getValue()).equals("4") || ((String)this.cbCHIPAL.getValue()).equals("V4") || ((String)this.cbCHIPAL.getValue()).equals("S")) {
            s = "\t\tCHMPOS M1=(" + this.tfM1X.getText() + "," + this.tfM1Y.getText() + ")," + "M2=(" + this.tfM2X.getText() + "," + this.tfM2Y.getText() + ")," + "M3=(" + this.tfM3X.getText() + "," + this.tfM3Y.getText() + ")," + "M4=(" + this.tfM3X.getText() + "," + this.tfM3Y.getText() + ")\n" + "\t\tCHMARK " + this.tfCHMARKW.getText() + "," + this.tfCHMARKL.getText() + "\n";
        }
        if (((String)this.cbCHIPAL.getValue()).equals("1") || ((String)this.cbCHIPAL.getValue()).equals("V1")) {
            s = "\t\tCHMPOS M1=(" + this.tfM1X.getText() + "," + this.tfM1Y.getText() + ")\n" + "\t\tCHMARK " + this.tfCHMARKW.getText() + "," + this.tfCHMARKL.getText() + "\n";
        }
        return s;
    }

    public double[] checkRamp() {
        String ramp = (String)this.cbDoseRamp.getValue();
        int num = Integer.parseInt(this.tfDoseElementsX.getText()) * Integer.parseInt(this.tfDoseElementsY.getText());
        double doseStart = Double.parseDouble(this.tfDoseStart.getText());
        double doseEnd = Double.parseDouble(this.tfDoseEnd.getText());
        double linearIncrement = Double.parseDouble(this.tfDoseLinear.getText());
        double percentangeIncrement = Double.parseDouble(this.tfDosePercentage.getText());
        double[] rampType = new double[num];
        switch (ramp) {
            case "Linear": {
                rampType = this.rampLinear(doseStart, linearIncrement);
                break;
            }
            case "Percentage": {
                rampType = this.rampPercentage(doseStart, percentangeIncrement);
                break;
            }
            case "Linear SE": {
                rampType = this.rampLinearSE(doseStart, doseEnd, linearIncrement);
                break;
            }
            case "Nonlinear SE": {
                rampType = this.rampNonLinearSE(doseStart, doseEnd);
                break;
            }
        }
        return rampType;
    }

    public double[] rampLinear(double doseStart, double linearIncrement) {
        double[] elements = new double[Integer.parseInt(this.tfDoseElementsX.getText()) * Integer.parseInt(this.tfDoseElementsY.getText())];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = doseStart;
            doseStart += linearIncrement;
        }
        return elements;
    }

    public double[] rampPercentage(double doseStart, double percentageIncrement) {
        double[] elements = new double[Integer.parseInt(this.tfDoseElementsX.getText()) * Integer.parseInt(this.tfDoseElementsY.getText())];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = doseStart;
            doseStart += Math.abs(doseStart * percentageIncrement / 100.0);
        }
        return elements;
    }

    public double[] rampLinearSE(double doseStart, double doseEnd, double linearIncrement) {
        int num = Integer.parseInt(this.tfDoseElementsX.getText()) * Integer.parseInt(this.tfDoseElementsY.getText());
        double[] elements = new double[num];
        double increment = (doseEnd - doseStart) / (double)(num - 1);
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = doseStart;
            doseStart += increment;
        }
        return elements;
    }

    public double[] rampNonLinearSE(double doseStart, double doseEnd) {
        double ratio;
        int num = Integer.parseInt(this.tfDoseElementsX.getText()) * Integer.parseInt(this.tfDoseElementsY.getText());
        double root = num == 1 ? 1.0 : 1.0 / (double)(num - 1);
        double[] elements = new double[num];
        if (doseStart == 0.0) {
            ratio = doseEnd;
            doseStart = 1.0;
        } else {
            ratio = Math.abs(doseEnd / doseStart);
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = doseStart;
            doseStart *= Math.pow(ratio, root);
        }
        return elements;
    }

    public void saveJDFSDF(String fileName, String fileContents) {
        try {
            FileWriter fstream = new FileWriter(this.saveToDir + fileName);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(fileContents);
            out.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    @FXML
    private void loadDoseTable(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - JEOL6300 Dose Table Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        String fileName = file.getPath();
        if (fileName != null) {
            try {
                String line;
                FileInputStream fstream = new FileInputStream(fileName);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String doseModulation = "";
                while ((line = br.readLine()) != null) {
                    doseModulation = doseModulation + line;
                }
                doseModulation = doseModulation.substring(doseModulation.indexOf("(") + 1);
                doseModulation = doseModulation.substring(0, doseModulation.lastIndexOf(")"));
                Matcher m = Pattern.compile("\\((.*?)\\)").matcher(doseModulation);
                int cnt = 0;
                while (m.find()) {
                    String[] theLine = m.group(1).split(",");
                    ((JEOL6300DoseTableData)this.tDoseTable.getItems().get(cnt)).setShotRank(theLine[0].replaceAll("\\s+", ""));
                    ((JEOL6300DoseTableData)this.tDoseTable.getItems().get(cnt)).setModulation(theLine[1].replaceAll("\\s+", ""));
                    ++cnt;
                }
                in.close();
                this.lDoseMatixStatus.setText("Dose Table loaded from " + fileName);
                this.lDoseMatixStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor3));
                this.displayColor3 = this.displayColor3 == 0 ? 1 : 0;
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    public AnchorPane plotPattern() {
        Line line2;
        Line line1;
        DecimalFormat df = new DecimalFormat("0.0");
        double scale = 400.0;
        double waferSize = Double.parseDouble(this.tfSubstrateSize.getText()) * 25.0;
        double scaling = scale / waferSize;
        double boxSize = 5.0;
        AnchorPane root = new AnchorPane();
        Circle circle = new Circle(250.0, 250.0, 200.0);
        circle.setFill(null);
        circle.setStroke((Paint)Color.WHITE);
        circle.setStrokeWidth(2.5);
        Rectangle rect = new Rectangle(50.0, 50.0, 400.0, 400.0);
        rect.setFill(null);
        rect.setStroke((Paint)Color.WHITE);
        rect.setStrokeWidth(2.5);
        root.getChildren().addAll((Object[])new Node[]{circle, rect});
        for (int i = 0; i < 3; ++i) {
            line1 = new Line(52.0, (double)(150 + i * 100), 450.0, (double)(150 + i * 100));
            line1.setStroke((Paint)Color.WHITE);
            line1.setStrokeWidth(0.5);
            line1.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 10.0});
            line2 = new Line((double)(150 + i * 100), 52.0, (double)(150 + i * 100), 450.0);
            line2.setStroke((Paint)Color.WHITE);
            line2.setStrokeWidth(0.5);
            line2.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 10.0});
            root.getChildren().addAll((Object[])new Node[]{line1, line2});
        }
        double[] axisLbls = this.axisLabels(waferSize);
        double textOffset = 0.0;
        for (int i = 0; i < axisLbls.length; ++i) {
            textOffset = i == 2 ? 10.0 : 0.0;
            Text text = new Text(10.0 + textOffset, (double)(455 - i * 100), df.format(axisLbls[i]));
            text.setFill((Paint)Color.WHITE);
            text.setFont(Font.font((String)"Helvetica", (double)14.0));
            root.getChildren().addAll((Object[])new Node[]{text});
            textOffset = i == 2 ? 5.0 : 0.0;
            text = new Text(textOffset + 35.0 + (double)(i * 100), 480.0, df.format(axisLbls[i]));
            text.setFill((Paint)Color.WHITE);
            text.setFont(Font.font((String)"Helvetica", (double)14.0));
            root.getChildren().addAll((Object[])new Node[]{text});
        }
        if (this.generateArr.size() > 0) {
            for (int i = 0; i < this.generateArr.size(); ++i) {
                String patFile = this.generateArr.get(i).get(0).toString();
                double x = scaling * Double.parseDouble(this.generateArr.get(i).get(1).toString()) / 1000.0;
                double y = scaling * Double.parseDouble(this.generateArr.get(i).get(2).toString()) / 1000.0;
                int elementsX = Integer.parseInt(this.generateArr.get(i).get(3).toString());
                int elementsY = Integer.parseInt(this.generateArr.get(i).get(4).toString());
                double pitchX = scaling * Double.parseDouble(this.generateArr.get(i).get(5).toString()) / 1000.0;
                double pitchY = scaling * Double.parseDouble(this.generateArr.get(i).get(6).toString()) / 1000.0;
                for (int j = 0; j < elementsX; ++j) {
                    for (int k = 0; k < elementsY; ++k) {
                        Rectangle patRec = new Rectangle(250.0 + x + (double)j * pitchX - boxSize / 2.0, 250.0 - y + (double)k * pitchY - boxSize / 2.0, boxSize, boxSize);
                        patRec.setFill((Paint)JEOL6300JdfSdfController.getArrayColor(i));
                        root.getChildren().addAll((Object[])new Node[]{patRec});
                    }
                }
                Rectangle patRec = new Rectangle(475.0, (double)(50 + i * 16), boxSize, boxSize);
                patRec.setFill((Paint)JEOL6300JdfSdfController.getArrayColor(i));
                root.getChildren().addAll((Object[])new Node[]{patRec});
                Text text = new Text(490.0, (double)(56 + i * 16), (String)this.cbGeneratedArrays.getItems().get(i));
                text.setFill((Paint)Color.WHITE);
                text.setFont(Font.font((String)"Helvetica", (double)12.0));
                root.getChildren().addAll((Object[])new Node[]{text});
            }
        }
        if (((String)this.cbAlignmentGlobal.getValue()).equals("Global")) {
            double glblPx = scaling * Double.parseDouble(this.tfPX.getText()) / 1000.0;
            double glblPy = scaling * Double.parseDouble(this.tfPY.getText()) / 1000.0;
            double glblQx = scaling * Double.parseDouble(this.tfQX.getText()) / 1000.0;
            double glblQy = scaling * Double.parseDouble(this.tfQY.getText()) / 1000.0;
            line1 = new Line(250.0 + (glblPx - 20.0), 250.0 - glblPy, 250.0 + (glblPx + 20.0), 250.0 - glblPy);
            line1.setStroke((Paint)Color.WHITE);
            line1.setStrokeWidth(2.0);
            line2 = new Line(250.0 + glblPx, 250.0 - (glblPy - 20.0), 250.0 + glblPx, 250.0 - (glblPy + 20.0));
            line2.setStroke((Paint)Color.WHITE);
            line2.setStrokeWidth(2.0);
            root.getChildren().addAll((Object[])new Node[]{line1, line2});
            line1 = new Line(250.0 + (glblQx - 20.0), 250.0 - glblQy, 250.0 + (glblQx + 20.0), 250.0 - glblQy);
            line1.setStroke((Paint)Color.WHITE);
            line1.setStrokeWidth(2.0);
            line2 = new Line(250.0 + glblQx, 250.0 - (glblQy - 20.0), 250.0 + glblQx, 250.0 - (glblQy + 20.0));
            line2.setStroke((Paint)Color.WHITE);
            line2.setStrokeWidth(2.0);
            root.getChildren().addAll((Object[])new Node[]{line1, line2});
            line1 = new Line(472.0, 37.0, 482.0, 37.0);
            line1.setStroke((Paint)Color.WHITE);
            line1.setStrokeWidth(2.0);
            line2 = new Line(477.0, 32.0, 477.0, 42.0);
            line2.setStroke((Paint)Color.WHITE);
            line2.setStrokeWidth(2.0);
            Text text = new Text(490.0, 42.0, "Global Marks");
            text.setFill((Paint)Color.WHITE);
            text.setFont(Font.font((String)"Helvetica", (double)12.0));
            root.getChildren().addAll((Object[])new Node[]{line1, line2, text});
        }
        return root;
    }

    public static Color getArrayColor(int i) {
        Color[] c = new Color[]{Color.LIGHTBLUE, Color.LIGHTCORAL, Color.LIGHTCYAN, Color.LIGHTGOLDENRODYELLOW, Color.LIGHTGRAY, Color.LIGHTGREEN, Color.LIGHTPINK, Color.LIGHTSALMON, Color.LIGHTSKYBLUE, Color.LIGHTSTEELBLUE, Color.LIGHTYELLOW, Color.ALICEBLUE, Color.ANTIQUEWHITE, Color.AQUAMARINE, Color.DEEPPINK, Color.DEEPSKYBLUE, Color.DODGERBLUE, Color.GAINSBORO, Color.MEDIUMORCHID, Color.MEDIUMPURPLE, Color.MEDIUMSEAGREEN, Color.MEDIUMSLATEBLUE, Color.MEDIUMSPRINGGREEN, Color.MEDIUMTURQUOISE, Color.MEDIUMVIOLETRED};
        int colNum = i % c.length;
        i = i == 0 ? 1 : i;
        int colorRange = (i - 1) / c.length;
        Color y = new Color(c[colNum].getRed(), c[colNum].getGreen(), c[colNum].getBlue(), 0.75 - (double)colorRange * 0.2);
        return y;
    }

    public double[] axisLabels(double waferSize) {
        double[] axis = new double[5];
        for (int i = 0; i < axis.length; ++i) {
            axis[i] = -waferSize / 2.0 + (double)i * waferSize / 4.0;
        }
        return axis;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) throws IOException {
        AboutActions.showAbout(this.about);
    }

    private void setParameters() {
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
            CNSTdefaultParameters.getJEOL6300Parameters();
            this.cbSubstratePosition.getItems().addAll((Object[])CNSTdefaultParameters.subPos);
            this.cbSubstratePosition.setValue((Object)CNSTdefaultParameters.subPosDefault);
            this.cbSubstratePosition.setVisibleRowCount(10);
            this.tfSubstrateSize.setText(CNSTdefaultParameters.subSize);
            this.cbALDPosition.getItems().addAll((Object[])CNSTdefaultParameters.aldPos);
            this.cbALDPosition.setValue((Object)CNSTdefaultParameters.aldPosDefault);
            this.cbALDPosition.setVisibleRowCount(10);
            this.cbLens.getItems().addAll((Object[])new String[]{"3", "6"});
            this.cbLens.setValue((Object)"3");
            this.cbLens.setVisibleRowCount(2);
            this.cbLBC.getItems().addAll((Object[])new String[]{"ON", "OFF"});
            this.cbLBC.setValue((Object)"ON");
            this.cbLBC.setVisibleRowCount(2);
            this.cbAlignmentGlobal.getItems().addAll((Object[])new String[]{"OFF", "Global"});
            this.cbAlignmentGlobal.setValue((Object)"OFF");
            this.cbAlignmentGlobal.setVisibleRowCount(2);
            this.cbAlignmentChip.getItems().addAll((Object[])new String[]{"OFF", "Chip"});
            this.cbAlignmentChip.setValue((Object)"OFF");
            this.cbAlignmentChip.setVisibleRowCount(2);
            this.cbHSWITCHglobal.getItems().addAll((Object[])new String[]{"OFF", "ON"});
            this.cbHSWITCHglobal.setValue((Object)"OFF");
            this.cbHSWITCHglobal.setVisibleRowCount(2);
            this.cbHSWITCHchip.getItems().addAll((Object[])new String[]{"OFF", "ON"});
            this.cbHSWITCHchip.setValue((Object)"OFF");
            this.cbHSWITCHchip.setVisibleRowCount(2);
            this.cbGLMDET.getItems().addAll((Object[])new String[]{"A", "S", "M", "C"});
            this.cbGLMDET.setValue((Object)"S");
            this.cbGLMDET.setVisibleRowCount(4);
            this.cbCHIPAL.getItems().addAll((Object[])new String[]{"0", "1", "4", "S", "V1", "V4"});
            this.cbCHIPAL.setValue((Object)"4");
            this.cbCHIPAL.setVisibleRowCount(10);
            this.cbPATH.getItems().addAll((Object[])CNSTdefaultParameters.path);
            this.cbPATH.setValue((Object)CNSTdefaultParameters.path[0]);
            this.cbPATH.setVisibleRowCount(10);
            this.cbCALPRM.getItems().addAll((Object[])CNSTdefaultParameters.calPrm);
            this.cbCALPRM.setValue((Object)CNSTdefaultParameters.calPrm[0]);
            this.cbCALPRM.setVisibleRowCount(10);
            this.tfPX.setText(CNSTdefaultParameters.pX);
            this.tfPY.setText(CNSTdefaultParameters.pY);
            this.tfQX.setText(CNSTdefaultParameters.qX);
            this.tfQY.setText(CNSTdefaultParameters.qY);
            this.tfM1X.setText(CNSTdefaultParameters.m1X);
            this.tfM1Y.setText(CNSTdefaultParameters.m1Y);
            this.tfM2X.setText(CNSTdefaultParameters.m2X);
            this.tfM2Y.setText(CNSTdefaultParameters.m2Y);
            this.tfM3X.setText(CNSTdefaultParameters.m3X);
            this.tfM3Y.setText(CNSTdefaultParameters.m3Y);
            this.tfM4X.setText(CNSTdefaultParameters.m4X);
            this.tfM4Y.setText(CNSTdefaultParameters.m4Y);
            this.tfGLMPW.setText(CNSTdefaultParameters.glmpW);
            this.tfGLMPL.setText(CNSTdefaultParameters.glmpL);
            this.tfGLMQRSW.setText(CNSTdefaultParameters.glmqrsW);
            this.tfGLMQRSL.setText(CNSTdefaultParameters.glmqrsL);
            this.tfCHMARKW.setText(CNSTdefaultParameters.chmW);
            this.tfCHMARKL.setText(CNSTdefaultParameters.chmL);
            this.cbDoseRamp.getItems().addAll((Object[])new String[]{"Linear", "Percentage", "Linear SE", "Nonlinear SE"});
            this.cbDoseRamp.setValue((Object)"Linear");
            this.cbDoseRamp.setVisibleRowCount(4);
            this.cbDoseMethod.getItems().addAll((Object[])new String[]{"Dose Matrix", "Base Dose"});
            this.cbDoseMethod.setValue((Object)"Dose Matrix");
            this.cbDoseMethod.setVisibleRowCount(2);
            this.cbDoseType.getItems().addAll((Object[])new String[]{"Dose", "Dose Table"});
            this.cbDoseType.setValue((Object)"Dose");
            this.cbDoseType.setVisibleRowCount(2);
            this.lXMLstatus.setText(CNSTdefaultParameters.status);
            this.cbPatternFiles.setVisibleRowCount(20);
            this.cbGeneratedArrays.setVisibleRowCount(20);
        }
        catch (Exception ex) {
            Logger.getLogger(JEOL6300JdfSdfController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void generateNullDoseTable(ObservableList<JEOL6300DoseTableData> ol, int num) {
        for (int i = 0; i < num; ++i) {
            ol.add((Object)new JEOL6300DoseTableData(null, null));
        }
    }

    public static class TextFieldCellFactory
    implements Callback<TableColumn<JEOL6300DoseTableData, String>, TableCell<JEOL6300DoseTableData, String>> {
        public TableCell<JEOL6300DoseTableData, String> call(TableColumn<JEOL6300DoseTableData, String> param) {
            TextFieldCell textFieldCell = new TextFieldCell();
            return textFieldCell;
        }

        public static class TextFieldCell
        extends TableCell<JEOL6300DoseTableData, String> {
            private TextField textField;
            private StringProperty boundToCurrently = null;

            public TextFieldCell() {
                String strCss = "-fx-padding: 0;";
                this.setStyle(strCss);
                this.textField = new TextField();
                strCss = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostFocus = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotFocus);
                        } else {
                            tf.setStyle(strStyleLostFocus);
                        }
                    }
                });
                this.textField.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotHover = "-fx-background-color: derive(purple,90%), -fx-text-box-border, derive(-fx-control-inner-background, 10%);-fx-background-insets: 1, 2.8, 3.8;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostHover = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        String strStyleHasFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotHover);
                        } else if (!tf.focusedProperty().get()) {
                            tf.setStyle(strStyleLostHover);
                        } else {
                            tf.setStyle(strStyleHasFocus);
                        }
                    }
                });
                this.textField.setStyle(strCss);
                this.setGraphic((Node)this.textField);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    ObservableValue ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                    SimpleStringProperty sp = (SimpleStringProperty)ov;
                    if (this.boundToCurrently == null) {
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)sp);
                    } else if (this.boundToCurrently != sp) {
                        this.textField.textProperty().unbindBidirectional((Property)this.boundToCurrently);
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)this.boundToCurrently);
                    }
                } else {
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            }
        }
    }
}

