/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.basicShapes;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Array;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class TorusController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfSides;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfPitchX;
    @FXML
    private TextField tfPitchY;
    @FXML
    private TextField tfElemX;
    @FXML
    private TextField tfElemY;
    @FXML
    private TextField tfRadOut;
    @FXML
    private TextField tfRadIn;
    @FXML
    private TextField tfRotation;
    @FXML
    private TextField tfAngStart;
    @FXML
    private TextField tfAngEnd;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Torus Module", "Torus module is used to create square and hexagonal arrays of arcs (limited sweep angle) and rings (0 to 360 degree sweep angle).");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(TorusController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double x = Double.parseDouble(this.tfPosX.getText());
        double y = Double.parseDouble(this.tfPosY.getText());
        double rin = Double.parseDouble(this.tfRadIn.getText());
        double rout = Double.parseDouble(this.tfRadOut.getText());
        double rotation = Double.parseDouble(this.tfRotation.getText());
        double pitchX = Double.parseDouble(this.tfPitchX.getText());
        double pitchY = Double.parseDouble(this.tfPitchY.getText());
        double angleStart = Double.parseDouble(this.tfAngStart.getText());
        double angleEnd = Double.parseDouble(this.tfAngEnd.getText());
        int numSides = Integer.parseInt(this.tfSides.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        int cols = Integer.parseInt(this.tfElemX.getText());
        int rows = Integer.parseInt(this.tfElemY.getText());
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        Struct topSqr = new Struct("topSquareArray");
        Struct topHex = new Struct("topHexArray");
        GArea ga = new GArea(PrimitiveShapes.createTorus(0.0, 0.0, rin, rout, angleStart, angleEnd, numSides, layer));
        Struct torus = new Struct("torusRi" + (int)(rin * 1000.0) + "Ro" + (int)(rout * 1000.0), ga);
        if (rotation != 0.0) {
            Struct ellipseRot = new Struct("torusRi" + (int)(rin * 1000.0) + "Ro" + (int)(rout * 1000.0) + "Rot" + rotation, new Ref(torus, 0.0, 0.0, 0, rotation));
            topSqr.add(new Array(ellipseRot, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchY));
            topHex.add(new Array(ellipseRot, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
            topHex.add(new Array(ellipseRot, x + pitchX / 2.0, pitchX * Math.cos(0.5235987755982988), cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
        } else {
            topSqr.add(new Array(torus, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchY));
            topHex.add(new Array(torus, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
            topHex.add(new Array(torus, x + pitchX / 2.0, y + pitchX * Math.cos(0.5235987755982988), cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
        }
        lib.add(new Ref(topSqr, 0.0, 0.0));
        lib.add(new Ref(topHex, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

