/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.basicShapes;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Array;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class PillarHoleController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfSides;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfRadX;
    @FXML
    private TextField tfRadY;
    @FXML
    private TextField tfRotation;
    @FXML
    private TextField tfPitchX;
    @FXML
    private TextField tfPitchY;
    @FXML
    private TextField tfElemX;
    @FXML
    private TextField tfElemY;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Pillar - Hole Module", "This module is used to create square and hexagonal arrays of holes and pillars.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(PillarHoleController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        Struct shapeInvHex;
        Struct shapeInv;
        Struct shape;
        double x = Double.parseDouble(this.tfPosX.getText());
        double y = Double.parseDouble(this.tfPosY.getText());
        double radX = Double.parseDouble(this.tfRadX.getText());
        double radY = Double.parseDouble(this.tfRadY.getText());
        double rotation = Double.parseDouble(this.tfRotation.getText());
        double pitchX = Double.parseDouble(this.tfPitchX.getText());
        double pitchY = Double.parseDouble(this.tfPitchY.getText());
        int numSides = Integer.parseInt(this.tfSides.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        int cols = Integer.parseInt(this.tfElemX.getText());
        int rows = Integer.parseInt(this.tfElemY.getText());
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        Struct topSqr = new Struct("ArraySquare");
        Struct topSqrInv = new Struct("ArraySquareInverse");
        Struct topHex = new Struct("ArrayHex");
        Struct topHexInv = new Struct("ArrayHexInverse");
        String strShape = "s";
        String strShapeInverse = strShape + "Inv";
        String strName = "Rx" + (int)(radX * 1000.0) + "Ry" + (int)(radY * 1000.0);
        GArea ga = new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, radX, radY, numSides, layer));
        if (rotation != 0.0) {
            Area a = new Area(ga.getArea());
            a.transform(AffineTransform.getRotateInstance(PrimitiveShapes.degreeToRadians(rotation)));
            GArea gaR = new GArea(a, layer);
            String[] tempStr = PillarHoleController.splitRotation(rotation);
            shape = new Struct(strShape + strName + "RT" + tempStr[0] + "p" + tempStr[1], gaR);
            shapeInv = new Struct(strShapeInverse + strName + "RT" + tempStr[0] + "p" + tempStr[1], PillarHoleController.inverseShape(gaR, pitchX, pitchY, layer));
            shapeInvHex = new Struct(strShapeInverse + "Hex" + strName + "RT" + tempStr[0] + "p" + tempStr[1], PillarHoleController.inverseShape(gaR, pitchX, pitchX, layer));
        } else {
            shape = new Struct(strShape + strName, ga);
            shapeInv = new Struct(strShapeInverse + strName, PillarHoleController.inverseShape(ga, pitchX, pitchY, layer));
            shapeInvHex = new Struct(strShapeInverse + "Hex" + strName, PillarHoleController.inverseShape(ga, pitchX, pitchX, layer));
        }
        topSqr.add(new Array(shape, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchY));
        topHex.add(new Array(shape, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
        topHex.add(new Array(shape, x + pitchX / 2.0, y + pitchX * Math.cos(0.5235987755982988), cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
        topSqrInv.add(new Array(shapeInv, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchY));
        topHexInv.add(new Array(shapeInvHex, x, y, cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
        topHexInv.add(new Array(shapeInvHex, x + pitchX / 2.0, y + pitchX * Math.cos(0.5235987755982988), cols, rows, (double)cols * pitchX, (double)rows * pitchX * Math.sqrt(3.0)));
        lib.add(new Ref(topSqr, 0.0, 0.0));
        lib.add(new Ref(topHex, 0.0, 0.0));
        lib.add(new Ref(topSqrInv, 0.0, 0.0));
        lib.add(new Ref(topHexInv, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    public static String[] splitRotation(double d) {
        DecimalFormat formatter = new DecimalFormat(".####");
        return formatter.format(d).split("\\.");
    }

    public static GArea inverseShape(GArea ga, double pitchX, double pitchY, int layer) {
        GArea rect = new GArea(new Rect(-pitchX / 2.0, -pitchY / 2.0, pitchX / 2.0, pitchY / 2.0, layer), layer);
        return rect.subtract(ga);
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

