/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.Const;
import JGDS2.GDSWriter;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class calOpt
implements Const {
    public static void main(String[] args) {
        try {
            File f = new File("calopt.gds");
            FileOutputStream fileOUT = new FileOutputStream(f);
            DataOutputStream dO = new DataOutputStream(fileOUT);
            GDSWriter g = new GDSWriter(dO);
            Lib lib = new Lib();
            double textSize = 4.0;
            Struct top = new Struct("top");
            int width = 5000;
            boolean i = false;
            boolean step = true;
            Struct barm = new Struct("barUM", new RectArea(0.0, 0.0, 4.0, 0.5, 1));
            Array abmg1 = new Array(barm, 0.0, 0.0, 1, width, 1.0, width);
            Array abmg5 = new Array(barm, 2.0, 0.0, 1, width / 5, 1.0, width);
            Array abmg10 = new Array(barm, 4.0, 0.0, 1, width / 10, 1.0, width);
            top.add(abmg1);
            top.add(abmg5);
            top.add(abmg10);
            for (int k = 0; k < width; k += 5) {
                Struct text = new Struct("tm" + k, new Text("" + k, 1, textSize));
                top.add(new Ref(text, 10.0, k));
            }
            width = 4000;
            Struct bari = new Struct("barIn", new RectArea(0.0, 0.0, 5.08, 0.6, 1));
            Array abig1 = new Array(bari, 50.0, 0.0, 1, width, 1.0, (double)width * 1.27);
            Array abig5 = new Array(bari, 52.0, 0.0, 1, width / 5, 1.0, (double)width * 1.27);
            Array abig10 = new Array(bari, 54.0, 0.0, 1, width / 10, 1.0, (double)width * 1.27);
            top.add(abig1);
            top.add(abig5);
            top.add(abig10);
            for (int k = 0; k < width; k += 5) {
                Struct text = new Struct("ti" + k, new Text("" + (double)k / 20.0, 1, textSize));
                top.add(new Ref(text, 60.0, (double)k * 1.27));
            }
            Struct topp = new Struct("topp", new Array(top, -9500.0, -8500.0, 20, 3, 20000.0, 18000.0));
            lib.add(new Ref(topp, 0.0, 0.0));
            lib.GDSOut(g);
            System.out.println(" Saved to " + f.getAbsolutePath());
        }
        catch (IOException eOutput) {
            eOutput.printStackTrace();
        }
        System.out.println("done");
    }

    Struct lable(Struct[] chrs, String lb, double adv) {
        Struct lab = new Struct("TxT" + lb);
        for (int i = 0; i < lb.length(); ++i) {
            int t = lb.charAt(i);
            if ((t -= 60) < 0 || t > 9) {
                t = t == -3 ? 11 : 10;
            }
            lab.add(new Ref(chrs[i], (double)i * adv, 0.0));
        }
        return lab;
    }
}

