/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import JGDS2.GArea;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;

public class Text
extends GArea {
    Font font;
    StringBuffer string;
    double defaultSize = 3500.0;
    double scale = 1.0;

    public Text(String text, int layerNumber, double size) {
        this.string = new StringBuffer(text);
        this.font = new Font("Serif", 0, (int)size);
        this.layer = layerNumber;
        this.setRenderReso(size / 100.0);
    }

    public Text(String text, int layerNumber, Font font) {
        this.string = new StringBuffer(text);
        this.font = font;
        this.layer = layerNumber;
        this.setRenderReso(font.getSize() / 100);
    }

    public Text(String st, int l, double size, double reso) {
        this.string = new StringBuffer(st);
        this.font = new Font("Serif", 0, (int)size);
        this.layer = l;
        this.setRenderReso(reso);
    }

    public void setText(String text) {
        this.string = new StringBuffer(text);
    }

    public void setScale(double s) {
        this.scale = s;
        this.setRenderReso(this.getRenderReso() * this.scale);
    }

    public static String[] getFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getAvailableFontFamilyNames();
    }

    public void setFont(String fontName) {
        this.font = new Font(fontName, 0, (int)this.defaultSize);
    }

    public void setFont(Font nfont) {
        this.font = nfont;
    }

    public void setFont(String fontName, int fontType, double size) {
        this.font = new Font(fontName, fontType, (int)size);
    }

    public void setFontName(String fontName) {
        this.font = new Font(fontName, this.font.getStyle(), this.font.getSize());
    }

    public void setFontStyle(int fontType) {
        this.font = new Font(this.font.getFontName(), fontType, this.font.getSize());
    }

    public void setFontSize(double size) {
        this.font = new Font(this.font.getFontName(), this.font.getStyle(), (int)size);
    }

    public double lookAtRR() {
        return this.getRenderReso();
    }

    @Override
    public Area getArea() {
        this.a = new Area();
        BufferedImage Im = new BufferedImage(2, 2, 2);
        Graphics2D g2 = Im.createGraphics();
        FontRenderContext frc = g2.getFontRenderContext();
        AffineTransform at = new AffineTransform();
        double ad = 0.0;
        for (int i = 0; i < this.string.length(); ++i) {
            char c = this.string.charAt(i);
            GlyphVector gv = this.font.createGlyphVector(frc, "" + c);
            Area ab = new Area(gv.getOutline());
            at.translate(ad, 0.0);
            ab.transform(at);
            this.a.add(ab);
            ad = gv.getGlyphMetrics(0).getAdvanceX();
        }
        at = AffineTransform.getScaleInstance(1.0 * this.scale, -1.0 * this.scale);
        this.a.transform(at);
        return this.a;
    }
}

