/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import JGDS2.Constants;
import JGDS2.GArea;
import JGDS2.Text;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class BarCode
extends GArea
implements Constants {
    StringBuffer string;
    int tool;
    boolean labeled;
    AffineTransform at = new AffineTransform();

    public BarCode(String barcodeTXT, int tool, int layer) {
        int strSZ = tool == 1 ? 12 : 10;
        this.string = new StringBuffer(barcodeTXT.substring(0, barcodeTXT.length() > strSZ ? strSZ : barcodeTXT.length()).toUpperCase());
        this.tool = tool;
        this.layer = layer;
    }

    public BarCode(String barcodeTXT, int tool, int layer, boolean labeled) {
        int strSZ = tool == 1 ? 12 : 10;
        this.string = new StringBuffer(barcodeTXT.substring(0, barcodeTXT.length() > strSZ ? strSZ : barcodeTXT.length()).toUpperCase());
        this.tool = tool;
        this.layer = layer;
        this.labeled = labeled;
    }

    @Override
    public Area getArea() {
        this.a = new Area();
        int sum = 0;
        for (int i = -1; i < this.string.length() + 2; ++i) {
            int c;
            if (i == -1) {
                c = 65;
            } else if (i == this.string.length()) {
                c = this.check(sum);
            } else if (i > this.string.length()) {
                c = 66;
            } else {
                c = this.getIndex(this.string.charAt(i));
                sum += c;
            }
            if (c == 0) continue;
            this.a.add(this.barcodeBounds(this.getBarcode(c)));
            if (!this.labeled) continue;
            String s = i < 0 || i >= this.string.length() ? "*" : this.string.substring(i, i + 1);
            Text t = new Text(s, 1, BARCODE[this.tool][67] / 4L);
            t.setFont("SanSerif");
            Area la = t.getArea();
            la.transform(this.at);
            la.transform(AffineTransform.getTranslateInstance(-BARCODE[this.tool][68] / 2L, (double)(-BARCODE[this.tool][67]) * 0.6));
            this.a.add(la);
        }
        return this.a;
    }

    private char check(int sum) {
        if (this.tool == 0) {
            return (char)((sum - 1) % 64 + 1);
        }
        return '\u0000';
    }

    private int getIndex(char ci) {
        return ci - 31;
    }

    private Area barcodeBounds(long[] bc) {
        double ad = BARCODE[this.tool][0];
        double height = BARCODE[this.tool][67];
        Area tA = new Area();
        double d = 0.0;
        for (int i = bc.length - 2; i >= 0; i -= 2) {
            Rectangle2D.Double r = new Rectangle2D.Double((d += (double)bc[i + 1]) * ad, 0.0, (double)bc[i] * ad, height);
            d += (double)bc[i];
            tA.add(new Area(r));
        }
        tA.transform(this.at);
        this.at.translate(ad * d, 0.0);
        return tA;
    }

    private long[] getBarcode(int index) {
        if (index > BARCODE[1].length - 1) {
            index = 32;
        }
        long bci = BARCODE[this.tool][index];
        int len = (int)Math.log10(bci) + 1;
        long[] bca = new long[len];
        for (int i = 0; i < len; ++i) {
            bca[i] = bci % 10L;
            bca[i] = bca[i] == 7L ? 27L : bca[i];
            bca[i] = bca[i] == 8L ? 0L : bca[i];
            bci /= 10L;
        }
        return bca;
    }
}

