/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class MEMSflexureHinges {
    public static ArrayList<GArea> createFlexureHinges4A(double width, double length1, double length2, double widthMass, double lengthMass, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        ga.or(new Rect(-width / 2.0, -length1 / 2.0, width / 2.0, length1 / 2.0, layer), layer);
        ga.or(new Rect(-length2 / 2.0, -width / 2.0, length2 / 2.0, width / 2.0, layer), layer);
        GArea base = new GArea(new Rect(-baseExtent - width / 2.0, -baseHeight / 2.0, baseExtent + width / 2.0, baseHeight / 2.0, layer), layer);
        GArea temp = new GArea(base);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, length1 / 2.0 + baseHeight / 2.0)));
        temp = new GArea(base);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, -length1 / 2.0 - baseHeight / 2.0)));
        temp = new GArea(base);
        temp.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(length2 / 2.0 + baseHeight / 2.0, 0.0)));
        temp = new GArea(base);
        temp.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-length2 / 2.0 - baseHeight / 2.0, 0.0)));
        alGA.add(ga);
        if (anchorDistance < baseExtent + width / 2.0) {
            GArea anchor = MEMSflexureHinges.createFlexureAnchor(width, baseHeight, baseExtent, anchorDistance, anchorLayer);
            temp = new GArea(anchor);
            GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(0.0, length1 / 2.0 + baseHeight / 2.0)));
            temp = new GArea(anchor);
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, -length1 / 2.0 - baseHeight / 2.0)));
            temp = new GArea(anchor);
            temp.transform(AffineTransform.getRotateInstance(1.5707963267948966));
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(length2 / 2.0 + baseHeight / 2.0, 0.0)));
            temp = new GArea(anchor);
            temp.transform(AffineTransform.getRotateInstance(1.5707963267948966));
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-length2 / 2.0 - baseHeight / 2.0, 0.0)));
            alGA.add(allAnchors);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges4B(double width, double length1, double length2, double widthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        double lengthMass = 2.0 * length2 + 2.0 * baseHeight + gap;
        GArea ga = new GArea(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        ga.or(new Rect(-widthMass / 2.0 - length1, -lengthMass / 2.0, widthMass / 2.0 + length1, -lengthMass / 2.0 + width, layer), layer);
        ga.or(new Rect(-widthMass / 2.0 - length1, lengthMass / 2.0 - width, widthMass / 2.0 + length1, lengthMass / 2.0, layer), layer);
        ga.or(new Rect(-widthMass / 2.0 - length1, -lengthMass / 2.0, -widthMass / 2.0 - length1 + width, -lengthMass / 2.0 + length2, layer), layer);
        ga.or(new Rect(widthMass / 2.0 + length1 - width, -lengthMass / 2.0, widthMass / 2.0 + length1, -lengthMass / 2.0 + length2, layer), layer);
        ga.or(new Rect(-widthMass / 2.0 - length1, lengthMass / 2.0 - length2, -widthMass / 2.0 - length1 + width, lengthMass / 2.0, layer), layer);
        ga.or(new Rect(widthMass / 2.0 + length1 - width, lengthMass / 2.0 - length2, widthMass / 2.0 + length1, lengthMass / 2.0, layer), layer);
        GArea bondPad = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        GArea temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 - baseWidth / 2.0 + width / 2.0, -lengthMass / 2.0 + length2)));
        temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 + length1 - baseWidth / 2.0 - width / 2.0, -lengthMass / 2.0 + length2)));
        temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 - baseWidth / 2.0 + width / 2.0, lengthMass / 2.0 - length2 - baseHeight)));
        temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 + length1 - baseWidth / 2.0 - width / 2.0, lengthMass / 2.0 - length2 - baseHeight)));
        alGA.add(ga);
        if (anchorDistance < baseWidth / 2.0 && anchorDistance < baseHeight / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea anchor = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
            temp = new GArea(anchor);
            GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 - baseWidth / 2.0 + width / 2.0, -lengthMass / 2.0 + length2)));
            temp = new GArea(anchor);
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 + length1 - baseWidth / 2.0 - width / 2.0, -lengthMass / 2.0 + length2)));
            temp = new GArea(anchor);
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 - baseWidth / 2.0 + width / 2.0, lengthMass / 2.0 - length2 - baseHeight)));
            temp = new GArea(anchor);
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 + length1 - baseWidth / 2.0 - width / 2.0, lengthMass / 2.0 - length2 - baseHeight)));
            alGA.add(allAnchors);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges4C(double width, double length1, double length2, double length3, double length4, double widthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        double lengthMass = 2.0 * baseHeight + gap;
        GArea ga = new GArea(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(0.0, length1 - width / 2.0);
        poly.lineTo(-length2 + width, length1 - width / 2.0);
        poly.lineTo(-length2 + width, length1 + length3 - 3.0 * width / 2.0);
        poly.lineTo(length4 + baseWidth / 2.0 + width / 2.0, length1 + length3 - 3.0 * width / 2.0);
        poly.lineTo(length4 + baseWidth / 2.0 + width / 2.0, 0.0);
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea meander = new GArea(bs.createStrokedShape(poly), layer);
        GArea temp = new GArea(meander);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 - width / 2.0, lengthMass / 2.0)));
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        GArea mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        temp = new GArea(meander);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 + width / 2.0, -lengthMass / 2.0)));
        mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        GArea bondPad = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length4 - baseWidth, -lengthMass / 2.0)));
        mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 + length4, lengthMass / 2.0 - baseHeight)));
        mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        alGA.add(ga);
        if (anchorDistance < baseWidth / 2.0 && anchorDistance < baseHeight / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea anchor = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
            temp = new GArea(anchor);
            GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length4 - baseWidth, -lengthMass / 2.0)));
            mirror = new GArea(temp);
            allAnchors.or((GDS2)mirror.transform(at));
            temp = new GArea(anchor);
            allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(widthMass / 2.0 + length4, lengthMass / 2.0 - baseHeight)));
            mirror = new GArea(temp);
            allAnchors.or((GDS2)mirror.transform(at));
            alGA.add(allAnchors);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges4D(double width1, double width2, double width3, double length1, double length2, double widthMass, double lengthMass, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        double extraWidth = width2 + length1 + length2 + baseWidth;
        GArea ga = new GArea(new Rect(-widthMass / 2.0 - extraWidth, -lengthMass / 2.0, widthMass / 2.0 + extraWidth, lengthMass / 2.0, layer), layer);
        GArea temp = new GArea(new Rect(-widthMass / 2.0 - extraWidth + width2, -lengthMass / 2.0 + width1, widthMass / 2.0 + extraWidth - width2, lengthMass / 2.0 - width1, layer), layer);
        ga.subtract(temp);
        ga.or(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        temp = new GArea(new Rect(-widthMass / 2.0 - extraWidth + width2, baseHeight / 2.0 + gap / 2.0 - width3 / 2.0, -widthMass / 2.0 - extraWidth + width2 + length2, baseHeight / 2.0 + gap / 2.0 + width3 / 2.0, layer), layer);
        temp.or(new Rect(-widthMass / 2.0 - extraWidth + width2, -baseHeight / 2.0 - gap / 2.0 - width3 / 2.0, -widthMass / 2.0 - extraWidth + width2 + length2, -baseHeight / 2.0 - gap / 2.0 + width3 / 2.0, layer), layer);
        ga.or(temp);
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        GArea mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        temp = new GArea(new Rect(-widthMass / 2.0 - extraWidth + width2 + length2, gap / 2.0, -widthMass / 2.0 - extraWidth + width2 + length2 + baseWidth, gap / 2.0 + baseHeight, layer), layer);
        temp.or(new Rect(-widthMass / 2.0 - extraWidth + width2 + length2, -gap / 2.0 - baseHeight, -widthMass / 2.0 - extraWidth + width2 + length2 + baseWidth, -gap / 2.0, layer), layer);
        ga.or(temp);
        mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        alGA.add(ga);
        if (anchorDistance < baseWidth / 2.0 && anchorDistance < baseHeight / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            temp = new GArea(new Rect(-widthMass / 2.0 - extraWidth + width2 + length2 + anchorDistance, gap / 2.0 + anchorDistance, -widthMass / 2.0 - extraWidth + width2 + length2 + baseWidth - anchorDistance, gap / 2.0 + baseHeight - anchorDistance, anchorLayer), anchorLayer);
            temp.or(new Rect(-widthMass / 2.0 - extraWidth + width2 + length2 + anchorDistance, -gap / 2.0 - baseHeight + anchorDistance, -widthMass / 2.0 - extraWidth + width2 + length2 + baseWidth - anchorDistance, -gap / 2.0 - anchorDistance, anchorLayer), anchorLayer);
            mirror = new GArea(temp);
            temp.or((GDS2)mirror.transform(at));
            alGA.add(temp);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges4E(double width1, double width2, double width3, double width4, double length1, double length2, double length3, double length4, double length5, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(-width1 / 2.0, -length1 / 2.0, width1 / 2.0, length1 / 2.0, layer), layer);
        double startX = -width1 / 2.0 - length3;
        ga.or(new Rect(startX, -length1 / 2.0 - width3, -startX, -length1 / 2.0, layer), layer);
        ga.or(new Rect(startX, length1 / 2.0, -startX, length1 / 2.0 + width3, layer), layer);
        startX = -width1 / 2.0 - length2;
        ga.or(new Rect(startX, -length1 / 2.0 + length4, -startX, -length1 / 2.0 + length4 + width2, layer), layer);
        ga.or(new Rect(startX, length1 / 2.0 - length4 - width2, -startX, length1 / 2.0 - length4, layer), layer);
        double startY = -length1 / 2.0 + length4 - length5;
        ga.or(new Rect(startX -= width4, startY, startX + width4, startY + length5 + width2, layer), layer);
        ga.or(new Rect(-startX - width4, startY, -startX, startY + length5 + width2, layer), layer);
        startY = length1 / 2.0 - length4 - width2;
        ga.or(new Rect(startX, startY, startX + width4, startY + length5 + width2, layer), layer);
        ga.or(new Rect(-startX - width4, startY, -startX, startY + length5 + width2, layer), layer);
        startX = startX + width4 / 2.0 - baseWidth / 2.0;
        startY = length1 / 2.0 - length4 + length5;
        ga.or(new Rect(startX, startY, startX + baseWidth, startY + baseHeight, layer), layer);
        ga.or(new Rect(-startX - baseWidth, startY, -startX, startY + baseHeight, layer), layer);
        GArea anchors = new GArea(new Rect(startX + anchorDistance, startY + anchorDistance, startX + baseWidth - anchorDistance, startY + baseHeight - anchorDistance, anchorLayer), anchorLayer);
        anchors.or(new Rect(-startX - baseWidth + anchorDistance, startY + anchorDistance, -startX - anchorDistance, startY + baseHeight - anchorDistance, anchorLayer), anchorLayer);
        startY = -length1 / 2.0 + length4 - length5 - baseHeight;
        ga.or(new Rect(startX, startY, startX + baseWidth, startY + baseHeight, layer), layer);
        ga.or(new Rect(-startX - baseWidth, startY, -startX, startY + baseHeight, layer), layer);
        anchors.or(new Rect(startX + anchorDistance, startY + anchorDistance, startX + baseWidth - anchorDistance, startY + baseHeight - anchorDistance, anchorLayer), anchorLayer);
        anchors.or(new Rect(-startX - baseWidth + anchorDistance, startY + anchorDistance, -startX - anchorDistance, startY + baseHeight - anchorDistance, anchorLayer), anchorLayer);
        alGA.add(ga);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges2A(double width, double length1, double length2, double widthMass, double lengthMass, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        GArea ga = new GArea(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        double boxW = 3.0 * width / 2.0 + length2 + baseWidth / 2.0;
        double boxH = 2.0 * length1 + lengthMass;
        GArea meander = new GArea(new Rect(-boxW / 2.0, -boxH / 2.0, boxW / 2.0, boxH / 2.0, layer), layer);
        meander.subtract(new Rect(-boxW / 2.0 + width, -boxH / 2.0 + width, boxW / 2.0 - width, boxH / 2.0 - width, layer), layer);
        GArea temp = new GArea(meander);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - boxW / 2.0 + width, 0.0)));
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        GArea mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        GArea bondPad = new GArea(new Rect(-baseWidth / 2.0, -baseHeight / 2.0, baseWidth / 2.0, baseHeight / 2.0, layer), layer);
        temp = new GArea(bondPad);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length2 - baseWidth / 2.0, 0.0)));
        mirror = new GArea(temp);
        ga.or((GDS2)mirror.transform(at));
        alGA.add(ga);
        if (anchorDistance < baseWidth / 2.0 && anchorDistance < baseHeight / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea anchor = new GArea(new Rect(-baseWidth / 2.0 + anchorDistance, -baseHeight / 2.0 + anchorDistance, baseWidth / 2.0 - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
            temp = new GArea(anchor);
            GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length2 - baseWidth / 2.0, 0.0)));
            mirror = new GArea(temp);
            allAnchors.or((GDS2)mirror.transform(at));
            alGA.add(allAnchors);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges2B(double width, double length1, double length2, double widthMass, double lengthMass, double connectorHeight, double connectorWidth, double squareHeight, double squareWidth, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        GArea ga = new GArea(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(length1 / 2.0 + width / 2.0, -connectorHeight / 2.0 + width / 2.0);
        poly.lineTo(length1 / 2.0 + width / 2.0, connectorHeight / 2.0 - width / 2.0);
        poly.lineTo(squareWidth / 2.0 - width / 2.0, length2 / 2.0 + width / 2.0);
        poly.lineTo(-squareWidth / 2.0 + width / 2.0, length2 / 2.0 + width / 2.0);
        poly.lineTo(-length1 / 2.0 - width / 2.0, baseHeight / 2.0 - width / 2.0);
        poly.lineTo(-length1 / 2.0 - width / 2.0, -baseHeight / 2.0 + width / 2.0);
        poly.lineTo(-squareWidth / 2.0 + width / 2.0, -length2 / 2.0 - width / 2.0);
        poly.lineTo(squareWidth / 2.0 - width / 2.0, -length2 / 2.0 - width / 2.0);
        poly.closePath();
        BasicStroke bs = new BasicStroke((float)width, 2, 0);
        GArea diamond = new GArea(bs.createStrokedShape(poly), layer);
        alGA.add(diamond);
        GArea temp = new GArea(new Rect(-baseWidth / 2.0, -baseHeight / 2.0, baseWidth / 2.0, baseHeight / 2.0, layer), layer);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-length1 / 2.0 - baseWidth / 2.0, 0.0)));
        temp = new GArea(new Rect(-connectorWidth / 2.0, -connectorHeight / 2.0, connectorWidth / 2.0, connectorHeight / 2.0, layer), layer);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(length1 / 2.0 + connectorWidth / 2.0, 0.0)));
        GArea square = new GArea(new Rect(-squareWidth / 2.0, -squareHeight / 2.0, squareWidth / 2.0, squareHeight / 2.0, layer), layer);
        temp = new GArea(square);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, length2 / 2.0 + squareHeight / 2.0)));
        temp = new GArea(square);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, -length2 / 2.0 - squareHeight / 2.0)));
        GArea mirror = new GArea(diamond);
        ga.or((GDS2)diamond.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 / 2.0 - connectorWidth, 0.0)));
        mirror.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 / 2.0 - connectorWidth, 0.0));
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        ga.or((GDS2)mirror.transform(at));
        alGA.add(ga);
        if (anchorDistance < baseWidth / 2.0 && anchorDistance < baseHeight / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea anchor = new GArea(new Rect(-baseWidth / 2.0 + anchorDistance, -baseHeight / 2.0 + anchorDistance, baseWidth / 2.0 - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
            temp = new GArea(anchor);
            GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(-widthMass / 2.0 - length1 - connectorWidth - baseWidth / 2.0, 0.0)));
            mirror = new GArea(temp);
            allAnchors.or((GDS2)mirror.transform(at));
            alGA.add(allAnchors);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges2C(double width, double length1, double length2, double length3, double widthMass, double lengthMass, double amplitude, int periods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        length3 = Math.abs(length3);
        GArea ga = new GArea(new Rect(-widthMass / 2.0, -lengthMass / 2.0, widthMass / 2.0, lengthMass / 2.0, layer), layer);
        double startX = baseWidth / 2.0;
        Path2D.Double path = new Path2D.Double();
        path.moveTo(startX, 0.0);
        path.lineTo(startX + length1, 0.0);
        double delta = length2 / (double)(periods * 2);
        for (double i = 0.0; i < length2; i += delta) {
            path.lineTo(i + startX + length1, amplitude);
            path.lineTo(i + delta + startX + length1, amplitude);
            path.lineTo(i + delta + startX + length1, -amplitude);
            path.lineTo(i + 2.0 * delta + startX + length1, -amplitude);
            path.lineTo(i + 2.0 * delta + startX + length1, 0.0);
            i += delta;
        }
        path.lineTo(startX + length1 + length2, 0.0);
        path.lineTo(startX + length1 + length2 + length3, 0.0);
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea meander = new GArea(bs.createStrokedShape(path), layer);
        meander.or(new Rect(-baseWidth / 2.0, -baseHeight / 2.0, baseWidth / 2.0, baseHeight / 2.0, layer), layer);
        meander.transform(AffineTransform.getTranslateInstance(-baseWidth / 2.0 - length1 - length2 - length3 - widthMass / 2.0, 0.0));
        GArea mirror = new GArea(meander);
        ga.or(meander);
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        ga.or((GDS2)mirror.transform(at));
        alGA.add(ga);
        if (anchorDistance < baseWidth / 2.0 && anchorDistance < baseHeight / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea anchor = new GArea(new Rect(-baseWidth / 2.0 + anchorDistance, -baseHeight / 2.0 + anchorDistance, baseWidth / 2.0 - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
            GArea temp = new GArea(anchor);
            GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(-baseWidth / 2.0 - length1 - length2 - length3 - widthMass / 2.0, 0.0)));
            mirror = new GArea(temp);
            allAnchors.or((GDS2)mirror.transform(at));
            alGA.add(allAnchors);
        }
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges2D(double width1, double width2, double width3, double width4, double length1, double length2, double length3, double length4, double length5, double length6, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(-width1 / 2.0, -length1 / 2.0 - width4, width1 / 2.0, length1 / 2.0 + width4, layer), layer);
        ga.or(new Rect(-width1 / 2.0 - length4 - width2 - length5, -length1 / 2.0 - width4, width1 / 2.0 + length4 + width2 + length5, -length1 / 2.0, layer), layer);
        ga.or(new Rect(-width1 / 2.0 - length4 - width2 - length5, length1 / 2.0, width1 / 2.0 + length4 + width2 + length5, length1 / 2.0 + width4, layer), layer);
        double startX = -width1 / 2.0 - length4 - width2;
        ga.or(new Rect(startX, length1 / 2.0 - length2 - width3, startX + width2, length1 / 2.0, layer), layer);
        ga.or(new Rect(startX, -length1 / 2.0, startX + width2, -length1 / 2.0 + length2 + width3, layer), layer);
        startX = width1 / 2.0 + length4;
        ga.or(new Rect(startX, length1 / 2.0 - length2 - width3, startX + width2, length1 / 2.0, layer), layer);
        ga.or(new Rect(startX, -length1 / 2.0, startX + width2, -length1 / 2.0 + length2 + width3, layer), layer);
        startX = -width1 / 2.0 - length4 - width2 - length3;
        ga.or(new Rect(startX, -length1 / 2.0 + length2, startX + length3, -length1 / 2.0 + length2 + width3, layer), layer);
        ga.or(new Rect(startX, length1 / 2.0 - length2 - width3, startX + length3, length1 / 2.0 - length2, layer), layer);
        startX = width1 / 2.0 + length4 + width2;
        ga.or(new Rect(startX, -length1 / 2.0 + length2, startX + length3, -length1 / 2.0 + length2 + width3, layer), layer);
        ga.or(new Rect(startX, length1 / 2.0 - length2 - width3, startX + length3, length1 / 2.0 - length2, layer), layer);
        startX = -width1 / 2.0 - length4 - width2 - length3 - baseWidth;
        double startY = -length1 / 2.0 + length2 - length6;
        double middleElectrodeHeight = length1 - 2.0 * length2;
        ga.or(new Rect(startX, startY, startX + baseWidth, startY + 2.0 * length6 + middleElectrodeHeight, layer), layer);
        GArea anchor = new GArea(new Rect(startX + anchorDistance, startY + anchorDistance, startX + baseWidth - anchorDistance, startY + 2.0 * length6 + middleElectrodeHeight - anchorDistance, anchorLayer), anchorLayer);
        startX = width1 / 2.0 + length4 + width2 + length3;
        ga.or(new Rect(startX, startY, startX + baseWidth, startY + 2.0 * length6 + middleElectrodeHeight, layer), layer);
        anchor.or(new Rect(startX + anchorDistance, startY + anchorDistance, startX + baseWidth - anchorDistance, startY + 2.0 * length6 + middleElectrodeHeight - anchorDistance, anchorLayer), anchorLayer);
        alGA.add(ga);
        alGA.add(anchor);
        return alGA;
    }

    public static ArrayList<GArea> createFlexureHinges2E(double width1, double width2, double width3, double width4, double width5, double length1, double length2, double length3, double length4, double gap, double baseExtent, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(-width1 / 2.0, -length1 / 2.0, width1 / 2.0, length1 / 2.0, layer), layer);
        double startX = -width1 / 2.0 - length3;
        double startY = -length1 / 2.0 - width3;
        ga.or(new Rect(startX, startY, -startX, startY + width3, layer), layer);
        ga.or(new Rect(startX, -startY - width3, -startX, -startY, layer), layer);
        startX = -width1 / 2.0 - gap - baseWidth - length2;
        startY = -length1 / 2.0 - width3 / 2.0 - width4 / 2.0;
        ga.or(new Rect(startX, startY, -startX, startY + width4, layer), layer);
        ga.or(new Rect(startX, -startY - width4, -startX, -startY, layer), layer);
        startY = -baseWidth / 2.0 + baseExtent;
        ga.or(new Rect(startX, startY, startX + length2, startY + width2, layer), layer);
        ga.or(new Rect(-startX - length2, startY, -startX, startY + width2, layer), layer);
        ga.or(new Rect(startX, -startY - width2, startX + length2, -startY, layer), layer);
        ga.or(new Rect(-startX - length2, -startY - width2, -startX, -startY, layer), layer);
        ga.or(new Rect(startX += length2, -baseHeight / 2.0, startX + baseWidth, baseHeight / 2.0, layer), layer);
        GArea anchors = new GArea(new Rect(startX + anchorDistance, -baseHeight / 2.0 + anchorDistance, startX + baseWidth - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
        ga.or(new Rect(-startX - baseWidth, -baseHeight / 2.0, -startX, baseHeight / 2.0, layer), layer);
        anchors.or(new Rect(-startX - baseWidth + anchorDistance, -baseHeight / 2.0 + anchorDistance, -startX - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
        startX = startX - length2 - width5;
        startY = -length1 / 2.0 - width3 / 2.0 - width4 / 2.0 - length4;
        ga.or(new Rect(startX, startY, startX + width5, -startY, layer), layer);
        ga.or(new Rect(-startX - width5, startY, -startX, -startY, layer), layer);
        alGA.add(ga);
        alGA.add(anchors);
        return alGA;
    }

    public static GArea createFlexureAnchor(double width, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
        GArea anchor = new GArea(new Rect(-baseExtent - width / 2.0 + anchorDistance, -baseHeight / 2.0 + anchorDistance, baseExtent + width / 2.0 - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
        return anchor;
    }
}

