/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.RectArea;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class CurvedBeamsNEMS {
    public static void createCurvedBeamNEMS(Struct s, double x, double y, double beamLength, double beamWidth, int numPointsBeamLength, double elevation, double bondPadLength, double electrodeSize, double gap, double triangleDistance, double triangleSize, double electrodeTriangleDistance, double electrodeTriangleSize, boolean withElectrode, int gdsLayer) {
        double increment = beamLength / (double)numPointsBeamLength;
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        CurvedBeamsNEMS.createCurvedStructures(alGA, beamLength, beamWidth, elevation, gdsLayer, numPointsBeamLength, bondPadLength, electrodeSize, gap, triangleDistance, triangleSize, electrodeTriangleDistance, electrodeTriangleSize, withElectrode);
        CurvedBeamsNEMS.addGAreaToStruct(alGA, s, beamLength, x, y);
    }

    public static double calculateShape(double x, double elevation, double length) {
        return elevation / 2.0 * (1.0 - Math.cos(Math.PI * 2 * x / length));
    }

    static double arcL(double x, double elevation, double length) {
        double fPrime = elevation / 2.0 * (Math.PI * 2 / length) * Math.sin(Math.PI * 2 * x / length);
        return Math.sqrt(1.0 + fPrime * fPrime);
    }

    public static double adaptive(double a, double b, double elevation, double length) {
        double EPSILON = 1.0E-6;
        double h = b - a;
        double c = (a + b) / 2.0;
        double d = (a + c) / 2.0;
        double e = (b + c) / 2.0;
        double Q1 = h / 6.0 * (CurvedBeamsNEMS.arcL(a, elevation, length) + 4.0 * CurvedBeamsNEMS.arcL(c, elevation, length) + CurvedBeamsNEMS.arcL(b, elevation, length));
        double Q2 = h / 12.0 * (CurvedBeamsNEMS.arcL(a, elevation, length) + 4.0 * CurvedBeamsNEMS.arcL(d, elevation, length) + 2.0 * CurvedBeamsNEMS.arcL(c, elevation, length) + 4.0 * CurvedBeamsNEMS.arcL(e, elevation, length) + CurvedBeamsNEMS.arcL(b, elevation, length));
        if (Math.abs(Q2 - Q1) <= EPSILON) {
            return Q2 + (Q2 - Q1) / 15.0;
        }
        return CurvedBeamsNEMS.adaptive(a, c, elevation, length) + CurvedBeamsNEMS.adaptive(c, b, elevation, length);
    }

    public static ArrayList<Double> calculateSegments(int N, double a, double b, double elevation, double length) {
        double arcLength = CurvedBeamsNEMS.adaptive(a, b, elevation, length);
        double EPSILON = 1.0E-6;
        double segment2 = arcLength / (double)N;
        ArrayList<Double> xValue = new ArrayList<Double>();
        for (int i = 0; i <= N; ++i) {
            double left = a;
            double right = b;
            double middle = 0.0;
            while (right - left > EPSILON) {
                middle = (left + right) / 2.0;
                double middleTMP = CurvedBeamsNEMS.adaptive(0.0, middle, elevation, length);
                if (middleTMP <= (double)i * segment2) {
                    left = middle;
                    continue;
                }
                right = middle;
            }
            xValue.add(middle);
        }
        return xValue;
    }

    public static void addGAreaToStruct(ArrayList<GArea> alGA, Struct s, double beamLength, double Tx, double Ty) {
        for (GArea alGA1 : alGA) {
            alGA1.setDataType(CNSTscriptingController.getDataType());
            alGA1.transform(AffineTransform.getRotateInstance(-1.5707963267948966, beamLength / 2.0, 0.0));
            alGA1.transform(AffineTransform.getTranslateInstance(-beamLength / 2.0 + Tx, Ty));
            s.add(alGA1);
        }
    }

    public static ArrayList<GArea> createCurvedStructures(ArrayList<GArea> alGA, double beamLength, double beamWidth, double elevation, int gdsLayer, int N, double bondPadLength, double electrodeSize, double gap, double triangleDistance, double triangleSize, double electrodeTriangleDistance, double electrodeTriangleSize, boolean withElectrode) {
        ArrayList<Double> xVal = CurvedBeamsNEMS.calculateSegments(N, 0.0, beamLength, elevation, beamLength);
        ArrayList<Double> yVal = new ArrayList<Double>();
        for (int i = 0; i < xVal.size(); ++i) {
            yVal.add(CurvedBeamsNEMS.calculateShape(xVal.get(i), elevation, beamLength) + beamWidth / 2.0);
        }
        alGA.add(CurvedBeamsNEMS.createCurvedBeam(xVal, yVal, beamWidth, gdsLayer));
        if (!withElectrode) {
            alGA.add(new RectArea(-bondPadLength, -bondPadLength / 2.0, 0.0, bondPadLength / 2.0, gdsLayer));
            alGA.add(new RectArea(beamLength, -bondPadLength / 2.0, beamLength + bondPadLength, bondPadLength / 2.0, gdsLayer));
            alGA.add(CurvedBeamsNEMS.createTriangle(beamLength, triangleSize, triangleDistance, gdsLayer, false));
            alGA.add(CurvedBeamsNEMS.createTriangle(beamLength, triangleSize, triangleDistance, gdsLayer, true));
        } else {
            alGA.add(new RectArea(-bondPadLength, -beamWidth / 2.0, 0.0, bondPadLength - beamWidth / 2.0, gdsLayer));
            alGA.add(new RectArea(beamLength, -beamWidth / 2.0, beamLength + bondPadLength, bondPadLength - beamWidth / 2.0, gdsLayer));
            alGA.add(CurvedBeamsNEMS.createTopElectrode(gap, beamLength, electrodeSize, electrodeTriangleDistance, electrodeTriangleSize, gdsLayer));
            alGA.add(new RectArea(-bondPadLength, -electrodeSize - gap, beamLength + bondPadLength, -gap, gdsLayer));
        }
        return alGA;
    }

    public static GArea createTopElectrode(double gap, double beamLength, double electrodeHeight, double electrodeTriangleDistance, double electrodeTriangleSize, int gdsLayer) {
        GArea rect = new GArea(new RectArea(gap, gap, beamLength - gap, electrodeHeight + gap, gdsLayer));
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(beamLength / 2.0, gap + electrodeTriangleDistance);
        poly.lineTo(beamLength / 2.0 + electrodeTriangleSize / 2.0, gap + electrodeTriangleDistance + electrodeTriangleSize);
        poly.lineTo(beamLength / 2.0 - electrodeTriangleSize / 2.0, gap + electrodeTriangleDistance + electrodeTriangleSize);
        poly.moveTo(beamLength / 2.0, gap + electrodeTriangleDistance);
        poly.closePath();
        GArea tri = new GArea(poly, gdsLayer);
        Area a = new Area(tri.getArea());
        rect.subtract(a);
        rect.setDataType(CNSTscriptingController.getDataType());
        return rect;
    }

    public static GArea createTriangle(double beamLength, double triangleSize, double triangleDistance, int bondPadLayer, boolean upsidedown) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(beamLength / 2.0, triangleDistance);
        poly.lineTo(beamLength / 2.0 + triangleSize / 2.0, triangleDistance + triangleSize);
        poly.lineTo(beamLength / 2.0 - triangleSize / 2.0, triangleDistance + triangleSize);
        poly.moveTo(beamLength / 2.0, triangleDistance);
        poly.closePath();
        GArea v = new GArea(poly, bondPadLayer);
        v.setDataType(CNSTscriptingController.getDataType());
        if (upsidedown) {
            v.transform(AffineTransform.getRotateInstance(Math.PI, beamLength / 2.0, 0.0));
        }
        return v;
    }

    public static GArea createCurvedBeam(ArrayList<Double> x, ArrayList<Double> y, double width, int layer) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x.get(0), y.get(0));
        for (i = 1; i < x.size(); ++i) {
            poly.lineTo(x.get(i), y.get(i));
        }
        for (i = x.size() - 1; i >= 0; --i) {
            poly.lineTo(x.get(i), y.get(i) - width);
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }
}

