/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.scripting;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.scripting.CNSTscriptingArrays;
import CNSTnanoToolbox.scripting.CircleThree;
import CNSTnanoToolbox.shapeMethods.AlignmentMarks;
import CNSTnanoToolbox.shapeMethods.AlignmentMarksCustom;
import CNSTnanoToolbox.shapeMethods.CNSTnistLogos;
import CNSTnanoToolbox.shapeMethods.CNSTreticleFrames;
import CNSTnanoToolbox.shapeMethods.CurvedBeamsNEMS;
import CNSTnanoToolbox.shapeMethods.Fractals;
import CNSTnanoToolbox.shapeMethods.FunctionPlot;
import CNSTnanoToolbox.shapeMethods.Grayscale;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.LabelMaker;
import CNSTnanoToolbox.shapeMethods.MEMSactuators;
import CNSTnanoToolbox.shapeMethods.MEMSbeams;
import CNSTnanoToolbox.shapeMethods.MEMScoupledArrays;
import CNSTnanoToolbox.shapeMethods.MEMSflexureHinges;
import CNSTnanoToolbox.shapeMethods.MISCobjects;
import CNSTnanoToolbox.shapeMethods.MeanderChannels;
import CNSTnanoToolbox.shapeMethods.Photonics;
import CNSTnanoToolbox.shapeMethods.PhotonicsDiscRingPulleys;
import CNSTnanoToolbox.shapeMethods.PhotonicsGratingCouplers;
import CNSTnanoToolbox.shapeMethods.PhotonicsWaveGuides;
import CNSTnanoToolbox.shapeMethods.PhotonicsWgDcThomasVladimir;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.shapeMethods.RegularPolygon;
import CNSTnanoToolbox.shapeMethods.Spirals;
import CNSTnanoToolbox.shapeMethods.StarPolygon;
import CNSTnanoToolbox.shapeMethods.TextOutline;
import CNSTnanoToolbox.shapeMethods.Verniers;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.GDS2Element;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.BasicStroke;
import java.awt.GraphicsEnvironment;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.script.ScriptException;

public class CNSTscriptingController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    static File file = null;
    static String openDir;
    static String saveToDir;
    static int displayColor;
    static int displayColor2;
    static ArrayList<Struct> structList;
    static ArrayList<String> structName;
    public static ArrayList<String> logFileINFO;
    static Map<String, GArea> genAreaMap;
    static int gdsLayer;
    static int dataType;
    static int psFracElements;
    static double psPixelValue;
    static double gdsReso;
    static double shapeReso;
    static double fontOutline;
    static String gdsFile;
    static String currentStructName;
    static Struct top;
    static String pts2instStructName;
    static boolean pts2inst;
    static boolean logFileTimeDate;
    static String[] fontNames;
    @FXML
    private TextField tfFileName;
    @FXML
    private Label lScriptFileStatus;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    CNST Scripting Module", "The scripting module allows for reading in ASCII files and converting shape contents directly to GDS. Several options are included that are either not found or extremely difficult to implement within standard CAD packages that produce GDS files. Scripting allows full customization of device layouts with structural hierarchy, vertex control for individual shapes, and more than 400 parameterized shapes including an extensive nanophotonic and MEMS-NEMS libraries. In particular, the nanophotonic library contains a variety of microrings, S- and Y-bends based on Bezier curves, photonic crystals, tapers, spiral delay lines, grating couplers, and other complex structures. The MEMS-NEMS library includes a variety of actuators, gears, flexures, clamped beams, interacting arrays, and test and measurement structures. Since Toolbox scripts are created with text-based parametrized constructors, scripting complex GDSII structures does not require any programming knowledge.");
        try {
            CNSTdefaultParameters.getFileParameters();
            openDir = CNSTdefaultParameters.openDir;
            saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(CNSTscriptingController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) throws IOException, FileNotFoundException, ScriptException {
        if (file != null) {
            final Scanner input = new Scanner(new File(file.getPath()));
            final String[] tmp = null;
            Task<Void> task = new Task<Void>(){

                public Void call() throws InterruptedException, FileNotFoundException, IOException, ScriptException {
                    this.updateMessage("Status: Generating GDS ....");
                    Platform.runLater(() -> CNSTscriptingController.this.lStatus.setTextFill((Paint)Color.WHITE));
                    this.updateMessage("Saved to " + CNSTscriptingController.this.exportGDS(input, tmp));
                    Platform.runLater(() -> CNSTscriptingController.this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(displayColor)));
                    Platform.runLater(() -> {
                        displayColor = displayColor == 0 ? 1 : 0;
                    });
                    return null;
                }
            };
            this.lStatus.textProperty().bind((ObservableValue)task.messageProperty());
            Thread thread = new Thread((Runnable)task);
            thread.setDaemon(true);
            thread.start();
        } else {
            this.lStatus.setText("ERROR: Script File Missing");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(displayColor));
            displayColor = displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void loadScript(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - CNST Scripting Module");
        chooser.setInitialDirectory(new File(openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        this.lScriptFileStatus.setText("Script File: " + file.getPath());
        this.lScriptFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(displayColor2));
        displayColor2 = displayColor2 == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }

    public static void readData(Scanner input) throws FileNotFoundException, ScriptException {
        Path2D.Double p2dTemp = new Path2D.Double();
        ArrayList alP2dTemp = new ArrayList();
        while (input.hasNext()) {
            double lengthTop;
            double width;
            ArrayList<Double> al = new ArrayList<Double>();
            while (input.hasNextDouble()) {
                al.add(input.nextDouble());
            }
            String s = input.next();
            p2dTemp = CNSTscriptingController.parseData(al, s, p2dTemp);
            if (s.startsWith("#")) {
                input.nextLine();
                p2dTemp = new Path2D.Double();
            }
            if (s.startsWith("<<") && s.endsWith(">>")) {
                String temp = s.substring(2, s.length() - 2);
                if (CNSTscriptingController.structExists(s.substring(2, s.length() - 2))) {
                    pts2inst = true;
                    if (structName.indexOf(currentStructName) != structName.indexOf(s.substring(2, s.length() - 2))) {
                        pts2instStructName = s.substring(2, s.length() - 2);
                        pts2inst = true;
                    } else {
                        pts2inst = false;
                        CNSTscriptingController.selfReferencingError(s);
                    }
                } else {
                    pts2inst = false;
                    CNSTscriptingController.structureDoesNotExist(s, s.substring(2, s.length() - 2), "Point To Instance Arrays");
                }
            }
            if (s.startsWith("<")) {
                s = s + input.nextLine();
                CNSTscriptingController.parseStructElements(s);
                p2dTemp = new Path2D.Double();
            }
            if (s.startsWith("{")) {
                s = s + input.nextLine();
                CNSTscriptingController.parseStructElementsTAB(s);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("h")) {
                CNSTscriptingController.createStruct(p2dTemp, psFracElements);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("logFileTimeDate")) {
                logFileTimeDate = true;
            }
            if (s.equals("points2shape")) {
                CNSTscriptingController.createStruct(p2dTemp);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("points2instance")) {
                CNSTscriptingController.createPoints2Instance(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("closepath")) {
                CNSTscriptingController.createStruct(p2dTemp, psFracElements);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("layer")) {
                CNSTscriptingController.setGdsLayer(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("dataType")) {
                CNSTscriptingController.setDataType(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dataType")) {
                CNSTscriptingController.setDataType(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("shapeReso")) {
                CNSTscriptingController.setShapeReso(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("psPixelValue")) {
                CNSTscriptingController.setPixelValue(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("psFracElements")) {
                CNSTscriptingController.setFracElements(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("gdsReso")) {
                CNSTscriptingController.setGDSReso(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("fontOutline")) {
                CNSTscriptingController.setFontOutline(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("ellipse")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createEllipse(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4).intValue(), gdsLayer), al.get(0), al.get(1), al.get(5)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("arc")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createArc(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), gdsLayer), al.get(0), al.get(1), al.get(7)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("torus")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createTorus(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("torusW")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createTorusW(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("torusEllipseW")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createTorusEllipseW(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), gdsLayer), (double)al.get(8), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("torusEllipseFocusW")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createTorusEllipseFocusW(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), gdsLayer), (double)al.get(8), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("cross")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createCross(al.get(0), al.get(1), al.get(2), al.get(3), gdsLayer), al.get(0), al.get(1), al.get(4)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("Lshape")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createLshape(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5), gdsLayer), al.get(0), al.get(1), al.get(6)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("rectSUshape")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createRectangularSUshape(al.get(2), al.get(3), al.get(4), al.get(5)), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("rectangle")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createRectangle(al, gdsLayer), al.get(0), al.get(1), al.get(4)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("rectangleLH")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createRectangleLH(al, gdsLayer), al.get(0), al.get(1), al.get(4)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("rectangleC")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(PrimitiveShapes.createRectangleC(al, gdsLayer), al.get(0), al.get(1), al.get(4)));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("roundrect")) {
                CNSTscriptingController.createVectorShapes(al, s);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("roundrectC")) {
                CNSTscriptingController.createVectorShapes(al, s);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("ellipseVector")) {
                CNSTscriptingController.createVectorShapes(al, s);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("arcVector")) {
                CNSTscriptingController.createVectorShapes(al, s);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("torusVector")) {
                CNSTscriptingController.createVectorShapes(al, s);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("polypath")) {
                CNSTscriptingController.createPolyPath(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("polygon")) {
                CNSTscriptingController.createPolygon(al, "polygon");
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("star")) {
                CNSTscriptingController.createPolygon(al, "star");
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("circlethree")) {
                CNSTscriptingController.createCircleThree(al);
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralArch")) {
                CNSTscriptingController.createStruct(Spirals.spiralArchimedes(al.get(2), al.get(3).intValue(), al.get(4), al.get(5), gdsLayer), al.get(0), al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralFermat")) {
                CNSTscriptingController.createStruct(Spirals.spiralFermat(al.get(2), al.get(3).intValue(), al.get(4), al.get(5), gdsLayer), al.get(0), al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralLog")) {
                CNSTscriptingController.createStruct(Spirals.spiralLogarithmic(al.get(2), al.get(3).intValue(), al.get(4), al.get(5), al.get(6), gdsLayer), al.get(0), al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralDelayLineArch")) {
                CNSTscriptingController.createStruct(Spirals.archimedesSpiralDelayLine(al.get(0), al.get(1), al.get(2), al.get(3).intValue(), al.get(4), al.get(5), al.get(6), CNSTscriptingController.degreeToRadians(al.get(7)), al.get(8).intValue(), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralDelayLineArchInv")) {
                CNSTscriptingController.createStruct(Spirals.archimedesSpiralDelayLineINVERSE(al.get(0), al.get(1), al.get(2), al.get(2) + 2.0 * al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), CNSTscriptingController.degreeToRadians(al.get(8)), al.get(9).intValue(), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralDelayLineArchV2")) {
                CNSTscriptingController.createStruct(Spirals.archimedesSpiralDelayLineV2(al.get(2), al.get(3).intValue(), al.get(4), al.get(5).intValue(), al.get(6).intValue(), al.get(7), al.get(9).intValue(), gdsLayer), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                CNSTscriptingController.createStruct(Spirals.archimedesSpiralDelayLineV2(al.get(2), al.get(3).intValue(), al.get(4), al.get(5).intValue(), al.get(6).intValue(), al.get(7), al.get(9).intValue(), gdsLayer), CNSTscriptingController.degreeToRadians(al.get(8)) + Math.PI, (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralDelayLineArchV2Inv")) {
                ArrayList<GArea> archV2INVwg = Spirals.archimedesSpiralDelayLineInvV2(al.get(2), al.get(4).intValue(), al.get(5), al.get(6).intValue(), al.get(7).intValue(), 0.0, al.get(8), 0, gdsLayer);
                ArrayList<GArea> archV2INVsleeve = Spirals.archimedesSpiralDelayLineInvV2(al.get(2) + 2.0 * al.get(3), al.get(4).intValue(), al.get(5), al.get(6).intValue(), al.get(7).intValue(), al.get(3), al.get(8), al.get(10).intValue(), gdsLayer);
                CNSTscriptingController.createStruct(Spirals.archimedesV2FracturedDelayLineINVERSE(archV2INVwg, archV2INVsleeve, al.get(0), al.get(1), CNSTscriptingController.degreeToRadians(al.get(9)), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralDelayLineFermat")) {
                CNSTscriptingController.createStruct(Spirals.fermatSpiralDelayLine(al.get(0), al.get(1), al.get(2), al.get(3).intValue(), al.get(4), al.get(5), al.get(6), CNSTscriptingController.degreeToRadians(al.get(7)), al.get(8).intValue(), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralDelayLineFermatInv")) {
                CNSTscriptingController.createStruct(Spirals.fermatSpiralDelayLineINVERSE(al.get(0), al.get(1), al.get(2), al.get(2) + 2.0 * al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), CNSTscriptingController.degreeToRadians(al.get(8)), al.get(9).intValue(), gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("customTaper")) {
                CNSTscriptingController.createStruct(Photonics.createCustomTaper(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideInvPhC")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgInvPhC(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideInvPhCvary")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgInvPhCvary(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuidePhC")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgPhC(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuidePhCvary")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgPhCvary(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideInvRectPhC")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgInvRectPhC(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideInvRectPhCvary")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgInvRectPhCvary(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideRectPhC")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgRectPhC(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideRectPhCvary")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgRectPhCvary(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideRectFlushPhCvary")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgRectFlushPhC(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equals("waveGuideInvRectFlushPhCvary")) {
                CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWgInvRectFlushPhC(al, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("nistCnstLogo")) {
                CNSTscriptingController.createStruct(CNSTnistLogos.getNistCnstLogo(al.get(0), al.get(1), al.get(2), shapeReso, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cnstLogo")) {
                CNSTscriptingController.createStruct(CNSTnistLogos.getCnstLogo(al.get(0), al.get(1), al.get(2), shapeReso, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cnstEmblem")) {
                CNSTscriptingController.createStruct(CNSTnistLogos.getCNSTemblemLogo(al.get(0), al.get(1), al.get(2), shapeReso, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("nistLogo")) {
                CNSTscriptingController.createStruct(CNSTnistLogos.getNistLogo(al.get(0), al.get(1), al.get(2), shapeReso, gdsLayer));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayER")) {
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleLinearRECT(al.get(2), al.get(3), al.get(4).intValue()), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayENgon")) {
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleLinearNGON(al.get(2), al.get(3), al.get(4).intValue(), al.get(5).intValue()), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayUDR")) {
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleCustomRECT(al), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayUDNgon")) {
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleCustomNGON(al), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayERamp")) {
                boolean UP = al.get(5) == 1.0;
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleLinearRAMPupDown(al.get(2), al.get(3), al.get(4).intValue(), UP), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayERamp2")) {
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleLinearRAMP(al.get(2), al.get(3), al.get(4).intValue()), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayUDRamp")) {
                boolean UP = al.get(al.size() - 2) == 1.0;
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleCustomRAMPupDown(al, UP), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("grayUDRamp2")) {
                CNSTscriptingController.createStruct(Grayscale.createGrayScaleCustomRAMP(al), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("graySpiralStairOverlap")) {
                int numSegments = al.get(4).intValue();
                for (int segment2 = 0; segment2 < numSegments; ++segment2) {
                    CNSTscriptingController.createStruct(Grayscale.grayScaleOverlappingARCs(al.get(2), al.get(3), segment2, numSegments, al.get(5).intValue()), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                }
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("graySpiralStair")) {
                int numSegments = al.get(4).intValue();
                CNSTscriptingController.createStruct(Grayscale.grayScaleARCs(al.get(2), al.get(3), numSegments, al.get(5).intValue()), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("circleWave")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createCircleWave(al.get(2), al.get(3).intValue(), al.get(4), al.get(5).intValue()), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("torusWaveIn")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createTorusWaveIN(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6).intValue()), CNSTscriptingController.degreeToRadians(al.get(7)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("torusWaveOut")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createTorusWaveOUT(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6).intValue()), CNSTscriptingController.degreeToRadians(al.get(7)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverL")) {
                CNSTscriptingController.createStruct(MEMSbeams.createCantileverLinear(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverP")) {
                CNSTscriptingController.createStruct(MEMSbeams.createCantileverPercentage(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSine")) {
                CNSTscriptingController.createStruct(MEMSbeams.createCantileverSinusoid(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverLSE")) {
                CNSTscriptingController.createStruct(MEMSbeams.createCantileverLinearSE(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverNLSE")) {
                CNSTscriptingController.createStruct(MEMSbeams.createCantileverNonLinearSE(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverCustom")) {
                CNSTscriptingController.createStruct(MEMSbeams.createCantileverCustom(al), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSR")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverSRect(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue()), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSTri")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverSTriangle(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue()), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSTrap")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverSTrapezoid(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue()), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSPaddle")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverSPaddle(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSCH")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverSCurvedHalf(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), al.get(8).intValue()), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverSCF")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverSCurvedFull(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverHR")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverHRect(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue()), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverHTri")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverHTriangle(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverHTrap")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverHTrapezoid(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverHPaddle")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverHPaddle(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverHCH")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverHCurvedHalf(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverHCF")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverHCurvedFull(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverPB2")) {
                double gap = al.get(6);
                width = al.get(2);
                lengthTop = al.get(5);
                if (gap <= lengthTop - 2.0 * width) {
                    CNSTscriptingController.createStruct(MEMSbeams.createLeverPB2(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                    p2dTemp = new Path2D.Double();
                } else {
                    logFileINFO.add("ERROR: Gap of " + gap + " is too big inside the cantileverPB2 constructor.");
                }
            }
            if (s.equalsIgnoreCase("cantileverPB3")) {
                double gap = al.get(7);
                width = al.get(2);
                lengthTop = al.get(6);
                if (gap <= (lengthTop - 4.0 * width) / 2.0) {
                    CNSTscriptingController.createStruct(MEMSbeams.createLeverPB3(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                    p2dTemp = new Path2D.Double();
                } else {
                    logFileINFO.add("ERROR: Gap of " + gap + " is too big inside the cantileverPB3 constructor.");
                }
            }
            if (s.equalsIgnoreCase("cantileverUR")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverUR(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverUCF")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverUCF(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverUC")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverUC(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverUCC")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverUCC(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverUCP")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverUCP(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverCE")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverCE(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("cantileverCEPaddle")) {
                CNSTscriptingController.createStruct(MEMSbeams.createLeverCEPaddle(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue(), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("beamCurvedEnds") || s.equalsIgnoreCase("beamCurvedEndsC")) {
                boolean CENTERED = s.equalsIgnoreCase("beamCurvedEndsC");
                CNSTscriptingController.createStruct(MEMSbeams.createBeamCurvedEnds(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), CENTERED, false), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("beamCurvedEndsV") || s.equalsIgnoreCase("beamCurvedEndsCV")) {
                boolean CENTERED = s.equalsIgnoreCase("beamCurvedEndsCV");
                boolean VECTORIZED = true;
                CNSTscriptingController.createStruct(MEMSbeams.createBeamCurvedEnds(al.get(2), al.get(3), al.get(4), 0, CENTERED, VECTORIZED), CNSTscriptingController.degreeToRadians(al.get(5)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamL")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamLinear(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamP")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamPercentage(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamLSE")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamLinearSE(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamNLSE")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamNonLinearSE(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamCustom")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamCustom(al), CNSTscriptingController.degreeToRadians(al.get(al.size() - 1)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamR")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamR(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue()), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamCB")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamCoupledBeams(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamT")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamTorsional(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamT2")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamTorsional2(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13).intValue()), CNSTscriptingController.degreeToRadians(al.get(14)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("dcBeamC")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDcBeamC(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue(), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure4A")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges4A(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure4B")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges4B(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure4C")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges4C(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure4D")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges4D(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13).intValue()), CNSTscriptingController.degreeToRadians(al.get(14)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure4E")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges4E(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure2A")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges2A(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure2B")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges2B(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure2C")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges2C(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue(), al.get(10), al.get(11), al.get(12), al.get(13).intValue()), CNSTscriptingController.degreeToRadians(al.get(14)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure2D")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges2D(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("flexure2E")) {
                CNSTscriptingController.createStruct(MEMSflexureHinges.createFlexureHinges2E(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14), al.get(15), al.get(16).intValue()), CNSTscriptingController.degreeToRadians(al.get(17)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("bentBeam")) {
                CNSTscriptingController.createStruct(MEMSactuators.createBentBeam(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("bentBeamArray")) {
                CNSTscriptingController.createStruct(MEMSactuators.createBentBeamArray(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9).intValue(), al.get(10), al.get(11), al.get(12), al.get(13).intValue(), al.get(14), al.get(15), al.get(16).intValue()), CNSTscriptingController.degreeToRadians(al.get(17)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("straightSpring")) {
                CNSTscriptingController.createStruct(MEMSactuators.createStraightSpring(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7).intValue(), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("circularSpring")) {
                CNSTscriptingController.createStruct(MEMSactuators.createCircularSpring(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7).intValue(), al.get(8), al.get(9).intValue()), CNSTscriptingController.degreeToRadians(al.get(10)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("straightSpringE")) {
                CNSTscriptingController.createStruct(MEMSactuators.createStraightSpringElectrodes(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7).intValue(), al.get(8), al.get(9), al.get(10).intValue(), al.get(11), al.get(12), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("circularSpringE")) {
                CNSTscriptingController.createStruct(MEMSactuators.createCircularSpringElectrode(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7).intValue(), al.get(8), al.get(9), al.get(10).intValue(), al.get(11), al.get(12), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("GuckelRing")) {
                CNSTscriptingController.createStruct(MEMSbeams.createGuckelRing(al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10).intValue()), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("GuckelRingArray")) {
                CNSTscriptingController.createStruct(MEMSbeams.createGuckelRingArray(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("diamondRing")) {
                CNSTscriptingController.createStruct(MEMSbeams.createDiamondRing(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("biMorph")) {
                CNSTscriptingController.createStruct(MEMSactuators.createBiMorphThermal(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue(), al.get(13), al.get(14), al.get(15), al.get(16).intValue()), CNSTscriptingController.degreeToRadians(al.get(17)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring1A") || s.equalsIgnoreCase("foldedSpring2A")) {
                boolean FOLDEDSPRING2A = s.equalsIgnoreCase("foldedSpring2A");
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring1A2A(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10), al.get(11).intValue(), FOLDEDSPRING2A), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring1B") || s.equalsIgnoreCase("foldedSpring2B")) {
                boolean FOLDEDSPRING2B = s.equalsIgnoreCase("foldedSpring2B");
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring1B2B(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10), al.get(11).intValue(), FOLDEDSPRING2B), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2C")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2C(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2D")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2D(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2E")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2E(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8).intValue(), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2F")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2F(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8).intValue(), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2G")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2G(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8).intValue(), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2H")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2H(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8).intValue(), al.get(9), al.get(10), al.get(11), al.get(12).intValue()), CNSTscriptingController.degreeToRadians(al.get(13)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2I")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2I(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8).intValue(), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("foldedSpring2J")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFoldedSpring2J(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8).intValue(), al.get(9), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("intElec1")) {
                CNSTscriptingController.createStruct(MISCobjects.createInteElectrodesV1(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10)), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("intElec2")) {
                CNSTscriptingController.createStruct(MISCobjects.createInteElectrodesV2(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10)), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("intElec3")) {
                CNSTscriptingController.createStruct(MISCobjects.createInteElectrodesV3(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10)), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("intElec4")) {
                CNSTscriptingController.createStruct(MISCobjects.createInteElectrodesV4(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10)), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("intElec5")) {
                CNSTscriptingController.createStruct(MISCobjects.createInteElectrodesV5(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10)), CNSTscriptingController.degreeToRadians(al.get(11)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("combDriveV1")) {
                CNSTscriptingController.createStruct(MEMSactuators.createCombDriveV1(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7), al.get(8), al.get(9).intValue(), al.get(10), al.get(11).intValue()), CNSTscriptingController.degreeToRadians(al.get(12)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("linearDriveV1")) {
                CNSTscriptingController.createStruct(MEMSactuators.createLinearDriveV1(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue(), al.get(13), al.get(14).intValue()), CNSTscriptingController.degreeToRadians(al.get(15)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MARC")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRTElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(4), al.get(5), al.get(6), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue(), al.get(15).intValue(), al.get(16).intValue(), al.get(17).intValue(), true), CNSTscriptingController.degreeToRadians(al.get(18)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MAR3")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRTElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(4), al.get(5), al.get(6), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue(), al.get(15).intValue(), al.get(16).intValue(), al.get(17).intValue(), false), CNSTscriptingController.degreeToRadians(al.get(18)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MAR2")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRT2CoupledBeams(al.get(2).intValue(), al.get(3), al.get(4), al.get(4), al.get(5), al.get(6), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14), al.get(15).intValue(), al.get(16).intValue(), al.get(17).intValue(), al.get(18).intValue()), CNSTscriptingController.degreeToRadians(al.get(19)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MATC")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRTElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14), al.get(15), al.get(16).intValue(), al.get(17).intValue(), al.get(18).intValue(), al.get(19).intValue(), true), CNSTscriptingController.degreeToRadians(al.get(20)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MAT3")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRTElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14), al.get(15), al.get(16).intValue(), al.get(17).intValue(), al.get(18).intValue(), al.get(19).intValue(), false), CNSTscriptingController.degreeToRadians(al.get(20)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MAT2")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRT2CoupledBeams(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14), al.get(15), al.get(16), al.get(17).intValue(), al.get(18).intValue(), al.get(19).intValue(), al.get(20).intValue()), CNSTscriptingController.degreeToRadians(al.get(21)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MARA")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRectElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14).intValue(), al.get(15).intValue(), al.get(16).intValue(), al.get(17).intValue()), CNSTscriptingController.degreeToRadians(al.get(18)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MATALW")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createTrapElectrodesCONST(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13).intValue(), al.get(14).intValue(), al.get(15).intValue(), al.get(16).intValue()), CNSTscriptingController.degreeToRadians(al.get(17)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MATA")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createTrapElectrodesVLW(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13), al.get(14), al.get(15), al.get(16).intValue(), al.get(17).intValue(), al.get(18).intValue(), al.get(19).intValue()), CNSTscriptingController.degreeToRadians(al.get(20)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MARACURVE")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRectVaryingElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13).intValue(), al.get(14).intValue(), al.get(15).intValue(), al.get(16).intValue(), false), CNSTscriptingController.degreeToRadians(al.get(17)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("MARALINEAR")) {
                CNSTscriptingController.createStruct(MEMScoupledArrays.createRectVaryingElectrode(al.get(2).intValue(), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13).intValue(), al.get(14).intValue(), al.get(15).intValue(), al.get(16).intValue(), true), CNSTscriptingController.degreeToRadians(al.get(17)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("spiralRect")) {
                CNSTscriptingController.createStruct(MISCobjects.createRectangularSpiral(al.get(2), al.get(3), al.get(4), al.get(5).intValue()), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("combRadialV1")) {
                CNSTscriptingController.createStruct(MEMSactuators.createRadialCombDriveV1(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue(), al.get(9).intValue(), al.get(10), al.get(11), al.get(12), al.get(13).intValue()), CNSTscriptingController.degreeToRadians(al.get(14)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("combRadialV2")) {
                CNSTscriptingController.createStruct(MEMSactuators.createRadialCombDriveV2(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8).intValue(), al.get(9).intValue(), al.get(10), al.get(11), al.get(12), al.get(13).intValue()), CNSTscriptingController.degreeToRadians(al.get(14)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("bolometerL")) {
                CNSTscriptingController.createStruct(MEMSactuators.createBolometerL(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue(), al.get(13), al.get(14), al.get(15), al.get(16), al.get(17), al.get(18), al.get(19).intValue(), al.get(20).intValue(), al.get(21).intValue(), al.get(22).intValue(), al.get(23).intValue(), al.get(24).intValue()), CNSTscriptingController.degreeToRadians(al.get(25)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("bolometerU")) {
                CNSTscriptingController.createStruct(MEMSactuators.createBolometerU(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12).intValue(), al.get(13), al.get(14), al.get(15), al.get(16), al.get(17), al.get(18), al.get(19).intValue(), al.get(20).intValue(), al.get(21).intValue(), al.get(22).intValue(), al.get(23).intValue(), al.get(24).intValue()), CNSTscriptingController.degreeToRadians(al.get(25)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("fluidCell")) {
                CNSTscriptingController.createStruct(MEMSactuators.createFluidCell(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), al.get(13).intValue(), al.get(14), al.get(15), al.get(16), al.get(17), al.get(18), al.get(19), al.get(20), al.get(21), al.get(22), al.get(23).intValue(), al.get(24).intValue(), al.get(25).intValue(), al.get(26).intValue(), al.get(27).intValue(), al.get(28).intValue()), CNSTscriptingController.degreeToRadians(al.get(29)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("gear")) {
                CNSTscriptingController.createStruct(MEMSactuators.createGear(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), 0.0, al.get(6).intValue()), CNSTscriptingController.degreeToRadians(al.get(7)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("gearT")) {
                CNSTscriptingController.createStruct(MEMSactuators.createGear(al.get(2), al.get(3), al.get(4), al.get(5).intValue(), al.get(6), al.get(7).intValue()), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("resoPattern")) {
                CNSTscriptingController.createStruct(MISCobjects.createResoTestPatterns(al.get(2), al.get(3), 0, false), CNSTscriptingController.degreeToRadians(al.get(4)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("resoPatternPi")) {
                CNSTscriptingController.createStruct(MISCobjects.createResoTestPatterns(al.get(2), 0.0, al.get(3).intValue(), true), CNSTscriptingController.degreeToRadians(al.get(4)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("resoPatternRS")) {
                CNSTscriptingController.createStruct(MISCobjects.createResoPatternRS(al.get(2), al.get(3), al.get(4).intValue()), CNSTscriptingController.degreeToRadians(al.get(5)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("resoPatternRSA")) {
                CNSTscriptingController.createStruct(MISCobjects.createResoPatternRSA(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7)), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("resoPatternLS")) {
                CNSTscriptingController.createStruct(MISCobjects.createResoPatternLS(al.get(2), al.get(3), al.get(4).intValue()), CNSTscriptingController.degreeToRadians(al.get(5)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("resoPatternLSA")) {
                CNSTscriptingController.createStruct(MISCobjects.createResoPatternLSA(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6).intValue(), al.get(7)), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("tJunction")) {
                CNSTscriptingController.createStruct(MISCobjects.createTjunction(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue()), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("hJunction")) {
                CNSTscriptingController.createStruct(MISCobjects.createHjunction(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue()), CNSTscriptingController.degreeToRadians(al.get(8)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("arrowJunction")) {
                CNSTscriptingController.createStruct(MISCobjects.createArrowJunction(al.get(2), al.get(3), al.get(4), al.get(5), al.get(6), al.get(7).intValue(), al.get(8)), CNSTscriptingController.degreeToRadians(al.get(9)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (s.equalsIgnoreCase("rectTaper")) {
                CNSTscriptingController.createStruct(MISCobjects.createRectangleTaper(al.get(2), al.get(3), al.get(4), al.get(5)), CNSTscriptingController.degreeToRadians(al.get(6)), (double)al.get(0), (double)al.get(1));
                p2dTemp = new Path2D.Double();
            }
            if (!s.equalsIgnoreCase("curvedBeamsNEMS")) continue;
            boolean withElectrode = al.get(13).intValue() != 0;
            CurvedBeamsNEMS.createCurvedBeamNEMS(structList.get(structName.indexOf(currentStructName)), al.get(0), al.get(1), al.get(2), al.get(3), al.get(4).intValue(), al.get(5), al.get(6), al.get(7), al.get(8), al.get(9), al.get(10), al.get(11), al.get(12), withElectrode, gdsLayer);
            p2dTemp = new Path2D.Double();
        }
    }

    public static Path2D.Double parseData(ArrayList<Double> al, String s, Path2D.Double p2d) {
        switch (s) {
            case "points2shape": {
                return CNSTscriptingController.mergePoints(al, p2d);
            }
            case "m": {
                p2d.moveTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "l": {
                p2d.lineTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "c": {
                p2d.curveTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)), CNSTscriptingController.rescalePSimage(al.get(2)), CNSTscriptingController.rescalePSimage(al.get(3)), CNSTscriptingController.rescalePSimage(al.get(4)), CNSTscriptingController.rescalePSimage(al.get(5)));
                return p2d;
            }
            case "q": {
                p2d.quadTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)), CNSTscriptingController.rescalePSimage(al.get(2)), CNSTscriptingController.rescalePSimage(al.get(3)));
                return p2d;
            }
            case "h": {
                p2d.closePath();
                return p2d;
            }
            case "moveto": {
                p2d.moveTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "lineto": {
                p2d.lineTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "curveto": {
                p2d.curveTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)), CNSTscriptingController.rescalePSimage(al.get(2)), CNSTscriptingController.rescalePSimage(al.get(3)), CNSTscriptingController.rescalePSimage(al.get(4)), CNSTscriptingController.rescalePSimage(al.get(5)));
                return p2d;
            }
            case "quadto": {
                p2d.quadTo(CNSTscriptingController.rescalePSimage(al.get(0)), CNSTscriptingController.rescalePSimage(al.get(1)), CNSTscriptingController.rescalePSimage(al.get(2)), CNSTscriptingController.rescalePSimage(al.get(3)));
                return p2d;
            }
            case "closepath": {
                p2d.closePath();
                return p2d;
            }
            case "layer": {
                return p2d;
            }
            case "shapeReso": {
                return p2d;
            }
            case "psPixelValue": {
                return p2d;
            }
            case "gdsReso": {
                return p2d;
            }
            case "fontOutline": {
                return p2d;
            }
            case "points2instance": {
                return p2d;
            }
            case "ellipse": {
                return p2d;
            }
            case "arc": {
                return p2d;
            }
            case "torus": {
                return p2d;
            }
            case "cross": {
                return p2d;
            }
            case "Lshape": {
                return p2d;
            }
            case "rectangle": {
                return p2d;
            }
            case "rectangleLH": {
                return p2d;
            }
            case "rectangleC": {
                return p2d;
            }
            case "roundrect": {
                return p2d;
            }
            case "ellipseVector": {
                return p2d;
            }
            case "arcVector": {
                return p2d;
            }
            case "polypath": {
                return p2d;
            }
            case "polygon": {
                return p2d;
            }
            case "star": {
                return p2d;
            }
            case "circlethree": {
                return p2d;
            }
            case "spiralarch": {
                return p2d;
            }
            case "spiralfermat": {
                return p2d;
            }
            case "spirallog": {
                return p2d;
            }
            case "customTaper": {
                return p2d;
            }
            case "waveGuideInvPhC": {
                return p2d;
            }
            case "waveGuideInvPhCvary": {
                return p2d;
            }
            case "waveGuidePhC": {
                return p2d;
            }
            case "waveGuidePhCvary": {
                return p2d;
            }
            case "waveGuideInvRectPhC": {
                return p2d;
            }
            case "waveGuideInvRectPhCvary": {
                return p2d;
            }
            case "waveGuideRectPhC": {
                return p2d;
            }
            case "waveGuideRectPhCvary": {
                return p2d;
            }
            case "waveGuideRectFlushPhCvary": {
                return p2d;
            }
            case "waveGuideInvRectFlushPhCvary": {
                return p2d;
            }
            case "nistCnstLogo": {
                return p2d;
            }
            case "cnstLogo": {
                return p2d;
            }
            case "cnstEmblem": {
                return p2d;
            }
            case "nistLogo": {
                return p2d;
            }
            case "curvedBeamsNEMS": {
                return p2d;
            }
        }
        return p2d;
    }

    public static void parseStructElementsTAB(String s) {
        String tmp = s.substring(1, s.length() - 1);
        String REGEX = "\\t+";
        Pattern p = Pattern.compile(REGEX);
        String[] sArr = p.split(tmp);
        if (sArr[sArr.length - 1].equalsIgnoreCase("labelMaker") || sArr[sArr.length - 1].equalsIgnoreCase("labelOutline")) {
            LabelMaker.parseLabel(sArr, s, structList.get(structName.indexOf(currentStructName)));
        }
    }

    /*
     * Opcode count of 27842 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void parseStructElements(String s) throws ScriptException, FileNotFoundException {
        String temp;
        int alignStandardLength;
        int arrowLength;
        int fractalLength;
        int gcWG;
        String[] sText;
        String[] textParameters;
        String fontName;
        boolean layerExists;
        boolean b;
        String tmp = s.substring(1, s.length() - 1);
        String REGEX = "\\s+";
        Pattern p = Pattern.compile(REGEX);
        String[] sArr = p.split(tmp);
        if (sArr[sArr.length - 1].equalsIgnoreCase("struct") && (b = CNSTscriptingController.lineError(sArr, 2, s))) {
            sArr[0] = sArr[0].length() < 32 ? sArr[0] : sArr[0].substring(0, 32);
            CNSTscriptingController.setStructName(sArr[0]);
            if (!CNSTscriptingController.structExists(sArr[0])) {
                structName.add(currentStructName);
                structList.add(new Struct(currentStructName));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("fileName")) {
            File f;
            boolean fileExists;
            b = CNSTscriptingController.lineError(sArr, 2, s);
            if (b & (fileExists = (f = new File(openDir + sArr[0] + ".cnst")).exists())) {
                Scanner inFile = new Scanner(f);
                CNSTscriptingController.readData(inFile);
            } else {
                String scriptFileError = "******** CNST script file: " + openDir + sArr[0] + ".cnst does NOT exist. Line " + s;
                logFileINFO.add(scriptFileError);
                System.out.println("scriptFileDoesNotExist Error::\t" + scriptFileError);
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("genArea")) {
            b = CNSTscriptingController.lineError(sArr, 4, s);
            int lyr = Integer.parseInt(sArr[2]);
            boolean bl = layerExists = lyr >= 0 && lyr <= 255;
            if (!layerExists) {
                CNSTscriptingController.layerDoesNotExist(s, sArr[2], "genArea");
            }
            if (b & layerExists) {
                if (CNSTscriptingController.structExists(sArr[1])) {
                    Area a = new Area(structList.get(structName.indexOf(sArr[1])).getArea(lyr));
                    GArea generalArea = new GArea(a, lyr);
                    genAreaMap.put(sArr[0], generalArea);
                } else {
                    CNSTscriptingController.structureDoesNotExist(s, sArr[1], "genArea");
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("and") || sArr[sArr.length - 1].equalsIgnoreCase("or") || sArr[sArr.length - 1].equalsIgnoreCase("subtract") || sArr[sArr.length - 1].equalsIgnoreCase("xor")) {
            b = CNSTscriptingController.lineError(sArr, 4, s);
            int resultLayer = Integer.parseInt(sArr[2]);
            boolean bl = layerExists = resultLayer >= 0 && resultLayer <= 255;
            if (!layerExists) {
                CNSTscriptingController.layerDoesNotExist(s, sArr[2], "BOOLEAN " + sArr[sArr.length - 1].toUpperCase());
            }
            if (b & layerExists) {
                if (genAreaMap.containsKey(sArr[0]) && genAreaMap.containsKey(sArr[1])) {
                    GArea g1 = new GArea(genAreaMap.get(sArr[0]));
                    GArea g2 = new GArea(genAreaMap.get(sArr[1]));
                    CNSTscriptingController.doBOOLEANS(g1, g2, resultLayer, sArr[sArr.length - 1]);
                } else {
                    boolean g1Exists = genAreaMap.containsKey(sArr[0]);
                    boolean g2Exists = genAreaMap.containsKey(sArr[1]);
                    String genAreaExists = g1Exists && g2Exists ? sArr[0] + " and " + sArr[1] : (g1Exists ? sArr[0] : sArr[1]);
                    String plural = g1Exists && g2Exists ? "Areas" : "Area";
                    String plural2 = g1Exists && g2Exists ? "do" : "does";
                    s = "****ERROR General " + plural + " " + genAreaExists + " for the boolean operations " + plural2 + " not exist in line \t" + s;
                    logFileINFO.add(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("genAreaCopy") || sArr[sArr.length - 1].equalsIgnoreCase("genAreaCopyC")) {
            b = CNSTscriptingController.lineError(sArr, 9, s);
            int resultLayer = Integer.parseInt(sArr[7]);
            layerExists = resultLayer >= 0 && resultLayer <= 255;
            boolean CENTERING = sArr[sArr.length - 1].equalsIgnoreCase("genAreaCopyC");
            if (!layerExists) {
                CNSTscriptingController.layerDoesNotExist(s, sArr[2], "GENERAL AREA AFFINE TRANSFORMS " + sArr[sArr.length - 1].toUpperCase());
            }
            if (b & layerExists) {
                if (genAreaMap.containsKey(sArr[0])) {
                    GArea g1 = new GArea(genAreaMap.get(sArr[0]));
                    CNSTscriptingController.copyGenAreaCenter(g1, Double.parseDouble(sArr[1]), Integer.parseInt(sArr[2]), sArr[3], Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), CENTERING);
                } else {
                    s = "****ERROR General Area " + sArr[0] + " for the general area affine transformations does not exist in line \t" + s;
                    logFileINFO.add(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("arrayRect") && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            if (CNSTscriptingController.structExists(sArr[0])) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    CNSTscriptingArrays.rectangularArray(sArr, structList.get(structName.indexOf(currentStructName)), structList.get(structName.indexOf(sArr[0])));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            } else {
                CNSTscriptingController.structureDoesNotExist(s, sArr[0], "Rectangular Array");
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("arrayHex") && (b = CNSTscriptingController.lineError(sArr, 7, s))) {
            if (CNSTscriptingController.structExists(sArr[0])) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    CNSTscriptingArrays.hexagonalArray(sArr, structList.get(structName.indexOf(currentStructName)), structList.get(structName.indexOf(sArr[0])));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            } else {
                CNSTscriptingController.structureDoesNotExist(s, sArr[0], "Hexagonal Array");
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("arrayPolar") && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            if (CNSTscriptingController.structExists(sArr[0])) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    CNSTscriptingArrays.polarArray(sArr, structList.get(structName.indexOf(currentStructName)), structList.get(structName.indexOf(sArr[0])));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            } else {
                CNSTscriptingController.structureDoesNotExist(s, sArr[0], "Polar Array");
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("instance") && (b = CNSTscriptingController.lineError(sArr, 7, s))) {
            if (CNSTscriptingController.structExists(sArr[0])) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    CNSTscriptingArrays.createInstance(sArr, structList.get(structName.indexOf(currentStructName)), structList.get(structName.indexOf(sArr[0])));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            } else {
                CNSTscriptingController.structureDoesNotExist(s, sArr[0], "Instance-Reference");
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("instanceSym") && (b = CNSTscriptingController.lineError(sArr, 11, s))) {
            if (CNSTscriptingController.structExists(sArr[0])) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    CNSTscriptingArrays.createInstanceSymmetric(sArr, structList.get(structName.indexOf(currentStructName)), structList.get(structName.indexOf(sArr[0])));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            } else {
                CNSTscriptingController.structureDoesNotExist(s, sArr[0], "Instance-Reference");
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("functionXY") || sArr[sArr.length - 1].equalsIgnoreCase("functionRT")) {
            boolean fXY = sArr[sArr.length - 1].equalsIgnoreCase("functionXY");
            String[] sText2 = s.split("}}");
            String functionString = sText2[0].substring(3, sText2[0].length());
            String[] textParameters2 = p.split(sText2[1].replaceAll("^\\s+", ""));
            b = CNSTscriptingController.lineError(textParameters2, 10, s);
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(textParameters2[0])) {
                    CNSTscriptingController.createStruct(FunctionPlot.createFunctionPlot(fXY, functionString, textParameters2), CNSTscriptingController.degreeToRadians(Double.parseDouble(textParameters2[8])), Double.parseDouble(textParameters2[0]), Double.parseDouble(textParameters2[1]));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("textgds") || sArr[sArr.length - 1].equalsIgnoreCase("textgdsC")) {
            boolean centered = sArr[sArr.length - 1].equalsIgnoreCase("textgdsC");
            String[] sText3 = s.split("}}");
            String textString = sText3[0].substring(3, sText3[0].length());
            String[] fontTemp = sText3[1].split("\\{\\{");
            fontName = fontTemp[1];
            textParameters = p.split(sText3[2].replaceAll("^\\s+", ""));
            b = CNSTscriptingController.lineError(textParameters, 4, s);
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(textParameters[0])) {
                    CNSTscriptingController.createStruct(CNSTscriptingArrays.createText(textString, fontName, textParameters, gdsLayer, centered));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("textOutline") || sArr[sArr.length - 1].equalsIgnoreCase("textOutlineC")) {
            boolean CENTERED = sArr[sArr.length - 1].equalsIgnoreCase("textOutlineC");
            String[] sText4 = s.split("}}");
            String textString = sText4[0].substring(3, sText4[0].length());
            String[] fontTemp = sText4[1].split("\\{\\{");
            fontName = fontTemp[1];
            if (!Arrays.asList(fontNames).contains(fontName)) {
                String fontError = "FONT NAME '" + fontName + "' does NOT exist!!";
                if (!Arrays.asList(fontNames).contains("Serif")) {
                    fontName = fontNames[0];
                    fontError = fontError + " '" + fontName + "' is used and may not be a vector font!!";
                } else {
                    fontName = "Serif";
                    fontError = fontError + " '" + fontName + "' is used instead!!";
                }
                logFileINFO.add(fontError);
            }
            if (b = CNSTscriptingController.lineError(textParameters = p.split(sText4[2].replaceAll("^\\s+", "")), 4, s)) {
                if (structName.indexOf(currentStructName) != structName.indexOf(textParameters[0])) {
                    CNSTscriptingController.createStruct(TextOutline.textOutline(textString, fontName, Double.parseDouble(textParameters[0]), Double.parseDouble(textParameters[1]), Double.parseDouble(textParameters[2]), shapeReso, gdsLayer, CENTERED));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("cnstASML")) {
            sText = s.split("}}");
            String labelString = sText[0].substring(3, sText[0].length());
            String[] barCodeTemp = sText[1].split("\\{\\{");
            String barCodeName = barCodeTemp[1];
            String[] textParameters3 = p.split(sText[2].replaceAll("^\\s+", ""));
            b = CNSTscriptingController.lineError(textParameters3, 2, s);
            if (b) {
                boolean MIRRORING = Integer.parseInt(textParameters3[0]) != 0;
                CNSTscriptingController.createStruct(CNSTreticleFrames.createReticleFrame(0, barCodeName, labelString, "Serif", CNSTscriptingController.getGdsLayer()), MIRRORING);
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("cnstContact5") || sArr[sArr.length - 1].equalsIgnoreCase("cnstContact7")) {
            sText = s.split("}}");
            String labelString = sText[0].substring(3, sText[0].length());
            int contactTool = sArr[sArr.length - 1].equalsIgnoreCase("cnstContact5") ? 1 : 2;
            String[] textParameters4 = p.split(sText[1].replaceAll("^\\s+", ""));
            b = CNSTscriptingController.lineError(textParameters4, 2, s);
            if (b) {
                boolean MIRRORING = Integer.parseInt(textParameters4[0]) != 0;
                CNSTscriptingController.createStruct(CNSTreticleFrames.createReticleFrame(contactTool, "", labelString, "Serif", CNSTscriptingController.getGdsLayer()), MIRRORING);
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("verniers") && (b = CNSTscriptingController.lineError(sArr, 13, s))) {
            CNSTscriptingController.createStruct(Verniers.createVerniers(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), sArr[6], sArr[7], Double.parseDouble(sArr[8]), shapeReso, Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("grating") && (b = CNSTscriptingController.lineError(sArr, 8, s))) {
            if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                PrimitiveShapes.createGratings(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), gdsLayer);
            } else {
                CNSTscriptingController.selfReferencingError(s);
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("phC") || sArr[sArr.length - 1].equalsIgnoreCase("phCV") || sArr[sArr.length - 1].equalsIgnoreCase("hex") || sArr[sArr.length - 1].equalsIgnoreCase("hexV")) {
            boolean ISVECTOR;
            int numSides;
            b = sArr[sArr.length - 1].equalsIgnoreCase("phCV") || sArr[sArr.length - 1].equalsIgnoreCase("hex") ? CNSTscriptingController.lineError(sArr, 9, s) : (sArr[sArr.length - 1].equalsIgnoreCase("phC") ? CNSTscriptingController.lineError(sArr, 10, s) : CNSTscriptingController.lineError(sArr, 8, s));
            int n = numSides = sArr[sArr.length - 1].equalsIgnoreCase("phCV") || sArr[sArr.length - 1].equalsIgnoreCase("hexV") ? 0 : Integer.parseInt(sArr[7]);
            double delta = sArr[sArr.length - 1].equalsIgnoreCase("hex") || sArr[sArr.length - 1].equalsIgnoreCase("hexV") ? 0.0 : (sArr[sArr.length - 1].equalsIgnoreCase("phC") ? Double.parseDouble(sArr[8]) : Double.parseDouble(sArr[7]));
            boolean DOUBLEARRAY = sArr[sArr.length - 1].equalsIgnoreCase("phC") || sArr[sArr.length - 1].equalsIgnoreCase("phCV");
            boolean bl = ISVECTOR = sArr[sArr.length - 1].equalsIgnoreCase("phCV") || sArr[sArr.length - 1].equalsIgnoreCase("hexV");
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    PrimitiveShapes.createPhC(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Integer.parseInt(sArr[6]), numSides, delta, DOUBLEARRAY, ISVECTOR);
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("sqrPillar") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHole") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC")) {
            double THETA;
            b = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 12, s);
            boolean ISVECTOR = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC");
            boolean ISPILLAR = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillar") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC");
            boolean ISHEX = false;
            boolean ISCENTERED = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC");
            int numSides = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? 0 : Integer.parseInt(sArr[5]);
            double pitchX = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? Double.parseDouble(sArr[5]) : Double.parseDouble(sArr[6]);
            double pitchY = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? Double.parseDouble(sArr[6]) : Double.parseDouble(sArr[7]);
            int elementsX = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? Integer.parseInt(sArr[7]) : Integer.parseInt(sArr[8]);
            int elementsY = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? Integer.parseInt(sArr[8]) : Integer.parseInt(sArr[9]);
            double d = THETA = sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("sqrPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("sqrHoleVC") ? Double.parseDouble(sArr[9]) : Double.parseDouble(sArr[10]);
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    PrimitiveShapes.createPillarHoleArray(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), numSides, pitchX, pitchY, elementsX, elementsY, THETA, ISVECTOR, ISPILLAR, ISHEX, ISCENTERED);
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("hexPillar") || sArr[sArr.length - 1].equalsIgnoreCase("hexHole") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleC") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC")) {
            double THETA;
            b = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC") ? CNSTscriptingController.lineError(sArr, 10, s) : CNSTscriptingController.lineError(sArr, 11, s);
            boolean ISVECTOR = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC");
            boolean ISPILLAR = sArr[sArr.length - 1].equalsIgnoreCase("hexPillar") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarC") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC");
            boolean ISHEX = true;
            boolean ISCENTERED = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleC") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC");
            int numSides = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC") ? 0 : Integer.parseInt(sArr[5]);
            double pitchX = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC") ? Double.parseDouble(sArr[5]) : Double.parseDouble(sArr[6]);
            int elementsX = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC") ? Integer.parseInt(sArr[6]) : Integer.parseInt(sArr[7]);
            int elementsY = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC") ? Integer.parseInt(sArr[7]) : Integer.parseInt(sArr[8]);
            double d = THETA = sArr[sArr.length - 1].equalsIgnoreCase("hexPillarV") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleV") || sArr[sArr.length - 1].equalsIgnoreCase("hexPillarVC") || sArr[sArr.length - 1].equalsIgnoreCase("hexHoleVC") ? Double.parseDouble(sArr[8]) : Double.parseDouble(sArr[9]);
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    PrimitiveShapes.createPillarHoleArray(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), numSides, pitchX, 0.0, elementsX, elementsY, THETA, ISVECTOR, ISPILLAR, ISHEX, ISCENTERED);
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("gratingCoupler") && (b = CNSTscriptingController.lineError(sArr, 10, s))) {
            for (int i = 0; i < Integer.parseInt(sArr[8]); ++i) {
                structList.get(structName.indexOf(currentStructName)).add(PrimitiveShapes.createTorusW(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]) + (double)i * Double.parseDouble(sArr[4]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), gdsLayer));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("apodizedGrating") && (b = CNSTscriptingController.lineError(sArr, 17, s))) {
            CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createApodizedGrating(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14])), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("gratingCWG") || sArr[sArr.length - 1].equalsIgnoreCase("gratingCWGinv")) && (b = CNSTscriptingController.lineError(sArr, gcWG = sArr[sArr.length - 1].equalsIgnoreCase("gratingCWG") ? 19 : 20, s))) {
            boolean ENDCAP = sArr[sArr.length - 3].equalsIgnoreCase("1");
            if (sArr[sArr.length - 1].equalsIgnoreCase("gratingCWG")) {
                CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createGratingCouplerWaveguideEC(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), 0.0, Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Integer.parseInt(sArr[12]), Integer.parseInt(sArr[13]), Integer.parseInt(sArr[14]), Integer.parseInt(sArr[15]), false, ENDCAP), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[17])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("gratingCWGinv")) {
                CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createGratingCouplerWaveguideEC(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Integer.parseInt(sArr[13]), Integer.parseInt(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), true, ENDCAP), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[18])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("sierpinskiTriangle") || sArr[sArr.length - 1].equalsIgnoreCase("sierpinskiCarpet") || sArr[sArr.length - 1].equalsIgnoreCase("vicsekSaltire") || sArr[sArr.length - 1].equalsIgnoreCase("vicsekCross") || sArr[sArr.length - 1].equalsIgnoreCase("curvedTree")) && (b = CNSTscriptingController.lineError(sArr, fractalLength = sArr[sArr.length - 1].equalsIgnoreCase("curvedTree") ? 7 : 6, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("sierpinskiTriangle")) {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.createSierpinskiTriangle(Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), gdsLayer, sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("sierpinskiCarpet")) {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.createSierpinskiCarpet(Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), gdsLayer, sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("vicsekSaltire")) {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.createVicsekSaltire(Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), gdsLayer, sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("vicsekCross")) {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.createVicsekCross(Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), gdsLayer, sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("curvedTree")) {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.createCurvedTree(sArr[0], Double.parseDouble(sArr[5]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[3]), gdsLayer), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            }
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("treeV1") || sArr[sArr.length - 1].equalsIgnoreCase("treeV2")) && (b = CNSTscriptingController.lineError(sArr, fractalLength = sArr[sArr.length - 1].equalsIgnoreCase("treeV1") ? 5 : 8, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("treeV1")) {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.createAnotherTree(sArr[0], Integer.parseInt(sArr[3]), gdsLayer), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            } else {
                structList.get(structName.indexOf(currentStructName)).add(new Ref(Fractals.tree(Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), sArr[0], gdsLayer), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2])));
            }
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("arrowHead") || sArr[sArr.length - 1].equalsIgnoreCase("arrow") || sArr[sArr.length - 1].equalsIgnoreCase("arrowArray")) && (b = CNSTscriptingController.lineError(sArr, arrowLength = sArr[sArr.length - 1].equalsIgnoreCase("arrowHead") ? 7 : (sArr[sArr.length - 1].equalsIgnoreCase("arrow") ? 8 : 9), s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("arrowHead")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createArrowHead(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[5])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("arrow")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createArrow(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[6])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("arrowArray")) {
                CNSTscriptingController.createStruct(PrimitiveShapes.createArrowLinearArray(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[7])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("alignFFFB1") || sArr[sArr.length - 1].equalsIgnoreCase("alignFFFB2") || sArr[sArr.length - 1].equalsIgnoreCase("align3Level") || sArr[sArr.length - 1].equalsIgnoreCase("alignVern") || sArr[sArr.length - 1].equalsIgnoreCase("alignVernLb1") || sArr[sArr.length - 1].equalsIgnoreCase("alignVernLb2")) {
            String temp2 = sArr[sArr.length - 1];
            int alignStandardLength2 = 0;
            if (temp2.equalsIgnoreCase("alignFFFB1") || temp2.equalsIgnoreCase("alignFFFB2")) {
                alignStandardLength2 = 6;
            }
            if (temp2.equalsIgnoreCase("align3Level") || temp2.equalsIgnoreCase("alignVernLb1") || temp2.equalsIgnoreCase("alignVernLb2")) {
                alignStandardLength2 = 7;
            }
            if (temp2.equalsIgnoreCase("alignVern")) {
                alignStandardLength2 = 11;
            }
            if (b = CNSTscriptingController.lineError(sArr, alignStandardLength2, s)) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignFFFB1")) {
                    CNSTscriptingController.createStruct(AlignmentMarks.createAlignFFFB1(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[4])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignFFFB2")) {
                    CNSTscriptingController.createStruct(AlignmentMarks.createAlignFFFB2(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[4])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("align3Level")) {
                    CNSTscriptingController.createStruct(AlignmentMarks.createAlign3Level(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3]), Integer.parseInt(sArr[4])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[5])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignVernLb1")) {
                    CNSTscriptingController.createStruct(AlignmentMarks.createAlignVernLb1(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[5])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignVernLb2")) {
                    CNSTscriptingController.createStruct(AlignmentMarks.createAlignVernLb2(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[5])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignVern")) {
                    boolean invA = Integer.parseInt(sArr[5]) != 0;
                    boolean invB = Integer.parseInt(sArr[6]) != 0;
                    CNSTscriptingController.createStruct(AlignmentMarks.createAlignVern(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), invA, invB, Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[9])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("alignCustC1") || sArr[sArr.length - 1].equalsIgnoreCase("alignCustC2") || sArr[sArr.length - 1].equalsIgnoreCase("alignCustC3") || sArr[sArr.length - 1].equalsIgnoreCase("alignCustC4") || sArr[sArr.length - 1].equalsIgnoreCase("alignCustVern")) {
            String temp3 = sArr[sArr.length - 1];
            int alignStandardLength3 = 0;
            if (temp3.equalsIgnoreCase("alignCustC1") || temp3.equalsIgnoreCase("alignCustC2")) {
                int n = alignStandardLength3 = temp3.equalsIgnoreCase("alignCustC1") ? 10 : 11;
            }
            if (temp3.equalsIgnoreCase("alignCustC3") || temp3.equalsIgnoreCase("alignCustC4")) {
                int n = alignStandardLength3 = temp3.equalsIgnoreCase("alignCustC3") ? 12 : 13;
            }
            if (temp3.equalsIgnoreCase("alignCustVern")) {
                alignStandardLength3 = 15;
            }
            if (b = CNSTscriptingController.lineError(sArr, alignStandardLength3, s)) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignCustC1")) {
                    boolean INV = Integer.parseInt(sArr[5]) != 0;
                    CNSTscriptingController.createStruct(AlignmentMarksCustom.createCustomCross(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, INV, Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), 1), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[8])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignCustC2")) {
                    boolean INV = Integer.parseInt(sArr[6]) != 0;
                    CNSTscriptingController.createStruct(AlignmentMarksCustom.createCustomCross(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), 0.0, Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), 0.0, 0.0, 0.0, 0.0, INV, Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), 2), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[9])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignCustC3")) {
                    boolean INV = Integer.parseInt(sArr[7]) != 0;
                    CNSTscriptingController.createStruct(AlignmentMarksCustom.createCustomCross(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), 0.0, Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), 0.0, 0.0, 0.0, INV, Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), 3), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[10])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignCustC4")) {
                    boolean INV = Integer.parseInt(sArr[8]) != 0;
                    CNSTscriptingController.createStruct(AlignmentMarksCustom.createCustomCross(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), 0.0, 0.0, 0.0, Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), INV, Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 4), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[11])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("alignCustVern")) {
                    boolean INVERSEA = Integer.parseInt(sArr[9]) != 0;
                    boolean INVERSEB = Integer.parseInt(sArr[10]) != 0;
                    CNSTscriptingController.createStruct(AlignmentMarksCustom.createCustomVerniers(Integer.parseInt(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), INVERSEA, INVERSEB, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[13])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
            }
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("meanderSin") || sArr[sArr.length - 1].equalsIgnoreCase("meanderSqr") || sArr[sArr.length - 1].equalsIgnoreCase("meanderRamp") || sArr[sArr.length - 1].equalsIgnoreCase("meanderTri")) && (b = CNSTscriptingController.lineError(sArr, alignStandardLength = (temp = sArr[sArr.length - 1]).equalsIgnoreCase("meanderSin") ? 15 : 14, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("meanderSin")) {
                CNSTscriptingController.createStruct(MeanderChannels.createMeanderChannels(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Integer.parseInt(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[13])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            } else {
                int FUNCTION = temp.equalsIgnoreCase("meanderSqr") ? 3 : (temp.equalsIgnoreCase("meanderRamp") ? 1 : 2);
                CNSTscriptingController.createStruct(MeanderChannels.createMeanderChannels(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), 0, Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), FUNCTION), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[12])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("arcSquareFill") || sArr[sArr.length - 1].equalsIgnoreCase("arcSquareFillV") || sArr[sArr.length - 1].equalsIgnoreCase("arcHexFill") || sArr[sArr.length - 1].equalsIgnoreCase("arcHexFillV")) {
            boolean ISVECTOR = sArr[sArr.length - 1].equalsIgnoreCase("arcSquareFillV") || sArr[sArr.length - 1].equalsIgnoreCase("arcHexFillV");
            boolean ISSQUARE = sArr[sArr.length - 1].equalsIgnoreCase("arcSquareFill") || sArr[sArr.length - 1].equalsIgnoreCase("arcSquareFillV");
            String temp4 = sArr[sArr.length - 1];
            int alignStandardLength4 = temp4.equalsIgnoreCase("arcSquareFill") || temp4.equalsIgnoreCase("arcHexFill") ? 13 : 12;
            b = CNSTscriptingController.lineError(sArr, alignStandardLength4, s);
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    if (temp4.equalsIgnoreCase("arcSquareFill") || temp4.equalsIgnoreCase("arcHexFill")) {
                        MISCobjects.arcSquareHexFill(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Integer.parseInt(sArr[10]), Double.parseDouble(sArr[11]), ISSQUARE, ISVECTOR);
                    } else {
                        MISCobjects.arcSquareHexFill(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), 0, Double.parseDouble(sArr[10]), ISSQUARE, ISVECTOR);
                    }
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("arcRadialFill")) {
            temp = sArr[sArr.length - 1];
            b = CNSTscriptingController.lineError(sArr, 12, s);
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    MISCobjects.arcRadialFill(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]));
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("spinIceA") || sArr[sArr.length - 1].equalsIgnoreCase("spinIceVectorA")) && (b = CNSTscriptingController.lineError(sArr, alignStandardLength = (temp = sArr[sArr.length - 1]).equalsIgnoreCase("spinIceA") ? 11 : 10, s))) {
            if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("spinIceA")) {
                    MISCobjects.spinIceA(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Integer.parseInt(sArr[8]), Integer.parseInt(sArr[9]), false);
                } else {
                    MISCobjects.spinIceA(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), 0, Integer.parseInt(sArr[7]), Integer.parseInt(sArr[8]), true);
                }
            } else {
                CNSTscriptingController.selfReferencingError(s);
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("randomPolygons")) {
            boolean RANDOMROTATION;
            b = CNSTscriptingController.lineError(sArr, 12, s);
            boolean bl = RANDOMROTATION = Integer.parseInt(sArr[10]) == 1;
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    MISCobjects.createRandomPolygons(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Integer.parseInt(sArr[9]), RANDOMROTATION);
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("randomEllipses")) {
            boolean RANDOMROTATION;
            b = CNSTscriptingController.lineError(sArr, 13, s);
            boolean bl = RANDOMROTATION = Integer.parseInt(sArr[11]) == 1;
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    MISCobjects.createRandomEllipses(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Integer.parseInt(sArr[9]), Integer.parseInt(sArr[10]), RANDOMROTATION);
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("randomEllipsesV")) {
            boolean RANDOMROTATION;
            b = CNSTscriptingController.lineError(sArr, 12, s);
            boolean bl = RANDOMROTATION = Integer.parseInt(sArr[10]) == 1;
            if (b) {
                if (structName.indexOf(currentStructName) != structName.indexOf(sArr[0])) {
                    MISCobjects.createRandomEllipsesV(structList.get(structName.indexOf(currentStructName)), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Integer.parseInt(sArr[9]), RANDOMROTATION);
                } else {
                    CNSTscriptingController.selfReferencingError(s);
                }
            }
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("sBend") || sArr[sArr.length - 1].equalsIgnoreCase("sBendLH")) && (b = CNSTscriptingController.lineError(sArr, 7, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("sBend")) {
                CNSTscriptingController.createStruct(Photonics.createSbend(new Point2D.Double(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1])), new Point2D.Double(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3])), Double.parseDouble(sArr[4]), shapeReso, Double.parseDouble(sArr[5]), gdsLayer));
            } else {
                CNSTscriptingController.createStruct(Photonics.createSbend(new Point2D.Double(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1])), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), shapeReso, Double.parseDouble(sArr[5]), gdsLayer));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("sBendInv") && (b = CNSTscriptingController.lineError(sArr, 8, s))) {
            CNSTscriptingController.createStruct(Photonics.createSbendInv(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6])));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("sBendInvSlot") && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            CNSTscriptingController.createStruct(Photonics.createSbendInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7])));
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("yBend") || sArr[sArr.length - 1].equalsIgnoreCase("yBendLH")) && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("yBend")) {
                CNSTscriptingController.createStruct(Photonics.createYbend(new Point2D.Double(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1])), new Point2D.Double(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3])), new Point2D.Double(Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5])), Double.parseDouble(sArr[6]), shapeReso, Double.parseDouble(sArr[7]), gdsLayer));
            } else {
                CNSTscriptingController.createStruct(Photonics.createYbend(new Point2D.Double(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1])), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), shapeReso, Double.parseDouble(sArr[7]), gdsLayer));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("yBendInv") && (b = CNSTscriptingController.lineError(sArr, 10, s))) {
            CNSTscriptingController.createStruct(Photonics.createYbendInv(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8])));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("yBendInvSlot") && (b = CNSTscriptingController.lineError(sArr, 11, s))) {
            CNSTscriptingController.createStruct(Photonics.createYbendInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9])));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("yBend90") && (b = CNSTscriptingController.lineError(sArr, 8, s))) {
            CNSTscriptingController.createStruct(Photonics.createYBend90(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[6])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("yBendInv90") && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            CNSTscriptingController.createStruct(Photonics.createYBendInv90(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[7])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("yBendInvSlot90") && (b = CNSTscriptingController.lineError(sArr, 10, s))) {
            CNSTscriptingController.createStruct(Photonics.createYBendInvSlot90(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[8])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("90degreeBend") || sArr[sArr.length - 1].equalsIgnoreCase("90degreeBendLH")) && (b = CNSTscriptingController.lineError(sArr, 7, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("90degreeBend")) {
                CNSTscriptingController.createStruct(Photonics.create90degreeBend(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), shapeReso, Double.parseDouble(sArr[5]), gdsLayer));
            } else {
                CNSTscriptingController.createStruct(Photonics.create90degreeBendLH(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), shapeReso, Double.parseDouble(sArr[5]), gdsLayer));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("90degreeBendInv") && (b = CNSTscriptingController.lineError(sArr, 8, s))) {
            CNSTscriptingController.createStruct(Photonics.create90degreeInv(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6])));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("90degreeBendInvSlot") && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            CNSTscriptingController.createStruct(Photonics.create90degreeInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7])));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("180degreeBend") && (b = CNSTscriptingController.lineError(sArr, 9, s))) {
            CNSTscriptingController.createStruct(Photonics.create180bend(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[7])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("180degreeBendInv") && (b = CNSTscriptingController.lineError(sArr, 10, s))) {
            CNSTscriptingController.createStruct(Photonics.create180bendInverse(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[8])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("180degreeBendInvSlot") && (b = CNSTscriptingController.lineError(sArr, 11, s))) {
            CNSTscriptingController.createStruct(Photonics.create180bendInverseSlot(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[9])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("linearTaper") && (b = CNSTscriptingController.lineError(sArr, 8, s)) && sArr[sArr.length - 1].equalsIgnoreCase("linearTaper")) {
            CNSTscriptingController.createStruct(Photonics.createLinearTaper(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("linearTaperSlot") && (b = CNSTscriptingController.lineError(sArr, 10, s)) && sArr[sArr.length - 1].equalsIgnoreCase("linearTaperSlot")) {
            CNSTscriptingController.createStruct(Photonics.createLinearTaperSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("linearTaperInvSlot") && (b = CNSTscriptingController.lineError(sArr, 11, s)) && sArr[sArr.length - 1].equalsIgnoreCase("linearTaperInvSlot")) {
            CNSTscriptingController.createStruct(Photonics.createLinearTaperInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("waveguide") && (b = CNSTscriptingController.lineError(sArr, 9, s)) && sArr[sArr.length - 1].equalsIgnoreCase("waveguide")) {
            CNSTscriptingController.createStruct(Photonics.createWaveGuide(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Integer.parseInt(sArr[7]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("waveguideSlot") && (b = CNSTscriptingController.lineError(sArr, 10, s)) && sArr[sArr.length - 1].equalsIgnoreCase("waveguideSlot")) {
            CNSTscriptingController.createStruct(Photonics.createWaveGuideSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Integer.parseInt(sArr[8]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("waveguideInv") && (b = CNSTscriptingController.lineError(sArr, 10, s)) && sArr[sArr.length - 1].equalsIgnoreCase("waveguideInv")) {
            CNSTscriptingController.createStruct(Photonics.createWaveGuideInv(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Integer.parseInt(sArr[8]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("waveguideInvSlot") && (b = CNSTscriptingController.lineError(sArr, 11, s)) && sArr[sArr.length - 1].equalsIgnoreCase("waveguideInvSlot")) {
            CNSTscriptingController.createStruct(Photonics.createWaveGuideInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Integer.parseInt(sArr[9]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("exponentialTaper") && (b = CNSTscriptingController.lineError(sArr, 8, s)) && sArr[sArr.length - 1].equalsIgnoreCase("exponentialTaper")) {
            ArrayList<Double> alExpTaper = new ArrayList();
            alExpTaper = Photonics.nonLinStartEnd(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]));
            CNSTscriptingController.createStruct(Photonics.createExponentialTaper(alExpTaper, Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), shapeReso, Double.parseDouble(sArr[6]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("exponentialTaperInv") && (b = CNSTscriptingController.lineError(sArr, 9, s)) && sArr[sArr.length - 1].equalsIgnoreCase("exponentialTaperInv")) {
            CNSTscriptingController.createStruct(Photonics.createExpTaperInv(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7])));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("exponentialTaperInvSlot") && (b = CNSTscriptingController.lineError(sArr, 11, s)) && sArr[sArr.length - 1].equalsIgnoreCase("exponentialTaperInvSlot")) {
            CNSTscriptingController.createStruct(Photonics.createExpTaperInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9])));
        }
        if ((sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler1") || sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler2")) && (b = CNSTscriptingController.lineError(sArr, 14, s))) {
            if (sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler1")) {
                CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createDirectionalCoupler1(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Integer.parseInt(sArr[11])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[12])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
            if (sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler2")) {
                CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createDirectionalCoupler2(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Integer.parseInt(sArr[11])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[12])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler3") || sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler4")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler3") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 10, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler3")) {
                    CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createDirectionalCoupler3(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[9])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("directionalCoupler4")) {
                    CNSTscriptingController.createStruct(PhotonicsGratingCouplers.createDirectionalCoupler4(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[8])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("sBendTaper") && (b = CNSTscriptingController.lineError(sArr, 8, s)) && sArr[sArr.length - 1].equalsIgnoreCase("sBendTaper")) {
            CNSTscriptingController.createStruct(Photonics.createSbendTaper(0.0, 0.0, Double.parseDouble(sArr[2]) / 2.0, 0.0, Double.parseDouble(sArr[2]) / 2.0, Double.parseDouble(sArr[3]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[6]), shapeReso, gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("sBendFunnel") && (b = CNSTscriptingController.lineError(sArr, 7, s)) && sArr[sArr.length - 1].equalsIgnoreCase("sBendFunnel")) {
            CNSTscriptingController.createStruct(Photonics.createSbendFunnel(0.0, 0.0, Double.parseDouble(sArr[2]) / 2.0, 0.0, Double.parseDouble(sArr[2]) / 2.0, Double.parseDouble(sArr[3]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[5]), shapeReso, gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("bezierCurve") && (b = CNSTscriptingController.lineError(sArr, 11, s)) && sArr[sArr.length - 1].equalsIgnoreCase("bezierCurve")) {
            CNSTscriptingController.createStruct(Photonics.createBezierCurve(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), shapeReso, Double.parseDouble(sArr[9]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("bezierCurveInv") && (b = CNSTscriptingController.lineError(sArr, 12, s)) && sArr[sArr.length - 1].equalsIgnoreCase("bezierCurveInv")) {
            CNSTscriptingController.createStruct(Photonics.createBezierCurveInv(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), shapeReso, Double.parseDouble(sArr[10]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("bezierCurveInvSlot") && (b = CNSTscriptingController.lineError(sArr, 13, s)) && sArr[sArr.length - 1].equalsIgnoreCase("bezierCurveInvSlot")) {
            CNSTscriptingController.createStruct(Photonics.createBezierCurveInvSlot(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), shapeReso, Double.parseDouble(sArr[11]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("racetrack") && (b = CNSTscriptingController.lineError(sArr, 8, s)) && sArr[sArr.length - 1].equalsIgnoreCase("racetrack")) {
            CNSTscriptingController.createStruct(PhotonicsWaveGuides.createRaceTrack(Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), gdsLayer));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discInfinite") || sArr[sArr.length - 1].equalsIgnoreCase("ringInfinite")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discInfinite") ? CNSTscriptingController.lineError(sArr, 9, s) : CNSTscriptingController.lineError(sArr, 10, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discInfinite")) {
                    PhotonicsDiscRingPulleys.createInfiniteRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), true, Integer.parseInt(sArr[7]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createInfiniteRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), false, Integer.parseInt(sArr[8]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discInfDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringInfDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discInfDS") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discInfDS")) {
                    PhotonicsDiscRingPulleys.createInfRingDiscDS(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createInfRingDiscDS(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discInfiniteInv") || sArr[sArr.length - 1].equalsIgnoreCase("ringInfiniteInv")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discInfiniteInv") ? CNSTscriptingController.lineError(sArr, 10, s) : CNSTscriptingController.lineError(sArr, 11, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discInfiniteInv")) {
                    PhotonicsDiscRingPulleys.createInfiniteRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), true, Integer.parseInt(sArr[8]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createInfiniteRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), false, Integer.parseInt(sArr[9]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discInfInvDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringInfInvDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discInfInvDS") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discInfInvDS")) {
                    PhotonicsDiscRingPulleys.createInfRingDiscInvDS(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createInfRingDiscInvDS(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discInfiniteInvPos") || sArr[sArr.length - 1].equalsIgnoreCase("ringInfiniteInvPos")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discInfiniteInvPos") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 12, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discInfiniteInvPos")) {
                    PhotonicsDiscRingPulleys.createInfiniteRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), true, Integer.parseInt(sArr[9]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createInfiniteRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), false, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discInfInvPosDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringInfInvPosDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discInfInvPosDS") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discInfInvPosDS")) {
                    PhotonicsDiscRingPulleys.createInfRingDiscInvPosDS(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createInfRingDiscInvPosDS(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetric") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetric")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetric") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetric")) {
                    PhotonicsDiscRingPulleys.createSymmetricRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymmetricRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymDS") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymDS")) {
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, true, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, true, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymPul")) {
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricLC") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricLC")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricLC") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricLC")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymmetricRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymmetricRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymLCDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymLCDS") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCDS")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, true, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, true, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymLCPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymLCPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCPul")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[11]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[10]) + Double.parseDouble(sArr[12]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[13]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricA") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricA") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 12, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricA")) {
                    PhotonicsDiscRingPulleys.createRDSymmetricA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), true, Integer.parseInt(sArr[9]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymmetricA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), false, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymADS") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymADS")) {
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), 0.0, Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), true, false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymAPul") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymAPul")) {
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), false, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricLCA") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricLCA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricLCA") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 12, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricLCA")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymmetricA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), true, Integer.parseInt(sArr[9]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymmetricA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), false, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymLCADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymLCADS") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCADS")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), 0.0, Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), true, false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymLCAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymLCAPul") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymLCAPul")) {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[10]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[11]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), angle2, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[11]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[10]) + Double.parseDouble(sArr[12]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), angle2, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), false, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInv") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInv")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInv") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInv")) {
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvDS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvDS")) {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), 0.0, true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPul") ? CNSTscriptingController.lineError(sArr, 19, s) : CNSTscriptingController.lineError(sArr, 20, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPul")) {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, true, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, false, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvLC") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvLC")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvLC") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvLC")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0 + Double.parseDouble(sArr[8]));
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0 + Double.parseDouble(sArr[9]));
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvLCDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCDS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCDS")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0 + Double.parseDouble(sArr[8]));
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), 0.0, true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0 + Double.parseDouble(sArr[9]));
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvLCPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCPul") ? CNSTscriptingController.lineError(sArr, 19, s) : CNSTscriptingController.lineError(sArr, 20, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCPul")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0 + Double.parseDouble(sArr[8]));
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[13]) / 2.0 + Double.parseDouble(sArr[14]));
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, true, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0 + Double.parseDouble(sArr[9]));
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[13]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[12]) + Double.parseDouble(sArr[14]) / 2.0 + Double.parseDouble(sArr[15]));
                    PhotonicsDiscRingPulleys.createSymRingDiscInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, false, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvA") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvA") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvA")) {
                    PhotonicsDiscRingPulleys.createRDSymmetricInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymmetricInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvADS") ? CNSTscriptingController.lineError(sArr, 16, s) : CNSTscriptingController.lineError(sArr, 17, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvADS")) {
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), true, true, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, false, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvAPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvAPul")) {
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvLCA") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvLCA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvLCA") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvLCA")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[8]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymmetricInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymmetricInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvLCADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCADS") ? CNSTscriptingController.lineError(sArr, 16, s) : CNSTscriptingController.lineError(sArr, 17, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCADS")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[8]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), true, true, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, false, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvLCAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCAPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvLCAPul")) {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[8]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[11]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[10]) + Double.parseDouble(sArr[13]) + Double.parseDouble(sArr[12]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), angle2, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[14]) + Double.parseDouble(sArr[13]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPos") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvPos")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPos") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPos")) {
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosDS") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosDS")) {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), 0.0, true, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosPul") ? CNSTscriptingController.lineError(sArr, 20, s) : CNSTscriptingController.lineError(sArr, 21, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosPul")) {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, true, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), Double.parseDouble(sArr[18]), false, false, Integer.parseInt(sArr[19]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosLC") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvPosLC")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosLC") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosLC")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymmetricRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosLCDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCDS") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCDS")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), 0.0, true, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosLCPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCPul") ? CNSTscriptingController.lineError(sArr, 20, s) : CNSTscriptingController.lineError(sArr, 21, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCPul")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[13]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[12]) + Double.parseDouble(sArr[14]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, true, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[14]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[13]) + Double.parseDouble(sArr[15]) / 2.0);
                    PhotonicsDiscRingPulleys.createSymRingDiscInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), Double.parseDouble(sArr[18]), false, false, Integer.parseInt(sArr[19]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosA") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvPosA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosA") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosA")) {
                    PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosADS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosADS")) {
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosAPul") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosAPul")) {
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosLCA") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymmetricInvPosLCA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosLCA") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymmetricInvPosLCA")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymmetricInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosLCADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCADS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCADS")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringSymInvPosLCAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCAPul") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discSymInvPosLCAPul")) {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[13]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[13]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[12]) + Double.parseDouble(sArr[14]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDSymInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), angle1, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), angle2, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulley") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulley")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulley") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulley")) {
                    PhotonicsDiscRingPulleys.createPulleyRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulleyRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulDS") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulDS")) {
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, true, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, true, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulPul")) {
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyLC") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyLC")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyLC") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyLC")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulleyRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulleyRingDisc(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulLCDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulLCDS") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCDS")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, true, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, true, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulLCPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulLCPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCPul")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[11]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[10]) + Double.parseDouble(sArr[12]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[13]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRingDiscDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyA") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyA") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 12, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyA")) {
                    PhotonicsDiscRingPulleys.createRDPulleyA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), true, Integer.parseInt(sArr[9]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulleyA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), false, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulADS") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulADS")) {
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), 0.0, Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), true, false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulAPul") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulAPul")) {
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), false, false, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyLCA") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyLCA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyLCA") ? CNSTscriptingController.lineError(sArr, 11, s) : CNSTscriptingController.lineError(sArr, 12, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyLCA")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulleyA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), true, Integer.parseInt(sArr[9]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulleyA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), false, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulLCADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulLCADS") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCADS")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), 0.0, Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), true, false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulLCAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulLCAPul") ? CNSTscriptingController.lineError(sArr, 15, s) : CNSTscriptingController.lineError(sArr, 16, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulLCAPul")) {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[10]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[11]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), angle2, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, true, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                } else {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[11]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[10]) + Double.parseDouble(sArr[12]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), angle2, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), false, false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInv") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInv")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInv") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInv")) {
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvDS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvDS")) {
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), 0.0, true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPul") ? CNSTscriptingController.lineError(sArr, 19, s) : CNSTscriptingController.lineError(sArr, 20, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPul")) {
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, true, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, false, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvLC") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvLC")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvLC") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvLC")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0 + Double.parseDouble(sArr[8]));
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0 + Double.parseDouble(sArr[9]));
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInverse(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvLCDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCDS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCDS")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0 + Double.parseDouble(sArr[8]));
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), 0.0, true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0 + Double.parseDouble(sArr[9]));
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvLCPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCPul") ? CNSTscriptingController.lineError(sArr, 19, s) : CNSTscriptingController.lineError(sArr, 20, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCPul")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[7]) / 2.0 + Double.parseDouble(sArr[8]));
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[13]) / 2.0 + Double.parseDouble(sArr[14]));
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, true, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0 + Double.parseDouble(sArr[9]));
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[13]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[12]) + Double.parseDouble(sArr[14]) / 2.0 + Double.parseDouble(sArr[15]));
                    PhotonicsDiscRingPulleys.createPulRDInvDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, false, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvA") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvA") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvA")) {
                    PhotonicsDiscRingPulleys.createRDPulleyInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulleyInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvADS") ? CNSTscriptingController.lineError(sArr, 16, s) : CNSTscriptingController.lineError(sArr, 17, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvADS")) {
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), true, true, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, false, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvAPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvAPul")) {
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvLCA") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvLCA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvLCA") ? CNSTscriptingController.lineError(sArr, 12, s) : CNSTscriptingController.lineError(sArr, 13, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvLCA")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[8]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulleyInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), true, Integer.parseInt(sArr[10]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulleyInvA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), false, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvLCADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCADS") ? CNSTscriptingController.lineError(sArr, 16, s) : CNSTscriptingController.lineError(sArr, 17, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCADS")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[8]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), thetaWG, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), 0.0, Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), true, true, Integer.parseInt(sArr[14]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, false, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvLCAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCAPul") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvLCAPul")) {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[5]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[4]) + Double.parseDouble(sArr[8]) + Double.parseDouble(sArr[7]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[11]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[10]) + Double.parseDouble(sArr[13]) + Double.parseDouble(sArr[12]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), angle1, Integer.parseInt(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), angle2, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), false, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[9]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[3]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[14]) + Double.parseDouble(sArr[13]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPos") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvPos")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPos") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPos")) {
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPDS") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPDS")) {
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), 0.0, true, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPPul") ? CNSTscriptingController.lineError(sArr, 20, s) : CNSTscriptingController.lineError(sArr, 21, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPPul")) {
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, true, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), Double.parseDouble(sArr[18]), false, false, Integer.parseInt(sArr[19]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosLC") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvPosLC")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosLC") ? CNSTscriptingController.lineError(sArr, 14, s) : CNSTscriptingController.lineError(sArr, 15, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosLC")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), true, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulleyRingDiscInversePos(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), false, Integer.parseInt(sArr[13]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCDS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPLCDS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCDS") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCDS")) {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), 0.0, true, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    double thetaWG = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG * 180.0 / Math.PI, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), 0.0, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), 0.0, true, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPLCPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCPul") ? CNSTscriptingController.lineError(sArr, 20, s) : CNSTscriptingController.lineError(sArr, 21, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCPul")) {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[13]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[12]) + Double.parseDouble(sArr[14]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), false, true, Integer.parseInt(sArr[18]) != 0, gdsLayer);
                } else {
                    double angle1 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0);
                    double angle2 = 1.5707963267948966 - 0.5 * Double.parseDouble(sArr[14]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[13]) + Double.parseDouble(sArr[15]) / 2.0);
                    PhotonicsDiscRingPulleys.createPulRDInvPosDSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), angle1 * 180.0 / Math.PI, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), angle2 * 180.0 / Math.PI, Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), Double.parseDouble(sArr[18]), false, false, Integer.parseInt(sArr[19]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosA") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvPosA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosA") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosA")) {
                    PhotonicsDiscRingPulleys.createRDPulleyInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulleyInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPADS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPADS")) {
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPAPul") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPAPul")) {
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosLCA") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulleyInvPosLCA")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosLCA") ? CNSTscriptingController.lineError(sArr, 13, s) : CNSTscriptingController.lineError(sArr, 14, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulleyInvPosLCA")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulleyInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), true, Integer.parseInt(sArr[11]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulleyInvPosA(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), false, Integer.parseInt(sArr[12]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCADS") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPLCADS")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCADS") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 18, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCADS")) {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), thetaWG, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), 0.0, Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), true, true, Integer.parseInt(sArr[15]) != 0, gdsLayer);
                } else {
                    double thetaWG = 0.5 * (Math.PI - Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), thetaWG, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), 0.0, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), true, false, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCAPul") || sArr[sArr.length - 1].equalsIgnoreCase("ringPulInvPLCAPul")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCAPul") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("discPulInvPLCAPul")) {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[6]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[5]) + Double.parseDouble(sArr[8]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[12]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[11]) + Double.parseDouble(sArr[13]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), 0.0, Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), angle1, Integer.parseInt(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), angle2, Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), false, true, Integer.parseInt(sArr[16]) != 0, gdsLayer);
                } else {
                    double angle1 = 0.5 * (Math.PI - Double.parseDouble(sArr[7]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[6]) + Double.parseDouble(sArr[9]) / 2.0)) * 57.29577951308232;
                    double angle2 = 0.5 * (Math.PI - Double.parseDouble(sArr[13]) / (Double.parseDouble(sArr[2]) + Double.parseDouble(sArr[12]) + Double.parseDouble(sArr[14]) / 2.0)) * 57.29577951308232;
                    PhotonicsDiscRingPulleys.createRDPulInvPosADSPul(structList.get(structName.indexOf(currentStructName)), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Integer.parseInt(sArr[5]), Double.parseDouble(sArr[6]), angle1, Integer.parseInt(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), angle2, Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), false, false, Integer.parseInt(sArr[17]) != 0, gdsLayer);
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV1") || sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV2")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV1") ? CNSTscriptingController.lineError(sArr, 17, s) : CNSTscriptingController.lineError(sArr, 21, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV1")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd1(Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[15])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV2")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd2(Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), Double.parseDouble(sArr[18])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[19])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV3") || sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV4") || sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV5") || sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV6")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV5") ? CNSTscriptingController.lineError(sArr, 18, s) : CNSTscriptingController.lineError(sArr, 19, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV3")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd3(Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[17])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV4")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd4(Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[17])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV5")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd5(Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[16])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV6")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd6(Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[17])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV7") || sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV8")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV7") ? CNSTscriptingController.lineError(sArr, 16, s) : CNSTscriptingController.lineError(sArr, 20, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV7")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd7(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Integer.parseInt(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[14])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("wgdcdV8")) {
                    CNSTscriptingController.createStruct(PhotonicsWgDcThomasVladimir.createWgdcd8(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[18])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("MARCs") || sArr[sArr.length - 1].equalsIgnoreCase("MAR3s") || sArr[sArr.length - 1].equalsIgnoreCase("MAR2s")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("MAR2s") ? CNSTscriptingController.lineError(sArr, 22, s) : CNSTscriptingController.lineError(sArr, 21, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("MARCs")) {
                    MEMScoupledArrays.createRTElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Double.parseDouble(sArr[19]), true);
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("MAR3s")) {
                    MEMScoupledArrays.createRTElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Double.parseDouble(sArr[19]), false);
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("MAR2s")) {
                    MEMScoupledArrays.createRT2CoupledBeamsSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Integer.parseInt(sArr[19]), Double.parseDouble(sArr[20]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("MATCs") || sArr[sArr.length - 1].equalsIgnoreCase("MAT3s") || sArr[sArr.length - 1].equalsIgnoreCase("MAT2s")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("MAT2s") ? CNSTscriptingController.lineError(sArr, 24, s) : CNSTscriptingController.lineError(sArr, 23, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("MATCs")) {
                    MEMScoupledArrays.createRTElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Integer.parseInt(sArr[19]), Integer.parseInt(sArr[20]), Double.parseDouble(sArr[21]), true);
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("MAT3s")) {
                    MEMScoupledArrays.createRTElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Integer.parseInt(sArr[19]), Integer.parseInt(sArr[20]), Double.parseDouble(sArr[21]), false);
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("MAT2s")) {
                    MEMScoupledArrays.createRT2CoupledBeamsSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Double.parseDouble(sArr[17]), Integer.parseInt(sArr[18]), Integer.parseInt(sArr[19]), Integer.parseInt(sArr[20]), Integer.parseInt(sArr[21]), Double.parseDouble(sArr[22]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("MARAs") && (b = CNSTscriptingController.lineError(sArr, 21, s))) {
            MEMScoupledArrays.createRectElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Double.parseDouble(sArr[19]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("MATALWs") || sArr[sArr.length - 1].equalsIgnoreCase("MATAs")) {
            boolean bl = b = sArr[sArr.length - 1].equalsIgnoreCase("MATALWs") ? CNSTscriptingController.lineError(sArr, 20, s) : CNSTscriptingController.lineError(sArr, 23, s);
            if (b) {
                if (sArr[sArr.length - 1].equalsIgnoreCase("MATALWs")) {
                    MEMScoupledArrays.createTrapElectrodesCONSTSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Integer.parseInt(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Double.parseDouble(sArr[18]));
                }
                if (sArr[sArr.length - 1].equalsIgnoreCase("MATAs")) {
                    MEMScoupledArrays.createTrapElectrodesVLWSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Double.parseDouble(sArr[15]), Double.parseDouble(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Integer.parseInt(sArr[19]), Integer.parseInt(sArr[20]), Double.parseDouble(sArr[21]));
                }
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("MARAs") && (b = CNSTscriptingController.lineError(sArr, 21, s))) {
            MEMScoupledArrays.createRectElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Double.parseDouble(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Integer.parseInt(sArr[18]), Double.parseDouble(sArr[19]));
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("MARACURVEs") || sArr[sArr.length - 1].equalsIgnoreCase("MARALINEARs")) {
            b = CNSTscriptingController.lineError(sArr, 20, s);
            boolean ISLINEAR = sArr[sArr.length - 1].equalsIgnoreCase("MARALINEARs");
            if (b) {
                MEMScoupledArrays.createRectVaryingElectrodeSTR(CNSTscriptingController.getCurrentStruct(), sArr[0], Double.parseDouble(sArr[1]), Double.parseDouble(sArr[2]), Integer.parseInt(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10]), Double.parseDouble(sArr[11]), Double.parseDouble(sArr[12]), Double.parseDouble(sArr[13]), Integer.parseInt(sArr[14]), Integer.parseInt(sArr[15]), Integer.parseInt(sArr[16]), Integer.parseInt(sArr[17]), Double.parseDouble(sArr[18]), ISLINEAR);
            }
        }
        if (sArr[sArr.length - 1].equalsIgnoreCase("wgExpander") && (b = CNSTscriptingController.lineError(sArr, 13, s))) {
            CNSTscriptingController.createStruct(PhotonicsWaveGuides.createWaveGuideExpander(Double.parseDouble(sArr[2]), Double.parseDouble(sArr[3]), Double.parseDouble(sArr[4]), Double.parseDouble(sArr[5]), Double.parseDouble(sArr[6]), Double.parseDouble(sArr[7]), Double.parseDouble(sArr[8]), Double.parseDouble(sArr[9]), Double.parseDouble(sArr[10])), CNSTscriptingController.degreeToRadians(Double.parseDouble(sArr[11])), Double.parseDouble(sArr[0]), Double.parseDouble(sArr[1]));
        }
    }

    public static boolean lineError(String[] sA, int i, String s) {
        if (sA.length != i) {
            s = "******** SYNTAX ERROR WITH LINE: " + s;
            System.out.println("lineError::\t" + s);
            logFileINFO.add(s);
            return false;
        }
        return true;
    }

    public static boolean parameterError(int p1, int p2, String s) {
        if (p1 != p2) {
            s = "******** PARAMETER SIZE SYNTAX ERROR WITH LINE: " + s;
            System.out.println("parameterError::\t" + s);
            logFileINFO.add(s);
            return false;
        }
        return true;
    }

    public static void selfReferencingError(String s) {
        s = "******** SELF REFERENCING STRUCTURE ERROR WITH LINE: " + s;
        logFileINFO.add(s);
        System.out.println("selfReferencingError::\t" + s);
    }

    public static void structureDoesNotExist(String s, String struct, String type) {
        s = "****ERROR Structure " + struct + " for " + type + " does not exist in line \t" + s;
        logFileINFO.add(s);
        System.out.println("structureDoesNotExist::\t" + s);
    }

    public static void layerDoesNotExist(String s, String layer, String type) {
        s = "****ERROR GDS Layer " + layer + " for " + type + " does not exist in line \t" + s;
        logFileINFO.add(s);
        System.out.println("layerDoesNotExist::\t" + s);
    }

    public static void setGdsLayer(ArrayList<Double> al) {
        gdsLayer = al.get(0).intValue() >= 0 && al.get(0).intValue() <= 255 ? al.get(0).intValue() : 0;
    }

    public static void setGdsLayer(int d) {
        gdsLayer = d >= 0 && d <= 255 ? d : 0;
    }

    public static int getGdsLayer() {
        return gdsLayer;
    }

    public static void setDataType(ArrayList<Double> al) {
        dataType = al.get(0).intValue() >= 0 && al.get(0).intValue() <= 255 ? al.get(0).intValue() : 0;
    }

    public static void setDataType(int d) {
        dataType = d >= 0 && d <= 255 ? d : 0;
    }

    public static int getDataType() {
        return dataType;
    }

    public static void setStructName(String s) {
        currentStructName = s;
    }

    public static void setGDSReso(ArrayList<Double> al) {
        gdsReso = al.get(0);
    }

    public static void setGDSReso(double reso) {
        gdsReso = reso;
    }

    public static void setFontOutline(ArrayList<Double> al) {
        fontOutline = al.get(0);
    }

    public static void setFontOutline(double outline) {
        fontOutline = outline;
    }

    public static double getFontOutline() {
        return fontOutline;
    }

    public static void setShapeReso(ArrayList<Double> al) {
        shapeReso = al.get(0);
    }

    public static void setShapeReso(double reso) {
        shapeReso = reso;
    }

    public static double getShapeReso() {
        return shapeReso;
    }

    public static double getGDSreso() {
        return gdsReso;
    }

    public static void setPixelValue(ArrayList<Double> al) {
        psPixelValue = al.get(0);
    }

    public static void setPixelValue(double pixelValue) {
        psPixelValue = pixelValue;
    }

    public static double getPixelValue() {
        return psPixelValue;
    }

    public static void setFracElements(ArrayList<Double> al) {
        psFracElements = al.get(0).intValue();
    }

    public static void setFracElements(int fracE) {
        psFracElements = fracE;
    }

    public static int getFracElements() {
        return psFracElements;
    }

    public static void setGDSfileName(String s) {
        gdsFile = s;
    }

    public static String[] getFontNames() {
        return fontNames;
    }

    public static void addToErrorLog(String s) {
        logFileINFO.add(s);
    }

    public static void doBOOLEANS(GArea g1, GArea g2, int lyr, String operation) {
        switch (operation.toUpperCase()) {
            case "AND": {
                g1.and(g2);
                break;
            }
            case "OR": {
                g1.or(g2);
                break;
            }
            case "SUBTRACT": {
                g1.subtract(g2);
                break;
            }
            case "XOR": {
                g1.xor(g2);
                break;
            }
        }
        g1.setLayer(lyr);
        g1.setDataType(dataType);
        CNSTscriptingController.createStruct(g1);
    }

    public static void copyGenAreaCenter(GArea ga, double Tx, double Ty, String MIRROR, double MAG, double ROTATE, double BIAS, int lyr, boolean CENTER) {
        String mirrorUpperCase;
        Area a = new Area(ga.getArea());
        a.transform(AffineTransform.getRotateInstance(ROTATE * Math.PI / 180.0, 0.0, 0.0));
        if (CENTER) {
            Rectangle2D rec = a.getBounds2D();
            a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
        }
        if ((mirrorUpperCase = MIRROR.toUpperCase()).equalsIgnoreCase("X") || mirrorUpperCase.equalsIgnoreCase("Y")) {
            AffineTransform mirrorY = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
            double rotateMirrorX = mirrorUpperCase.equalsIgnoreCase("Y") ? 0.0 : Math.PI;
            a.transform(mirrorY);
            a.transform(AffineTransform.getRotateInstance(rotateMirrorX));
        }
        a.transform(AffineTransform.getScaleInstance(MAG, MAG));
        a.transform(AffineTransform.getTranslateInstance(Tx, Ty));
        GArea v = new GArea(a, lyr);
        v.grow(BIAS);
        v.setDataType(dataType);
        CNSTscriptingController.createStruct(v);
    }

    public static Struct getCurrentStruct() {
        if (structList.size() > 0) {
            return structList.get(structName.indexOf(currentStructName));
        }
        return top;
    }

    public static void createStruct(Path2D.Double p2d) {
        GArea v = new GArea(p2d, gdsLayer);
        v.setRenderReso(shapeReso);
        v.setDataType(dataType);
        if (structList.size() > 0) {
            structList.get(structName.indexOf(currentStructName)).add(v);
        } else {
            top.add(v);
        }
    }

    public static void createStruct(Path2D.Double p2d, int fractureElements) {
        GArea ga = new GArea(p2d, gdsLayer);
        Area a = new Area(ga.getArea());
        Rectangle2D rec = a.getBounds2D();
        double width = rec.getWidth() / (double)fractureElements;
        GArea frac = new GArea(new Rect(0.0, 0.0, width, rec.getHeight(), gdsLayer), gdsLayer);
        GArea temp = new GArea(ga);
        GArea tempFrac = new GArea(frac);
        temp.setDataType(dataType);
        tempFrac.setDataType(dataType);
        ga.setRenderReso(shapeReso);
        for (int i = 0; i < 10; ++i) {
            GArea resolutionArea = new GArea((GArea)temp.and((GDS2)tempFrac.transform(AffineTransform.getTranslateInstance((double)i * width, 0.0))));
            resolutionArea.setRenderReso(shapeReso);
            if (structList.size() > 0) {
                structList.get(structName.indexOf(currentStructName)).add(resolutionArea);
            } else {
                top.add(resolutionArea);
            }
            temp = new GArea(ga);
            tempFrac = new GArea(frac);
        }
    }

    public static void createStruct(GArea ga) {
        ga.setDataType(dataType);
        if (structList.size() > 0) {
            structList.get(structName.indexOf(currentStructName)).add(ga);
        } else {
            top.add(ga);
        }
    }

    public static void createStruct(GArea ga, double THETA, double x, double y) {
        ga.setDataType(dataType);
        if (structList.size() > 0) {
            ga.transform(AffineTransform.getTranslateInstance(x, y));
            ga.transform(AffineTransform.getRotateInstance(THETA, x, y));
            structList.get(structName.indexOf(currentStructName)).add(ga);
        } else {
            ga.transform(AffineTransform.getTranslateInstance(x, y));
            top.add((GDS2Element)ga.transform(AffineTransform.getRotateInstance(THETA, x, y)));
        }
    }

    public static void createStruct(ArrayList<GArea> ga) {
        if (structList.size() > 0) {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                structList.get(structName.indexOf(currentStructName)).add(ga.get(i));
            }
        } else {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                top.add(ga.get(i));
            }
        }
    }

    public static void createStruct(ArrayList<GArea> ga, boolean MIRROR) {
        AffineTransform mirroGArea = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        if (structList.size() > 0) {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                if (MIRROR) {
                    structList.get(structName.indexOf(currentStructName)).add((GDS2Element)ga.get(i).transform(mirroGArea));
                    continue;
                }
                structList.get(structName.indexOf(currentStructName)).add(ga.get(i));
            }
        } else {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                if (MIRROR) {
                    top.add((GDS2Element)ga.get(i).transform(mirroGArea));
                    continue;
                }
                top.add(ga.get(i));
            }
        }
    }

    public static void createStruct(ArrayList<GArea> ga, double x, double y) {
        if (structList.size() > 0) {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                structList.get(structName.indexOf(currentStructName)).add((GDS2Element)ga.get(i).transform(AffineTransform.getTranslateInstance(x, y)));
            }
        } else {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                top.add((GDS2Element)ga.get(i).transform(AffineTransform.getTranslateInstance(x, y)));
            }
        }
    }

    public static void createStruct(ArrayList<GArea> ga, double THETA, double x, double y) {
        if (structList.size() > 0) {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                ga.get(i).transform(AffineTransform.getTranslateInstance(x, y));
                structList.get(structName.indexOf(currentStructName)).add((GDS2Element)ga.get(i).transform(AffineTransform.getRotateInstance(THETA, x, y)));
            }
        } else {
            for (int i = 0; i < ga.size(); ++i) {
                ga.get(i).setDataType(dataType);
                ga.get(i).transform(AffineTransform.getTranslateInstance(x, y));
                top.add((GDS2Element)ga.get(i).transform(AffineTransform.getRotateInstance(THETA, x, y)));
            }
        }
    }

    public static boolean structExists(String s) {
        return structName.indexOf(s) != -1;
    }

    public static void createPoints2Instance(ArrayList<Double> al) {
        for (int i = 0; i < al.size() - 1; i += 2) {
            structList.get(structName.indexOf(currentStructName)).add(new Ref(structList.get(structName.indexOf(pts2instStructName)), al.get(i), al.get(i + 1)));
        }
    }

    public static Path2D.Double mergePoints(ArrayList<Double> al, Path2D.Double p2d) {
        p2d.moveTo(al.get(0), al.get(1));
        for (int i = 2; i < al.size() - 1; i += 2) {
            p2d.lineTo(al.get(i), al.get(i + 1));
        }
        p2d.closePath();
        return p2d;
    }

    public static double rescalePSimage(double d) {
        return (double)Math.round(psPixelValue * d * 1000.0) / 1000.0;
    }

    public static void createPolyPath(ArrayList<Double> al) {
        double width = al.get(al.size() - 3);
        double temp = al.get(al.size() - 2);
        int cap = (int)temp;
        temp = al.get(al.size() - 1);
        int join = (int)temp;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(al.get(0), al.get(1));
        for (int i = 2; i < al.size() - 3; i += 2) {
            poly.lineTo(al.get(i), al.get(i + 1));
        }
        BasicStroke bs = new BasicStroke((float)width, cap, join);
        GArea v = new GArea(bs.createStrokedShape(poly), gdsLayer);
        v.setDataType(dataType);
        CNSTscriptingController.createStruct(v);
    }

    public static GArea createPolyPathGArea(ArrayList<Double> al) {
        double width = al.get(al.size() - 3);
        double temp = al.get(al.size() - 2);
        int cap = (int)temp;
        temp = al.get(al.size() - 1);
        int join = (int)temp;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(al.get(0), al.get(1));
        for (int i = 2; i < al.size() - 3; i += 2) {
            poly.lineTo(al.get(i), al.get(i + 1));
        }
        BasicStroke bs = new BasicStroke((float)width, cap, join);
        GArea v = new GArea(bs.createStrokedShape(poly), gdsLayer);
        v.setDataType(dataType);
        return v;
    }

    public static void createVectorShapes(ArrayList<Double> al, String s) {
        Shape s1 = null;
        if (s.equalsIgnoreCase("roundRect")) {
            s1 = new RoundRectangle2D.Double(al.get(0), al.get(1), al.get(2), al.get(3), al.get(4), al.get(5));
        }
        if (s.equalsIgnoreCase("roundRectC")) {
            s1 = new RoundRectangle2D.Double(al.get(0) - al.get(2) / 2.0, al.get(1) - al.get(3) / 2.0, al.get(2), al.get(3), al.get(4), al.get(5));
        }
        if (s.equalsIgnoreCase("ellipseVector")) {
            s1 = new Ellipse2D.Double(al.get(0) - al.get(2), al.get(1) - al.get(3), 2.0 * al.get(2), 2.0 * al.get(3));
        }
        if (s.equalsIgnoreCase("arcVector")) {
            double angleStart = al.get(4);
            double angleStop = al.get(5);
            angleStart = angleStart >= 90.0 ? angleStart - 360.0 : angleStart;
            double angleExtent = angleStop - angleStart;
            s1 = new Arc2D.Double(0.0, 0.0, 2.0 * al.get(2), 2.0 * al.get(3), al.get(4), angleExtent, 2);
        }
        if (s.equalsIgnoreCase("torusVector")) {
            Ellipse2D.Double sBig = new Ellipse2D.Double(al.get(0) - al.get(3), al.get(1) - al.get(3), 2.0 * al.get(3), 2.0 * al.get(3));
            Ellipse2D.Double sSmall = new Ellipse2D.Double(al.get(0) - al.get(2), al.get(1) - al.get(2), 2.0 * al.get(2), 2.0 * al.get(2));
            Area a1 = new Area(sBig);
            Area a2 = new Area(sSmall);
            a1.subtract(a2);
            s1 = a1;
        }
        Path2D.Double p2dTemp = new Path2D.Double();
        PathIterator pi = s1.getPathIterator(null);
        while (!pi.isDone()) {
            p2dTemp = CNSTscriptingController.describeCurrentSegment(pi, p2dTemp, false);
            pi.next();
        }
        GArea v = new GArea(p2dTemp, gdsLayer);
        v.setRenderReso(shapeReso);
        v.setDataType(dataType);
        if (s.equalsIgnoreCase("roundRect")) {
            CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(v, al.get(0), al.get(1), al.get(6)));
        }
        if (s.equalsIgnoreCase("roundRectC")) {
            CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(v, al.get(0), al.get(1), al.get(6)));
        }
        if (s.equalsIgnoreCase("ellipseVector")) {
            CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(v, al.get(0), al.get(1), al.get(4)));
        }
        if (s.equalsIgnoreCase("arcVector")) {
            v.transform(AffineTransform.getTranslateInstance(-al.get(2).doubleValue(), -al.get(3).doubleValue()));
            v.transform(AffineTransform.getTranslateInstance(al.get(0), al.get(1)));
            v.transform(new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0}));
            v.transform(AffineTransform.getRotateInstance(Math.PI));
            v.transform(AffineTransform.getTranslateInstance(0.0, 2.0 * al.get(1)));
            CNSTscriptingController.createStruct(PrimitiveShapes.rotateGArea(v, al.get(0), al.get(1), al.get(6)));
        }
        if (s.equalsIgnoreCase("torusVector")) {
            CNSTscriptingController.createStruct(v);
        }
    }

    public static void createPolygon(ArrayList<Double> al, String s) {
        Polygon s1;
        Path2D.Double p2dTemp = new Path2D.Double();
        switch (s) {
            case "polygon": {
                s1 = new RegularPolygon(CNSTscriptingController.um2nmConversion(al.get(0)), CNSTscriptingController.um2nmConversion(al.get(1)), CNSTscriptingController.um2nmConversion(al.get(2)), al.get(3).intValue(), CNSTscriptingController.degreeToRadians(al.get(4)));
                break;
            }
            default: {
                s1 = new StarPolygon(CNSTscriptingController.um2nmConversion(al.get(0)), CNSTscriptingController.um2nmConversion(al.get(1)), CNSTscriptingController.um2nmConversion(al.get(2)), CNSTscriptingController.um2nmConversion(al.get(3)), al.get(4).intValue(), CNSTscriptingController.degreeToRadians(al.get(5)));
            }
        }
        PathIterator pi = s1.getPathIterator(null);
        while (!pi.isDone()) {
            p2dTemp = CNSTscriptingController.describeCurrentSegment(pi, p2dTemp, true);
            pi.next();
        }
        GArea v = new GArea(p2dTemp, gdsLayer);
        v.setDataType(dataType);
        CNSTscriptingController.createStruct(v);
    }

    public static void clearStructs() {
        structList.clear();
        structName.clear();
        logFileINFO.clear();
        logFileTimeDate = false;
        gdsLayer = 4;
        dataType = 0;
        psFracElements = 1;
        psPixelValue = 1.0;
        gdsReso = 0.001;
        shapeReso = 0.001;
        fontOutline = 0.1;
    }

    public static int um2nmConversion(double d) {
        return (int)(d * 1000.0);
    }

    public static double nm2umConversion(int i) {
        return (double)i / 1000.0;
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static Path2D.Double describeCurrentSegment(PathIterator pi, Path2D.Double p2d, boolean b) {
        double[] coordinate = new double[6];
        int type = pi.currentSegment(coordinate);
        if (b) {
            for (int i = 0; i < coordinate.length; ++i) {
                coordinate[i] = CNSTscriptingController.nm2umConversion((int)coordinate[i]);
            }
        }
        switch (type) {
            case 0: {
                p2d.moveTo(coordinate[0], coordinate[1]);
                return p2d;
            }
            case 1: {
                p2d.lineTo(coordinate[0], coordinate[1]);
                return p2d;
            }
            case 2: {
                p2d.quadTo(coordinate[0], coordinate[1], coordinate[2], coordinate[3]);
                return p2d;
            }
            case 3: {
                p2d.curveTo(coordinate[0], coordinate[1], coordinate[2], coordinate[3], coordinate[4], coordinate[5]);
                return p2d;
            }
            case 4: {
                p2d.closePath();
                return p2d;
            }
        }
        return p2d;
    }

    public static void createCircleThree(ArrayList<Double> al) {
        CircleThree.Point p1 = new CircleThree.Point(al.get(0), al.get(1));
        CircleThree.Point p2 = new CircleThree.Point(al.get(2), al.get(3));
        CircleThree.Point p3 = new CircleThree.Point(al.get(4), al.get(5));
        CircleThree.Circle c = CircleThree.circleFromPoints(p1, p2, p3);
        ArrayList<Double> cThree = new ArrayList<Double>(Arrays.asList(c.center.x, c.center.y, c.radius, c.radius, al.get(6)));
        CNSTscriptingController.createStruct(PrimitiveShapes.createEllipse(c.center.x, c.center.y, c.radius, c.radius, al.get(6).intValue(), gdsLayer));
        CNSTscriptingController.createCircleThreeLog(al, cThree);
    }

    public static void createCircleThreeLog(ArrayList<Double> al, ArrayList<Double> cThree) {
        String sp = " ";
        DecimalFormat df = new DecimalFormat("#.####");
        String s = al.get(0) + sp + al.get(1) + sp + al.get(2) + sp + al.get(3) + sp + al.get(4) + sp + al.get(5) + sp + al.get(6).intValue() + sp + "circlethree" + " ->  " + df.format(cThree.get(0)) + sp + df.format(cThree.get(1)) + sp + df.format(cThree.get(2)) + sp;
        logFileINFO.add(s);
    }

    public static void exportLogFile() throws IOException {
        String logFile = gdsFile + ".log";
        if (logFileTimeDate) {
            Date date = new Date();
            SimpleDateFormat ft = new SimpleDateFormat("yyyyMMdd-hhmmssa");
            logFile = gdsFile + ft.format(date) + ".log";
        }
        logFileINFO.add("COMPLETED!");
        FileWriter fstream = new FileWriter(saveToDir + logFile);
        BufferedWriter out = new BufferedWriter(fstream);
        for (String circleThreeINFO1 : logFileINFO) {
            out.write(circleThreeINFO1 + "\n");
        }
        out.close();
    }

    public String exportGDS(Scanner input, String[] cmdLine) throws IOException, FileNotFoundException, ScriptException {
        gdsFile = this.tfFileName.getText() + ".gds";
        Lib lib = new Lib();
        top = new Struct("top");
        CNSTscriptingController.readData(input);
        CNSTscriptingController.exportLogFile();
        for (Struct structList1 : structList) {
            lib.add(new Ref(structList1, 0.0, 0.0));
        }
        lib.add(new Ref(top, 0.0, 0.0));
        GDS2.setReso(gdsReso);
        File f = lib.GDSOut(saveToDir + gdsFile);
        CNSTscriptingController.clearStructs();
        return f.getAbsolutePath();
    }

    public static void commandLineExportGDS(Scanner input, String[] cmdLine) throws IOException, Exception {
        CNSTdefaultParameters.getFileParameters();
        openDir = CNSTdefaultParameters.openDir;
        saveToDir = CNSTdefaultParameters.saveToDir;
        gdsFile = cmdLine[2];
        Lib lib = new Lib();
        top = new Struct("top");
        CNSTscriptingController.readData(input);
        CNSTscriptingController.exportLogFile();
        for (Struct structList1 : structList) {
            lib.add(new Ref(structList1, 0.0, 0.0));
        }
        lib.add(new Ref(top, 0.0, 0.0));
        GDS2.setReso(gdsReso);
        File f = lib.GDSOut(saveToDir + gdsFile);
        System.out.println("\nSaved to: " + f.getAbsolutePath());
        System.out.println("\nPlease acknowledge the Nanolithography Toolbox by including the following reference:");
        System.out.println("\nThe Nanolithography Toolbox, K. C. Balram, D. A. Westly, M. Davanco, K. E. Grutter, Q. Li, T. Michels, C. H. Ray, L. Yu,  R. J. Kasica,  C. B. Wallin, I. J. Gilbert, B. A. Bryce, G. Simelgor, J. Topolancik, N. Lobontiu , Y. Liu, P. Neuzil, V. Svatos, K. A. Dill, N. A. Bertrand, M. G. Metzler, G. Lopez, D. A. Czaplewski, L. Ocola, K. A. Srinivasan, S. M. Stavis, V. A. Aksyuk, J. A. Liddle, S. Krylov and B. R. Ilic, J. Res. Natl. Inst. Stand. 121, pp. 464-475 (2016).");
    }

    static {
        displayColor = 0;
        displayColor2 = 0;
        structList = new ArrayList();
        structName = new ArrayList();
        logFileINFO = new ArrayList();
        genAreaMap = new HashMap<String, GArea>();
        gdsLayer = 4;
        dataType = 0;
        psFracElements = 1;
        psPixelValue = 1.0;
        gdsReso = 0.001;
        shapeReso = 0.001;
        fontOutline = 0.1;
        currentStructName = "top";
        pts2instStructName = "top";
        pts2inst = false;
        logFileTimeDate = false;
        fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }
}

