/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.scripting;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.Array;
import JGDS2.GArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class CNSTscriptingArrays {
    public static void createInstance(String[] s, Struct structArr, Struct struct) {
        double x = Double.parseDouble(s[1]);
        double y = Double.parseDouble(s[2]);
        double mag = Double.parseDouble(s[4]);
        double angle = Double.parseDouble(s[5]);
        int mirror = 0;
        if (s[3].equalsIgnoreCase("X") || s[3].equalsIgnoreCase("Y")) {
            mirror = 32768;
            double rotateMirrorX = s[3].equalsIgnoreCase("X") ? 0.0 : 180.0;
            angle += rotateMirrorX;
        }
        structArr.add(new Ref(struct, x, y, mirror, mag, angle));
    }

    public static void createInstanceSymmetric(String[] s, Struct structArr, Struct struct) {
        double x = Double.parseDouble(s[1]);
        double y = Double.parseDouble(s[2]);
        double mag = Double.parseDouble(s[8]);
        double angle = Double.parseDouble(s[9]);
        double L = mag * (Double.parseDouble(s[5]) - Double.parseDouble(s[3]));
        double H = mag * (Double.parseDouble(s[6]) - Double.parseDouble(s[4]));
        int mirror = 0;
        if (s[7].equalsIgnoreCase("X") || s[7].equalsIgnoreCase("Y")) {
            mirror = 32768;
            double rotateMirrorX = s[7].equalsIgnoreCase("X") ? 0.0 : 180.0;
            angle += rotateMirrorX;
        }
        structArr.add(new Ref(struct, x - L / 2.0, y - H / 2.0, mirror, mag, angle));
    }

    public static GArea createText(String s, String fontName, String[] parameters, int layer, boolean centered) {
        double fontSize = Double.parseDouble(parameters[0]);
        double x = Double.parseDouble(parameters[1]);
        double y = Double.parseDouble(parameters[2]);
        if (!Arrays.asList(CNSTscriptingController.fontNames).contains(fontName)) {
            String fontError = "FONT NAME '" + fontName + "' does NOT exist!!";
            if (!Arrays.asList(CNSTscriptingController.fontNames).contains("Serif")) {
                fontName = CNSTscriptingController.fontNames[0];
                fontError = fontError + " '" + fontName + "' is used and may not be a vector font!!";
            } else {
                fontName = "Serif";
                fontError = fontError + " '" + fontName + "' is used instead!!";
            }
            CNSTscriptingController.logFileINFO.add(fontError);
        }
        Font f = new Font(fontName, 0, 1000);
        Text lb = new Text(s, layer, f);
        lb.setFontSize(fontSize);
        lb.setRenderReso(CNSTscriptingController.shapeReso);
        Area a = new Area(lb.getArea());
        Rectangle2D rec = a.getBounds2D();
        GArea g = new GArea();
        if (centered) {
            a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX() + x, -rec.getCenterY() + y));
            g = new GArea(a, layer);
            g.setRenderReso(CNSTscriptingController.shapeReso);
        } else {
            a.transform(AffineTransform.getTranslateInstance(x, y));
            g = new GArea(a, layer);
            g.setRenderReso(CNSTscriptingController.shapeReso);
        }
        return g;
    }

    public static void rectangularArray(String[] s, Struct structArr, Struct struct) {
        double x = Double.parseDouble(s[1]);
        double y = Double.parseDouble(s[2]);
        int xColumns = Integer.parseInt(s[3]);
        int yRows = Integer.parseInt(s[4]);
        double xN = Double.parseDouble(s[5]);
        double yN = Double.parseDouble(s[6]);
        if (Integer.parseInt(s[7]) == 1) {
            structArr.add(new Array(struct, x, y, xColumns, yRows, (double)xColumns * xN, (double)yRows * yN));
        } else {
            structArr.add(new Array(struct, x, y, xColumns, yRows, xN, yN));
        }
    }

    public static void hexagonalArray(String[] s, Struct structArr, Struct struct) {
        double x = Double.parseDouble(s[1]);
        double y = Double.parseDouble(s[2]);
        int xColumns = Integer.parseInt(s[3]);
        int yRows = Integer.parseInt(s[4]);
        double deltaX = Double.parseDouble(s[5]);
        double deltaY = 2.0 * deltaX * Math.cos(0.5235987755982988);
        structArr.add(new Array(struct, x, y, xColumns, yRows, (double)xColumns * deltaX, (double)yRows * deltaY));
        structArr.add(new Array(struct, x + deltaX / 2.0, y + deltaY / 2.0, xColumns, yRows, (double)xColumns * deltaX, (double)yRows * deltaY));
    }

    public static void polarArray(String[] s, Struct structArr, Struct struct) {
        boolean rotate = false;
        if (s[7].equals("1") || s[7].equalsIgnoreCase("1R")) {
            rotate = s[7].equalsIgnoreCase("1R");
            CNSTscriptingArrays.generatePolarArrayV1(s, structArr, struct, rotate);
        } else {
            rotate = s[7].equalsIgnoreCase("2R");
            CNSTscriptingArrays.generatePolarArrayV2(s, structArr, struct, rotate);
        }
    }

    public static void generatePolarArrayV1(String[] s, Struct structArr, Struct struct, boolean rotate) {
        double angleStart = Double.parseDouble(s[1]);
        double angleEnd = Double.parseDouble(s[2]);
        double angleInc = Double.parseDouble(s[3]);
        double radiusStart = Double.parseDouble(s[4]);
        double radiusEnd = Double.parseDouble(s[5]);
        double radiusInc = Double.parseDouble(s[6]);
        if (angleStart > angleEnd) {
            angleStart = -(360.0 - angleStart);
        }
        for (double i = angleStart; i <= angleEnd; i += angleInc) {
            for (double j = radiusStart; j <= radiusEnd; j += radiusInc) {
                if (rotate) {
                    structArr.add(new Ref(struct, j * Math.cos(CNSTscriptingArrays.degreeToRadians(i)), j * Math.sin(CNSTscriptingArrays.degreeToRadians(i)), 0, CNSTscriptingArrays.polarAngleRotation(i)));
                    continue;
                }
                structArr.add(new Ref(struct, j * Math.cos(CNSTscriptingArrays.degreeToRadians(i)), j * Math.sin(CNSTscriptingArrays.degreeToRadians(i))));
            }
        }
    }

    public static void generatePolarArrayV2(String[] s, Struct structArr, Struct struct, boolean rotate) {
        double angleStart = Double.parseDouble(s[1]);
        double angleEnd = Double.parseDouble(s[2]);
        int angleNumRegions = Integer.parseInt(s[3]);
        double radiusStart = Double.parseDouble(s[4]);
        double radiusEnd = Double.parseDouble(s[5]);
        int radiusNumRegions = Integer.parseInt(s[6]);
        double angle = angleEnd > angleStart ? Math.abs(angleStart - angleEnd) : 360.0 - Math.abs(angleStart - angleEnd);
        int angleSteps = angleNumRegions;
        double radiusStep = (radiusEnd - radiusStart) / (double)(radiusNumRegions - 1);
        double c = angle * (Math.PI / 180) / (double)(angleSteps - 1);
        for (int i = 0; i < angleSteps; ++i) {
            for (double j = radiusStart; j <= radiusEnd; j += radiusStep) {
                if (rotate) {
                    double rotationAngle = angleStart + (double)i * c * 180.0 / Math.PI;
                    structArr.add(new Ref(struct, j * Math.cos((double)i * c + CNSTscriptingArrays.degreeToRadians(angleStart)), j * Math.sin((double)i * c + CNSTscriptingArrays.degreeToRadians(angleStart)), 0, CNSTscriptingArrays.polarAngleRotation(rotationAngle)));
                    continue;
                }
                structArr.add(new Ref(struct, j * Math.cos((double)i * c + CNSTscriptingArrays.degreeToRadians(angleStart)), j * Math.sin((double)i * c + CNSTscriptingArrays.degreeToRadians(angleStart))));
            }
        }
    }

    public static double polarAngleRotation(double angle) {
        double rotation = 360.0 - (90.0 - angle);
        rotation = rotation >= 360.0 ? rotation - 360.0 : rotation;
        return rotation;
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static void fontExists(String font) {
        boolean b = Arrays.asList(CNSTscriptingController.fontNames).contains(font);
    }

    public static void createVerniers(String[] s, Struct structArr) {
    }
}

