/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class EBLWriteTimeEstimationController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    @FXML
    private TextField tfBeamCurrent;
    @FXML
    private TextField tfDose;
    @FXML
    private TextField tfDieArea;
    @FXML
    private TextField tfFieldsPerDie;
    @FXML
    private TextField tfNumberOfDie;
    @FXML
    private TextField tfEBLsec;
    @FXML
    private TextField tfEBLmin;
    @FXML
    private TextField tfEBLhrs;
    @FXML
    private TextField tfSTAGEsec;
    @FXML
    private TextField tfSTAGEmin;
    @FXML
    private TextField tfSTAGEhrs;
    @FXML
    private TextField tfTOTALsec;
    @FXML
    private TextField tfTOTALmin;
    @FXML
    private TextField tfTOTALhrs;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    EBL Writetime Estimation Module", "This module calculates an estimated electron beam lithography write time. Calculation is based on beam current, die area (written die area in micro-meters squared, value easily obtained from various CAD tools such as LayoutBEAMER), writing dose, fields per die and the number of die. Stage time is estimated at 1second per stage move. This is not quite correct ('estimate') since stage motion depends upon distance traveled, tool (various vintage JEOL tools). The estimated calculation does not take into account tool calibration time.");
        ActionEvent event = new ActionEvent();
        try {
            this.calculateTime(event);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(EBLWriteTimeEstimationController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void calculateTime(ActionEvent event) throws FileNotFoundException {
        DecimalFormat df0 = new DecimalFormat("#");
        DecimalFormat df2 = new DecimalFormat("#.##");
        double beamCurrent = Double.parseDouble(this.tfBeamCurrent.getText());
        double dose = Double.parseDouble(this.tfDose.getText());
        double dieArea = Double.parseDouble(this.tfDieArea.getText());
        int fieldsPerDie = Integer.parseInt(this.tfFieldsPerDie.getText());
        int numberOfDie = Integer.parseInt(this.tfNumberOfDie.getText());
        double areaPerDie = dieArea * 1.0E-4 * 1.0E-4;
        double eblTime = (double)numberOfDie * areaPerDie * (dose * 1.0E-6) / (beamCurrent * 1.0E-9);
        double stageTime = numberOfDie * fieldsPerDie;
        String eblTimeSec = df0.format(eblTime);
        String eblTimeMin = df2.format(eblTime / 60.0);
        String eblTimeHrs = df2.format(eblTime / 3600.0);
        this.tfEBLsec.setText(eblTimeSec);
        this.tfEBLmin.setText(eblTimeMin);
        this.tfEBLhrs.setText(eblTimeHrs);
        String stageTimeSec = df0.format(stageTime);
        String stageTimeMin = df2.format(stageTime / 60.0);
        String stageTimeHrs = df2.format(stageTime / 3600.0);
        this.tfSTAGEsec.setText(stageTimeSec);
        this.tfSTAGEmin.setText(stageTimeMin);
        this.tfSTAGEhrs.setText(stageTimeHrs);
        String totalTimeSec = df0.format(eblTime + stageTime);
        String totalTimeMin = df2.format((eblTime + stageTime) / 60.0);
        String totalTimeHrs = df2.format((eblTime + stageTime) / 3600.0);
        this.tfTOTALsec.setText(totalTimeSec);
        this.tfTOTALmin.setText(totalTimeMin);
        this.tfTOTALhrs.setText(totalTimeHrs);
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

