/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class LabelMakerController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    int displayColor = 0;
    int displayColor2 = 0;
    static File file = null;
    static String[] horzArr;
    static String[] vertArr;
    static String[][] rowColArr;
    String openDir;
    String saveToDir;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfArraySizeX;
    @FXML
    private TextField tfArraySizeY;
    @FXML
    private TextField tfPitchX;
    @FXML
    private TextField tfPitchY;
    @FXML
    private TextField tfFontSize;
    @FXML
    private TextField tfFontResolution;
    @FXML
    private TextField tfLayer;
    @FXML
    private ComboBox<String> cbFontList;
    @FXML
    private ComboBox<String> cbLabelType;
    @FXML
    private Label lLabelFileStatus;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Label Maker Module", "This module creates text labels for an array of chips. User defined and automatically generated labels are available.");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.cbFontList.getItems().add((Object)fontFamilies[i]);
        }
        this.cbFontList.setValue((Object)"Serif");
        this.cbFontList.setVisibleRowCount(11);
        this.cbLabelType.getItems().addAll((Object[])new String[]{"Outer", "Row-Column", "Outer Custom (from file)", "Row-Column Custom (from file)"});
        this.cbLabelType.setValue((Object)"Outer");
        this.cbLabelType.setVisibleRowCount(4);
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(LabelMakerController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double pitchX = Double.parseDouble(this.tfPitchX.getText());
        double pitchY = Double.parseDouble(this.tfPitchY.getText());
        double fontSize = Double.parseDouble(this.tfFontSize.getText());
        double fontResolution = Double.parseDouble(this.tfFontResolution.getText());
        int arraySizeX = Integer.parseInt(this.tfArraySizeX.getText());
        int arraySizeY = Integer.parseInt(this.tfArraySizeY.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String fileName = this.tfFileName.getText();
        String fontType = (String)this.cbFontList.getValue();
        String labelType = (String)this.cbLabelType.getValue();
        Lib lib = new Lib();
        if ("Outer".equals(labelType) || "Row-Column".equals(labelType)) {
            Struct[] numArr = LabelMakerController.numberArray(fontType, fontSize, fontResolution, layer);
            int[] numAdv = this.numberAdvance(fontType, fontSize);
            if ("Outer".equals(labelType)) {
                LabelMakerController.outer(lib, arraySizeX, arraySizeY, pitchX, pitchY, numArr, numAdv);
            }
            if ("Row-Column".equals(labelType)) {
                Struct top = new Struct("top");
                LabelMakerController.rowCol(arraySizeX, arraySizeY, pitchX, pitchY, top, numArr, numAdv);
                lib.add(new Ref(top, 0.0, 0.0));
            }
        }
        if ("Outer Custom (from file)".equals(labelType) || "Row-Column Custom (from file)".equals(labelType)) {
            String fontFile = file.getPath();
            if (fontFile != null) {
                Struct[] asciiArr = LabelMakerController.asciiArray(fontType, fontSize, fontResolution, layer);
                int[] asciiAdv = this.asciiAdvance(fontType, fontSize);
                if ("Outer Custom (from file)".equals(labelType)) {
                    LabelMakerController.outerCustom(lib, arraySizeX, arraySizeY, pitchX, pitchY, asciiArr, asciiAdv);
                }
                if ("Row-Column Custom (from file)".equals(labelType)) {
                    Struct top = new Struct("top");
                    LabelMakerController.rowColCustom(arraySizeX, arraySizeY, pitchX, pitchY, top, asciiArr, asciiAdv);
                    lib.add(new Ref(top, 0.0, 0.0));
                }
            } else {
                this.lLabelFileStatus.setText("ERROR: LABEL FILE MISSING!!");
                this.lLabelFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
                this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
            }
        }
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void loadLabel(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Label Maker Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        this.lLabelFileStatus.setText("Label File: " + file.getName());
        this.lLabelFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
        this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
    }

    static void outer(Lib lib, int sizeX, int sizeY, double pitchX, double pitchY, Struct[] numArray, int[] numAdvance) {
        int itmp;
        char c;
        int j;
        int advanceCounter;
        String s;
        int i;
        Struct horizntlLbl = new Struct("0HorizontalLabel");
        Struct verticalLbl = new Struct("0VerticalLabel");
        for (i = 1; i <= sizeX; ++i) {
            s = Integer.toString(i);
            advanceCounter = 0;
            for (j = 0; j < s.length(); ++j) {
                c = s.charAt(j);
                itmp = Character.getNumericValue(c);
                if (j > 0) {
                    advanceCounter += numAdvance[itmp];
                }
                horizntlLbl.add(new Ref(numArray[itmp], (double)(i - 1) * pitchX + (double)advanceCounter, 0.0));
            }
        }
        for (i = 1; i <= sizeY; ++i) {
            s = Integer.toString(i);
            advanceCounter = 0;
            for (j = 0; j < s.length(); ++j) {
                c = s.charAt(j);
                itmp = Character.getNumericValue(c);
                if (j > 0) {
                    advanceCounter += numAdvance[itmp];
                }
                verticalLbl.add(new Ref(numArray[itmp], advanceCounter, (double)(-(i - 1)) * pitchY));
            }
        }
        lib.add(new Ref(horizntlLbl, 0.0, 0.0));
        lib.add(new Ref(verticalLbl, 0.0, 0.0));
    }

    static void rowCol(int sizeX, int sizeY, double pitchX, double pitchY, Struct top, Struct[] numArray, int[] numAdvance) {
        for (int i = 1; i <= sizeY; ++i) {
            for (int j = 1; j <= sizeX; ++j) {
                int itmp;
                int k;
                String s = i + "," + j;
                char[] c = s.toCharArray();
                int[] iArry = new int[c.length];
                int advanceCounter = 0;
                for (k = 0; k < c.length; ++k) {
                    if (c[k] == ',') {
                        iArry[k] = numAdvance[10];
                        continue;
                    }
                    itmp = Character.getNumericValue(c[k]);
                    iArry[k] = numAdvance[itmp];
                }
                for (k = 0; k < c.length; ++k) {
                    itmp = Character.getNumericValue(c[k]);
                    if (k > 0) {
                        advanceCounter += iArry[k - 1];
                    }
                    if (c[k] == ',') {
                        top.add(new Ref(numArray[10], (double)(j - 1) * pitchX + (double)advanceCounter, (double)(-(i - 1)) * pitchY));
                        continue;
                    }
                    top.add(new Ref(numArray[itmp], (double)(j - 1) * pitchX + (double)advanceCounter, (double)(-(i - 1)) * pitchY));
                }
            }
        }
    }

    static void outerCustom(Lib lib, int arraySizeX, int arraySizeY, double pitchX, double pitchY, Struct[] asciiArray, int[] asciiAdvance) {
        LabelMakerController.readHorizVert(arraySizeX, arraySizeY);
        LabelMakerController.horizStructures(lib, pitchX, asciiArray, asciiAdvance);
        LabelMakerController.vertStructures(lib, pitchY, asciiArray, asciiAdvance);
    }

    static void horizStructures(Lib lib, double pitchX, Struct[] asciiArray, int[] asciiAdvance) {
        Struct horizntlLbl = new Struct("0HorizontalLabel");
        for (int i = 0; i < horzArr.length; ++i) {
            char[] c = horzArr[i].toCharArray();
            int[] iAscii = LabelMakerController.hvAdvance(c);
            int advanceCounter = 0;
            for (int j = 0; j < iAscii.length; ++j) {
                if (j > 0) {
                    advanceCounter += asciiAdvance[iAscii[j - 1]];
                }
                horizntlLbl.add(new Ref(asciiArray[iAscii[j]], (double)i * pitchX + (double)advanceCounter, 0.0));
            }
        }
        lib.add(new Ref(horizntlLbl, 0.0, 0.0));
    }

    static void vertStructures(Lib lib, double pitchY, Struct[] asciiArray, int[] asciiAdvance) {
        Struct verticalLbl = new Struct("0VerticalLabel");
        for (int i = 0; i < vertArr.length; ++i) {
            char[] c = vertArr[i].toCharArray();
            int[] iAscii = LabelMakerController.hvAdvance(c);
            int advanceCounter = 0;
            for (int j = 0; j < iAscii.length; ++j) {
                if (j > 0) {
                    advanceCounter += asciiAdvance[iAscii[j - 1]];
                }
                verticalLbl.add(new Ref(asciiArray[iAscii[j]], advanceCounter, -((double)i * pitchY)));
            }
        }
        lib.add(new Ref(verticalLbl, 0.0, 0.0));
    }

    static int[] hvAdvance(char[] c) {
        int[] iArr = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            char iCharAdv = c[i];
            iArr[i] = iCharAdv - 32;
        }
        return iArr;
    }

    static void readHorizVert(int arraySizeX, int arraySizeY) {
        horzArr = new String[arraySizeX];
        vertArr = new String[arraySizeY];
        horzArr = LabelMakerController.fillArray(horzArr);
        vertArr = LabelMakerController.fillArray(vertArr);
        LabelMakerController.getHorizVertData();
    }

    static void getHorizVertData() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file.getPath()));
            String horizontal = in.readLine();
            String vertical = in.readLine();
            in.close();
            String[] horizSplit = horizontal.split("\t");
            String[] vertSplit = vertical.split("\t");
            LabelMakerController.setHorizVertData(horizSplit, vertSplit);
        }
        catch (IOException e) {
            System.out.println("There was a problem:" + e);
        }
    }

    static void setHorizVertData(String[] h, String[] v) {
        if (horzArr.length >= h.length) {
            LabelMakerController.setHorizData(h, h.length);
        } else {
            LabelMakerController.setHorizData(h, horzArr.length);
        }
        if (vertArr.length >= v.length) {
            LabelMakerController.setVertData(v, v.length);
        } else {
            LabelMakerController.setVertData(v, vertArr.length);
        }
    }

    static void setHorizData(String[] h, int l) {
        for (int i = 0; i < l; ++i) {
            LabelMakerController.horzArr[i] = h[i];
        }
    }

    static void setVertData(String[] v, int l) {
        for (int i = 0; i < l; ++i) {
            LabelMakerController.vertArr[i] = v[i];
        }
    }

    static void rowColCustom(int arraySizeX, int arraySizeY, double pitchX, double pitchY, Struct top, Struct[] asciiArray, int[] asciiAdvance) {
        LabelMakerController.readRowCol(arraySizeX, arraySizeY);
        LabelMakerController.rowColStructures(pitchX, pitchY, top, asciiArray, asciiAdvance);
    }

    static void rowColStructures(double pitchX, double pitchY, Struct top, Struct[] asciiArray, int[] asciiAdvance) {
        for (int i = 0; i < rowColArr.length; ++i) {
            for (int j = 0; j < rowColArr[0].length; ++j) {
                char[] c = rowColArr[i][j].toCharArray();
                int[] iAscii = LabelMakerController.hvAdvance(c);
                int advanceCounter = 0;
                for (int k = 0; k < iAscii.length; ++k) {
                    if (k > 0) {
                        advanceCounter += asciiAdvance[iAscii[k - 1]];
                    }
                    top.add(new Ref(asciiArray[iAscii[k]], (double)j * pitchX + (double)advanceCounter, -((double)i * pitchY)));
                }
            }
        }
    }

    static void readRowCol(int arraySizeX, int arraySizeY) {
        rowColArr = new String[arraySizeY][arraySizeX];
        rowColArr = LabelMakerController.fillArray(rowColArr);
        LabelMakerController.getRowColData();
    }

    static void getRowColData() {
        String[] readData = new String[rowColArr.length];
        try {
            BufferedReader in = new BufferedReader(new FileReader(file.getPath()));
            for (int i = 0; i < rowColArr.length; ++i) {
                String read = in.readLine();
                if (read == null) continue;
                readData[i] = read;
            }
            in.close();
            LabelMakerController.setRowColData(readData);
        }
        catch (IOException e) {
            System.out.println("There was a problem:" + e);
        }
    }

    static void setRowColData(String[] rc) {
        for (int i = 0; i < rowColArr.length; ++i) {
            String[] tempStrArr = rc[i].split("\t");
            if (rowColArr[0].length >= tempStrArr.length) {
                LabelMakerController.setRowColArr(tempStrArr, tempStrArr.length, i);
                continue;
            }
            LabelMakerController.setRowColArr(tempStrArr, rowColArr[0].length, i);
        }
    }

    static void setRowColArr(String[] sa, int l, int cnt) {
        for (int i = 0; i < l; ++i) {
            LabelMakerController.rowColArr[cnt][i] = sa[i];
        }
    }

    static String[] fillArray(String[] sa) {
        Arrays.fill(sa, "0");
        return sa;
    }

    static int[] fillArray(int[] ia) {
        Arrays.fill(ia, 0);
        return ia;
    }

    static String[][] fillArray(String[][] sa) {
        for (int i = 0; i < sa.length; ++i) {
            Arrays.fill(sa[i], "0");
        }
        return sa;
    }

    static int[][] fillArray(int[][] ia) {
        for (int i = 0; i < ia.length; ++i) {
            Arrays.fill(ia[i], 0);
        }
        return ia;
    }

    static Struct[] numberArray(String fontType, double fontSize, double fontResolution, int layer) {
        Struct[] numArray = new Struct[11];
        String textString = "";
        Font font = new Font(fontType, 0, 1000);
        for (int i = 0; i < numArray.length; ++i) {
            Struct tmpLabel;
            textString = i == numArray.length - 1 ? "," : "" + i;
            Text lb = new Text(textString, layer, font);
            lb.setFontSize(fontSize);
            lb.setRenderReso(fontResolution);
            if (i == numArray.length - 1) {
                textString = "comma";
            }
            numArray[i] = tmpLabel = new Struct("zNumber_" + textString, lb);
        }
        return numArray;
    }

    public int[] numberAdvance(String font, double fontSize) {
        int textSizeINT = (int)fontSize;
        int[] numAdvance = new int[11];
        String tempStr = "";
        Font defaultFont = new Font(font, 0, textSizeINT);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(defaultFont);
        for (int i = 0; i < numAdvance.length; ++i) {
            tempStr = i == numAdvance.length - 1 ? "," : "" + i;
            numAdvance[i] = fm.stringWidth(tempStr);
        }
        return numAdvance;
    }

    static Struct[] asciiArray(String fontType, double fontSize, double fontResolution, int layer) {
        Struct[] asciiArr = new Struct[95];
        Font font = new Font(fontType, 0, 1000);
        for (int i = 0; i < asciiArr.length; ++i) {
            Struct tmpLabel;
            char c = (char)(i + 32);
            String s = Character.toString(c);
            Text lb = new Text(s, layer, font);
            lb.setFontSize(fontSize);
            lb.setRenderReso(fontResolution);
            asciiArr[i] = tmpLabel = new Struct("zASCIIchar_" + (i + 32), lb);
        }
        return asciiArr;
    }

    public int[] asciiAdvance(String font, double fontSize) {
        int textSizeINT = (int)fontSize;
        int[] asciiAdv = new int[95];
        Font defaultFont = new Font(font, 0, textSizeINT);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(defaultFont);
        for (int i = 0; i < asciiAdv.length; ++i) {
            char c = (char)(i + 32);
            String s = Character.toString(c);
            asciiAdv[i] = fm.stringWidth(s);
        }
        return asciiAdv;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

