/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.Fractals;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class FractalsController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfCellNamePrefix;
    @FXML
    private TextField tfIterations;
    @FXML
    private TextField tfLength;
    @FXML
    private TextField tfWidth;
    @FXML
    private ComboBox<String> cbFractalType;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Fractals Module", "This module creates Sierpinski triangles and curved tree fractals. Fractals are useful in many areas of applied sciences. For instance, Sierpinski structures (triangles and carpets) have been utilized as fractal antennas due to their self similar and scale invariant properties, thereby easily accommodating multiple frequencies. Curved tree fractal could find applications within the MEMS/NEMS arena as well as in sorting micro- and nano-fluidics.");
        this.cbFractalType.getItems().addAll((Object[])new String[]{"Sierpinski Triangle", "Sierpinski Carpet", "Curved Tree", "Vicsek Saltire", "Vicsek Cross"});
        this.cbFractalType.setValue((Object)"Sierpinski Triangle");
        this.cbFractalType.setVisibleRowCount(5);
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(FractalsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double posX = Double.parseDouble(this.tfPosX.getText());
        double posY = Double.parseDouble(this.tfPosY.getText());
        double length = Double.parseDouble(this.tfLength.getText());
        double width = Double.parseDouble(this.tfWidth.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        int iterations = Integer.parseInt(this.tfIterations.getText());
        String cellNamePrefix = this.tfCellNamePrefix.getText();
        String fileName = this.tfFileName.getText();
        String fractalType = (String)this.cbFractalType.getValue();
        Lib lib = new Lib();
        Struct top = new Struct("top");
        switch (fractalType) {
            case "Sierpinski Triangle": {
                top.add(new Ref(Fractals.createSierpinskiTriangle(iterations, length, layer, cellNamePrefix), posX, posY));
                break;
            }
            case "Sierpinski Carpet": {
                top.add(new Ref(Fractals.createSierpinskiCarpet(iterations, length, layer, cellNamePrefix), posX, posY));
                break;
            }
            case "Curved Tree": {
                top.add(new Ref(Fractals.createCurvedTree(cellNamePrefix, width, length, iterations, layer), posX, posY));
                break;
            }
            case "Vicsek Saltire": {
                top.add(new Ref(Fractals.createVicsekSaltire(iterations, length, layer, cellNamePrefix), posX, posY));
                break;
            }
            case "Vicsek Cross": {
                top.add(new Ref(Fractals.createVicsekCross(iterations, length, layer, cellNamePrefix), posX, posY));
            }
        }
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

