/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.BarCode;
import JGDS2.Constants;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.GDSReader;
import JGDS2.GDSWriter;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class frameTestTest
implements Constants {
    public static void main(String[] args) {
        try {
            File f = new File("ASTest.gds");
            FileOutputStream fileOUT = new FileOutputStream(f);
            DataOutputStream dO = new DataOutputStream(fileOUT);
            GDSWriter g = new GDSWriter(dO);
            Lib lib = new Lib();
            Struct top = new Struct("top");
            Struct up = new Struct("up");
            lib.add(new Ref(top, 0.0, 0.0));
            boolean LINE = false;
            boolean VIA = true;
            boolean LF = false;
            boolean DF = true;
            boolean LINETYPE = LINE;
            boolean POLARITY = LF;
            boolean PS = false;
            int[] step = new int[]{50};
            int[] size = new int[]{750};
            int length = 2500;
            int tl = length + 200;
            double[] x = new double[]{0.0, tl, 2 * tl};
            double[] y = new double[]{0.0, 1200.0, 2400.0, 3600.0, 4800.0, 6000.0, 7200.0, 8400.0, 9600.0, 10800.0, 12000.0};
            double duty = 2.0;
            int yOff = 0;
            Struct quart = new Struct("quart");
            quart.add(new Ref(up, tl, 0.0));
            top.add(new Ref(quart, 0.0, 0.0));
            top.add(new Ref(quart, 0.0, 0.0, 0, 90.0));
            LINETYPE = VIA;
            duty = 6.0;
            POLARITY = DF;
            up.add(new Ref(frameTestTest.lineWidth(size, step, duty, POLARITY, LINETYPE, PS, length, 8), x[2], y[++yOff]));
            lib.GDSOut(g);
            System.out.println(" Saved to " + f.getAbsolutePath());
            System.out.println("" + GDSReader.readFile(f.getAbsolutePath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("done");
    }

    public static Struct lineWidth(int[] size, int[] step, double duty, boolean DF, boolean VA, boolean PS, double length, int numLines) {
        int textSize = 25;
        String sDF = DF ? "N" : "";
        String sVia = VA ? "V" : "";
        String sPS = PS ? "P" : "";
        int sizeMin = size[0];
        int sizeMax = size[size.length - 1];
        int sn = 0;
        int MinSep = 5;
        Struct f = new Struct(sDF + sVia + sPS + "G_" + sizeMin + "_" + sizeMax + "_" + numLines + "_" + GDS2.val(duty));
        int del = 0;
        for (int n = sizeMin; n <= sizeMax; n += step[sn]) {
            if (n < sizeMax && n >= size[sn + 1]) {
                ++sn;
            }
            double s = (double)n * 0.001;
            Struct text = new Struct("text_" + n, new Text("" + n, 2, textSize));
            if (VA) {
                Struct vLine;
                GArea v = new GArea(new RectArea(0.0, 0.0, s, s, 2), 2);
                Struct via = new Struct("via_" + n, v);
                int num = (int)(length / (s * duty));
                double len = (double)numLines * duty * s;
                double len2 = (double)num * (s * duty);
                double theta = Math.atan2(numLines, 1.1);
                if (numLines == 1) {
                    theta = 0.0;
                }
                if (PS) {
                    theta = 1.578;
                }
                Double angle = theta / 3.141592653589 * 180.0;
                if (PS) {
                    GArea vp = new GArea(new RectArea(0.0, 0.0, s, s, 2), 3);
                    Struct viap = new Struct("viap_" + n, vp);
                    vLine = new Struct("vlp_" + n + "_" + GDS2.val(duty) + "_" + numLines, new Array(viap, 0.0, 0.0, numLines / 2, 2, len * Math.cos(theta), len * Math.sin(theta), len * (1.0 + Math.cos(theta)) / (double)numLines * 2.0, len * (1.0 + Math.sin(theta)) / (double)numLines, angle));
                    vLine.add(new Array(via, len * Math.cos(theta) / (double)numLines, len * Math.sin(theta) / (double)numLines, numLines / 2, 2, len * Math.cos(theta), len * Math.sin(theta), len * (1.0 - Math.cos(theta)) / (double)numLines * 2.0, -len * (1.0 + Math.sin(theta)) / (double)numLines, angle));
                } else {
                    vLine = new Struct("vl_" + n + "_" + GDS2.val(duty) + "_" + numLines, new Array(via, 0.0, 0.0, numLines, 1, len * Math.cos(theta), len * Math.sin(theta), 0.0, 0.0, angle));
                }
                if (DF) {
                    GArea nv = new GArea(new RectArea(-s * (duty - 1.0) * 0.75, -s * (duty - 1.0) * 0.75, s + s * (duty - 1.0) * 0.75, s + s * (duty - 1.0) * 0.75, 2), 2);
                    nv.subtract(v);
                    Struct nvia = new Struct("Nv_" + n + "_" + GDS2.val(duty), nv);
                    Struct nvLine = new Struct("Nvl_" + n + "_" + GDS2.val(duty) + "_" + numLines, new Array(nvia, 0.0, 0.0, numLines, 1, len * Math.cos(theta), len * Math.sin(theta), 0.0, 0.0, angle));
                    f.add(new Array(nvLine, -length - 20.0, (double)del + (double)textSize / 3.0, num, 1, len2, 1.0));
                } else {
                    f.add(new Array(vLine, -length - 20.0, (double)del + (double)textSize / 3.0, num / 2, 1, len2, 1.0));
                }
            } else if (DF) {
                GArea ng = new GArea(new RectArea(-10.0, -((duty - 1.0) * s) * 0.75, length + 10.0, s + (duty - 1.0) * s * 0.75, 2), 2);
                GArea g = new GArea(new RectArea(0.0, 0.0, length, s, 2), 2);
                ng.subtract(g);
                Struct nbar = new Struct("Nbar_" + n + "_" + GDS2.val(duty), ng);
                f.add(new Array(nbar, -length - 20.0, (double)del + (double)textSize / 3.0, 1, numLines, 1.0, s * (double)numLines * duty));
            } else {
                int psn = (int)((double)numLines / 2.0 + 0.5);
                int nL = numLines / (PS ? 2 : 1);
                Struct bar = new Struct("bar_" + n, new RectArea(0.0, 0.0, length, (double)n / 1000.0, 2));
                f.add(new Array(bar, -length - 20.0, (double)del + (double)textSize / 3.0 + (PS ? s * duty : 0.0), 1, nL, 1.0, s * (double)nL * (double)(PS ? 2 : 1) * duty));
                if (PS) {
                    Struct pbar = new Struct("PSbar_" + n, new RectArea(0.0, 0.0, length, (double)n / 1000.0, 3));
                    f.add(new Array(pbar, -length - 20.0, (double)del + (double)textSize / 3.0, 1, psn, 1.0, s * (double)(psn * 2) * duty));
                }
            }
            f.add(new Ref(text, 0.0, del));
            del += duty * s * (double)numLines + 5.0 > (double)(textSize + MinSep) ? (int)(s * duty * (double)numLines + 5.0) : textSize + MinSep;
        }
        return f;
    }

    public static GArea torus(double inSize, double outSize) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(inSize, 0.0);
        int points = 120;
        double delta = Math.PI * 2 / (double)points;
        for (i = 1; i < points; ++i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(inSize, 0.0);
        poly.moveTo(outSize, 0.0);
        for (i = points - 1; i > 0; --i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(outSize, 0.0);
        poly.moveTo(inSize, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, 1);
        return v;
    }

    public static Struct star(double size, int numlines, boolean ps, double duty) {
        int i;
        if (numlines < 2) {
            numlines = 2;
        }
        String sPS = ps ? "P" : "";
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(size, 0.0);
        double angle = Math.PI / (double)numlines;
        poly.lineTo(size * Math.cos(angle * duty), size * Math.sin(angle * duty));
        poly.closePath();
        GArea v = new GArea(poly, 1);
        Struct f = new Struct("star_bar" + (int)size + "_" + numlines + "_" + GDS2.val(duty), v);
        Struct lf = new Struct(sPS + "star_" + (int)size + "_" + numlines + "_" + GDS2.val(duty));
        angle = 360.0 / (double)numlines;
        int n = i = ps ? 1 : 0;
        while (i < numlines) {
            lf.add(new Ref(f, 0.0, 0.0, 0, angle * (double)i));
            i += ps ? 2 : 1;
        }
        if (ps) {
            GArea vp = new GArea(poly, 3);
            Struct pf = new Struct(sPS + "star_bar" + (int)size + "_" + numlines + "_" + GDS2.val(duty), vp);
            for (int i2 = 0; i2 < numlines; i2 += 2) {
                lf.add(new Ref(pf, 0.0, 0.0, 0, angle * (double)i2));
            }
        }
        String hc = "" + numlines + "_" + size;
        String n2 = sPS + "_" + (double)GDS2.val(duty) / 1000.0 + "_" + hc;
        Struct text = new Struct("text_" + n2, new Text("" + n2, 2, size / 8.0));
        lf.add(new Ref(text, size / 2.0, -size));
        return lf;
    }

    public static Struct frame(int tool, String barcode, String label) {
        Struct f = new Struct("frame");
        switch (tool) {
            case 1: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct l = new Struct("l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(l, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode, 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label, 1, 3500.0);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
                break;
            }
            case 0: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct l = new Struct("l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(l, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode, 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label, 1, 3500.0);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
            }
        }
        return f;
    }
}

