/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.BarCode;
import JGDS2.Constants;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.GDSReader;
import JGDS2.GDSWriter;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class fidMatrix
implements Constants {
    public static void main(String[] args) {
        try {
            File f = new File("fidmat.gds");
            FileOutputStream fileOUT = new FileOutputStream(f);
            DataOutputStream dO = new DataOutputStream(fileOUT);
            GDSWriter g = new GDSWriter(dO);
            Lib lib = new Lib();
            Struct top = new Struct("top");
            lib.add(new Ref(top, 0.0, 0.0));
            double[] size = new double[]{1000.0, 0.16, 0.18, 0.2, 0.4, 0.5, 0.8, 1.0, 1.5, 2.0, 3.0, 5.0, 7.5, 10.0, 15.0, 20.0, 30.0, 50.0, 75.0, 100.0, 150.0, 200.0, 300.0, 500.0, 750.0};
            double[] del = new double[]{0.5, 1.75, 2.5, 3.25, 4.0, 4.75, 5.5, 6.25, 7.0, 7.75, 8.5, 9.25, 10.0, 10.75, 11.5, 12.25, 13.0, 13.75, 14.5, 15.25, 16.0, 17.0, 18.0, 19.25, 20.75};
            top.add(new Ref(fidMatrix.lineWidth(size, del), -11000.0, -11000.0));
            lib.GDSOut(g);
            System.out.println(" Saved to " + f.getAbsolutePath());
            System.out.println("" + GDSReader.readFile(f.getAbsolutePath()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("done");
    }

    public static Struct lineWidth(double[] size, double[] del) {
        Struct f = new Struct("RectArray");
        for (int j = 0; j < size.length; ++j) {
            for (int i = 0; i < size.length; ++i) {
                RectArea r = new RectArea(del[j] * 1000.0 - size[j] / 2.0, del[i] * 1000.0 - size[i] / 2.0, del[j] * 1000.0 + size[j] / 2.0, del[i] * 1000.0 + size[i] / 2.0, 1);
                f.add(r);
            }
        }
        return f;
    }

    public static GArea torus(double inSize, double outSize) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(inSize, 0.0);
        int points = 120;
        double delta = Math.PI * 2 / (double)points;
        for (i = 1; i < points; ++i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(inSize, 0.0);
        poly.moveTo(outSize, 0.0);
        for (i = points - 1; i > 0; --i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(outSize, 0.0);
        poly.moveTo(inSize, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, 1);
        return v;
    }

    public static Struct star(double size, int numlines, boolean ps, double duty) {
        int i;
        if (numlines < 2) {
            numlines = 2;
        }
        String sPS = ps ? "P" : "";
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(size, 0.0);
        double angle = Math.PI / (double)numlines;
        poly.lineTo(size * Math.cos(angle * duty), size * Math.sin(angle * duty));
        poly.closePath();
        GArea v = new GArea(poly, 1);
        Struct f = new Struct("star_bar" + (int)size + "_" + numlines + "_" + GDS2.val(duty), v);
        Struct lf = new Struct(sPS + "star_" + (int)size + "_" + numlines + "_" + GDS2.val(duty));
        angle = 360.0 / (double)numlines;
        int n = i = ps ? 1 : 0;
        while (i < numlines) {
            lf.add(new Ref(f, 0.0, 0.0, 0, angle * (double)i));
            i += ps ? 2 : 1;
        }
        if (ps) {
            GArea vp = new GArea(poly, 3);
            Struct pf = new Struct(sPS + "star_bar" + (int)size + "_" + numlines + "_" + GDS2.val(duty), vp);
            for (int i2 = 0; i2 < numlines; i2 += 2) {
                lf.add(new Ref(pf, 0.0, 0.0, 0, angle * (double)i2));
            }
        }
        String hc = "" + numlines + "_" + size;
        String n2 = sPS + "_" + (double)GDS2.val(duty) / 1000.0 + "_" + hc;
        Struct text = new Struct("text_" + n2, new Text("" + n2, 2, size / 8.0));
        lf.add(new Ref(text, size / 2.0, -size));
        return lf;
    }

    public static Struct frame(int tool, String barcode, String label) {
        Struct f = new Struct("frame");
        switch (tool) {
            case 1: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct l = new Struct("l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(l, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode, 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label, 1, 3500.0);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
                break;
            }
            case 0: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct l = new Struct("l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(l, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode, 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label, 1, 3500.0);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
            }
        }
        return f;
    }
}

