/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNST.Scripting;
import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class MEMSbeams {
    public static ArrayList<GArea> createCantileverLinear(double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double linearVar) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        alGA.add(MEMSbeams.createCantileverBase(width, pitch, baseHeight, baseExtent, numElements));
        for (int i = 0; i < numElements; ++i) {
            alGA.add(new GArea(new Rect(baseExtent + (double)i * pitch, baseHeight, baseExtent + (double)i * pitch + width, baseHeight + startL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            startL += linearVar;
        }
        return alGA;
    }

    public static ArrayList<GArea> createCantileverPercentage(double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double percentageVar) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        alGA.add(MEMSbeams.createCantileverBase(width, pitch, baseHeight, baseExtent, numElements));
        for (int i = 0; i < numElements; ++i) {
            alGA.add(new GArea(new Rect(baseExtent + (double)i * pitch, baseHeight, baseExtent + (double)i * pitch + width, baseHeight + startL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            startL *= 1.0 + percentageVar / 100.0;
        }
        return alGA;
    }

    public static ArrayList<GArea> createCantileverSinusoid(double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double sineAmplitude) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        alGA.add(MEMSbeams.createCantileverBase(width, pitch, baseHeight, baseExtent, numElements));
        double sinInc = Math.PI * 2 / (double)numElements;
        for (int i = 0; i < numElements; ++i) {
            double sineLength = startL + sineAmplitude * Math.sin((double)i * sinInc);
            alGA.add(new GArea(new Rect(baseExtent + (double)i * pitch, baseHeight, baseExtent + (double)i * pitch + width, baseHeight + sineLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        }
        return alGA;
    }

    public static ArrayList<GArea> createCantileverLinearSE(double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        alGA.add(MEMSbeams.createCantileverBase(width, pitch, baseHeight, baseExtent, numElements));
        double deltaLinSE = (endL - startL) / (double)(numElements - 1);
        for (int i = 0; i < numElements; ++i) {
            alGA.add(new GArea(new Rect(baseExtent + (double)i * pitch, baseHeight, baseExtent + (double)i * pitch + width, baseHeight + startL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            startL += deltaLinSE;
        }
        return alGA;
    }

    public static ArrayList<GArea> createCantileverNonLinearSE(double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        alGA.add(MEMSbeams.createCantileverBase(width, pitch, baseHeight, baseExtent, numElements));
        double[] nonlinSE = MEMSbeams.calculateRampNonLinearSE(startL, endL, numElements);
        for (int i = 0; i < numElements; ++i) {
            alGA.add(new GArea(new Rect(baseExtent + (double)i * pitch, baseHeight, baseExtent + (double)i * pitch + width, baseHeight + nonlinSE[i], CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        }
        return alGA;
    }

    public static ArrayList<GArea> createCantileverCustom(ArrayList<Double> al) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double baseHeight = al.get(al.size() - 2);
        double baseWidth = 0.0;
        double xPos = 0.0;
        for (int i = 2; i < al.size() - 3; i += 3) {
            baseWidth = baseWidth + al.get(i) + al.get(i + 1);
            alGA.add(new GArea(new Rect(xPos + al.get(i), baseHeight, xPos + al.get(i) + al.get(i + 1), baseHeight + al.get(i + 2), CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            xPos = xPos + al.get(i) + al.get(i + 1);
        }
        alGA.add(new GArea(new Rect(0.0, 0.0, baseWidth += al.get(al.size() - 3).doubleValue(), baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamLinear(double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double linearVar) {
        ArrayList<GArea> alGA = MEMSbeams.createCantileverLinear(width, startL, pitch, numElements, baseHeight, baseExtent, linearVar);
        double xPos = baseExtent + width / 2.0 + pitch / 2.0;
        double endLength = startL + (double)(numElements - 1) * linearVar;
        GArea temp = new GArea(new Rect(0.0, baseHeight + startL, xPos - pitch, 2.0 * baseHeight + endLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        for (int i = 0; i < numElements; ++i) {
            temp.or(new GArea(new Rect(xPos + (double)i * pitch - pitch, baseHeight + startL, xPos + (double)i * pitch, 2.0 * baseHeight + endLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            startL += linearVar;
        }
        temp.or(new GArea(new Rect(xPos + (double)(numElements - 1) * pitch, baseHeight + endLength, xPos + (double)(numElements - 1) * pitch - pitch / 2.0 + width / 2.0 + baseExtent, 2.0 * baseHeight + endLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        alGA.add(temp);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamPercentage(double width, double startL, double pitch, int numElements, double baseHeight, double baseExtent, double percentageVar) {
        ArrayList<GArea> alGA = MEMSbeams.createCantileverPercentage(width, startL, pitch, numElements, baseHeight, baseExtent, percentageVar);
        double xPos = baseExtent + width / 2.0 + pitch / 2.0;
        double endLength = startL;
        for (int i = 0; i < numElements - 1; ++i) {
            endLength *= 1.0 + percentageVar / 100.0;
        }
        GArea temp = new GArea(new Rect(0.0, baseHeight + startL, xPos - pitch, 2.0 * baseHeight + endLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        for (int i = 0; i < numElements; ++i) {
            temp.or(new GArea(new Rect(xPos + (double)i * pitch - pitch, baseHeight + startL, xPos + (double)i * pitch, 2.0 * baseHeight + endLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            startL = i < numElements - 1 ? startL * (1.0 + percentageVar / 100.0) : startL;
        }
        temp.or(new GArea(new Rect(xPos + (double)(numElements - 1) * pitch, baseHeight + endLength, xPos + (double)(numElements - 1) * pitch - pitch / 2.0 + width / 2.0 + baseExtent, 2.0 * baseHeight + endLength, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        alGA.add(temp);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamLinearSE(double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent) {
        ArrayList<GArea> alGA = MEMSbeams.createCantileverLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent);
        double xPos = baseExtent + width / 2.0 + pitch / 2.0;
        double deltaLinSE = (endL - startL) / (double)(numElements - 1);
        GArea temp = new GArea(new Rect(0.0, baseHeight + startL, xPos - pitch, 2.0 * baseHeight + endL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        for (int i = 0; i < numElements; ++i) {
            temp.or(new GArea(new Rect(xPos + (double)i * pitch - pitch, baseHeight + startL, xPos + (double)i * pitch, 2.0 * baseHeight + endL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            startL += deltaLinSE;
        }
        temp.or(new GArea(new Rect(xPos + (double)(numElements - 1) * pitch, baseHeight + endL, xPos + (double)(numElements - 1) * pitch - pitch / 2.0 + width / 2.0 + baseExtent, 2.0 * baseHeight + endL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        alGA.add(temp);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamNonLinearSE(double width, double startL, double endL, double pitch, int numElements, double baseHeight, double baseExtent) {
        ArrayList<GArea> alGA = MEMSbeams.createCantileverNonLinearSE(width, startL, endL, pitch, numElements, baseHeight, baseExtent);
        double xPos = baseExtent + width / 2.0 + pitch / 2.0;
        double[] nonlinSE = MEMSbeams.calculateRampNonLinearSE(startL, endL, numElements);
        GArea temp = new GArea(new Rect(0.0, baseHeight + startL, xPos - pitch, 2.0 * baseHeight + endL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        for (int i = 0; i < numElements; ++i) {
            temp.or(new GArea(new Rect(xPos + (double)i * pitch - pitch, baseHeight + nonlinSE[i], xPos + (double)i * pitch, 2.0 * baseHeight + endL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        }
        temp.or(new GArea(new Rect(xPos + (double)(numElements - 1) * pitch, baseHeight + endL, xPos + (double)(numElements - 1) * pitch - pitch / 2.0 + width / 2.0 + baseExtent, 2.0 * baseHeight + endL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        alGA.add(temp);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamCustom(ArrayList<Double> al) {
        ArrayList<GArea> alGA = MEMSbeams.createCantileverCustom(al);
        double maxL = 0.0;
        for (int i = 2; i < al.size() - 3; i += 3) {
            maxL = al.get(i + 2) > maxL ? al.get(i + 2) : maxL;
        }
        double baseHeight = al.get(al.size() - 2);
        double xPos = 0.0;
        GArea temp = new GArea(new Rect(0.0, baseHeight + al.get(4), al.get(2) / 2.0, 2.0 * baseHeight + maxL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        for (int i = 2; i < al.size() - 3; i += 3) {
            temp.or(new GArea(new Rect(xPos + al.get(i) / 2.0, baseHeight + al.get(i + 2), xPos + al.get(i) + al.get(i + 1) + al.get(i + 3) / 2.0, 2.0 * baseHeight + maxL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
            xPos = xPos + al.get(i) + al.get(i + 1);
        }
        temp.or(new GArea(new Rect(xPos + al.get(al.size() - 3) / 2.0, baseHeight + al.get(al.size() - 4), xPos + al.get(al.size() - 3), 2.0 * baseHeight + maxL, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer()));
        alGA.add(temp);
        return alGA;
    }

    public static GArea createCantileverBase(double width, double pitch, double baseHeight, double baseExtent, int numElements) {
        double baseLength = 2.0 * baseExtent + (double)(numElements - 1) * pitch + width;
        return new GArea(new Rect(0.0, 0.0, baseLength, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
    }

    public static double[] calculateRampNonLinearSE(double startL, double endL, int numElements) {
        double ratio;
        double[] leverLengths = new double[numElements];
        double root = leverLengths.length == 1 ? 1.0 : 1.0 / (double)(leverLengths.length - 1);
        if (startL == 0.0) {
            ratio = endL;
            startL = 1.0;
        } else {
            ratio = Math.abs(endL / startL);
        }
        for (int i = 0; i < leverLengths.length; ++i) {
            leverLengths[i] = startL;
            startL *= Math.pow(ratio, root);
        }
        return leverLengths;
    }

    public static ArrayList<GArea> createLeverSRect(double width, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverSTriangle(double width, double length, double triangleHeight, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseExtent, baseHeight + length);
        poly.lineTo(baseExtent + width, baseHeight + length);
        poly.lineTo(baseExtent + width / 2.0, baseHeight + length + triangleHeight);
        poly.closePath();
        ga.or(new GArea(poly, CNSTscriptingController.getGdsLayer()));
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverSTrapezoid(double widthBottom, double widthTop, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + widthBottom, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseExtent, baseHeight);
        poly.lineTo(baseExtent + widthBottom, baseHeight);
        poly.lineTo(baseExtent + widthBottom / 2.0 + widthTop / 2.0, baseHeight + length);
        poly.lineTo(baseExtent + widthBottom / 2.0 - widthTop / 2.0, baseHeight + length);
        poly.closePath();
        ga.or(new GArea(poly, CNSTscriptingController.getGdsLayer()));
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, widthBottom, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverSPaddle(double widthBot, double widthTop, double lengthBot, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + widthBot, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + widthBot, baseHeight + lengthBot, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent + widthBot / 2.0 - widthTop / 2.0, baseHeight + lengthBot, baseExtent + widthBot / 2.0 + widthTop / 2.0, baseHeight + lengthBot + lengthTop, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, widthBot, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverSCurvedHalf(double width, double radius, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight, radius, width, 90.0, 180.0, numSides, CNSTscriptingController.getGdsLayer()));
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverSCurvedFull(double width, double radius, int numSides, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        length = Math.abs(length);
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight, radius, width, 0.0, 180.0, numSides, CNSTscriptingController.getGdsLayer()));
        ga.or(new Rect(baseExtent + 2.0 * radius, baseHeight - length, baseExtent + 2.0 * radius + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static void createSAnchor(ArrayList<GArea> alGA, double width, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        if (anchorDistance < baseExtent + width / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea temp = new GArea(new Rect(anchorDistance, anchorDistance, baseExtent * 2.0 + width - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
            alGA.add(temp);
        }
    }

    public static ArrayList<GArea> createLeverHRect(double width, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        if (hollowW < width / 2.0) {
            ga.subtract(new Rect(baseExtent + hollowW, baseHeight, baseExtent + width - hollowW, baseHeight + length - hollowW, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        }
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverHTriangle(double width, double length, double triangleHeight, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseExtent, baseHeight + length);
        poly.lineTo(baseExtent + width, baseHeight + length);
        poly.lineTo(baseExtent + width / 2.0, baseHeight + length + triangleHeight);
        poly.closePath();
        ga.or(new GArea(poly, CNSTscriptingController.getGdsLayer()));
        if (hollowW < width / 2.0) {
            double triHollow = 2.0 * triangleHeight * hollowW / width;
            poly = new Path2D.Double();
            poly.moveTo(baseExtent + hollowW, baseHeight);
            poly.lineTo(baseExtent + width - hollowW, baseHeight);
            poly.lineTo(baseExtent + width - hollowW, baseHeight + length);
            poly.lineTo(baseExtent + width / 2.0, baseHeight + length + triangleHeight - triHollow);
            poly.lineTo(baseExtent + hollowW, baseHeight + length);
            poly.closePath();
            GArea temp = new GArea(poly, CNSTscriptingController.getGdsLayer());
            ga.subtract(temp);
        }
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverHTrapezoid(double widthBottom, double widthTop, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + widthBottom, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseExtent + hollowW / 2.0, baseHeight);
        poly.lineTo(baseExtent + widthBottom / 2.0 - widthTop / 2.0, baseHeight + length - hollowW / 2.0);
        poly.lineTo(baseExtent + widthBottom / 2.0 + widthTop / 2.0, baseHeight + length - hollowW / 2.0);
        poly.lineTo(baseExtent + widthBottom - hollowW / 2.0, baseHeight);
        BasicStroke bs = new BasicStroke((float)hollowW, 2, 0);
        ga.or(new GArea(bs.createStrokedShape(poly), CNSTscriptingController.getGdsLayer()));
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, widthBottom, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverHPaddle(double widthBot, double widthTop, double lengthBot, double lengthTop, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + widthBot, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + widthBot, baseHeight + lengthBot, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent + widthBot / 2.0 - widthTop / 2.0, baseHeight + lengthBot, baseExtent + widthBot / 2.0 + widthTop / 2.0, baseHeight + lengthBot + lengthTop, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        if (hollowW < widthBot / 2.0 && hollowW < widthTop) {
            GArea temp = new GArea(new Rect(baseExtent + hollowW, baseHeight, baseExtent + widthBot - hollowW, baseHeight + lengthBot + hollowW, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            temp.or(new Rect(baseExtent + widthBot / 2.0 - widthTop / 2.0 + hollowW, baseHeight + lengthBot + hollowW, baseExtent + widthBot / 2.0 + widthTop / 2.0 - hollowW, baseHeight + lengthBot + lengthTop - hollowW, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            ga.subtract(temp);
        }
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, widthBot, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverHCurvedHalf(double width, double radius, int numSides, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight, radius, width, 90.0, 180.0, numSides, CNSTscriptingController.getGdsLayer()));
        if (hollowW < width / 2.0) {
            GArea temp = PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight, radius, width - 2.0 * hollowW, (1.5707963267948966 + hollowW / radius) * 57.29577951308232, 180.0, numSides, CNSTscriptingController.getGdsLayer());
            ga.subtract(temp);
        }
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverHCurvedFull(double width, double radius, int numSides, double length, double hollowW, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        length = Math.abs(length);
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight, radius, width, 0.0, 180.0, numSides, CNSTscriptingController.getGdsLayer()));
        ga.or(new Rect(baseExtent + 2.0 * radius, baseHeight - length, baseExtent + 2.0 * radius + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        if (hollowW < width / 2.0) {
            GArea temp = PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight, radius, width - 2.0 * hollowW, 0.0, 180.0, numSides, CNSTscriptingController.getGdsLayer());
            temp.or(new Rect(baseExtent + 2.0 * radius + hollowW, baseHeight - length + hollowW, baseExtent + 2.0 * radius + width - hollowW, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            ga.subtract(temp);
        }
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverPB2(double width, double length1, double length2, double lengthTop, double gap, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        lengthTop = Math.abs(lengthTop);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseExtent + lengthTop / 2.0 - gap / 2.0, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        if (gap <= lengthTop - 2.0 * width) {
            ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            ga.or(new Rect(baseExtent, baseHeight + length1 - width, baseExtent + lengthTop, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            alGA.add(ga);
            MEMSbeams.createPBAnchor(alGA, width, baseHeight, baseExtent + lengthTop / 2.0 - gap / 2.0, anchorDistance, anchorLayer);
            GArea temp = new GArea(new Rect(0.0, 0.0, baseExtent + lengthTop / 2.0 - gap / 2.0, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            temp.or(new Rect(lengthTop / 2.0 - gap / 2.0 - width, baseHeight, lengthTop / 2.0 - gap / 2.0, baseHeight + length2, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            temp.transform(AffineTransform.getTranslateInstance(baseExtent + lengthTop / 2.0 + gap / 2.0, length1 - length2));
            ga.or(temp);
            ArrayList<GArea> tempAnchor = new ArrayList<GArea>();
            MEMSbeams.createPBAnchor(tempAnchor, width, baseHeight, baseExtent + lengthTop / 2.0 - gap / 2.0, anchorDistance, anchorLayer);
            tempAnchor.get(0).transform(AffineTransform.getTranslateInstance(baseExtent + lengthTop / 2.0 + gap / 2.0, length1 - length2));
            alGA.add(tempAnchor.get(0));
        }
        return alGA;
    }

    public static ArrayList<GArea> createLeverPB3(double width, double length1, double length2, double length3, double lengthTop, double gap, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        length3 = Math.abs(length3);
        lengthTop = Math.abs(lengthTop);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double bx = (lengthTop - 2.0 * gap) / 2.0;
        GArea ga = new GArea(new Rect(0.0, 0.0, baseExtent + bx / 2.0, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        if (gap <= (lengthTop - 4.0 * width) / 2.0) {
            ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            ga.or(new Rect(baseExtent, baseHeight + length1 - width, baseExtent + lengthTop, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            alGA.add(ga);
            MEMSbeams.createPBAnchor(alGA, width, baseHeight, baseExtent + bx / 2.0, anchorDistance, anchorLayer);
            GArea tempMid = new GArea(new Rect(0.0, 0.0, bx, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            tempMid.or(new Rect((bx - width) / 2.0, baseHeight, (bx + width) / 2.0, baseHeight + length2, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            tempMid.transform(AffineTransform.getTranslateInstance(baseExtent + bx / 2.0 + gap, length1 - length2));
            ga.or(tempMid);
            ArrayList<GArea> tempAnchorMiddle = new ArrayList<GArea>();
            MEMSbeams.createPBAnchor(tempAnchorMiddle, width, baseHeight, bx, anchorDistance, anchorLayer);
            tempAnchorMiddle.get(0).transform(AffineTransform.getTranslateInstance(baseExtent + bx / 2.0 + gap, length1 - length2));
            alGA.add(tempAnchorMiddle.get(0));
            GArea temp = new GArea(new Rect(0.0, 0.0, baseExtent + bx / 2.0, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            temp.or(new Rect(bx / 2.0 - width, baseHeight, bx / 2.0, baseHeight + length3, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
            temp.transform(AffineTransform.getTranslateInstance(baseExtent + 2.0 * gap + 1.5 * bx, length1 - length3));
            ga.or(temp);
            ArrayList<GArea> tempAnchorMid = new ArrayList<GArea>();
            MEMSbeams.createPBAnchor(tempAnchorMid, width, baseHeight, baseExtent + bx / 2.0, anchorDistance, anchorLayer);
            tempAnchorMid.get(0).transform(AffineTransform.getTranslateInstance(baseExtent + 2.0 * gap + 1.5 * bx, length1 - length3));
            alGA.add(tempAnchorMid.get(0));
        }
        return alGA;
    }

    public static void createPBAnchor(ArrayList<GArea> alGA, double width, double baseHeight, double baseLength, double anchorDistance, int anchorLayer) {
        if (anchorDistance < baseLength / 2.0) {
            anchorLayer = anchorLayer < 256 && anchorLayer >= 0 ? anchorLayer : 0;
            GArea temp = new GArea(new Rect(anchorDistance, anchorDistance, baseLength - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
            alGA.add(temp);
        }
    }

    public static ArrayList<GArea> createLeverUR(double width, double length1, double length2, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        lengthTop = Math.abs(lengthTop);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight + length1 - width, baseExtent + lengthTop, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent + lengthTop - width, baseHeight + length1 - length2, baseExtent + lengthTop, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverUCF(double width, double length1, double length2, double lengthTop, double radius, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        radius = Math.abs(radius);
        lengthTop = Math.abs(lengthTop);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius, baseHeight + length1, radius, width, 90.0, 180.0, numSides, CNSTscriptingController.getGdsLayer()));
        ga.or(new Rect(baseExtent + width / 2.0 + radius, baseHeight + length1 + radius - width / 2.0, baseExtent + width / 2.0 + radius + lengthTop, baseHeight + length1 + radius + width / 2.0, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + radius + lengthTop, baseHeight + length1, radius, width, 0.0, 90.0, numSides, CNSTscriptingController.getGdsLayer()));
        ga.or(new Rect(baseExtent + 2.0 * radius + lengthTop, baseHeight + length1 - length2, baseExtent + 2.0 * radius + lengthTop + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverUC(double width, double length1, double length2, double diameter, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        length2 = Math.abs(length2);
        diameter = Math.abs(diameter);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(PrimitiveShapes.createTorusW(baseExtent + width / 2.0 + diameter / 2.0, baseHeight + length1, diameter / 2.0, width, 0.0, 180.0, numSides, CNSTscriptingController.getGdsLayer()));
        ga.or(new Rect(baseExtent + diameter, baseHeight + length1 - length2, baseExtent + diameter + width, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        return alGA;
    }

    public static ArrayList<GArea> createLeverUCC(double width1, double width2, double length1, double length2, double length3, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        length3 = Math.abs(length3);
        lengthTop = Math.abs(lengthTop);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width1, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width1, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        MEMSbeams.createSAnchor(alGA, width1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        ga.or(new Rect(baseExtent, baseHeight + length1 - width1, baseExtent + lengthTop, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        double LBOT = length2 > 0.0 ? length1 - length2 : length1;
        double LTOP = length2 > 0.0 ? length1 : length1 - length2;
        ga.or(new Rect(baseExtent + lengthTop / 2.0 - width2 / 2.0, baseHeight + LBOT, baseExtent + lengthTop / 2.0 + width2 / 2.0, baseHeight + LTOP, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        GArea tempMid = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width1, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        tempMid.or(new Rect(baseExtent, baseHeight, baseExtent + width1, baseHeight + length3, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        tempMid.transform(AffineTransform.getTranslateInstance(lengthTop - width1, length1 - length3));
        ga.or(tempMid);
        ArrayList<GArea> tempAnchorMiddle = new ArrayList<GArea>();
        MEMSbeams.createSAnchor(tempAnchorMiddle, width1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        tempAnchorMiddle.get(0).transform(AffineTransform.getTranslateInstance(lengthTop - width1, length1 - length3));
        alGA.add(tempAnchorMiddle.get(0));
        return alGA;
    }

    public static ArrayList<GArea> createLeverUCP(double width1, double width2, double length1, double length2a, double length2b, double length3, double lengthTop, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        length1 = Math.abs(length1);
        length2a = Math.abs(length2a);
        length2b = Math.abs(length2b);
        length3 = Math.abs(length3);
        lengthTop = Math.abs(lengthTop);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width1, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width1, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        MEMSbeams.createSAnchor(alGA, width1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        ga.or(new Rect(baseExtent, baseHeight + length1 - width1, baseExtent + lengthTop, baseHeight + length1, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        ga.or(new Rect(baseExtent + lengthTop / 2.0 - width2 / 2.0, baseHeight + length1 - width1 / 2.0 - length2a, baseExtent + lengthTop / 2.0 + width2 / 2.0, baseHeight + length1 - width1 / 2.0 + length2b, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        alGA.add(ga);
        GArea tempMid = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width1, baseHeight, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        tempMid.or(new Rect(baseExtent, baseHeight, baseExtent + width1, baseHeight + length3, CNSTscriptingController.getGdsLayer()), CNSTscriptingController.getGdsLayer());
        tempMid.transform(AffineTransform.getTranslateInstance(lengthTop - width1, length1 - length3));
        ga.or(tempMid);
        ArrayList<GArea> tempAnchorMiddle = new ArrayList<GArea>();
        MEMSbeams.createSAnchor(tempAnchorMiddle, width1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        tempAnchorMiddle.get(0).transform(AffineTransform.getTranslateInstance(lengthTop - width1, length1 - length3));
        alGA.add(tempAnchorMiddle.get(0));
        return alGA;
    }

    public static ArrayList<GArea> createLeverCE(double width, double length, double rX, double rY, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width + 2.0 * rX, baseHeight + rY, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent, baseHeight + rY, rX, rY, numSides *= 4, layer));
        ga.subtract(new Rect(0.0, baseHeight, baseExtent, baseHeight + rY, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + width + 2.0 * rX, baseHeight + rY, rX, rY, numSides, layer));
        ga.subtract(new Rect(baseExtent + width + 2.0 * rX, baseHeight, 2.0 * baseExtent + width + 2.0 * rX, baseHeight + rY, layer), layer);
        ga.or(new Rect(baseExtent + rX, baseHeight + rY, baseExtent + rX + width, baseHeight + rY + length, layer), layer);
        MEMSbeams.createSAnchor(alGA, width + 2.0 * rX, baseHeight, baseExtent, anchorDistance, anchorLayer);
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createLeverCEPaddle(double width, double length, double rX1, double rY1, double rX2, double rY2, int numSides, double paddleW, double paddleL, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width + 2.0 * rX1, baseHeight + rY1, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent, baseHeight + rY1, rX1, rY1, numSides *= 4, layer));
        ga.subtract(new Rect(0.0, baseHeight, baseExtent, baseHeight + rY1, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + width + 2.0 * rX1, baseHeight + rY1, rX1, rY1, numSides, layer));
        ga.subtract(new Rect(baseExtent + width + 2.0 * rX1, baseHeight, 2.0 * baseExtent + width + 2.0 * rX1, baseHeight + rY1, layer), layer);
        ga.or(new Rect(baseExtent + rX1, baseHeight + rY1, baseExtent + rX1 + width, baseHeight + rY1 + length, layer), layer);
        ga.or(new Rect(baseExtent + rX1 - rX2, baseHeight + rY1 + length, baseExtent + rX1 + width + rX2, baseHeight + rY1 + length + rY2, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + rX1 - rX2, baseHeight + rY1 + length, rX2, rY2, numSides, layer));
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + rX1 + width + rX2, baseHeight + rY1 + length, rX2, rY2, numSides, layer));
        ga.or(new Rect(baseExtent + rX1 - rX2 - paddleW, baseHeight + rY1 + length + rY2, baseExtent + rX1 + width + rX2 + paddleW, baseHeight + rY1 + length + rY2 + paddleL, layer), layer);
        MEMSbeams.createSAnchor(alGA, width + 2.0 * rX1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamR(double width, double length, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width, baseHeight, layer), layer);
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width, baseHeight + length, layer), layer);
        ga.or(new Rect(0.0, baseHeight + length, 2.0 * baseExtent + width, 2.0 * baseHeight + length, layer), layer);
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        ArrayList<GArea> topAnchor = new ArrayList<GArea>();
        MEMSbeams.createSAnchor(topAnchor, width, baseHeight, baseExtent, anchorDistance, anchorLayer);
        topAnchor.get(0).transform(AffineTransform.getTranslateInstance(0.0, baseHeight + length));
        alGA.add(topAnchor.get(0));
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamCoupledBeams(double width, double lengthStart, double lengthEnd, int numElements, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea electrode = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        GArea anchor = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea electrodesALL = new GArea(electrode);
        GArea anchorsALL = new GArea(anchor);
        double lengthX = lengthStart + baseWidth;
        double deltaL = (lengthEnd - lengthStart) / (double)(numElements - 1);
        for (int i = 1; i <= numElements; ++i) {
            GArea tempE = new GArea(electrode);
            GArea tempA = new GArea(anchor);
            electrodesALL.or((GDS2)tempE.transform(AffineTransform.getTranslateInstance(lengthX, 0.0)));
            anchorsALL.or((GDS2)tempA.transform(AffineTransform.getTranslateInstance(lengthX, 0.0)));
            if (i == numElements) continue;
            lengthX = lengthX + lengthStart + (double)i * deltaL + baseWidth;
        }
        electrodesALL.or(new Rect(baseWidth, baseHeight / 2.0 - width / 2.0, baseWidth + lengthX, baseHeight / 2.0 + width / 2.0, layer), layer);
        alGA.add(electrodesALL);
        alGA.add(anchorsALL);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamTorsional(double width1, double length1, double width2, double length2, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width1, baseHeight, layer), layer);
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width1, baseHeight + length1, layer), layer);
        ga.or(new Rect(0.0, baseHeight + length1, 2.0 * baseExtent + width1, 2.0 * baseHeight + length1, layer), layer);
        ga.or(new Rect(baseExtent + width1 / 2.0 - width2 / 2.0, baseHeight + length1 / 2.0 - length2 / 2.0, baseExtent + width1 / 2.0 + width2 / 2.0, baseHeight + length1 / 2.0 + length2 / 2.0, layer), layer);
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        ArrayList<GArea> topAnchor = new ArrayList<GArea>();
        MEMSbeams.createSAnchor(topAnchor, width1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        topAnchor.get(0).transform(AffineTransform.getTranslateInstance(0.0, baseHeight + length1));
        alGA.add(topAnchor.get(0));
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamTorsional2(double width1, double width2, double width3, double width4, double length1, double length2, double length3, double gap, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        double startX = baseWidth;
        double startY = baseHeight / 2.0 - width3 / 2.0;
        ga.or(new Rect(startX, startY, startX + baseWidth, startY + width3, layer), layer);
        startY = baseHeight / 2.0 - length1 / 2.0 - length2 - width4;
        ga.or(new Rect(startX += length3, startY, startX + 2.0 * gap + 2.0 * width4 + width1, baseHeight / 2.0 + length1 / 2.0 + length2 + width4, layer), layer);
        ga.subtract(new Rect(startX + width4, startY + width4, startX + 2.0 * gap + width4 + width1, baseHeight / 2.0 + length1 / 2.0 + length2, layer), layer);
        startX = startX + width4 + gap + width1 / 2.0 - width2 / 2.0;
        ga.or(new Rect(startX, startY, startX + width2, baseHeight / 2.0 + length1 / 2.0 + length2 + width4, layer), layer);
        startX = startX + width2 / 2.0 - width1 / 2.0;
        startY = startY + width4 + length2;
        ga.or(new Rect(startX, startY, startX + width1, startY + length1, layer), layer);
        startX = startX + width1 + gap + width4;
        startY = startY + length1 / 2.0 - width3 / 2.0;
        ga.or(new Rect(startX, startY, startX + length3, startY + width3, layer), layer);
        startY = startY + width3 / 2.0 - baseHeight / 2.0;
        ga.or(new Rect(startX += length3, startY, startX + baseWidth, startY + baseHeight, layer), layer);
        GArea temp = new GArea(new Rect(startX + anchorDistance, startY + anchorDistance, startX + baseWidth - anchorDistance, startY + baseHeight - anchorDistance, layer), layer);
        anchors.or(temp);
        alGA.add(ga);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createDcBeamC(double width, double length, double rX1, double rY1, double rX2, double rY2, int numSides, double baseHeight, double baseExtent, double anchorDistance, int anchorLayer) {
        numSides *= 4;
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, 2.0 * baseExtent + width + 2.0 * rX1, baseHeight + rY1, layer), layer);
        ga.or(new Rect(baseExtent, baseHeight, baseExtent + width + 2.0 * rX1, baseHeight + rY1, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent, baseHeight + rY1, rX1, rY1, numSides, layer));
        ga.subtract(new Rect(0.0, baseHeight, baseExtent, baseHeight + rY1, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + width + 2.0 * rX1, baseHeight + rY1, rX1, rY1, numSides, layer));
        ga.subtract(new Rect(baseExtent + width + 2.0 * rX1, baseHeight, 2.0 * baseExtent + width + 2.0 * rX1, baseHeight + rY1, layer), layer);
        ga.or(new Rect(baseExtent + rX1, baseHeight + rY1, baseExtent + rX1 + width, baseHeight + rY1 + length, layer), layer);
        ga.or(new Rect(baseExtent + rX1 - rX2, baseHeight + rY1 + length, baseExtent + rX1 + width + rX2, baseHeight + rY1 + length + rY2, layer), layer);
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + rX1 - rX2, baseHeight + rY1 + length, rX2, rY2, numSides, layer));
        ga.subtract(PrimitiveShapes.createEllipse(baseExtent + rX1 + width + rX2, baseHeight + rY1 + length, rX2, rY2, numSides, layer));
        ga.or(new Rect(baseExtent + rX1 - rX2 - baseExtent, baseHeight + rY1 + length + rY2, baseExtent + rX1 + width + rX2 + baseExtent, baseHeight + rY1 + length + rY2 + baseHeight, layer), layer);
        alGA.add(ga);
        MEMSbeams.createSAnchor(alGA, width + 2.0 * rX1, baseHeight, baseExtent, anchorDistance, anchorLayer);
        ArrayList<GArea> topAnchor = new ArrayList<GArea>();
        MEMSbeams.createSAnchor(topAnchor, width + 2.0 * rX2, baseHeight, baseExtent, anchorDistance, anchorLayer);
        topAnchor.get(0).transform(AffineTransform.getTranslateInstance(rX1 - rX2, baseHeight + rY1 + length + rY2));
        alGA.add(topAnchor.get(0));
        return alGA;
    }

    public static ArrayList<GArea> createGuckelRing(double ringWidth, double radius, int numOfSides, double beamWidth, double base, double connectorLegth, double connectorWidth, double anchorDistance, int anchorLayer) {
        return MEMSbeams.createGuckelRingArray(ringWidth, radius, radius, radius, numOfSides, beamWidth, base, connectorLegth, connectorWidth, anchorDistance, anchorLayer);
    }

    public static ArrayList<GArea> createGuckelRingArray(double ringWidth, double radiusStart, double radiusEnd, double deltaRadius, int numOfSides, double beamWidth, double base, double connectorLegth, double connectorWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        double offsetX = 0.0;
        for (double radius = radiusStart; radius <= radiusEnd; radius += deltaRadius) {
            GArea ga = PrimitiveShapes.createTorusW(0.0, 0.0, radius, ringWidth, 0.0, 360.0, numOfSides, layer);
            ga.or(new Rect(-beamWidth / 2.0, -radius, beamWidth / 2.0, radius, layer), layer);
            GArea temp = new GArea(new Rect(-base / 2.0, -base / 2.0, base / 2.0, base / 2.0, layer), layer);
            temp.or(new Rect(base / 2.0, -connectorWidth / 2.0, base / 2.0 + connectorLegth + ringWidth / 2.0, connectorWidth / 2.0, layer), layer);
            double bondPadOffset = -radius - base / 2.0 - connectorLegth - ringWidth / 2.0;
            temp.transform(AffineTransform.getTranslateInstance(bondPadOffset, 0.0));
            ga.or(temp);
            AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
            GArea mirror = new GArea(temp);
            ga.or((GDS2)mirror.transform(at));
            ga.transform(AffineTransform.getTranslateInstance(offsetX, 0.0));
            alGA.add(ga);
            GArea bondpads = new GArea(new Rect(-base / 2.0 + anchorDistance, -base / 2.0 + anchorDistance, base / 2.0 - anchorDistance, base / 2.0 - anchorDistance, anchorLayer), anchorLayer);
            bondpads.transform(AffineTransform.getTranslateInstance(bondPadOffset, 0.0));
            mirror = new GArea(bondpads);
            bondpads.or((GDS2)mirror.transform(at));
            alGA.add((GArea)bondpads.transform(AffineTransform.getTranslateInstance(offsetX, 0.0)));
            offsetX = offsetX + 2.0 * Math.abs(bondPadOffset) + deltaRadius;
        }
        return alGA;
    }

    public static ArrayList<GArea> createDiamondRing(double width1, double width2, double width3, double length1, double length2, double length3, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        double innerBoxX = Math.sqrt(2.0) * length3 / 2.0;
        double outerBoxX = innerBoxX + 2.0 * width1;
        double width1Prime = Math.sqrt(2.0) * width1 / 2.0;
        double middleBar = length3 + 2.0 * width1Prime + 2.0 * length1;
        GArea diamond = new GArea(new Rect(-outerBoxX / 2.0, -outerBoxX / 2.0, outerBoxX / 2.0, outerBoxX / 2.0, layer), layer);
        diamond.subtract(new GArea(new Rect(-innerBoxX / 2.0, -innerBoxX / 2.0, innerBoxX / 2.0, innerBoxX / 2.0, layer), layer));
        diamond.transform(AffineTransform.getRotateInstance(0.7853981633974483));
        diamond.or(new GArea(new Rect(-middleBar / 2.0, -width3 / 2.0, middleBar / 2.0, width3 / 2.0, layer), layer));
        diamond.or(new GArea(new Rect(-width2 / 2.0, length3 / 2.0, width2 / 2.0, length3 / 2.0 + length2, layer), layer));
        diamond.or(new GArea(new Rect(-width2 / 2.0, -length3 / 2.0 - length2, width2 / 2.0, -length3 / 2.0, layer), layer));
        GArea bondPad = new GArea(new Rect(-baseWidth / 2.0, -baseHeight / 2.0, baseWidth / 2.0, baseHeight / 2.0, layer), layer);
        GArea temp = new GArea(bondPad);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, length2 + length3 / 2.0 + baseHeight / 2.0)));
        temp = new GArea(bondPad);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, -length2 - length3 / 2.0 - baseHeight / 2.0)));
        temp = new GArea(bondPad);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-middleBar / 2.0 - baseWidth / 2.0, 0.0)));
        temp = new GArea(bondPad);
        diamond.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(middleBar / 2.0 + baseWidth / 2.0, 0.0)));
        alGA.add(diamond);
        GArea anchors = new GArea(new Rect(-baseWidth / 2.0 + anchorDistance, -baseHeight / 2.0 + anchorDistance, baseWidth / 2.0 - anchorDistance, baseHeight / 2.0 - anchorDistance, anchorLayer), anchorLayer);
        temp = new GArea(anchors);
        GArea allAnchors = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(0.0, length2 + length3 / 2.0 + baseHeight / 2.0)));
        temp = new GArea(anchors);
        allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, -length2 - length3 / 2.0 - baseHeight / 2.0)));
        temp = new GArea(anchors);
        allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-middleBar / 2.0 - baseWidth / 2.0, 0.0)));
        temp = new GArea(anchors);
        allAnchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(middleBar / 2.0 + baseWidth / 2.0, 0.0)));
        alGA.add(allAnchors);
        return alGA;
    }

    public static GArea createBeamCurvedEnds(double L, double W, double r, int numSides, boolean CENTERED, boolean VECTOR) {
        int gdsLayer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        GArea endBox = Scripting.createRectangle(-r - W / 2.0, 0.0, r + W / 2.0, r, 0.0, gdsLayer);
        GArea circ = VECTOR ? Scripting.createEllipseVector(0.0, 0.0, r, r, 0.0, gdsLayer, shapeReso) : Scripting.createEllipse(0.0, 0.0, r, r, numSides, 0.0, gdsLayer);
        GArea temp = new GArea(circ);
        temp.transform(AffineTransform.getTranslateInstance(r + W / 2.0, r));
        endBox.subtract(temp);
        temp = new GArea(circ);
        temp.transform(AffineTransform.getTranslateInstance(-r - W / 2.0, r));
        endBox.subtract(temp);
        GArea beam = Scripting.createRectangleLH(0.0, -W / 2.0, L, W, 0.0, gdsLayer);
        temp = new GArea(endBox).transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        beam.or(temp);
        temp = ((GArea)new GArea(endBox).transform(AffineTransform.getRotateInstance(1.5707963267948966))).transform(AffineTransform.getTranslateInstance(L, 0.0));
        beam.or(temp);
        if (CENTERED) {
            beam.transform(AffineTransform.getTranslateInstance(-L / 2.0, 0.0));
        }
        return beam;
    }
}

