/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNST.Scripting;
import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.FractureShapes;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class MEMSactuators {
    public static ArrayList<GArea> createGear(double rad, double width, double height, int numGears, double triangleL, int numSides) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = PrimitiveShapes.createEllipse(0.0, 0.0, rad, rad, numSides, layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, -height / 2.0);
        poly.lineTo(rad + width, -height / 2.0);
        poly.lineTo(rad + width + triangleL, 0.0);
        poly.lineTo(rad + width, height / 2.0);
        poly.lineTo(0.0, height / 2.0);
        poly.closePath();
        GArea gearTooth = new GArea(poly, layer);
        double dTheta = Math.PI * 2 / (double)numGears;
        for (int i = 0; i < numGears; ++i) {
            GArea temp = new GArea(gearTooth);
            ga.or((GDS2)temp.transform(AffineTransform.getRotateInstance((double)i * dTheta)));
        }
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        return alGA;
    }

    public static ArrayList<GArea> createLinearDriveV1(double width1, double length1, double length2, double length3, double gap, int numElectrodes, double pitch, double baseHeight, double baseWidth, double rotorPitch, int rotorLayer, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double lengthTopElectrodes = (double)(numElectrodes - 1) * pitch + baseWidth;
        double startX = -lengthTopElectrodes / 2.0 - length3;
        GArea middle = new GArea(new Rect(startX, -length2 / 2.0, -startX, length2 / 2.0, rotorLayer), rotorLayer);
        startX = -lengthTopElectrodes / 2.0;
        double startY = length2 + length1 + gap;
        GArea electrode = new GArea(new Rect(startX, startY, startX + baseWidth, startY + baseHeight, layer), layer);
        GArea anchor = new GArea(new Rect(startX + anchorDistance, startY + anchorDistance, startX + baseWidth - anchorDistance, startY + baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea electrodesALL = new GArea(electrode);
        GArea anchorsALL = new GArea(anchor);
        for (int i = 0; i < numElectrodes; ++i) {
            GArea tempE = new GArea(electrode);
            GArea tempA = new GArea(anchor);
            electrodesALL.or((GDS2)tempE.transform(AffineTransform.getTranslateInstance((double)i * pitch, 0.0)));
            anchorsALL.or((GDS2)tempA.transform(AffineTransform.getTranslateInstance((double)i * pitch, 0.0)));
            tempE = new GArea(electrode);
            tempA = new GArea(anchor);
            electrodesALL.or((GDS2)tempE.transform(AffineTransform.getTranslateInstance((double)i * pitch, -2.0 * startY - baseHeight)));
            anchorsALL.or((GDS2)tempA.transform(AffineTransform.getTranslateInstance((double)i * pitch, -2.0 * startY - baseHeight)));
        }
        int numMidFingers = (int)(lengthTopElectrodes / rotorPitch);
        for (int i = 0; i <= numMidFingers; ++i) {
            middle.or(new Rect((double)i * rotorPitch + -lengthTopElectrodes / 2.0, length2 / 2.0, (double)i * rotorPitch + -lengthTopElectrodes / 2.0 + width1, length2 / 2.0 + length1, rotorLayer), rotorLayer);
            middle.or(new Rect((double)i * rotorPitch + -lengthTopElectrodes / 2.0, -length2 / 2.0 - length1, (double)i * rotorPitch + -lengthTopElectrodes / 2.0 + width1, -length2 / 2.0, rotorLayer), rotorLayer);
        }
        alGA.add(electrodesALL);
        alGA.add(anchorsALL);
        alGA.add(middle);
        return alGA;
    }

    public static ArrayList<GArea> createCombDriveV1(double width1, double width2, double length1, double length2, int numElectrodes, double pitch, double baseHeight, int baseLayer, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea topElectrode = new GArea(new Rect(0.0, -baseHeight, (double)(numElectrodes - 1) * pitch + width1, 0.0, baseLayer), baseLayer);
        GArea anchor = new GArea(new Rect(anchorDistance, -baseHeight + anchorDistance, (double)(numElectrodes - 1) * pitch + width1 - anchorDistance, -anchorDistance, anchorLayer), anchorLayer);
        double startX = 0.0;
        double startY = -baseHeight - length1;
        for (int i = 0; i < numElectrodes; ++i) {
            topElectrode.or(new Rect((double)i * pitch + startX, startY, (double)i * pitch + startX + width1, startY + length1, baseLayer), baseLayer);
        }
        startX = pitch / 2.0;
        startY = -baseHeight - 2.0 * length1 + length2;
        GArea bottomElectrode = new GArea(new Rect(startX, startY - width2, startX + (double)(numElectrodes - 2) * pitch + width1, startY, layer), layer);
        for (int i = 0; i < numElectrodes - 1; ++i) {
            bottomElectrode.or(new Rect((double)i * pitch + startX, startY, (double)i * pitch + startX + width1, startY + length1, layer), layer);
        }
        alGA.add(topElectrode);
        alGA.add(bottomElectrode);
        alGA.add(anchor);
        return alGA;
    }

    public static ArrayList<GArea> createRadialCombDriveV1(double w1, double r1, double w2, double r2, double wc, double gap, int numElements, int numSides, double thetaALL, double thetaOverlap, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double thetaPrime = Math.abs((thetaALL - thetaOverlap) / 2.0);
        double totalLengthUpper = (double)(2 * numElements - 1) * wc + (double)(2 * (numElements - 1)) * gap;
        double totalLengthLower = (double)(2 * (numElements - 1)) * wc + (double)(2 * (numElements - 1)) * gap;
        GArea ga = new GArea(new Rect(r2, -w2 / 2.0, r2 + (r1 - r2) + totalLengthLower - gap, w2 / 2.0, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(r1 * Math.cos(thetaALL * Math.PI / 180.0), r1 * Math.sin(thetaALL * Math.PI / 180.0));
        poly.lineTo((r1 + totalLengthUpper) * Math.cos(thetaALL * Math.PI / 180.0), (r1 + totalLengthUpper) * Math.sin(thetaALL * Math.PI / 180.0));
        BasicStroke bs = new BasicStroke((float)w1, 0, 0);
        GArea temp = new GArea(bs.createStrokedShape(poly), layer);
        ga.or(temp);
        temp = PrimitiveShapes.createTorusW(0.0, 0.0, r1 + wc / 2.0, wc, thetaALL - thetaPrime - thetaOverlap, thetaALL, numSides, layer);
        for (int i = 0; i < numElements; ++i) {
            temp.or(PrimitiveShapes.createTorusW(0.0, 0.0, (double)i * (2.0 * wc + 2.0 * gap) + r1 + wc / 2.0, wc, thetaALL - thetaPrime - thetaOverlap, thetaALL, numSides, layer));
            if (i >= numElements - 1) continue;
            temp.or(PrimitiveShapes.createTorusW(0.0, 0.0, (double)i * (2.0 * wc + 2.0 * gap) + r1 + wc / 2.0 + gap + wc, wc, 0.0, thetaPrime + thetaOverlap, numSides, layer));
        }
        poly = new Path2D.Double();
        poly.moveTo((r1 + anchorDistance) * Math.cos(thetaALL * Math.PI / 180.0), (r1 + anchorDistance) * Math.sin(thetaALL * Math.PI / 180.0));
        poly.lineTo((r1 + totalLengthUpper - anchorDistance) * Math.cos(thetaALL * Math.PI / 180.0), (r1 + totalLengthUpper - anchorDistance) * Math.sin(thetaALL * Math.PI / 180.0));
        bs = new BasicStroke((float)(w1 - 2.0 * anchorDistance), 0, 0);
        GArea anchor = new GArea(bs.createStrokedShape(poly), anchorLayer);
        alGA.add(ga);
        alGA.add(temp);
        alGA.add(anchor);
        return alGA;
    }

    public static ArrayList<GArea> createRadialCombDriveV2(double w1, double r1, double w2, double r2, double wc, double gap, int numElements, int numSides, double thetaALL, double thetaOverlap, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> structure = MEMSactuators.createRadialCombDriveV1(w1, r1, w2, r2, wc, gap, numElements, numSides, thetaALL, thetaOverlap, anchorDistance, anchorLayer);
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        for (int i = 0; i < structure.size(); ++i) {
            alGA.add(structure.get(i));
            GArea temp = new GArea(structure.get(i));
            temp.transform(at);
            alGA.add((GArea)temp.transform(AffineTransform.getRotateInstance(Math.PI)));
        }
        return alGA;
    }

    public static ArrayList<GArea> createBentBeam(double width, double length1, double length2, double length3, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth + length1, 0.0, 2.0 * baseWidth + length1, baseHeight, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseWidth - width / 2.0, baseHeight / 2.0);
        poly.lineTo(baseWidth + length2, baseHeight / 2.0 + length3);
        poly.lineTo(baseWidth + length1 + width / 2.0, baseHeight / 2.0);
        BasicStroke bs = new BasicStroke((float)width, 2, 0);
        GArea bentBeam = new GArea(bs.createStrokedShape(poly), layer);
        ga.or(bentBeam);
        alGA.add(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        temp.transform(AffineTransform.getTranslateInstance(baseWidth + length1, 0.0));
        anchors.or(temp);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createBentBeamArray(double width, double length1, double length2, double length3, double length4, double hOffset, double pitch, int numElements, double centralBeamWidth, double dimpleHeight, double dimpleWidth, int dimpleLayer, double baseWidth, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        double baseHeight = 2.0 * hOffset + pitch * (double)(numElements - 1);
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth + length1, 0.0, 2.0 * baseWidth + length1, baseHeight, layer), layer);
        GArea bentBeams = new GArea();
        BasicStroke bs = new BasicStroke((float)width, 2, 0);
        Path2D.Double poly = new Path2D.Double();
        for (int i = 0; i < numElements; ++i) {
            poly.moveTo(baseWidth - width / 2.0, hOffset + (double)i * pitch);
            poly.lineTo(baseWidth + length2, hOffset + length3 + (double)i * pitch);
            poly.lineTo(baseWidth + length1 + width / 2.0, hOffset + (double)i * pitch);
            bentBeams = new GArea(bs.createStrokedShape(poly), layer);
            ga.or(bentBeams);
        }
        double centralBeamHeight = 2.0 * length4 + pitch * (double)(numElements - 1);
        GArea centralElement = new GArea(new Rect(0.0, 0.0, centralBeamWidth, centralBeamHeight, layer), layer);
        ga.or((GDS2)centralElement.transform(AffineTransform.getTranslateInstance(baseWidth + length2 - centralBeamWidth / 2.0, hOffset + length3 - length4)));
        alGA.add(ga);
        GArea dimples = new GArea(new Rect(baseWidth + length2 - dimpleWidth / 2.0, hOffset + length3 - dimpleHeight / 2.0, baseWidth + length2 + dimpleWidth / 2.0, hOffset + length3 + dimpleHeight / 2.0, dimpleLayer), dimpleLayer);
        for (int i = 1; i < numElements - 1; ++i) {
            dimples.or(new Rect(baseWidth + length2 - dimpleWidth / 2.0, pitch * (double)i + hOffset + length3 - dimpleHeight / 2.0, baseWidth + length2 + dimpleWidth / 2.0, pitch * (double)i + hOffset + length3 + dimpleHeight / 2.0, dimpleLayer), dimpleLayer);
        }
        alGA.add(dimples);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        temp.transform(AffineTransform.getTranslateInstance(baseWidth + length1, 0.0));
        anchors.or(temp);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createStraightSpring(double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double anchorDistance, int anchorLayer) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub, radiusCenterHub, numSides, layer);
        ga.or(PrimitiveShapes.createTorusW(0.0, 0.0, radiusRing, widthRing, 0.0, 360.0, numSides, layer));
        GArea beam = new GArea(new Rect(0.0, -width / 2.0, radiusRing, width / 2.0, layer), layer);
        GArea temp = new GArea(beam);
        for (int i = 0; i < numElements; ++i) {
            ga.or((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElements)));
            temp = new GArea(beam);
        }
        alGA.add(ga);
        GArea anchors = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub - anchorDistance, radiusCenterHub - anchorDistance, numSides, anchorLayer);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createCircularSpring(double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        double radBeam = (radiusRing - (radiusCenterHub - width / 2.0)) / 2.0;
        GArea ga = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub, radiusCenterHub, numSides, layer);
        ga.or(PrimitiveShapes.createTorusW(0.0, 0.0, radiusRing, widthRing, 0.0, 360.0, numSides, layer));
        GArea beam = PrimitiveShapes.createTorusW(0.0, 0.0, radBeam, width, 0.0, 180.0, numSides, layer);
        beam.transform(AffineTransform.getTranslateInstance(radiusRing - radBeam, 0.0));
        GArea temp = new GArea(beam);
        for (int i = 0; i < numElements; ++i) {
            ga.or((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElements)));
            temp = new GArea(beam);
        }
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub - anchorDistance, radiusCenterHub - anchorDistance, numSides, anchorLayer);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createStraightSpringElectrodes(double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double gap, double electrodeWidth, int numElectrodes, double gapFraction, double anchorElectrodeDistance, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub, radiusCenterHub, numSides, layer);
        ga.or(PrimitiveShapes.createTorusW(0.0, 0.0, radiusRing, widthRing, 0.0, 360.0, numSides, layer));
        GArea beam = new GArea(new Rect(0.0, -width / 2.0, radiusRing, width / 2.0, layer), layer);
        GArea temp = new GArea(beam);
        for (int i = 0; i < numElements; ++i) {
            ga.or((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElements)));
            temp = new GArea(beam);
        }
        double radiusElectrodeINNER = radiusRing + widthRing / 2.0 + gap;
        double radiusElectrodeMID = radiusElectrodeINNER + electrodeWidth / 2.0;
        GArea electrodes = PrimitiveShapes.createTorusW(0.0, 0.0, radiusElectrodeMID, electrodeWidth, 0.0, 360.0, numSides, layer);
        double circumference = Math.PI * 2 * radiusElectrodeINNER;
        double electrodeSegment = circumference / (double)numElectrodes;
        double theta = 57.29577951308232 * (electrodeSegment * gapFraction) / radiusElectrodeINNER;
        GArea arc = PrimitiveShapes.createArc(0.0, 0.0, radiusElectrodeINNER + electrodeWidth * 1.5, radiusElectrodeINNER + electrodeWidth * 1.5, -theta / 2.0, theta / 2.0, numSides, layer);
        if (gapFraction > 0.0 && gapFraction < 1.0) {
            for (int i = 0; i < numElectrodes; ++i) {
                temp = new GArea(arc);
                electrodes.subtract((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElectrodes)));
            }
        }
        ga.or(electrodes);
        alGA.add(ga);
        GArea anchors = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub - anchorDistance, radiusCenterHub - anchorDistance, numSides, anchorLayer);
        GArea anchorTorus = PrimitiveShapes.createTorusW(0.0, 0.0, radiusElectrodeMID, electrodeWidth - 2.0 * anchorElectrodeDistance, 0.0, 360.0, numSides, layer);
        theta = 57.29577951308232 * (electrodeSegment * gapFraction + 2.0 * anchorElectrodeDistance) / radiusElectrodeINNER;
        arc = PrimitiveShapes.createArc(0.0, 0.0, radiusElectrodeINNER + electrodeWidth * 1.5, radiusElectrodeINNER + electrodeWidth * 1.5, -theta / 2.0, theta / 2.0, numSides, anchorLayer);
        if (gapFraction > 0.0 && gapFraction < 1.0) {
            for (int i = 0; i < numElectrodes; ++i) {
                temp = new GArea(arc);
                anchorTorus.subtract((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElectrodes)));
            }
        }
        anchors.or(anchorTorus);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createCircularSpringElectrode(double width, double radiusCenterHub, double widthRing, double radiusRing, int numSides, int numElements, double gap, double electrodeWidth, int numElectrodes, double gapFraction, double anchorElectrodeDistance, double anchorDistance, int anchorLayer) {
        double radBeam = (radiusRing - (radiusCenterHub - width / 2.0)) / 2.0;
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub, radiusCenterHub, numSides, layer);
        ga.or(PrimitiveShapes.createTorusW(0.0, 0.0, radiusRing, widthRing, 0.0, 360.0, numSides, layer));
        GArea beam = PrimitiveShapes.createTorusW(0.0, 0.0, radBeam, width, 0.0, 180.0, numSides, layer);
        beam.transform(AffineTransform.getTranslateInstance(radiusRing - radBeam, 0.0));
        GArea temp = new GArea(beam);
        for (int i = 0; i < numElements; ++i) {
            ga.or((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElements)));
            temp = new GArea(beam);
        }
        double radiusElectrodeINNER = radiusRing + widthRing / 2.0 + gap;
        double radiusElectrodeMID = radiusElectrodeINNER + electrodeWidth / 2.0;
        GArea electrodes = PrimitiveShapes.createTorusW(0.0, 0.0, radiusElectrodeMID, electrodeWidth, 0.0, 360.0, numSides, layer);
        double circumference = Math.PI * 2 * radiusElectrodeINNER;
        double electrodeSegment = circumference / (double)numElectrodes;
        double theta = 57.29577951308232 * (electrodeSegment * gapFraction) / radiusElectrodeINNER;
        GArea arc = PrimitiveShapes.createArc(0.0, 0.0, radiusElectrodeINNER + electrodeWidth * 1.5, radiusElectrodeINNER + electrodeWidth * 1.5, -theta / 2.0, theta / 2.0, numSides, layer);
        if (gapFraction > 0.0 && gapFraction < 1.0) {
            for (int i = 0; i < numElectrodes; ++i) {
                temp = new GArea(arc);
                electrodes.subtract((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElectrodes)));
            }
        }
        ga.or(electrodes);
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = PrimitiveShapes.createEllipse(0.0, 0.0, radiusCenterHub - anchorDistance, radiusCenterHub - anchorDistance, numSides, anchorLayer);
        GArea anchorTorus = PrimitiveShapes.createTorusW(0.0, 0.0, radiusElectrodeMID, electrodeWidth - 2.0 * anchorElectrodeDistance, 0.0, 360.0, numSides, layer);
        theta = 57.29577951308232 * (electrodeSegment * gapFraction + 2.0 * anchorElectrodeDistance) / radiusElectrodeINNER;
        arc = PrimitiveShapes.createArc(0.0, 0.0, radiusElectrodeINNER + electrodeWidth * 1.5, radiusElectrodeINNER + electrodeWidth * 1.5, -theta / 2.0, theta / 2.0, numSides, anchorLayer);
        if (gapFraction > 0.0 && gapFraction < 1.0) {
            for (int i = 0; i < numElectrodes; ++i) {
                temp = new GArea(arc);
                anchorTorus.subtract((GDS2)temp.transform(AffineTransform.getRotateInstance((double)(i * 2) * Math.PI / (double)numElectrodes)));
            }
        }
        anchors.or(anchorTorus);
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring1A2A(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, boolean foldedSpring2A) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseWidth, baseHeight / 2.0);
        double startX = baseWidth + length1 + width / 2.0;
        poly.lineTo(startX, baseHeight / 2.0);
        for (int i = 0; i < numberOfPeriods; ++i) {
            poly.lineTo((double)(i * 2) * pitch + startX, baseHeight / 2.0 + amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, baseHeight / 2.0 + amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, baseHeight / 2.0 - amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, baseHeight / 2.0 - amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, baseHeight / 2.0);
        }
        startX = (double)((numberOfPeriods - 1) * 2) * pitch + startX + 2.0 * pitch + length2 + width / 2.0;
        poly.lineTo(startX, baseHeight / 2.0);
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea meander = new GArea(bs.createStrokedShape(poly), layer);
        ga.or(meander);
        if (foldedSpring2A) {
            ga.or(new Rect(startX, 0.0, startX + baseWidth, baseHeight, layer), layer);
        }
        alGA.add(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        if (foldedSpring2A) {
            GArea temp = new GArea(anchors);
            anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX, 0.0)));
        }
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring1B2B(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer, boolean foldedSpring2B) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseWidth, width / 2.0);
        double startX = baseWidth + length1 + width / 2.0;
        poly.lineTo(startX, width / 2.0);
        for (int i = 0; i < numberOfPeriods; ++i) {
            poly.lineTo((double)(i * 2) * pitch + startX, width / 2.0 + 2.0 * amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, width / 2.0 + 2.0 * amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, width / 2.0);
            poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, width / 2.0);
            poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, width / 2.0);
        }
        startX = (double)((numberOfPeriods - 1) * 2) * pitch + startX + 2.0 * pitch + length2 + width / 2.0 - pitch;
        poly.lineTo(startX, width / 2.0);
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea meander = new GArea(bs.createStrokedShape(poly), layer);
        ga.or(meander);
        if (foldedSpring2B) {
            ga.or(new Rect(startX, 0.0, startX + baseWidth, baseHeight, layer), layer);
        }
        alGA.add(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        if (foldedSpring2B) {
            GArea temp = new GArea(anchors);
            anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX, 0.0)));
        }
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2C(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseWidth / 2.0, baseHeight);
        double startX = baseWidth / 2.0;
        double startY = baseHeight + length1 + width / 2.0;
        poly.lineTo(startX, startY);
        for (int i = 0; i < numberOfPeriods; ++i) {
            poly.lineTo((double)(i * 2) * pitch + startX, startY + amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, startY + amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, startY);
            poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, startY);
            poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, startY + amplitude);
        }
        startX = (double)((numberOfPeriods - 1) * 2) * pitch + startX + 2.0 * pitch;
        startY = startY + amplitude + length2;
        poly.lineTo(startX, startY);
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea meander = new GArea(bs.createStrokedShape(poly), layer);
        ga.or(meander);
        ga.or(new Rect(startX -= baseWidth / 2.0, startY, startX + baseWidth, startY + baseHeight, layer), layer);
        alGA.add(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX, startY)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2D(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(baseWidth / 2.0, baseHeight);
        double startX = baseWidth / 2.0;
        double startY = baseHeight + length1 + width / 2.0;
        poly.lineTo(startX, startY);
        for (int i = 0; i < numberOfPeriods; ++i) {
            poly.lineTo((double)(i * 2) * pitch + startX, startY + amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, startY + amplitude);
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, startY);
            if (i != numberOfPeriods - 1) {
                poly.lineTo((double)(i * 2) * pitch + startX + 2.0 * pitch, startY);
                continue;
            }
            poly.lineTo((double)(i * 2) * pitch + startX + pitch, startY - length2);
        }
        startX = (double)((numberOfPeriods - 1) * 2) * pitch + startX + pitch - baseWidth / 2.0;
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea meander = new GArea(bs.createStrokedShape(poly), layer);
        ga.or(meander);
        ga.or(new Rect(startX, 0.0, startX + baseWidth, baseHeight, layer), layer);
        alGA.add(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX, 0.0)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2E(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        double startX = baseWidth + length1;
        double startY = baseHeight / 2.0 - width / 2.0;
        ga.or(new Rect(baseWidth, startY, baseWidth + length1, startY + width, layer), layer);
        double halfwayPoint = (pitch + width) / 2.0;
        GArea meander = new GArea(new Rect(startX, startY, startX + width, startY + amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + halfwayPoint, startY + amplitude + width, pitch / 2.0, width, 0.0, 180.0, numSides, layer));
        meander.or(new Rect(startX + pitch, startY - amplitude - width, startX + pitch + width, startY + amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + pitch + halfwayPoint, startY - amplitude - width, pitch / 2.0, width, 180.0, 360.0, numSides, layer));
        meander.or(new Rect(startX + pitch + pitch, startY - amplitude - width, startX + pitch + pitch + width, startY + width, layer), layer);
        for (int i = 0; i < numberOfPeriods; ++i) {
            GArea temp = new GArea(meander);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
        }
        double lastElement = (double)(numberOfPeriods * 2) * pitch + startX;
        ga.or(new Rect(lastElement, startY, lastElement + length2 + width, startY + width, layer), layer);
        ga.or(new Rect(lastElement + length2 + width, startY - baseHeight / 2.0 + width / 2.0, lastElement + length2 + width + baseWidth, startY + baseHeight / 2.0 + width / 2.0, layer), layer);
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(lastElement + width + length2, startY - baseHeight / 2.0 + width / 2.0)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2F(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth, 0.0, baseWidth + length1, width, layer), layer);
        double startX = baseWidth + length1;
        double halfwayPoint = (pitch + width) / 2.0;
        GArea meander = new GArea(new Rect(startX, 0.0, startX + width, amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + halfwayPoint, amplitude + width, pitch / 2.0, width, 0.0, 180.0, numSides, layer));
        meander.or(new Rect(startX + pitch, 0.0, startX + pitch + width, amplitude + width, layer), layer);
        for (int i = 0; i < numberOfPeriods; ++i) {
            if (i != numberOfPeriods - 1) {
                ga.or(PrimitiveShapes.createTorusW((double)(i * 2) * pitch + startX + pitch + halfwayPoint, 0.0, pitch / 2.0, width, 180.0, 360.0, numSides, layer));
            }
            GArea temp = new GArea(meander);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
        }
        startX = startX + (double)(numberOfPeriods * 2) * pitch - pitch;
        ga.or(new Rect(startX, 0.0, startX + length2 + width, width, layer), layer);
        ga.or(new Rect(startX + length2 + width, 0.0, startX + length2 + width + baseWidth, baseHeight, layer), layer);
        ga.or(meander);
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX + length2 + width, 0.0)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2G(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth / 2.0 - width / 2.0, baseHeight, baseWidth / 2.0 + width / 2.0, baseHeight + length1, layer), layer);
        double startX = baseWidth / 2.0 - width / 2.0;
        double startY = baseHeight + length1;
        double halfwayPoint = (pitch + width) / 2.0;
        GArea meander = new GArea(new Rect(startX, startY, startX + width, startY + amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + halfwayPoint, startY + amplitude + width, pitch / 2.0, width, 0.0, 180.0, numSides, layer));
        meander.or(new Rect(startX + pitch, startY, startX + pitch + width, startY + amplitude + width, layer), layer);
        for (int i = 0; i < numberOfPeriods; ++i) {
            ga.or(PrimitiveShapes.createTorusW((double)(i * 2) * pitch + startX + pitch + halfwayPoint, startY, pitch / 2.0, width, 180.0, 360.0, numSides, layer));
            GArea temp = new GArea(meander);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
        }
        ga.or(new Rect(startX += (double)(numberOfPeriods * 2) * pitch, startY, startX + width, startY + amplitude + width, layer), layer);
        ga.or(new Rect(startX, startY + amplitude, startX + width, startY + amplitude + length2 + width, layer), layer);
        ga.or(new Rect(startX - baseWidth / 2.0 + width / 2.0, startY + amplitude + length2, startX + baseWidth / 2.0 + width / 2.0, startY + amplitude + length2 + baseHeight, layer), layer);
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX - baseWidth / 2.0 + width / 2.0, startY + amplitude + length2)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2H(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth / 2.0 - width / 2.0, baseHeight, baseWidth / 2.0 + width / 2.0, baseHeight + length1, layer), layer);
        double startX = baseWidth / 2.0 - width / 2.0;
        double startY = baseHeight + length1;
        double halfwayPoint = (pitch + width) / 2.0;
        GArea meander = new GArea(new Rect(startX, startY, startX + width, startY + amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + halfwayPoint, startY + amplitude + width, pitch / 2.0, width, 0.0, 180.0, numSides, layer));
        meander.or(new Rect(startX + pitch, startY, startX + pitch + width, startY + amplitude + width, layer), layer);
        for (int i = 0; i < numberOfPeriods; ++i) {
            if (i != numberOfPeriods - 1) {
                ga.or(PrimitiveShapes.createTorusW((double)(i * 2) * pitch + startX + pitch + halfwayPoint, startY, pitch / 2.0, width, 180.0, 360.0, numSides, layer));
            }
            GArea temp = new GArea(meander);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
        }
        startX = startX + (double)(numberOfPeriods * 2) * pitch - pitch;
        ga.or(new Rect(startX, baseHeight, startX + width, baseHeight + length2 + width, layer), layer);
        ga.or(new Rect(startX - baseWidth / 2.0 + width / 2.0, 0.0, startX + baseWidth / 2.0 + width / 2.0, baseHeight, layer), layer);
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX - baseWidth / 2.0 + width / 2.0, 0.0)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2I(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double diameter, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        double radius = (diameter *= 2.0) / 2.0;
        GArea ga = PrimitiveShapes.createEllipse(radius, radius, radius, radius, numSides, layer);
        ga.or(new Rect(radius - width / 2.0, diameter - width, radius + width / 2.0, diameter + width + length1, layer), layer);
        double startX = diameter / 2.0 - width / 2.0;
        double startY = diameter + length1 + width;
        double halfwayPoint = (pitch + width) / 2.0;
        GArea meander = new GArea(new Rect(startX, startY, startX + width, startY + amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + halfwayPoint, startY + amplitude + width, pitch / 2.0, width, 0.0, 180.0, numSides, layer));
        meander.or(new Rect(startX + pitch, startY, startX + pitch + width, startY + amplitude + width, layer), layer);
        for (int i = 0; i < numberOfPeriods; ++i) {
            ga.or(PrimitiveShapes.createTorusW((double)(i * 2) * pitch + startX + pitch + halfwayPoint, startY, pitch / 2.0, width, 180.0, 360.0, numSides, layer));
            GArea temp = new GArea(meander);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
        }
        ga.or(new Rect(startX += (double)(numberOfPeriods * 2) * pitch, startY, startX + width, startY + amplitude + width, layer), layer);
        ga.or(new Rect(startX, startY + amplitude, startX + width, startY + amplitude + length2 + width, layer), layer);
        ga.or(PrimitiveShapes.createEllipse(startX + width / 2.0, startY + amplitude + length2 + radius, radius, radius, numSides, layer));
        ga.transform(AffineTransform.getTranslateInstance(-diameter / 2.0, -diameter / 2.0));
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = PrimitiveShapes.createEllipse(radius, radius, radius - anchorDistance, radius - anchorDistance, numSides, anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX + width / 2.0 - radius, startY + amplitude + length2)));
        alGA.add((GArea)anchors.transform(AffineTransform.getTranslateInstance(-diameter / 2.0, -diameter / 2.0)));
        return alGA;
    }

    public static ArrayList<GArea> createFoldedSpring2J(double width, double length1, double length2, double pitch, double amplitude, int numberOfPeriods, int numSides, double diameter, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        double radius = (diameter *= 2.0) / 2.0;
        GArea ga = PrimitiveShapes.createEllipse(radius, radius, radius, radius, numSides, layer);
        ga.or(new Rect(radius - width / 2.0, diameter - width, radius + width / 2.0, diameter + width + length1, layer), layer);
        double startX = diameter / 2.0 - width / 2.0;
        double startY = diameter + length1 + width;
        double halfwayPoint = (pitch + width) / 2.0;
        GArea meander = new GArea(new Rect(startX, startY, startX + width, startY + amplitude + width, layer), layer);
        meander.or(PrimitiveShapes.createTorusW(startX + halfwayPoint, startY + amplitude + width, pitch / 2.0, width, 0.0, 180.0, numSides, layer));
        meander.or(new Rect(startX + pitch, startY, startX + pitch + width, startY + amplitude + width, layer), layer);
        for (int i = 0; i < numberOfPeriods; ++i) {
            if (i != numberOfPeriods - 1) {
                ga.or(PrimitiveShapes.createTorusW((double)(i * 2) * pitch + startX + pitch + halfwayPoint, startY, pitch / 2.0, width, 180.0, 360.0, numSides, layer));
            }
            GArea temp = new GArea(meander);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
        }
        startX = startX + (double)(numberOfPeriods * 2) * pitch - pitch;
        ga.or(new Rect(startX, diameter - width, startX + width, diameter + length2 + width, layer), layer);
        ga.or(PrimitiveShapes.createEllipse(startX + width / 2.0, radius, radius, radius, numSides, layer));
        ga.transform(AffineTransform.getTranslateInstance(-diameter / 2.0, -diameter / 2.0));
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        GArea anchors = PrimitiveShapes.createEllipse(radius, radius, radius - anchorDistance, radius - anchorDistance, numSides, anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(startX + width / 2.0 - radius, 0.0)));
        alGA.add((GArea)anchors.transform(AffineTransform.getTranslateInstance(-diameter / 2.0, -diameter / 2.0)));
        return alGA;
    }

    public static ArrayList<GArea> createBiMorphThermal(double width1, double width2, double width3, double width4, double length1, double length2, double length3, double pitch, double dimpleHeight, double dimpleWidth, int dimpleLayer, double baseHeight, double baseWidth, double anchorDistance, int anchorLayer) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth, baseHeight - width1, baseWidth + length1, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth + length1, baseHeight - width4, baseWidth + length2, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth + length2 - length3, baseHeight, baseWidth + length2, baseHeight + width3, layer), layer);
        ga.or(new Rect(0.0, baseHeight + width3, baseWidth, 2.0 * baseHeight + width3, layer), layer);
        ga.or(new Rect(baseWidth, baseHeight + width3, baseWidth + length2, baseHeight + width3 + width2, layer), layer);
        alGA.add(ga);
        double distance = length2 - length1;
        if (pitch > dimpleWidth && width4 > dimpleHeight && distance > dimpleWidth) {
            int numPeriods = (int)(distance / pitch);
            double unoccupiedSpace = pitch - dimpleWidth;
            double edgeOffset = (distance - (double)numPeriods * pitch + unoccupiedSpace) / 2.0;
            GArea dimpleSingle = new GArea(new Rect(0.0, 0.0, dimpleWidth, dimpleHeight, dimpleLayer), dimpleLayer);
            double xOffset = baseWidth + length1 + edgeOffset;
            double yOffset = baseHeight - (width4 - dimpleHeight) / 2.0 - dimpleHeight;
            GArea dimple = new GArea((GArea)dimpleSingle.transform(AffineTransform.getTranslateInstance(xOffset, yOffset)));
            GArea temp = new GArea(dimpleSingle);
            for (int i = 1; i < numPeriods; ++i) {
                dimple.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(pitch * (double)i, 0.0)));
                temp = new GArea(dimpleSingle);
            }
            alGA.add(dimple);
        }
        GArea anchors = new GArea(new Rect(anchorDistance, anchorDistance, baseWidth - anchorDistance, baseHeight - anchorDistance, anchorLayer), anchorLayer);
        GArea temp = new GArea(anchors);
        anchors.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, baseHeight + width3)));
        alGA.add(anchors);
        return alGA;
    }

    public static ArrayList<GArea> createBolometerL(double w1, double w2, double w3, double g1, double g2, double g3, double L1, double L2, double r, double ri, int numSides, double a, double b, double c, double d, double e, double f, int La, int Lb, int Lc, int Ld, int Le, int Lf) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double innerWidth = L2 + 2.0 * (g1 + g2 + w2);
        double innerHeight = L1 + 2.0 * (g1 + g2 + w2);
        GArea gaRoundRectInner = new GArea(new RoundRectangle2D.Double(0.0, 0.0, innerWidth, innerHeight, ri, ri), Le);
        gaRoundRectInner.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0, -innerHeight / 2.0));
        gaRoundRectInner.setRenderReso(CNSTscriptingController.getShapeReso());
        GArea gaRoundRectTemp = new GArea(gaRoundRectInner);
        gaRoundRectTemp.grow(g3);
        GArea gaRoundRectOuter = new GArea(gaRoundRectInner);
        gaRoundRectOuter.grow(g3 + w3);
        gaRoundRectOuter.setLayer(Ld);
        gaRoundRectOuter.subtract(gaRoundRectTemp);
        gaRoundRectOuter.setRenderReso(CNSTscriptingController.getShapeReso());
        GArea temp = new GArea(new Rect(-innerWidth / 2.0 - g3 - 2.0 * w3, innerHeight / 2.0 - g1 - w2 / 2.0 - w1 / 2.0 - b, -innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 / 2.0 + w1 / 2.0 + b, Le), Le);
        gaRoundRectOuter.subtract(temp);
        temp = new GArea(new Rect(innerWidth / 2.0, -innerHeight / 2.0 + g1 + w2 / 2.0 - w1 / 2.0 - b, innerWidth / 2.0 + g3 + 2.0 * w3, -innerHeight / 2.0 + g1 + w2 / 2.0 + w1 / 2.0 + b, Le), Le);
        gaRoundRectOuter.subtract(temp);
        alGA.add(gaRoundRectOuter);
        double padding = (w2 - w1) / 2.0;
        alGA.add(new GArea(new Rect(-L2 / 2.0 + padding, -L1 / 2.0 + padding, L2 / 2.0 - padding, L1 / 2.0 - padding, Lf), Lf));
        GArea runnerW2 = new GArea(new Rect(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2, innerWidth / 2.0 - g1 - w2 / 2.0 - r, innerHeight / 2.0 - g1, Lc), Lc);
        runnerW2.or(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 / 2.0 - r, innerHeight / 2.0 - g1 - w2 / 2.0 - r, r, w2, 0.0, 90.0, numSides, Lc));
        runnerW2.or(new GArea(new Rect(innerWidth / 2.0 - g1 - w2, -L1 / 2.0 + w2 / 2.0 + r, innerWidth / 2.0 - g1, innerHeight / 2.0 - g1 - w2 / 2.0 - r, Lc), Lc));
        runnerW2.or(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 / 2.0 - r, -L1 / 2.0 + w2 / 2.0 + r, r, w2, 270.0, 360.0, numSides, Lc));
        runnerW2.or(new GArea(new Rect(L2 / 2.0, -L1 / 2.0, innerWidth / 2.0 - g1 - w2 / 2.0 - r, -L1 / 2.0 + w2, Lc), Lc));
        temp = new GArea(runnerW2);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        runnerW2.or(temp);
        runnerW2.or(new GArea(new Rect(-L2 / 2.0, -L1 / 2.0, L2 / 2.0, L1 / 2.0, Lc), Lc));
        temp = new GArea(new Rect(-ri - w2 / 2.0, 0.0, ri + w2 / 2.0, ri, Lc), Lc);
        GArea circ = PrimitiveShapes.createEllipse(-w2 / 2.0 - ri, ri, ri, ri, numSides, Lc);
        GArea circ2 = PrimitiveShapes.createEllipse(w2 / 2.0 + ri, ri, ri, ri, numSides, Lc);
        temp.subtract(circ);
        temp.subtract(circ2);
        GArea temp2 = new GArea(temp);
        temp2.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        temp2.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 / 2.0));
        runnerW2.or(temp2);
        temp.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        temp.transform(AffineTransform.getTranslateInstance(innerWidth / 2.0, -innerHeight / 2.0 + g1 + w2 / 2.0));
        runnerW2.or(temp);
        alGA.add(runnerW2);
        gaRoundRectInner.subtract(runnerW2);
        alGA.add(gaRoundRectInner);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(f, 0.0);
        poly.lineTo(f + c, d / 2.0 - w1 / 2.0);
        poly.lineTo(f + c, d / 2.0 + w1 / 2.0);
        poly.lineTo(f, d);
        poly.lineTo(0.0, d);
        poly.closePath();
        GArea bondPad = new GArea(poly, Lb);
        temp = new GArea(bondPad);
        temp.grow(-e);
        temp.or(new GArea(new Rect(0.0, e, e, d - e, La), La));
        temp.setLayer(La);
        bondPad.or(new GArea(new Rect(f + c, d / 2.0 - w1 / 2.0, f + c + a, d / 2.0 + w1 / 2.0, Lb), Lb));
        bondPad.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0 - a - c - f, innerHeight / 2.0 - g1 - w2 / 2.0 - d / 2.0));
        temp.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0 - a - c - f, innerHeight / 2.0 - g1 - w2 / 2.0 - d / 2.0));
        temp2 = new GArea(temp);
        temp2.transform(AffineTransform.getRotateInstance(Math.PI));
        temp.or(temp2);
        alGA.add(temp);
        GArea runnerW1 = new GArea(bondPad);
        runnerW1.or(new GArea(new Rect(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 + padding, innerWidth / 2.0 - g1 - w2 / 2.0 - r, innerHeight / 2.0 - g1 - w2 + padding + w1, Lb), Lb));
        runnerW1.or(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 / 2.0 - r, innerHeight / 2.0 - g1 - w2 / 2.0 - r, r, w1, 0.0, 90.0, numSides, Lb));
        runnerW1.or(new GArea(new Rect(innerWidth / 2.0 - g1 - w2 + padding, -L1 / 2.0 + w2 / 2.0 + r, innerWidth / 2.0 - g1 - padding, innerHeight / 2.0 - g1 - w2 / 2.0 - r, Lb), Lb));
        runnerW1.or(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 / 2.0 - r, -L1 / 2.0 + w2 / 2.0 + r, r, w1, 270.0, 360.0, numSides, Lb));
        runnerW1.or(new GArea(new Rect(L2 / 2.0, -L1 / 2.0 + padding, innerWidth / 2.0 - g1 - w2 / 2.0 - r, -L1 / 2.0 + w2 - padding, Lb), Lb));
        int numPeriods = (int)Math.floor((L2 - 2.0 * r) / (4.0 * r));
        double extraLengthPerSide = (L2 - 2.0 * r - (double)(numPeriods * 4) * r) / 2.0;
        double botL1p = -L1 / 2.0 + padding + w1 / 2.0 + r;
        double topL1p = L1 / 2.0 - padding - w1 / 2.0 - r;
        runnerW1.or(new GArea(new Rect(-L2 / 2.0, L1 / 2.0 - padding - w1, -L2 / 2.0 + extraLengthPerSide, L1 / 2.0 - padding, Lb), Lb));
        temp = new GArea(runnerW1);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        runnerW1.or(temp);
        double startX = -L2 / 2.0 + extraLengthPerSide;
        double startY = L1 / 2.0 - padding - w1;
        GArea meander = PrimitiveShapes.createTorusW(startX, startY + w1 / 2.0 - r, r, w1, 0.0, 90.0, numSides, Lb);
        meander.or(new GArea(new Rect(startX + r - w1 / 2.0, botL1p, startX + r + w1 / 2.0, topL1p, Lb), Lb));
        meander.or(PrimitiveShapes.createTorusW(startX + 2.0 * r, botL1p, r, w1, 180.0, 360.0, numSides, Lb));
        meander.or(new GArea(new Rect(startX + 3.0 * r - w1 / 2.0, botL1p, startX + 3.0 * r + w1 / 2.0, topL1p, Lb), Lb));
        meander.or(PrimitiveShapes.createTorusW(startX + 4.0 * r, topL1p, r, w1, 90.0, 180.0, numSides, Lb));
        double pitch = 2.0 * r;
        int cnt = 0;
        for (int i = 0; i < numPeriods; ++i) {
            temp = new GArea(meander);
            runnerW1.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(i * 2) * pitch, 0.0)));
            ++cnt;
        }
        GArea meanderLast = PrimitiveShapes.createTorusW(startX, startY + w1 / 2.0 - r, r, w1, 0.0, 90.0, numSides, Lb);
        meanderLast.or(new GArea(new Rect(startX + r - w1 / 2.0, botL1p, startX + r + w1 / 2.0, topL1p, Lb), Lb));
        meanderLast.or(PrimitiveShapes.createTorusW(startX + 2.0 * r, botL1p, r, w1, 180.0, 270.0, numSides, Lb));
        meanderLast.transform(AffineTransform.getTranslateInstance((double)(cnt * 2) * pitch, 0.0));
        runnerW1.or(meanderLast);
        alGA.add(runnerW1);
        return alGA;
    }

    public static ArrayList<GArea> createBolometerU(double w1, double w2, double w3, double g1, double g2, double g3, double L1, double L2, double r, double ri, int numSides, double a, double b, double c, double d, double e, double f, int La, int Lb, int Lc, int Ld, int Le, int Lf) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double innerWidth = L2 + 2.0 * g1;
        double innerHeight = L1 + 2.0 * g1 + 4.0 * (g2 + w2);
        GArea gaRoundRectInner = new GArea(new RoundRectangle2D.Double(0.0, 0.0, innerWidth, innerHeight, ri, ri), Le);
        gaRoundRectInner.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0, -innerHeight / 2.0));
        gaRoundRectInner.setRenderReso(CNSTscriptingController.getShapeReso());
        GArea gaRoundRectTemp = new GArea(gaRoundRectInner);
        gaRoundRectTemp.grow(g3);
        GArea gaRoundRectOuter = new GArea(gaRoundRectInner);
        gaRoundRectOuter.grow(g3 + w3);
        gaRoundRectOuter.setLayer(Ld);
        gaRoundRectOuter.subtract(gaRoundRectTemp);
        gaRoundRectOuter.setRenderReso(CNSTscriptingController.getShapeReso());
        GArea temp = new GArea(new Rect(-innerWidth / 2.0 - g3 - 2.0 * w3, innerHeight / 2.0 - g1 - w2 / 2.0 - w1 / 2.0 - b, -innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 / 2.0 + w1 / 2.0 + b, Le), Le);
        gaRoundRectOuter.subtract(temp);
        temp = new GArea(new Rect(innerWidth / 2.0, -innerHeight / 2.0 + g1 + w2 / 2.0 - w1 / 2.0 - b, innerWidth / 2.0 + g3 + 2.0 * w3, -innerHeight / 2.0 + g1 + w2 / 2.0 + w1 / 2.0 + b, Le), Le);
        gaRoundRectOuter.subtract(temp);
        alGA.add(gaRoundRectOuter);
        double padding = (w2 - w1) / 2.0;
        alGA.add(new GArea(new Rect(-L2 / 2.0 + padding, -L1 / 2.0 + padding, L2 / 2.0 - padding, L1 / 2.0 - padding, Lf), Lf));
        GArea runnerW2 = new GArea(new Rect(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2, innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1, Lc), Lc);
        runnerW2.or(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 - g2 / 2.0, g2 / 2.0 + w2 / 2.0, w2, 270.0, 90.0, numSides, Lc));
        runnerW2.or(new GArea(new Rect(-innerWidth / 2.0 + g1 + w2 + g2 / 2.0, innerHeight / 2.0 - g1 - 2.0 * w2 - g2, innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 - g2, Lc), Lc));
        runnerW2.or(PrimitiveShapes.createTorusW(-innerWidth / 2.0 + g1 + w2 + g2 / 2.0, innerHeight / 2.0 - g1 - 2.0 * w2 - g2 - g2 / 2.0, g2 / 2.0 + w2 / 2.0, w2, 90.0, 180.0, numSides, Lc));
        runnerW2.or(new Rect(-L2 / 2.0, L1 / 2.0, -L2 / 2.0 + w2, L1 / 2.0 + g2 / 2.0, Lc), Lc);
        temp = new GArea(runnerW2);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        runnerW2.or(temp);
        runnerW2.or(new GArea(new Rect(-L2 / 2.0, -L1 / 2.0, L2 / 2.0, L1 / 2.0, Lc), Lc));
        temp = new GArea(new Rect(-ri - w2 / 2.0, 0.0, ri + w2 / 2.0, ri, Lc), Lc);
        GArea circ = PrimitiveShapes.createEllipse(-w2 / 2.0 - ri, ri, ri, ri, numSides, Lc);
        GArea circ2 = PrimitiveShapes.createEllipse(w2 / 2.0 + ri, ri, ri, ri, numSides, Lc);
        temp.subtract(circ);
        temp.subtract(circ2);
        GArea curvedEnds = new GArea(temp);
        GArea temp2 = new GArea(temp);
        temp2.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        temp2.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 / 2.0));
        runnerW2.or(temp2);
        temp.transform(AffineTransform.getRotateInstance(1.5707963267948966));
        temp.transform(AffineTransform.getTranslateInstance(innerWidth / 2.0, -innerHeight / 2.0 + g1 + w2 / 2.0));
        runnerW2.or(temp);
        alGA.add(runnerW2);
        AffineTransform piRot = new AffineTransform(AffineTransform.getRotateInstance(Math.PI));
        gaRoundRectInner.subtract(new GArea(new Rect(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2, innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1, Le), Le));
        gaRoundRectInner.subtract(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 - g2 / 2.0, g2 / 2.0 + w2 / 2.0, w2, 270.0, 90.0, numSides, Le));
        gaRoundRectInner.subtract(new GArea(new Rect(-innerWidth / 2.0 + g1 + w2 + g2 / 2.0, innerHeight / 2.0 - g1 - 2.0 * w2 - g2, innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 - g2, Le), Le));
        gaRoundRectInner.subtract(PrimitiveShapes.createTorusW(-innerWidth / 2.0 + g1 + w2 + g2 / 2.0, innerHeight / 2.0 - g1 - 2.0 * w2 - g2 - g2 / 2.0, g2 / 2.0 + w2 / 2.0, w2, 90.0, 180.0, numSides, Le));
        gaRoundRectInner.subtract(new Rect(-L2 / 2.0, L1 / 2.0, -L2 / 2.0 + w2, L1 / 2.0 + g2 / 2.0, Le), Le);
        gaRoundRectInner.subtract(new GArea(new Rect(-L2 / 2.0, -L1 / 2.0, L2 / 2.0, L1 / 2.0, Le), Le));
        gaRoundRectInner.subtract(new GArea(new Rect(-innerWidth, -innerHeight, innerWidth, 0.0, Le), Le));
        curvedEnds.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
        curvedEnds.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 / 2.0));
        gaRoundRectInner.subtract(curvedEnds);
        GArea gaRoundRectInnerBot = new GArea(gaRoundRectInner);
        gaRoundRectInner.transform(AffineTransform.getRotateInstance(Math.PI));
        alGA.add(gaRoundRectInner);
        alGA.add(gaRoundRectInnerBot);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(f, 0.0);
        poly.lineTo(f + c, d / 2.0 - w1 / 2.0);
        poly.lineTo(f + c, d / 2.0 + w1 / 2.0);
        poly.lineTo(f, d);
        poly.lineTo(0.0, d);
        poly.closePath();
        GArea bondPad = new GArea(poly, Lb);
        temp = new GArea(bondPad);
        temp.grow(-e);
        temp.or(new GArea(new Rect(0.0, e, e, d - e, La), La));
        temp.setLayer(La);
        bondPad.or(new GArea(new Rect(f + c, d / 2.0 - w1 / 2.0, f + c + a, d / 2.0 + w1 / 2.0, Lb), Lb));
        bondPad.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0 - a - c - f, innerHeight / 2.0 - g1 - w2 / 2.0 - d / 2.0));
        temp.transform(AffineTransform.getTranslateInstance(-innerWidth / 2.0 - a - c - f, innerHeight / 2.0 - g1 - w2 / 2.0 - d / 2.0));
        temp2 = new GArea(temp);
        temp2.transform(AffineTransform.getRotateInstance(Math.PI));
        temp.or(temp2);
        alGA.add(temp);
        GArea runnerW1 = new GArea(bondPad);
        runnerW1.or(new GArea(new Rect(-innerWidth / 2.0, innerHeight / 2.0 - g1 - w2 + padding, innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 + padding + w1, Lb), Lb));
        runnerW1.or(PrimitiveShapes.createTorusW(innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 - g2 / 2.0, g2 / 2.0 + w2 / 2.0, w1, 270.0, 90.0, numSides, Lc));
        runnerW1.or(new GArea(new Rect(-innerWidth / 2.0 + g1 + w2 + g2 / 2.0, innerHeight / 2.0 - g1 - 2.0 * w2 - g2 + padding, innerWidth / 2.0 - g1 - w2 - g2 / 2.0, innerHeight / 2.0 - g1 - w2 - g2 - padding, Lc), Lc));
        runnerW1.or(PrimitiveShapes.createTorusW(-innerWidth / 2.0 + g1 + w2 + g2 / 2.0, innerHeight / 2.0 - g1 - 2.0 * w2 - g2 - g2 / 2.0, g2 / 2.0 + w2 / 2.0, w1, 90.0, 180.0, numSides, Lc));
        runnerW1.or(new GArea(new Rect(-L2 / 2.0 + padding, L1 / 2.0, -L2 / 2.0 + w2 - padding, L1 / 2.0 + g2 / 2.0, Lc), Lc));
        int numPeriods = (int)Math.floor((L1 - 2.0 * r) / (4.0 * r));
        double extraLengthPerSide = (L1 - 2.0 * r - (double)(numPeriods * 4) * r) / 2.0;
        double negL2p = -L2 / 2.0 + padding + w1 / 2.0 + r;
        double posL2p = L2 / 2.0 - padding - w1 / 2.0 - r;
        runnerW1.or(new GArea(new Rect(-L2 / 2.0 + padding, L1 / 2.0 - extraLengthPerSide, -L2 / 2.0 + padding + w1, L1 / 2.0, Lb), Lb));
        temp = new GArea(runnerW1);
        runnerW1.or((GDS2)temp.transform(AffineTransform.getRotateInstance(Math.PI)));
        double startX = -L2 / 2.0 + padding + w1;
        double startY = L1 / 2.0 - extraLengthPerSide;
        GArea meander = PrimitiveShapes.createTorusW(startX - w1 / 2.0 + r, startY, r, w1, 180.0, 270.0, numSides, Lb);
        meander.or(new GArea(new Rect(negL2p, startY - r - w1 / 2.0, posL2p, startY - r + w1 / 2.0, Lb), Lb));
        meander.or(PrimitiveShapes.createTorusW(posL2p, startY - 2.0 * r, r, w1, 270.0, 90.0, numSides, Lb));
        meander.or(new GArea(new Rect(negL2p, startY - 3.0 * r - w1 / 2.0, posL2p, startY - 3.0 * r + w1 / 2.0, Lb), Lb));
        meander.or(PrimitiveShapes.createTorusW(negL2p, startY - 4.0 * r, r, w1, 90.0, 180.0, numSides, Lb));
        double pitch = 2.0 * r;
        int cnt = 0;
        for (int i = 0; i < numPeriods; ++i) {
            temp = new GArea(meander);
            runnerW1.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, (double)(-i * 2) * pitch)));
            ++cnt;
        }
        GArea meanderLast = PrimitiveShapes.createTorusW(startX - w1 / 2.0 + r, startY, r, w1, 180.0, 270.0, numSides, Lb);
        meanderLast.or(new GArea(new Rect(negL2p, startY - r - w1 / 2.0, posL2p, startY - r + w1 / 2.0, Lb), Lb));
        meanderLast.or(PrimitiveShapes.createTorusW(posL2p, startY - 2.0 * r, r, w1, 0.0, 90.0, numSides, Lb));
        meanderLast.transform(AffineTransform.getTranslateInstance(0.0, (double)(-cnt * 2) * pitch));
        runnerW1.or(meanderLast);
        alGA.add(runnerW1);
        return alGA;
    }

    public static ArrayList<GArea> createFluidCell(double w1, double w2, double w2T, double w3, double w4, double L1, double L2, double r, double r1, double r2, double r3, int numSides, double a, double b, double c, double d, double e, double f, double g, double h, double i, int La, int Lb, int Lc, int Ld, int Le, int Lf) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea goldPad = Scripting.createEllipse(0.0, 0.0, r1, r1, numSides, 0.0, La);
        alGA.add(goldPad);
        GArea fluidChannel = Scripting.createEllipse(0.0, 0.0, r2, r2, numSides, 0.0, Lc);
        fluidChannel.or(new GArea(new Rect(r2 - w2, 0.0, r2, L1, Lc), Lc));
        fluidChannel.or(Scripting.createSbendFunnel(r2 - w2 / 2.0, L1, L2, w2T / 2.0, w2, 90.0, Le, CNSTscriptingController.getShapeReso()));
        GArea temp = new GArea(fluidChannel);
        fluidChannel.or((GDS2)temp.transform(AffineTransform.getRotateInstance(Math.PI)));
        alGA.add(fluidChannel);
        GArea release = Scripting.createEllipse(0.0, 0.0, r3, r3, numSides, 0.0, Ld);
        GArea releaseGap = Scripting.createEllipse(0.0, 0.0, r2 + i, r2 + i, numSides, 0.0, 44);
        releaseGap.or(new GArea(new Rect(r2 - w2 - i, 0.0, r2 + i, L1, 44), 44));
        releaseGap.or(new GArea(new Rect(-r2 - i, -L1, -r2 + w2 + i, 0.0, 44), 44));
        release.subtract(releaseGap);
        alGA.add(release);
        double trenchWtot = 2.0 * w3 + 3.0 * w4;
        double trenchRin = r3 + h;
        GArea trench = Scripting.createTorus(0.0, 0.0, trenchRin, trenchRin + trenchWtot, 0.0, 360.0, numSides, 0.0, Le);
        trench.subtract(Scripting.createTorus(0.0, 0.0, trenchRin + w4, trenchRin + w4 + w3, 0.0, 360.0, numSides, 0.0, Le));
        trench.subtract(Scripting.createTorus(0.0, 0.0, trenchRin + 2.0 * w4 + w3, trenchRin + 2.0 * w4 + 2.0 * w3, 0.0, 360.0, numSides, 0.0, Le));
        GArea trenchRectSub = new GArea(new Rect(r2 - w2 - b, 0.0, r2 + b, trenchRin + trenchWtot, Le), Le);
        trench.subtract(trenchRectSub);
        temp = new GArea(trenchRectSub);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        trench.subtract(temp);
        double yRbot = Math.sqrt((r3 + h) * (r3 + h) - (r2 + b) * (r2 + b));
        double xR = r2 + b;
        double yRtop = Math.sqrt((r3 + h + 2.0 * w3 + 2.0 * w4) * (r3 + h + 2.0 * w3 + 2.0 * w4) - (r2 + b) * (r2 + b));
        temp = new GArea(new Rect(xR, yRbot, xR + w4, yRtop, Le), Le);
        trench.or(temp);
        GArea temp2 = new GArea(temp);
        trench.or((GDS2)temp2.transform(AffineTransform.getRotateInstance(Math.PI)));
        double yLbot = Math.sqrt((r3 + h + w4) * (r3 + h + w4) - (r2 - w2 - b) * (r2 - w2 - b));
        double xL = r2 - w2 - b - w4;
        double yLtop = Math.sqrt((r3 + h + 2.0 * w3 + 3.0 * w4) * (r3 + h + 2.0 * w3 + 3.0 * w4) - (r2 - w2 - b) * (r2 - w2 - b));
        temp = new GArea(new Rect(xL, yLbot, xL + w4, yLtop, Le), Le);
        trench.or(temp);
        temp2 = new GArea(temp);
        trench.or((GDS2)temp2.transform(AffineTransform.getRotateInstance(Math.PI)));
        double rCrit = r2 - w2 / 2.0;
        int nTurns = (int)(rCrit / (2.0 * w1 * 2.0));
        double extraSpace = rCrit - (double)nTurns * (2.0 * w1 * 2.0);
        ArrayList<GArea> spiralDDGA = Scripting.createSpiralDelayLineArch(0.0, 0.0, w1, nTurns, 3.0 * w1 + (extraSpace /= (double)nTurns), 0.01, a, 0.0, 0, Lb);
        for (int j = 0; j < spiralDDGA.size(); ++j) {
            alGA.add(spiralDDGA.get(j));
        }
        int gdsTestLayer = 44;
        temp = Scripting.createTorusW(r2 - w2 / 2.0 + r, a, r, w1, 90.0, 180.0, numSides, 0.0, Lb);
        temp.or(new GArea(new Rect(r2 - w2 / 2.0 - w1 / 2.0, 0.0, r2 - w2 / 2.0 + w1 / 2.0, a, Lb), Lb));
        double startX = r2 - w2 / 2.0 + r;
        double startY = a + r - w1 / 2.0;
        temp.or(new GArea(new Rect(startX, startY, startX + c, startY + w1, Lb), Lb));
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(startX + c, startY + w1);
        poly.lineTo(startX + c + d, startY + w1 / 2.0 + e / 2.0);
        poly.lineTo(startX + c + d + g, startY + w1 / 2.0 + e / 2.0);
        poly.lineTo(startX + c + d + g, startY + w1 / 2.0 - e / 2.0);
        poly.lineTo(startX + c + d, startY + w1 / 2.0 - e / 2.0);
        poly.lineTo(startX + c, startY);
        GArea bondPad = new GArea(poly, Lb);
        temp.or(bondPad);
        temp2 = new GArea(temp);
        temp.or((GDS2)temp2.transform(AffineTransform.getRotateInstance(Math.PI)));
        alGA.add(temp);
        GArea smallerBondPad = new GArea(bondPad);
        smallerBondPad.grow(-f);
        smallerBondPad.or(new GArea(new Rect(startX + c + d + g - f, startY + w1 / 2.0 - e / 2.0 + f, startX + c + d + g, startY + w1 / 2.0 + e / 2.0 - f, Lf), Lf));
        smallerBondPad.setLayer(Lf);
        temp = new GArea(smallerBondPad);
        smallerBondPad.or((GDS2)temp.transform(AffineTransform.getRotateInstance(Math.PI)));
        alGA.add(smallerBondPad);
        alGA.add(trench);
        return alGA;
    }
}

