/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.basicShapes;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.basicShapes.GratingsData;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Array;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class GratingsController
implements AboutInterface {
    static File file = null;
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    final ObservableList<GratingsData> ol = FXCollections.observableArrayList();
    @FXML
    private TableView<GratingsData> tGratings;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfTopCellSpacing;
    @FXML
    private Label lStatus;

    @FXML
    private void createGDS(ActionEvent event) {
        double spacing = Double.parseDouble(this.tfTopCellSpacing.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        Struct top = new Struct("top");
        this.createGratings(top, spacing, layer);
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void loadGratingTable(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Grating Table Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        String fileName = file.getPath();
        if (fileName != null) {
            try {
                FileInputStream fstream = new FileInputStream(fileName);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String REGEX = "\\s+";
                Pattern p = Pattern.compile(REGEX);
                int cnt = 0;
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] theLine = p.split(line);
                    ((GratingsData)this.tGratings.getItems().get(cnt)).setLineWidth(theLine[0]);
                    ((GratingsData)this.tGratings.getItems().get(cnt)).setLineLength(theLine[1]);
                    ((GratingsData)this.tGratings.getItems().get(cnt)).setPitch(theLine[2]);
                    ((GratingsData)this.tGratings.getItems().get(cnt)).setNumberOfLines(theLine[3]);
                    ++cnt;
                }
                in.close();
                this.lStatus.setText("Grating Table data loaded from " + fileName);
                this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                this.displayColor = this.displayColor == 0 ? 1 : 0;
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }

    public void createGratings(Struct top, double spacing, int layer) {
        double xPos = 0.0;
        for (int i = 0; i < this.tGratings.getItems().size(); ++i) {
            if (!this.checkNullValues(((GratingsData)this.tGratings.getItems().get(i)).getLineWidth(), ((GratingsData)this.tGratings.getItems().get(i)).getLineLength(), ((GratingsData)this.tGratings.getItems().get(i)).getPitch(), ((GratingsData)this.tGratings.getItems().get(i)).getNumberOfLines())) continue;
            double w = Double.parseDouble(((GratingsData)this.tGratings.getItems().get(i)).getLineWidth());
            double l = Double.parseDouble(((GratingsData)this.tGratings.getItems().get(i)).getLineLength());
            double pitch = Double.parseDouble(((GratingsData)this.tGratings.getItems().get(i)).getPitch());
            int numLines = Integer.parseInt(((GratingsData)this.tGratings.getItems().get(i)).getNumberOfLines());
            String structName = "R" + this.rowNumberPrefix(i) + (i + 1) + "W" + (int)(w * 1000.0) + "L" + (int)(l * 1000.0) + "P" + (int)(pitch * 1000.0) + "N" + numLines;
            Struct testStruct = new Struct(structName, new Rect(0.0, 0.0, w, l, layer));
            structName = "R" + this.rowNumberPrefix(i) + (i + 1) + "ARRAY";
            Struct arrayStruct = new Struct(structName, new Array(testStruct, 0.0, 0.0, numLines, 1, (double)numLines * pitch, 1.0));
            top.add(new Ref(arrayStruct, xPos, 0.0));
            xPos += this.arrayExtent(w, pitch, numLines, spacing);
        }
    }

    public double arrayExtent(double w, double pitch, int numLines, double spacing) {
        return (double)(numLines - 1) * pitch + w + spacing;
    }

    public String rowNumberPrefix(int i) {
        boolean b = i < 10;
        return b ? "0" : "";
    }

    public boolean checkNullValues(String w, String l, String pitch, String numLines) {
        return w != null && l != null && pitch != null && numLines != null;
    }

    @FXML
    private void initialize() {
        AboutActions.hideAbout(this.about, "About:    Gratings Module", "The gratings module is used to create arrays of lines with defined length, width and pitch. Array values from the user input table are employed to construct individual GDS structures of each array. Thearrays are then instantiated within the 'top' cell.");
        int numGratings = 400;
        for (int i = 0; i < numGratings; ++i) {
            this.ol.add((Object)new GratingsData(null, null, null, null));
        }
        this.tGratings.setItems(this.ol);
        final TableColumn c1 = new TableColumn("Line Width (um)");
        c1.setCellValueFactory((Callback)new PropertyValueFactory("lineWidth"));
        c1.setCellFactory((Callback)new TextFieldCellFactory());
        c1.setPrefWidth(121.0);
        c1.setSortable(false);
        c1.setResizable(false);
        final TableColumn c2 = new TableColumn("Line Length (um)");
        c2.setCellValueFactory((Callback)new PropertyValueFactory("lineLength"));
        c2.setCellFactory((Callback)new TextFieldCellFactory());
        c2.setPrefWidth(121.0);
        c2.setSortable(false);
        c2.setResizable(false);
        final TableColumn c3 = new TableColumn("Pitch (um)");
        c3.setCellValueFactory((Callback)new PropertyValueFactory("pitch"));
        c3.setCellFactory((Callback)new TextFieldCellFactory());
        c3.setPrefWidth(121.0);
        c3.setSortable(false);
        c3.setResizable(false);
        final TableColumn c4 = new TableColumn("Number of Lines");
        c4.setCellValueFactory((Callback)new PropertyValueFactory("numberOfLines"));
        c4.setCellFactory((Callback)new TextFieldCellFactory());
        c4.setPrefWidth(121.0);
        c4.setSortable(false);
        c4.setResizable(false);
        this.tGratings.getColumns().addAll((Object[])new TableColumn[]{c1, c2, c3, c4});
        this.tGratings.getColumns().addListener(new ListChangeListener(){
            public boolean suspended;

            public void onChanged(ListChangeListener.Change change) {
                change.next();
                if (change.wasReplaced() && !this.suspended) {
                    this.suspended = true;
                    GratingsController.this.tGratings.getColumns().setAll((Object[])new TableColumn[]{c1, c2, c3, c4});
                    this.suspended = false;
                }
            }
        });
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(GratingsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void printTable() {
        System.out.println("***************************************************************");
        System.out.println("tGratings.getItems().size() = " + this.tGratings.getItems().size());
        for (int i = 0; i < this.tGratings.getItems().size(); ++i) {
            System.out.println("i = " + i);
            System.out.println("tGratings.getItems().get(" + i + ").getLineWidth() = " + ((GratingsData)this.tGratings.getItems().get(i)).getLineWidth());
            System.out.println("tGratings.getItems().get(" + i + ").getLineLength() = " + ((GratingsData)this.tGratings.getItems().get(i)).getLineLength());
            System.out.println("tGratings.getItems().get(" + i + ").getPitch() = " + ((GratingsData)this.tGratings.getItems().get(i)).getPitch());
            System.out.println("tGratings.getItems().get(" + i + ").getNumberOfLines() = " + ((GratingsData)this.tGratings.getItems().get(i)).getNumberOfLines());
        }
    }

    public static class TextFieldCellFactory
    implements Callback<TableColumn<GratingsData, String>, TableCell<GratingsData, String>> {
        public TableCell<GratingsData, String> call(TableColumn<GratingsData, String> param) {
            TextFieldCell textFieldCell = new TextFieldCell();
            return textFieldCell;
        }

        public static class TextFieldCell
        extends TableCell<GratingsData, String> {
            private TextField textField;
            private StringProperty boundToCurrently = null;

            public TextFieldCell() {
                String strCss = "-fx-padding: 0;";
                this.setStyle(strCss);
                this.textField = new TextField();
                strCss = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostFocus = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotFocus);
                        } else {
                            tf.setStyle(strStyleLostFocus);
                        }
                    }
                });
                this.textField.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotHover = "-fx-background-color: derive(purple,90%), -fx-text-box-border, derive(-fx-control-inner-background, 10%);-fx-background-insets: 1, 2.8, 3.8;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostHover = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        String strStyleHasFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotHover);
                        } else if (!tf.focusedProperty().get()) {
                            tf.setStyle(strStyleLostHover);
                        } else {
                            tf.setStyle(strStyleHasFocus);
                        }
                    }
                });
                this.textField.setStyle(strCss);
                this.setGraphic((Node)this.textField);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    ObservableValue ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                    SimpleStringProperty sp = (SimpleStringProperty)ov;
                    if (this.boundToCurrently == null) {
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)sp);
                    } else if (this.boundToCurrently != sp) {
                        this.textField.textProperty().unbindBidirectional((Property)this.boundToCurrently);
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)this.boundToCurrently);
                    }
                } else {
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            }
        }
    }
}

