/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class Text2GDSController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfText;
    @FXML
    private TextField tfSize;
    @FXML
    private TextField tfResolution;
    @FXML
    private TextField tfLayer;
    @FXML
    private ComboBox<String> cbFontList;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Text To GDS Module", "Text to GDS module casts a text string into a GDS shape using the selected vectorized font. Font size is defined from the decender to ascender line in micrometers. Font resolution is the rendering resolution of the vectorized font.");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            this.cbFontList.getItems().add((Object)fontFamilies[i]);
        }
        this.cbFontList.setValue((Object)"Serif");
        this.cbFontList.setVisibleRowCount(11);
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(Text2GDSController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double size = Double.parseDouble(this.tfSize.getText());
        double reso = Double.parseDouble(this.tfResolution.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String fileName = this.tfFileName.getText();
        String textString = this.tfText.getText();
        String fontType = (String)this.cbFontList.getValue();
        Lib lib = new Lib();
        Struct text = new Struct("text");
        Struct textCentered = new Struct("textCentered");
        Font font = new Font(fontType, 0, 1000);
        Text lb = new Text(textString, layer, font);
        lb.setFontSize(size);
        lb.setRenderReso(reso);
        text.add(lb);
        Area a = new Area(lb.getArea());
        Rectangle2D rec = a.getBounds2D();
        a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
        GArea g = new GArea(a, layer);
        g.setRenderReso(reso);
        textCentered.add(g);
        lib.add(new Ref(text, 0.0, 0.0));
        lib.add(new Ref(textCentered, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

