/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class RandomPolygonsController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    int displayColor2 = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfElements;
    @FXML
    private TextField tfRadius;
    @FXML
    private TextField tfSides;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfLength;
    @FXML
    private TextField tfSeparation;
    @FXML
    private TextField tfIterations;
    @FXML
    private CheckBox chbRandomRotation;
    @FXML
    private Label lElementStatus;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Random Polygons Module", "This module randomly places shapes within a specified area. User defined separation potential controls the minimum spacing between elements. Example applications of the resulting structure reside in micro- and nano-fluidic sorting, random photonic crystals and other localization phenonmenon based on random distrubution of  asperities.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(RandomPolygonsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double radius = Double.parseDouble(this.tfRadius.getText());
        double width = Double.parseDouble(this.tfWidth.getText());
        double length = Double.parseDouble(this.tfLength.getText());
        double separation = Double.parseDouble(this.tfSeparation.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        int elements = Integer.parseInt(this.tfElements.getText());
        int sides = Integer.parseInt(this.tfSides.getText());
        int iterations = Integer.parseInt(this.tfIterations.getText());
        String fileName = this.tfFileName.getText();
        if (sides > 2) {
            Lib lib = new Lib();
            Struct top = new Struct("top");
            Struct shapeElement = new Struct("shape", new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, radius, radius, sides, layer)));
            TreeMap<Double, Double> coordinates = RandomPolygonsController.generateCoordinates(width, length, radius, separation, iterations, elements);
            for (int i = 0; i < coordinates.size(); ++i) {
                if (this.chbRandomRotation.isSelected()) {
                    top.add(new Ref(shapeElement, Double.parseDouble(coordinates.keySet().toArray()[i].toString()), Double.parseDouble(coordinates.values().toArray()[i].toString()), 0, Math.random() * 360.0));
                    continue;
                }
                top.add(new Ref(shapeElement, Double.parseDouble(coordinates.keySet().toArray()[i].toString()), Double.parseDouble(coordinates.values().toArray()[i].toString())));
            }
            lib.add(new Ref(top, 0.0, 0.0));
            File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
            this.lStatus.setText("Saved to " + f.getAbsolutePath());
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
            this.lElementStatus.setText(coordinates.size() + " elements created");
            this.lElementStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
            this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
        } else {
            this.lStatus.setText("ERROR: NUMBER OF SIDES < 3");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    public static TreeMap<Double, Double> generateCoordinates(double xWidth, double yLength, double radius, double separation, int iterations, int numberOfElements) {
        HashMap<Double, Double> hashMap = new HashMap<Double, Double>();
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>(hashMap);
        int count = 0;
        hashMap.put(Math.random() * (xWidth - radius), Math.random() * (yLength - radius));
        treeMap = new TreeMap(hashMap);
        for (int i = 1; i < numberOfElements; ++i) {
            SortedMap<Double, Double> subMap;
            double yVal;
            double xVal = Math.random() * xWidth;
            boolean testDistance = RandomPolygonsController.testSeparation(xVal, yVal = Math.random() * yLength, separation, subMap = treeMap.subMap(xVal - separation, xVal + separation));
            if (testDistance) {
                hashMap.put(xVal, yVal);
                treeMap = new TreeMap(hashMap);
                count = 0;
                continue;
            }
            --i;
            if (++count != iterations) continue;
            i = numberOfElements + 1;
        }
        return treeMap;
    }

    static boolean testSeparation(double xVal, double yVal, double separation, Map<Double, Double> subMap) {
        int count = 0;
        if (subMap.isEmpty()) {
            return true;
        }
        for (int i = 0; i < subMap.size(); ++i) {
            double y;
            double x = xVal - Double.parseDouble(subMap.keySet().toArray()[i].toString());
            double distance = Math.sqrt(x * x + (y = yVal - Double.parseDouble(subMap.values().toArray()[i].toString())) * y);
            if (distance > separation) {
                ++count;
                continue;
            }
            i = subMap.size() + 1;
        }
        return count == subMap.size();
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

