/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.advancedCAD.PhotonicCrystalsData;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Array;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class PhotonicCrystalsController
implements AboutInterface {
    static File file = null;
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    final ObservableList<PhotonicCrystalsData> ol = FXCollections.observableArrayList();
    @FXML
    private TableView<PhotonicCrystalsData> tPhotonicCrystals;
    @FXML
    private TextField tfFileName;
    @FXML
    private Label lStatus;

    @FXML
    private void createGDS(ActionEvent event) {
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        this.createGratings(lib);
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void loadPhCTable(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Photonic Crystal Table Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        String fileName = file.getPath();
        if (fileName != null) {
            try {
                FileInputStream fstream = new FileInputStream(fileName);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String REGEX = "\\s+";
                Pattern p = Pattern.compile(REGEX);
                int cnt = 0;
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] theLine = p.split(line);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setDiameter(theLine[0]);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setSides(theLine[1]);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setSpacing(theLine[2]);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setSizeX(theLine[3]);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setSizeY(theLine[4]);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setSeparation(theLine[5]);
                    ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(cnt)).setLayer(theLine[6]);
                    ++cnt;
                }
                in.close();
                this.lStatus.setText("Photonic Crystal Table data loaded from " + fileName);
                this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                this.displayColor = this.displayColor == 0 ? 1 : 0;
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }

    public void createGratings(Lib lib) {
        for (int i = 0; i < this.tPhotonicCrystals.getItems().size(); ++i) {
            if (!this.checkNullValues(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getDiameter(), ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSides(), ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSpacing(), ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSizeX(), ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSizeY(), ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSeparation(), ((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getLayer())) continue;
            double diameter = Double.parseDouble(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getDiameter());
            diameter /= 1000.0;
            int sides = Integer.parseInt(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSides());
            double spacing = Double.parseDouble(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSpacing());
            spacing /= 1000.0;
            double sizeX = Double.parseDouble(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSizeX());
            double sizeY = Double.parseDouble(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSizeY());
            double separation = Double.parseDouble(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getSeparation());
            separation /= 1000.0;
            int layer = Integer.parseInt(((PhotonicCrystalsData)this.tPhotonicCrystals.getItems().get(i)).getLayer());
            String structName = "R" + this.rowNumberPrefix(i) + (i + 1) + "D" + (int)(diameter * 1000.0);
            Struct circleStruct = new Struct(structName, new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, diameter / 2.0, diameter / 2.0, sides, layer)));
            double t = 2.0 * (diameter + spacing) * Math.cos(0.5235987755982988);
            int temp = (int)(sizeX / (diameter + spacing));
            int temp2 = (int)(sizeY / t);
            structName = "R" + this.rowNumberPrefix(i) + (i + 1) + "HexARRAY";
            Struct arrayHex = new Struct(structName, new Array(circleStruct, 0.0, 0.0, temp + 1, temp2 + 1, sizeX + sizeX / (double)temp, (double)temp2 * t + t));
            arrayHex.add(new Array(circleStruct, (diameter + spacing) / 2.0, (diameter + spacing) * Math.cos(0.5235987755982988), temp, temp2, sizeX, (double)temp2 * t));
            structName = "R" + this.rowNumberPrefix(i) + (i + 1) + "PhC_D" + (int)(diameter * 1000.0) + "XS" + (int)(sizeX * 1000.0) + "YS" + (int)(sizeY * 1000.0);
            Struct PhC = new Struct(structName, new Ref(arrayHex, 0.0, (separation + diameter) / 2.0));
            DecimalFormat formatter = new DecimalFormat(".####");
            String tempString = formatter.format(t);
            tempString = tempString.substring(0, tempString.length() - 1);
            double extentCalc = Double.parseDouble(tempString);
            PhC.add(new Ref(arrayHex, 0.0, -((double)temp2 * extentCalc + separation / 2.0 + diameter / 2.0)));
            lib.add(new Ref(PhC, 0.0, 0.0));
        }
    }

    public double arrayExtent(double w, double pitch, int numLines, double spacing) {
        return (double)(numLines - 1) * pitch + w + spacing;
    }

    public String rowNumberPrefix(int i) {
        boolean b = i < 10;
        return b ? "0" : "";
    }

    public boolean checkNullValues(String diameter, String sides, String spacing, String sizeX, String sizeY, String separation, String layer) {
        return diameter != null && sides != null && spacing != null && sizeX != null && sizeY != null && separation != null && layer != null;
    }

    @FXML
    private void initialize() {
        AboutActions.hideAbout(this.about, "About:    Photonic Crystals Module", "This module creates a hexagonal array of circular dots.  The array is then instantiated inorder to form two hexagonal arrays separated by a user defined distance. Example applications of the resulting structures could be in micro- and nano-photonics, -fluidics, -mechanics, -electronics and related fields.");
        int numPhCs = 400;
        for (int i = 0; i < numPhCs; ++i) {
            this.ol.add((Object)new PhotonicCrystalsData(null, null, null, null, null, null, null));
        }
        this.tPhotonicCrystals.setItems(this.ol);
        final TableColumn c1 = new TableColumn("Diameter(nm)");
        c1.setCellValueFactory((Callback)new PropertyValueFactory("diameter"));
        c1.setCellFactory((Callback)new TextFieldCellFactory());
        c1.setPrefWidth(100.0);
        c1.setSortable(false);
        c1.setResizable(false);
        final TableColumn c2 = new TableColumn("Sides");
        c2.setCellValueFactory((Callback)new PropertyValueFactory("sides"));
        c2.setCellFactory((Callback)new TextFieldCellFactory());
        c2.setPrefWidth(60.0);
        c2.setSortable(false);
        c2.setResizable(false);
        final TableColumn c3 = new TableColumn("Spacing(nm)");
        c3.setCellValueFactory((Callback)new PropertyValueFactory("spacing"));
        c3.setCellFactory((Callback)new TextFieldCellFactory());
        c3.setPrefWidth(95.0);
        c3.setSortable(false);
        c3.setResizable(false);
        final TableColumn c4 = new TableColumn("SizeX(um)");
        c4.setCellValueFactory((Callback)new PropertyValueFactory("sizeX"));
        c4.setCellFactory((Callback)new TextFieldCellFactory());
        c4.setPrefWidth(90.0);
        c4.setSortable(false);
        c4.setResizable(false);
        final TableColumn c5 = new TableColumn("SizeY(um)");
        c5.setCellValueFactory((Callback)new PropertyValueFactory("sizeY"));
        c5.setCellFactory((Callback)new TextFieldCellFactory());
        c5.setPrefWidth(85.0);
        c5.setSortable(false);
        c5.setResizable(false);
        final TableColumn c6 = new TableColumn("Separation(nm)");
        c6.setCellValueFactory((Callback)new PropertyValueFactory("separation"));
        c6.setCellFactory((Callback)new TextFieldCellFactory());
        c6.setPrefWidth(105.0);
        c6.setSortable(false);
        c6.setResizable(false);
        final TableColumn c7 = new TableColumn("Layer");
        c7.setCellValueFactory((Callback)new PropertyValueFactory("layer"));
        c7.setCellFactory((Callback)new TextFieldCellFactory());
        c7.setPrefWidth(60.0);
        c7.setSortable(false);
        c7.setResizable(false);
        this.tPhotonicCrystals.getColumns().addAll((Object[])new TableColumn[]{c1, c2, c3, c4, c5, c6, c7});
        this.tPhotonicCrystals.getColumns().addListener(new ListChangeListener(){
            public boolean suspended;

            public void onChanged(ListChangeListener.Change change) {
                change.next();
                if (change.wasReplaced() && !this.suspended) {
                    this.suspended = true;
                    PhotonicCrystalsController.this.tPhotonicCrystals.getColumns().setAll((Object[])new TableColumn[]{c1, c2, c3, c4, c5, c6, c7});
                    this.suspended = false;
                }
            }
        });
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(PhotonicCrystalsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class TextFieldCellFactory
    implements Callback<TableColumn<PhotonicCrystalsData, String>, TableCell<PhotonicCrystalsData, String>> {
        public TableCell<PhotonicCrystalsData, String> call(TableColumn<PhotonicCrystalsData, String> param) {
            TextFieldCell textFieldCell = new TextFieldCell();
            return textFieldCell;
        }

        public static class TextFieldCell
        extends TableCell<PhotonicCrystalsData, String> {
            private TextField textField;
            private StringProperty boundToCurrently = null;

            public TextFieldCell() {
                String strCss = "-fx-padding: 0;";
                this.setStyle(strCss);
                this.textField = new TextField();
                strCss = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostFocus = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotFocus);
                        } else {
                            tf.setStyle(strStyleLostFocus);
                        }
                    }
                });
                this.textField.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotHover = "-fx-background-color: derive(purple,90%), -fx-text-box-border, derive(-fx-control-inner-background, 10%);-fx-background-insets: 1, 2.8, 3.8;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostHover = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        String strStyleHasFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotHover);
                        } else if (!tf.focusedProperty().get()) {
                            tf.setStyle(strStyleLostHover);
                        } else {
                            tf.setStyle(strStyleHasFocus);
                        }
                    }
                });
                this.textField.setStyle(strCss);
                this.setGraphic((Node)this.textField);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    ObservableValue ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                    SimpleStringProperty sp = (SimpleStringProperty)ov;
                    if (this.boundToCurrently == null) {
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)sp);
                    } else if (this.boundToCurrently != sp) {
                        this.textField.textProperty().unbindBidirectional((Property)this.boundToCurrently);
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)this.boundToCurrently);
                    }
                } else {
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            }
        }
    }
}

