/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class CantileverArraysController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfLinear;
    @FXML
    private TextField tfPercentage;
    @FXML
    private TextField tfSineAmplitude;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfNumberOfElements;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfLenghtStart;
    @FXML
    private TextField tfLengthEnd;
    @FXML
    private TextField tfPitch;
    @FXML
    private TextField tfBaseExtent;
    @FXML
    private TextField tfBaseHeight;
    @FXML
    private ComboBox<String> cbCantileverType;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Cantilever Arrays Module", "This module creates arrays of cantilevers attached to a user defined base. Example applications of the resulting structures reside in the micro- and nano-electro(opto)mechanical arena.");
        this.cbCantileverType.setVisibleRowCount(5);
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(CantileverArraysController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double width = Double.parseDouble(this.tfWidth.getText());
        double lengthStart = Double.parseDouble(this.tfLenghtStart.getText());
        double lengthEnd = Double.parseDouble(this.tfLengthEnd.getText());
        double pitch = Double.parseDouble(this.tfPitch.getText());
        double baseExtent = Double.parseDouble(this.tfBaseExtent.getText());
        double baseHeight = Double.parseDouble(this.tfBaseHeight.getText());
        double linear = Double.parseDouble(this.tfLinear.getText());
        double percentage = Double.parseDouble(this.tfPercentage.getText());
        double sineAmplitude = Double.parseDouble(this.tfSineAmplitude.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        int numberOfElements = Integer.parseInt(this.tfNumberOfElements.getText());
        String fileName = this.tfFileName.getText();
        String cantileverType = (String)this.cbCantileverType.getValue();
        Lib lib = new Lib();
        double[] leverLengths = new double[numberOfElements];
        switch (cantileverType) {
            case "Linear": {
                for (int i = 0; i < leverLengths.length; ++i) {
                    leverLengths[i] = lengthStart;
                    lengthStart += linear;
                }
                break;
            }
            case "Linear SE": {
                double increment = (lengthEnd - lengthStart) / (double)(numberOfElements - 1);
                for (int i = 0; i < leverLengths.length; ++i) {
                    leverLengths[i] = lengthStart;
                    lengthStart += increment;
                }
                break;
            }
            case "Percentage": {
                for (int i = 0; i < leverLengths.length; ++i) {
                    leverLengths[i] = lengthStart;
                    lengthStart += lengthStart * percentage / 100.0;
                }
                break;
            }
            case "NonLinear SE": {
                leverLengths = CantileverArraysController.rampNonLinearSE(leverLengths, lengthStart, lengthEnd);
                break;
            }
            case "Sinusoid": {
                double sinInc = Math.PI * 2 / (double)numberOfElements;
                for (int i = 0; i < numberOfElements; ++i) {
                    leverLengths[i] = lengthStart + sineAmplitude * Math.sin((double)i * sinInc);
                }
                break;
            }
        }
        Struct top = new Struct("top");
        Struct devices = CantileverArraysController.createArray(leverLengths, width, pitch, layer);
        GArea ga = new GArea(new Rect(-baseExtent, -baseHeight, (double)(numberOfElements - 1) * pitch + width + baseExtent, 0.0, layer), layer);
        top.add(new Ref(devices, 0.0, 0.0));
        top.add(ga);
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    public static double[] rampNonLinearSE(double[] leverLengths, double lengthStart, double lengthEnd) {
        double ratio;
        double root = leverLengths.length == 1 ? 1.0 : 1.0 / (double)(leverLengths.length - 1);
        if (lengthStart == 0.0) {
            ratio = lengthEnd;
            lengthStart = 1.0;
        } else {
            ratio = Math.abs(lengthEnd / lengthStart);
        }
        for (int i = 0; i < leverLengths.length; ++i) {
            leverLengths[i] = lengthStart;
            lengthStart *= Math.pow(ratio, root);
        }
        return leverLengths;
    }

    static Struct createArray(double[] leverLengths, double width, double pitch, int layer) {
        Struct leverArray = new Struct("cantileverArray");
        for (int i = 0; i < leverLengths.length; ++i) {
            GArea ga = new GArea(new Rect((double)i * pitch, 0.0, (double)i * pitch + width, leverLengths[i], layer), layer);
            leverArray.add(ga);
        }
        return leverArray;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

