/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.Const;
import JGDS2.GDS2;
import JGDS2.GDSReader;
import JGDS2.GDSWriter;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class remote
implements Const {
    public static void main(String[] args) {
        try {
            File f = new File("remote.gds");
            FileOutputStream fileOUT = new FileOutputStream(f);
            DataOutputStream dO = new DataOutputStream(fileOUT);
            GDSWriter g = new GDSWriter(dO);
            Lib lib = new Lib();
            Struct top = new Struct("top");
            lib.add(new Ref(top, 0.0, 0.0));
            Struct g1 = remote.grate(0.5);
            Struct g2 = remote.grate(0.42);
            Struct g3 = remote.grate(0.34);
            Struct g4 = remote.grate(0.26);
            top.add(new Ref(g1, -6000.0, -6000.0));
            top.add(new Ref(g2, 0.0, -6000.0));
            top.add(new Ref(g3, 0.0, 0.0));
            top.add(new Ref(g4, -6000.0, 0.0));
            top.add(new Ref(g1, 6000.0, 6000.0, 0, 90.0));
            top.add(new Ref(g2, 0.0, 6000.0, 0, 90.0));
            top.add(new Ref(g3, -6000.0, 6000.0));
            top.add(new Ref(g4, 6000.0, 0.0));
            lib.GDSOut(g);
            System.out.println(" Saved to " + f.getAbsolutePath());
            System.out.println(GDSReader.readFile(f.getAbsolutePath()));
        }
        catch (IOException eOutput) {
            eOutput.printStackTrace();
        }
        System.out.println("done");
    }

    static Struct grate(double duty) {
        double pitch = 0.667;
        double extent = 5000.0;
        int number = (int)(extent / pitch);
        extent = (double)number * pitch;
        System.out.println(" ext= " + extent);
        Struct abar = new Struct("Bar_" + GDS2.val(duty), new RectArea(0.0, 0.0, pitch * duty, 5000.0, 2));
        Array abg = new Array(abar, -extent / 2.0, -extent / 2.0, number, 1, extent, 1.0);
        Struct barGrate = new Struct("Grate_" + GDS2.val(duty), abg);
        return barGrate;
    }
}

