/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Const;
import JGDS2.GArea;
import JGDS2.GDSReader;
import JGDS2.GDSWriter;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class angleGrate
implements Const {
    public static void main(String[] args) {
        try {
            File f = new File("testTrans.gds");
            FileOutputStream fileOUT = new FileOutputStream(f);
            DataOutputStream dO = new DataOutputStream(fileOUT);
            GDSWriter g = new GDSWriter(dO);
            Lib lib = new Lib();
            double textSize = 4.0;
            int startn = 0;
            int endn = 360;
            int width = 50000;
            boolean i = false;
            int step = 30;
            Struct text = new Struct("text_A", new Text("A", 2, textSize));
            for (int n = startn; n <= endn; ++n) {
                double ang = (double)n * Math.PI / 180.0;
                double siz = textSize * 1.5;
                int mirror = 32768;
                double mag = 0.5;
                Struct textRot = new Struct("text_rot_" + n, new Ref(text, 0.0, siz / 2.0, mirror, mag, n));
                GArea ng = new GArea(new RectArea(-siz, -siz, siz, siz, 4), 4);
                ng.subtract(textRot);
                textRot.add(ng);
                lib.add(new Ref(textRot, 0.0, siz * (double)n));
            }
            lib.GDSOut(g);
            System.out.println(" Saved to " + f.getAbsolutePath());
            System.out.println(GDSReader.readFile(f.getAbsolutePath()));
        }
        catch (IOException eOutput) {
            eOutput.printStackTrace();
        }
        System.out.println("done");
    }
}

