/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import JGDS2.DrawnElement;
import JGDS2.GDS2;
import JGDS2.GDSWriter;
import JGDS2.Intersection;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public class GArbPath
extends DrawnElement {
    public Path2D.Double a;
    public static int MAXPOINTS = 200;
    static boolean VERTICAL = false;

    public GArbPath(int lr) {
        this.a = new Path2D.Double();
        this.layer = lr;
    }

    public GArbPath(Path2D.Double area, int lr) {
        this.a = area;
        this.layer = lr;
    }

    public GArbPath(Shape s, int lr) {
        this.layer = lr;
        this.a = new Path2D.Double(s);
    }

    public GArbPath(GDS2 el, int lr) {
        this.a = new Path2D.Double(el.getArea());
        this.layer = lr;
    }

    @Override
    protected void GDSII(GDSWriter g) throws IOException {
        LinkedList<segment> al = this.gdsCompatibleSegmentList(this.a);
        System.out.println("GPath GDSOut flattened");
        for (int i = 0; i < al.size(); ++i) {
            segment s = al.get(i);
            if (s.op == 0) {
                System.out.println("Seg " + i + " is moveto " + s.x + " " + s.y + " val(x,y) " + GArbPath.val(s.x) + "," + GArbPath.val(s.y));
                g.add((short)2048);
                g.write();
                g.add((short)3330);
                g.adds(this.layer);
                g.write();
                g.add((short)3586);
                g.adds(this.dataType);
                g.write();
                g.add((short)4099);
                g.addInt(GArbPath.val(s.x));
                g.addInt(GArbPath.val(s.y));
            }
            if (s.op == 1) {
                System.out.println("Seg " + i + " is lineto " + s + " val(x,y) " + GArbPath.val(s.x) + "," + GArbPath.val(s.y));
                g.addInt(GArbPath.val(s.x));
                g.addInt(GArbPath.val(s.y));
            }
            if (s.op != 4) continue;
            System.out.println("Seg " + i + " is close");
            g.write();
            g.add((short)4352);
            g.write();
        }
    }

    @Override
    public Area getArea() {
        return new Area(this.a);
    }

    @Override
    public Area getArea(int lr) {
        if (lr == this.layer) {
            return new Area(this.a);
        }
        return new Area();
    }

    public void setArea(Area ar) {
        this.a = new Path2D.Double(ar);
    }

    public Path2D.Double getPath() {
        return this.a;
    }

    public LinkedList<segment> gdsCompatibleSegmentList(Path2D.Double path) {
        ArrayList out = this.separateShapes(path);
        this.PathToSegmentList(path, true, MAXPOINTS);
        System.out.println("GPath gdsCompatibleSegmentList(): # of areas =" + out.size());
        LinkedList<segment> oList = new LinkedList<segment>();
        for (int i = 0; i < out.size(); ++i) {
            oList.addAll(this.cutToSize(this.PathToSegmentList((Path2D.Double)out.get(i), true, MAXPOINTS)));
        }
        return oList;
    }

    public PathInfo PathToSegmentList(Path2D.Double path, boolean FLATTEN, int MAX) {
        PathInfo pathO;
        LinkedList<segment> segList = new LinkedList<segment>();
        PathInfo currentPath = pathO = new PathInfo(segList);
        segment seg = null;
        segment segP = null;
        segment start = new segment(0, 0.0, 0.0);
        Rectangle2D bounds = null;
        int numPaths = 0;
        double[] cto = new double[6];
        PathIterator pi = FLATTEN ? new FlatteningPathIterator(path.getPathIterator(null), this.getReso()) : path.getPathIterator(null);
        while (!pi.isDone()) {
            double[] co = new double[6];
            int type = pi.currentSegment(co);
            switch (type) {
                case 0: {
                    cto[0] = co[0];
                    cto[1] = co[1];
                    currentPath = pathO.newPath();
                    segList = currentPath.segList;
                    segP = seg;
                    seg = new segment(1, co[0], co[1]);
                    segList.add(seg);
                    ++numPaths;
                    bounds = new Rectangle2D.Double(seg.x, seg.y, 0.0, 0.0);
                    start = seg;
                    break;
                }
                case 1: {
                    segP = seg;
                    segP.next = seg = new segment(type, co[0], co[1]);
                    segList.add(seg);
                    bounds.add(seg.x, seg.y);
                    break;
                }
                case 4: {
                    if (segList.size() <= 2) {
                        System.err.println("GPAth psthToSeglist close 1 or 2 point PATH");
                        pathO.removeLast();
                        break;
                    }
                    if (seg.sameXY(start)) {
                        segP.next = start;
                        currentPath.setBounds((Rectangle2D.Double)bounds);
                        segList.removeLast();
                        break;
                    }
                    System.err.println("GPath pathToSeglist() path not closed");
                    break;
                }
            }
            pi.next();
        }
        return pathO;
    }

    public Path2D.Double PathFromSegmentList(LinkedList<segment> al) {
        System.out.println("GPath  AreaFromSegmentList() size=" + al.size());
        Path2D.Double path = new Path2D.Double(1);
        for (segment seg : al) {
            switch (seg.op) {
                case 0: {
                    path.moveTo(seg.x, seg.y);
                    break;
                }
                case 1: {
                    path.lineTo(seg.x, seg.y);
                    break;
                }
                case 4: {
                    path.closePath();
                    break;
                }
            }
        }
        return path;
    }

    public LinkedList slice(LinkedList<segment> segList) {
        segment startSeg;
        int i;
        LinkedList<segment> subpathStarts = new LinkedList<segment>();
        LinkedList<SegDistance> closest = new LinkedList<SegDistance>();
        for (i = 0; i < segList.size(); ++i) {
            startSeg = segList.get(i);
            if (startSeg.op != 0) continue;
            subpathStarts.add(startSeg);
        }
        for (i = 0; i < subpathStarts.size(); ++i) {
            closest.add(new SegDistance(null, Double.POSITIVE_INFINITY));
        }
        System.out.println("GPath Slice totalPoints " + segList.size() + " internalPaths " + subpathStarts.size());
        double x = 0.0;
        double y = 0.0;
        for (int k = 0; k < subpathStarts.size() - 1; ++k) {
            double rm;
            segment seg;
            startSeg = (segment)subpathStarts.get(k);
            SegDistance closestSoFar = (SegDistance)closest.get(k);
            int pathStart = segList.indexOf(startSeg);
            int nextPathStart = k < subpathStarts.size() - 1 ? segList.indexOf(subpathStarts.get(k + 1)) : segList.size();
            for (int i2 = 0; i2 < segList.size(); ++i2) {
                double Xdist;
                seg = segList.get(i2);
                if ((startSeg.y <= y && startSeg.y >= seg.y || startSeg.y >= y && startSeg.y <= seg.y) && seg.op != 4 && seg.op != 0 && (pathStart > i2 || nextPathStart < i2) && (Xdist = startSeg.x - (x + (rm = (seg.x - x) / (seg.y - y)) * (startSeg.y - y))) < closestSoFar.dist && Xdist >= 0.0) {
                    closestSoFar.seg = seg;
                    closestSoFar.dist = Xdist;
                }
                x = seg.x;
                y = seg.y;
            }
            int ind = segList.indexOf(closestSoFar.seg);
            seg = segList.get(ind - 1);
            rm = (seg.x - closestSoFar.seg.x) / (seg.y - closestSoFar.seg.y);
            x = seg.x + rm * (startSeg.y - seg.y);
            segment newSeg = new segment(1, x, startSeg.y);
            int te = segList.indexOf(startSeg);
            int e = k < subpathStarts.size() - 1 ? segList.indexOf(subpathStarts.get(k + 1)) - 1 : segList.size() - 1;
            LinkedList<segment> temp = new LinkedList<segment>(segList.subList(te, e));
            e -= te;
            for (int j = 0; j < e + 1; ++j) {
                segList.remove(te);
            }
            ind = segList.indexOf(closestSoFar.seg);
            startSeg.op = 1;
            temp.add(0, newSeg);
            temp.add(newSeg);
            segList.addAll(ind, temp);
            int i3 = ind - 1;
            seg = segList.get(i3);
            if (!this.InALine(segList.get(i3 - 1), seg, segList.get(i3 + 1))) continue;
            segList.remove(i3);
        }
        this.cleanDuplicatePoints(segList);
        return segList;
    }

    LinkedList<segment> cutToSize(PathInfo paths) {
        LinkedList<segment> out = new LinkedList<segment>();
        if (paths.size() > MAXPOINTS) {
            System.out.println("CutToSize pathSize > " + MAXPOINTS);
            paths.echo();
            Rectangle2D.Double bounds = paths.get((int)0).bounds;
            double loc = bounds.x + bounds.width / 2.0;
            Line2D.Double line = new Line2D.Double(loc, -1.7976931348623157E308, loc, Double.MAX_VALUE);
            LinkedList<Intersection> intersects = this.intersections(paths, line);
            System.out.println(" cut Tu Size int.size= " + intersects.size());
            loc = bounds.y + bounds.height / 2.0;
            line = new Line2D.Double(-1.7976931348623157E308, loc, Double.MAX_VALUE, loc);
            LinkedList<Intersection> intersects2 = this.intersections(paths, line);
            if (intersects2.size() == intersects.size()) {
                double dely = intersects.getFirst().newSeg.y - intersects.getLast().newSeg.y;
                double delx = intersects2.getFirst().newSeg.x - intersects2.getLast().newSeg.x;
                System.out.println("XXXXXXXXX del y" + dely);
                System.out.println("YYYYYYYYY del x" + delx);
                if (Math.abs(dely) > Math.abs(delx)) {
                    intersects = intersects2;
                }
            } else if (this.cutCost(intersects2) < this.cutCost(intersects)) {
                intersects = intersects2;
            }
            LinkedList<PathInfo> PI = this.cut(intersects);
            for (int i = 0; i < PI.size(); ++i) {
                out.addAll(this.cutToSize(PI.get(i)));
            }
        } else {
            out.addAll(paths.getGDSSegments());
        }
        return out;
    }

    public int cutCost(LinkedList<Intersection> in) {
        int r = 0;
        for (Intersection intersection : in) {
            r += intersection.newSeg.op == 48 ? 2 : 0;
        }
        return r;
    }

    public PathInfo dice(PathInfo p) {
        int i;
        LinkedList<Intersection> it = new LinkedList<Intersection>();
        System.out.println(" DICE EEE EEEEEE EEEE");
        CutLine cl = new CutLine();
        for (i = 0; i < p.subPaths.size(); ++i) {
            System.out.println("SUBPATH(" + i + ")");
            PathInfo sp = p.subPaths.get(i);
            segment seg = sp.segList.getFirst();
            Line2D.Double l = new Line2D.Double(-1.7976931348623157E308, seg.y, seg.x, seg.y);
            LinkedList<Intersection> is = this.intersections(p, l);
            System.out.println("!!!!!!!!!!! last int " + is.getLast() + "\r\n next last " + is.get(is.size() - 2));
            it.addAll(this.intersectionsForSlice(is));
        }
        for (i = 0; i < it.size(); ++i) {
            cl.cutTo((Intersection)it.get(i));
        }
        return p;
    }

    LinkedList<Intersection> intersectionsForSlice(LinkedList<Intersection> l) {
        return l;
    }

    LinkedList<PathInfo> cut(LinkedList<Intersection> intersects) {
        int j;
        PathInfo path;
        LinkedList<PathInfo> out = new LinkedList<PathInfo>();
        LinkedList<segment> cutSegList = new LinkedList<segment>();
        for (Intersection inter : intersects) {
            System.out.println("CUT before cutTo " + inter);
        }
        CutLine cl = new CutLine();
        for (int i = 0; i < intersects.size(); ++i) {
            cl.cutTo(intersects.get(i));
        }
        int i = 0;
        for (Intersection inter : intersects) {
            System.out.println("CUT after cutTO " + inter);
        }
        System.out.println("intersectedSeg size " + intersects.size());
        while (i < intersects.size()) {
            Intersection in = intersects.get(i++);
            segment startSeg = in.seg;
            if (startSeg.op == 12) {
                startSeg.op = 1;
                System.out.println(" ADDED already, skip " + startSeg);
                continue;
            }
            startSeg.op = 1;
            cutSegList.add(startSeg);
            System.out.println("while next startSeg\r\n " + startSeg);
            Rectangle2D.Double bounds = new Rectangle2D.Double(startSeg.x, startSeg.y, 0.0, 0.0);
            path = new PathInfo();
            out.add(path);
            segment seg = startSeg.next;
            segment prevSeg = startSeg;
            while (seg != startSeg) {
                cutSegList.add(seg);
                if ((seg.op & 0x30) != 0) {
                    System.out.print("REMOVE SEG from intersect list ");
                    seg.op = 12;
                } else {
                    seg.op = 1;
                }
                System.out.println("  " + seg);
                bounds.add(seg.x, seg.y);
                prevSeg = seg;
                prevSeg.next = seg = seg.next;
            }
            prevSeg.next = startSeg;
            path.segList = cutSegList;
            path.setBounds(bounds);
            cutSegList = new LinkedList();
            System.out.println("while end  ");
        }
        LinkedList<PathInfo> subPaths = intersects.get((int)0).path.subPaths;
        PathInfo containingPath = null;
        for (j = 0; j < subPaths.size(); ++j) {
            path = subPaths.get(j);
            for (int k = 0; k < out.size(); ++k) {
                PathInfo exteriorPath = (PathInfo)out.get(k);
                if (!exteriorPath.bounds.contains(path.bounds) || containingPath != null && !containingPath.bounds.contains(exteriorPath.bounds)) continue;
                containingPath = exteriorPath;
            }
            if (containingPath == null) {
                System.out.println("cp =null");
                continue;
            }
            containingPath.subPaths.add(path);
        }
        System.out.println("CUT OUT size = " + out.size());
        for (j = 0; j < out.size(); ++j) {
            PathInfo p = out.get(j);
            System.out.println("Out (" + j + ")");
            p.echo();
        }
        return out;
    }

    LinkedList<Intersection> intersections(PathInfo paths, Line2D.Double line) {
        double loc;
        boolean horizontal;
        if (line.x1 - line.x2 == 0.0) {
            horizontal = false;
            loc = line.x1;
        } else {
            horizontal = true;
            loc = line.y1;
        }
        LinkedList<Intersection> intersects = new LinkedList<Intersection>();
        double px = horizontal ? -1.7976931348623157E308 : loc;
        double py = horizontal ? loc : -1.7976931348623157E308;
        double x = 0.0;
        double y = 0.0;
        int left = 0;
        int totLeft = 0;
        for (int k = 0; k < paths.numberOfPaths(); ++k) {
            PathInfo path = paths.get(k);
            if (path.bounds.intersectsLine(line)) {
                segment seg = path.segList.getLast();
                x = seg.x;
                y = seg.y;
                for (int i = 0; i < path.segList.size(); ++i) {
                    segment prev = seg;
                    seg = path.segList.get(i);
                    if (line.intersectsLine(x, y, seg.x, seg.y)) {
                        int sgn = line.relativeCCW(px, py);
                        double m = (seg.y - y) / (seg.x - x);
                        if (!(Double.isInfinite(m) && !horizontal || m == 0.0 && horizontal)) {
                            segment newSeg;
                            int op;
                            if (horizontal) {
                                if (m != 0.0) {
                                    op = y == loc || seg.y == loc ? (y == loc ? 16 : 32) : 48;
                                    x = seg.x + (loc - seg.y) / m;
                                    newSeg = new segment(op, x, loc);
                                    intersects.add(new Intersection(seg, newSeg, prev, path));
                                    System.out.println(" new Inersection seg " + seg + " indx " + path.segList.indexOf(seg) + " new " + newSeg);
                                }
                            } else if (!Double.isInfinite(m)) {
                                op = x == loc || seg.x == loc ? (x == loc ? 16 : 32) : 48;
                                y = seg.y + m * (loc - seg.x);
                                newSeg = new segment(op, loc, y);
                                intersects.add(new Intersection(seg, newSeg, prev, path));
                                System.out.println(" new Inersection seg " + seg + " indx " + path.segList.indexOf(seg) + " new " + newSeg);
                            }
                            left += sgn * i;
                        } else {
                            System.out.println("mark intersect horiz =" + horizontal + " m " + m + " num intersects=" + intersects.size());
                        }
                    }
                    x = seg.x;
                    y = seg.y;
                }
                if (left < 0) {
                    left += path.segList.size();
                }
            }
            totLeft += left;
        }
        Intersection.right = totLeft;
        Intersection.horizontal = horizontal;
        Collections.sort(intersects);
        Intersection in = (Intersection)intersects.getFirst();
        double t = horizontal ? Math.atan2(in.seg.y - in.prev.y, in.seg.x - in.prev.x) : Math.atan2(in.prev.x - in.seg.x, in.seg.y - in.prev.y);
        paths.CLOCKWISE = t < 0.0;
        System.out.println(" theda !!!!!!!!!!!!!!!!!!" + t + "    int   " + in);
        return intersects;
    }

    public LinkedList cleanDuplicatePoints(LinkedList<segment> segs) {
        for (int i = 1; i < segs.size() - 2; ++i) {
            segment seg = segs.get(i);
            if (seg.op == 0 || seg.op == 4 || !this.InALine(segs.get(i - 1), seg, segs.get(i + 1))) continue;
            segs.remove(i);
            --i;
        }
        return segs;
    }

    public boolean InALine(segment pr, segment pi, segment pc) {
        double q;
        double c4;
        double o = GArbPath.val(pi.x) - GArbPath.val(pr.x);
        double n = GArbPath.val(pr.y) - GArbPath.val(pi.y);
        double p = GArbPath.val(pi.x) - GArbPath.val(pc.x);
        double c1 = p * n;
        return c1 + (c4 = (q = (double)(GArbPath.val(pi.y) - GArbPath.val(pc.y))) * o) == 0.0;
    }

    public ArrayList separateShapes(Shape ar) {
        Path2D.Double path;
        int i;
        ArrayList<Object> out = new ArrayList<Object>();
        ArrayList allPaths = this.shapeToListOfPaths(ar);
        int size = allPaths.size();
        pathP[] allp = new pathP[size];
        for (i = 0; i < size; ++i) {
            allp[i] = new pathP(i);
        }
        for (i = 0; i < size; ++i) {
            path = (Path2D.Double)allPaths.get(i);
            Point2D pc = path.getCurrentPoint();
            for (int j = 0; j < size; ++j) {
                Path2D.Double path2;
                if (j == i || !(path2 = (Path2D.Double)allPaths.get(j)).contains(pc)) continue;
                allp[j].contains(i);
                allp[i].contained();
            }
            if (!allp[i].notContained()) continue;
            out.add(allp[i]);
        }
        for (i = 0; i < out.size(); ++i) {
            pathP temp = (pathP)out.get(i);
            temp.removeContainedPaths(allp);
            path = (Path2D.Double)allPaths.get(temp.num);
            for (int j = 0; j < temp.in.size(); ++j) {
                path.append((Shape)allPaths.get(temp.getIn(j)), false);
            }
            out.set(i, path);
        }
        return out;
    }

    public ArrayList shapeToListOfPaths(Shape a) {
        ArrayList<Path2D.Double> allPaths = new ArrayList<Path2D.Double>();
        Path2D.Double path = null;
        int pathSize = 0;
        PathIterator pi = a.getPathIterator(null);
        while (!pi.isDone()) {
            path = !allPaths.isEmpty() ? (Path2D.Double)allPaths.get(allPaths.size() - 1) : (Path2D.Double)null;
            double[] co = new double[6];
            int type = pi.currentSegment(co);
            switch (type) {
                case 0: {
                    pathSize = 1;
                    path = new Path2D.Double(1);
                    path.moveTo((float)co[0], (float)co[1]);
                    allPaths.add(path);
                    break;
                }
                case 1: {
                    ++pathSize;
                    path.lineTo((float)co[0], (float)co[1]);
                    break;
                }
                case 2: {
                    ++pathSize;
                    path.quadTo((float)co[0], (float)co[1], (float)co[2], (float)co[3]);
                    break;
                }
                case 3: {
                    ++pathSize;
                    path.curveTo((float)co[0], (float)co[1], (float)co[2], (float)co[3], (float)co[4], (float)co[5]);
                    break;
                }
                case 4: {
                    if (pathSize < 2) {
                        allPaths.remove(allPaths.size() - 1);
                    }
                    path.closePath();
                    break;
                }
            }
            pi.next();
        }
        return allPaths;
    }

    public static void main(String[] args) {
    }

    public static Path2D.Double reversePath(Path2D.Double path) {
        Path2D.Double pathR = new Path2D.Double();
        ArrayList<double[]> segList = new ArrayList<double[]>();
        double[] co = new double[6];
        PathIterator pi = path.getPathIterator(null);
        while (!pi.isDone()) {
            int type = pi.currentSegment(co);
            double[] seg = new double[]{type, co[0], co[1]};
            segList.add(seg);
            if (type == 4) {
                segList.clear();
                System.err.println("GArea reverse closed psth cleared");
            }
            pi.next();
        }
        double[] temp = (double[])segList.get(segList.size() - 1);
        pathR.moveTo(temp[1], temp[2]);
        block8: for (int i = segList.size() - 2; i >= 0; --i) {
            temp = (double[])segList.get(i);
            int type = (int)temp[0];
            switch (type) {
                case 0: {
                    pathR.lineTo(temp[1], temp[2]);
                    continue block8;
                }
                case 1: {
                    pathR.lineTo(temp[1], temp[2]);
                    continue block8;
                }
                case 2: {
                    System.err.println("Quadratic to ");
                    continue block8;
                }
                case 3: {
                    System.err.println("Cubic to ");
                    continue block8;
                }
                case 4: {
                    continue block8;
                }
            }
        }
        return pathR;
    }

    public static void describeCurrentSegment(PathIterator pi, Graphics2D g2) {
        double[] co = new double[6];
        int type = pi.currentSegment(co);
        Rectangle2D.Float r = new Rectangle2D.Float(-2.0f, -2.0f, 2.0f, 2.0f);
        Color b = new Color(2, 150, 255);
        g2.setPaint(b);
        switch (type) {
            case 0: {
                ((Rectangle2D)r).setRect(co[0], co[1], 6.0, 6.0);
                g2.fill(r);
                break;
            }
            case 1: {
                b = new Color(3, 255, 3, 150);
                g2.setPaint(b);
                ((Rectangle2D)r).setRect(co[0], co[1], 4.0, 4.0);
                g2.fill(r);
                break;
            }
            case 2: {
                ((Rectangle2D)r).setRect(co[0], co[1], 2.0, 2.0);
                g2.fill(r);
                ((Rectangle2D)r).setRect(co[2], co[3], 2.0, 2.0);
                g2.fill(r);
                break;
            }
            case 3: {
                ((Rectangle2D)r).setRect(co[0], co[1], 2.0, 2.0);
                g2.fill(r);
                ((Rectangle2D)r).setRect(co[2], co[3], 2.0, 2.0);
                g2.fill(r);
                ((Rectangle2D)r).setRect(co[4], co[5], 2.0, 2.0);
                g2.fill(r);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public class pathP {
        ArrayList<Integer> in = new ArrayList();
        int depth = 0;
        int num;

        public pathP(int i) {
            this.num = i;
        }

        public void contains(int i) {
            this.in.add(new Integer(i));
        }

        public void contained() {
            ++this.depth;
        }

        public boolean notContained() {
            return this.depth % 2 < 1;
        }

        public int getIn(int i) {
            return this.in.get(i);
        }

        public void removeContainedPaths(pathP[] allp) {
            for (int i = 0; i < this.in.size(); ++i) {
                int j = this.getIn(i);
                pathP sp = allp[j];
                if (sp.depth == this.depth + 1) continue;
                this.in.remove(i--);
            }
        }

        public int sizeInner() {
            return this.in.size();
        }

        public void setDepth(int i) {
            this.depth = i;
        }
    }

    public class CutLine {
        boolean FROMCLOSED = true;
        boolean TOCLOSED = true;
        segment l = null;
        segment r = null;

        void cutTo(Intersection i) {
            int type = i.newSeg.op;
            segment to = i.newSeg.copy();
            to.next = i.seg.copy();
            i.seg.op = 12;
            to.op = 1;
            if ((type & 0x10) == 16) {
                if (this.FROMCLOSED) {
                    this.FROMCLOSED = false;
                    this.l = to;
                    System.out.println("cutTo() open l " + this.l + " > " + this.l.next + " > " + this.l.next.next + " seg" + i.seg);
                } else {
                    this.FROMCLOSED = true;
                    i.newSeg.next = this.l;
                    i.seg.copy(i.newSeg);
                    System.out.println("cutTo() closeL Int seg " + i.seg + " > " + i.seg.next + " > " + i.seg.next.next);
                    if (i.newSeg.sameXY(this.l)) {
                        System.out.println("cutTo() close left same as start so skip");
                        i.newSeg.op = 13;
                        i.seg.copy(this.l);
                    }
                }
            }
            if ((type & 0x20) == 32) {
                if (this.TOCLOSED) {
                    this.TOCLOSED = false;
                    i.seg.copy(i.newSeg);
                    this.r = i.seg;
                    System.out.println("cutTo() open r" + this.r + " seg" + i.seg);
                } else {
                    this.TOCLOSED = true;
                    this.r.next = to;
                    System.out.println("cutTo() closeR " + this.r + " > " + this.r.next + " > " + this.r.next.next);
                    if (this.r.next.sameXY(this.r)) {
                        System.out.println(" CutLine cutTo close right same as start so skip");
                        this.r.next = to.next;
                    }
                }
            }
        }

        public void close(Intersection i) {
            if (!this.FROMCLOSED) {
                System.out.println("CutLine close !LCLOSED");
            }
            if (!this.TOCLOSED) {
                System.out.println("CutLine close !RCLOSED");
            }
        }
    }

    public class PathInfo {
        LinkedList<segment> segList;
        LinkedList<PathInfo> subPaths;
        segment startSeg;
        boolean CLOCKWISE = true;
        Rectangle2D.Double bounds;
        boolean exterior = false;

        public PathInfo() {
            this.segList = new LinkedList();
            this.subPaths = new LinkedList();
        }

        public PathInfo(LinkedList<segment> segList) {
            this.segList = segList;
            this.subPaths = new LinkedList();
        }

        public PathInfo(segment s, Rectangle2D.Double b) {
            this.startSeg = s;
            this.bounds = b;
        }

        public PathInfo(LinkedList<segment> segList, LinkedList<PathInfo> subPaths, Rectangle2D.Double b) {
            this.segList = segList;
            this.subPaths = subPaths;
            this.bounds = b;
        }

        public void set(int i, PathInfo p) {
            if (i == 0) {
                p = this;
            } else {
                this.subPaths.set(i - 1, p);
            }
        }

        public void setBounds(Rectangle2D.Double bounds) {
            this.bounds = bounds;
        }

        public PathInfo get(int i) {
            if (i == 0) {
                return this;
            }
            return this.subPaths.get(i - 1);
        }

        int numberOfPaths() {
            return this.subPaths.size() + 1;
        }

        void echo() {
            for (int j = 0; j < this.numberOfPaths(); ++j) {
                PathInfo path = this.get(j);
                System.out.print("PathInfo echo Path[" + j + "] bounds " + this.bounds);
                int size = path.segList.size();
                for (int i = 0; i < size; ++i) {
                    segment s = path.segList.get(i);
                    System.out.print("\r\n " + i + s);
                    if (i > 0) {
                        System.out.print("" + (path.segList.get((int)((size + i - 1) % size)).next == s ? "" : "BAD LINK"));
                    }
                    if (i + 1 != path.segList.size()) continue;
                    System.out.println(" **end**\r\n " + ++i + s.next);
                    System.out.println(" " + ++i + s.next.next);
                }
            }
            System.out.println("");
        }

        int size() {
            int size = this.segList.size();
            System.out.print("PathInfo size() segList.size()= " + this.segList.size());
            for (int i = 0; i < this.subPaths.size(); ++i) {
                size += this.subPaths.get((int)i).segList.size();
                System.out.print(" subPath[" + i + "].size()= " + this.subPaths.get((int)i).segList.size());
            }
            System.out.println("");
            return size;
        }

        public PathInfo newPath() {
            if (this.segList.size() == 0) {
                return this;
            }
            PathInfo p = new PathInfo();
            this.subPaths.add(p);
            return p;
        }

        LinkedList<segment> getGDSSegments() {
            LinkedList<segment> out = new LinkedList<segment>();
            segment seg = this.segList.get(0);
            seg.op = 0;
            this.segList.set(0, seg);
            seg = seg.copy();
            seg.op = 1;
            segment close = new segment(4, 0.0, 0.0);
            out.addAll(this.segList);
            out.add(seg);
            out.add(close);
            for (int j = 0; j < this.subPaths.size(); ++j) {
                PathInfo PT = this.subPaths.get(j);
                out.addAll(PT.getGDSSegments());
            }
            return out;
        }

        public void removeLast() {
            if (this.subPaths.size() == 0) {
                this.segList.clear();
            } else {
                this.subPaths.removeLast();
            }
        }
    }

    public class SegDistance {
        segment seg;
        double dist;

        public SegDistance(segment s, double d) {
            this.seg = s;
            this.dist = d;
        }
    }

    public class segment {
        double x;
        double y;
        int op;
        segment next;

        public segment(int oper, double xx, double yy) {
            this.op = oper;
            this.x = xx;
            this.y = yy;
        }

        public segment(int oper, double xx, double yy, segment s) {
            this.op = oper;
            this.x = xx;
            this.y = yy;
            this.next = s;
        }

        segment copy() {
            return new segment(this.op, this.x, this.y, this.next);
        }

        boolean sameXY(segment s) {
            return this.x == s.x && this.y == s.y;
        }

        void copy(segment s) {
            this.x = s.x;
            this.y = s.y;
            this.op = s.op;
            this.next = s.next;
        }

        segment setOpNext(int oper, segment s) {
            this.op = oper;
            this.next = s;
            return this;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")" + this.op + " " + this.hashCode() / 100000;
        }
    }
}

