/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.Const;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.GDSWriter;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import PartLib.PartsLib;
import java.awt.BasicStroke;
import java.awt.geom.Path2D;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class GenFrame
implements Const {
    public static void main(String[] args) {
        try {
            File f = new File("Gen.gds");
            FileOutputStream fileOUT = new FileOutputStream(f);
            DataOutputStream dO = new DataOutputStream(fileOUT);
            GDSWriter g = new GDSWriter(dO);
            Lib lib = new Lib();
            Struct top = new Struct("top");
            boolean corn = false;
            boolean curved = true;
            top.add(new Ref(GenFrame.leads(10000.0, 0.5, corn, curved), 5000.0, 5000.0));
            top.add(new Array(GenFrame.leads(5000.0, 0.5, corn, curved), -7500.0, 2500.0, 2, 2, 10000.0, 10000.0));
            top.add(new Array(GenFrame.leads(2000.0, 0.5, corn, curved), 1000.0, -9000.0, 5, 5, 10000.0, 10000.0));
            top.add(new Array(GenFrame.leads(2500.0, 0.5, corn, curved), -8750.0, -8750.0, 4, 4, 10000.0, 10000.0));
            top.add(new Array(GenFrame.zero(), -5000.0, -5000.0, 2, 2, 20000.0, 20000.0));
            lib.add(new Ref(top, 0.0, 0.0));
            lib.GDSOut(g);
            System.out.println(" Saved to " + f.getAbsolutePath());
        }
        catch (IOException eOutput) {
            eOutput.printStackTrace();
        }
        System.out.println("done");
    }

    static Struct zero() {
        Struct s = new Struct("zero");
        Struct q = new Struct("zeroQ");
        Struct v2 = PartsLib.Vern(1, 10, 0.01, 20, "1", "4");
        Struct v1 = PartsLib.Vern(10, 1, 0.01, 20, "4", "1");
        Struct v3 = PartsLib.Vern(1, 2, 0.01, 20, "1", "2");
        Struct v4 = PartsLib.Vern(1, 3, 0.01, 20, "1", "3");
        Struct v5 = PartsLib.Vern(1, 4, 0.01, 20, "1", "4");
        q.add(new Ref(v3, 4000.0, 4920.0));
        q.add(new Ref(v3, 4070.0, 4920.0, 0, 0.0, 90.0));
        q.add(new Ref(v4, 3500.0, 4920.0));
        q.add(new Ref(v4, 3570.0, 4920.0, 0, 0.0, 90.0));
        q.add(new Ref(v5, 3000.0, 4920.0));
        q.add(new Ref(v5, 3070.0, 4920.0, 0, 0.0, 90.0));
        s.add(new Ref(v1, 0.0, 5000.0));
        s.add(new Ref(v1, -5000.0, 0.0, 0, 0.0, 90.0));
        s.add(new Ref(v2, 0.0, -5000.0, 0, 0.0, 0.0));
        s.add(new Ref(v2, 5000.0, 0.0, 0, 0.0, 90.0));
        s.add(new Ref(q, 0.0, 0.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 0.0, 90.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 0.0, 180.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 0.0, 270.0));
        return s;
    }

    static Struct leads(double size, double rOut, boolean corn, boolean curved) {
        int i;
        int cols = 1;
        double ps = 125.0;
        Struct p = new Struct("pad", new RectArea(-ps, -ps, ps, ps, 2));
        Struct sp = new Struct("pm", new RectArea(-10.0, -10.0, 10.0, 10.0, 2));
        Struct oc = new Struct("oct" + (int)size);
        Struct gm = new Struct("globemrk", new RectArea(-3.0, -100.0, 3.0, 100.0, 1));
        gm.add(new RectArea(-100.0, -3.0, 100.0, 3.0, 1));
        Struct cm = new Struct("chipmrk", new RectArea(-2.0, -30.0, 2.0, 30.0, 1));
        cm.add(new RectArea(-30.0, -2.0, 30.0, 2.0, 1));
        Struct q = new Struct("quart" + (int)size);
        q.add(new Ref(oc, 0.0, 0.0));
        q.add(new Ref(oc, 0.0, 0.0, 32768, 1.0, 0.0));
        Struct s = new Struct("cell" + (int)size);
        int CnR = 2;
        double pos = -size / 2.0 + ps * 4.0;
        s.add(new Array(gm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        pos = -size / 2.0 * rOut;
        s.add(new Array(cm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        pos = -size / 2.0 * (rOut * 1.2);
        s.add(new Array(cm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        int n = i = corn ? 0 : 1;
        while ((double)i < size / 1000.0) {
            Path2D.Double poly3 = new Path2D.Double();
            poly3.moveTo(-size / 2.0 + ps * 2.0, size / 2.0 - (double)(500 * i) - ps * 2.0);
            if (curved) {
                poly3.curveTo((-size / 2.0 + ps * 2.0) * (1.0 + rOut) / 2.0, size / 2.0 - (double)(500 * i) - ps * 2.0, (-size / 2.0 + ps * 2.0) * (1.0 + rOut) / 2.0, (size / 2.0 - (double)(500 * i) - ps * 2.0) * rOut, (-size / 2.0 + ps * 2.0) * rOut, (size / 2.0 - (double)(500 * i) - ps * 2.0) * rOut);
            } else {
                poly3.lineTo((-size / 2.0 + ps * 2.0) * rOut, (size / 2.0 - (double)(500 * i) - ps * 2.0) * rOut);
            }
            BasicStroke bs = new BasicStroke(50.0f, 0, 0, 2.5f);
            GArea fa = new GArea(bs.createStrokedShape(poly3), 2);
            oc.add(fa);
            ++i;
        }
        i = 1;
        while ((double)i < size / 500.0) {
            String sl = String.valueOf((char)(i + 64));
            Struct tl = new Struct(sl, new Text(sl, 2, 100.0));
            s.add(new Ref(tl, -size / 2.0 + ps * 2.0 - 50.0, size / 2.0 - 500.0 * ((double)i - 0.4) - ps * 2.0, 2));
            s.add(new Ref(tl, size / 2.0 - ps * 2.0 - 30.0, size / 2.0 - 500.0 * ((double)i - 0.4) - ps * 2.0, 2));
            String su = String.valueOf(i);
            Struct tu = new Struct(su, new Text(su, 2, 100.0));
            s.add(new Ref(tu, -(size / 2.0 - 500.0 * ((double)i - 0.6) - ps * 2.0), -size / 2.0 + ps * 2.0 - 50.0, 2));
            s.add(new Ref(tu, -(size / 2.0 - 500.0 * ((double)i - 0.6) - ps * 2.0), -(-size / 2.0 + ps * 2.0), 2));
            ++i;
        }
        q.add(new Array(p, -size / 2.0 + ps * 2.0, -size / 2.0 + ps * 2.0, cols, (int)(size / 500.0), 500 * cols, size));
        q.add(new Array(sp, -size / 2.0 + ps, -size / 2.0 + ps * 4.0, cols, (int)(size / 500.0) - 1, 500 * cols, size - 500.0));
        s.add(new Ref(q, 0.0, 0.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 1.0, 90.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 1.0, 180.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 1.0, 270.0));
        return s;
    }

    static Struct tree(double d, double ang, double ratio, int depth) {
        int i;
        double rd = 0.25;
        double p = ratio / (ratio + 1.0);
        Path2D.Double poly3 = new Path2D.Double();
        poly3.moveTo(d / 2.0, 0.0);
        poly3.curveTo(d / 2.0, 0.5 - rd * Math.cos(ang), 0.5 - rd * Math.sin(ang), 0.5 - rd * Math.cos(ang), 0.5, 0.5);
        BasicStroke bs = new BasicStroke((float)d, 0, 0, 2.5f);
        GArea fa = new GArea(bs.createStrokedShape(poly3), 2);
        ang = ang * 180.0 / Math.PI;
        Struct s = new Struct("s_" + GDS2.val(d * 11.0 + ang * 13.0 + ratio * 17.0), fa);
        Struct w = new Struct("d0_" + GDS2.val(d * 11.0 + ang * 13.0 + ratio * 17.0), new Ref(s, -(0.5 - p) * d, 0.0, 0, 1.0 - p, 0.0));
        w.add(new Ref(s, d * (p - 0.5), 0.0, 32768, p, 180.0));
        ArrayList<Struct> n = new ArrayList<Struct>();
        n.add(w);
        for (i = 1; i < depth; ++i) {
            boolean odd = i / 2 * 2 != i;
            Struct temp = new Struct("tree" + i + "_" + GDS2.val(d * 11.0 + ang * 13.0 + ratio * 17.0));
            Ref r = new Ref((Struct)n.get(i - 1), -0.5 * p + d * (p - 0.5), 0.5 * p, odd ? 32768 : 0);
            r.setMag(p);
            r.setAngle(ang + (double)(odd ? 180 : 0));
            temp.add(r);
            r = new Ref((Struct)n.get(i - 1), 0.5 * (1.0 - p) - (0.5 - p) * d, 0.5 * (1.0 - p), odd ? 0 : 32768);
            r.setMag(1.0 - p);
            r.setAngle(360.0 - ang - (double)(odd ? 0 : 180));
            temp.add(r);
            r = new Ref((Struct)n.get(0), 0.0, 0.0);
            temp.add(r);
            n.add(temp);
        }
        return (Struct)n.get(i - 1);
    }
}

