/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import JGDS2.GArea;
import JGDS2.RectArea;
import JGDS2.Text;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Verniers {
    public static ArrayList<GArea> createVerniers(int layer1, int layer2, double vernierReso, int ticks, String label1, String label2, double fontSize, double fontReso, double lineWidth, double lineLength, double pitch) {
        ArrayList<GArea> alGa = new ArrayList<GArea>();
        alGa.add(new GArea(new RectArea(-lineWidth / 2.0, 0.0, lineWidth / 2.0, lineLength, layer1)));
        alGa.add(new GArea(new RectArea(-lineWidth / 2.0, -lineLength, lineWidth / 2.0, 0.0, layer2)));
        for (int i = 1; i < ticks + 1; ++i) {
            double offset = i % 10 == 0 ? lineLength / 3.0 : (i % 5 == 0 ? lineLength / 7.0 : 0.0);
            alGa.add(new GArea(new RectArea(-lineWidth / 2.0 + (double)i * pitch, 0.0, lineWidth / 2.0 + (double)i * pitch, lineLength / 3.0 + offset, layer1)));
            alGa.add(new GArea(new RectArea(-lineWidth / 2.0 - (double)i * pitch, 0.0, lineWidth / 2.0 - (double)i * pitch, lineLength / 3.0 + offset, layer1)));
            alGa.add(new GArea(new RectArea(-lineWidth / 2.0 + (double)i * pitch + (double)i * vernierReso, -lineLength / 3.0 - offset, lineWidth / 2.0 + (double)i * pitch + (double)i * vernierReso, 0.0, layer2)));
            alGa.add(new GArea(new RectArea(-lineWidth / 2.0 - (double)i * pitch - (double)i * vernierReso, -lineLength / 3.0 - offset, lineWidth / 2.0 - (double)i * pitch - (double)i * vernierReso, 0.0, layer2)));
        }
        Font font = new Font("Serif", 0, 1000);
        Text lb1 = new Text(label1, layer1, font);
        lb1.setFontSize(fontSize);
        lb1.setRenderReso(fontReso);
        Area a = new Area(lb1.getArea());
        Rectangle2D rec = a.getBounds2D();
        a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY() + (lineLength + fontSize / 2.0)));
        GArea g1 = new GArea(a, layer1);
        g1.setRenderReso(fontReso);
        alGa.add(g1);
        Text lb2 = new Text(label2, layer2, font);
        lb2.setFontSize(fontSize);
        lb2.setRenderReso(fontReso);
        a = new Area(lb2.getArea());
        rec = a.getBounds2D();
        a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY() - (lineLength + fontSize / 2.0)));
        GArea g2 = new GArea(a, layer2);
        g2.setRenderReso(fontReso);
        alGa.add(g2);
        return alGa;
    }
}

