/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.Array;
import JGDS2.DrawnElement;
import JGDS2.GArea;
import JGDS2.Rect;
import JGDS2.Struct;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;

public class PrimitiveShapes {
    public static GArea createArrowHead(double arrowW, double arrowL, double width) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(width / 2.0, 0.0);
        poly.curveTo(width / 2.0 + arrowW / 4.0, 0.0, width / 2.0 + arrowW / 2.0, -arrowL / 4.0, width / 2.0 + arrowW / 2.0, -arrowL / 4.0);
        poly.lineTo(0.0, arrowL);
        poly.closePath();
        GArea v = new GArea(poly, CNSTscriptingController.getGdsLayer());
        GArea vTmp = new GArea(v);
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        vTmp.transform(at);
        v.or(vTmp);
        v.transform(AffineTransform.getTranslateInstance(0.0, -arrowL));
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createArrow(double arrowW, double arrowL, double width, double length) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = new GArea(new Rect(-width / 2.0, 0.0, width / 2.0, length, layer), layer);
        ga.transform(AffineTransform.getTranslateInstance(0.0, -arrowL - length));
        GArea arrowHead = PrimitiveShapes.createArrowHead(arrowW, arrowL, width);
        ga.or(arrowHead);
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static GArea createArrowLinearArray(double arrowW, double arrowL, double width, double length, int numberOfArrows) {
        GArea ga = new GArea(PrimitiveShapes.createArrow(arrowW, arrowL, width, length));
        GArea gaTmp = new GArea(ga);
        for (int i = 1; i < numberOfArrows; ++i) {
            gaTmp.transform(AffineTransform.getTranslateInstance(0.0, length + arrowL));
            ga.or(gaTmp);
        }
        ga.transform(AffineTransform.getTranslateInstance(0.0, -(length + arrowL) * (double)(numberOfArrows - 1)));
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static GArea createEllipse(double x, double y, double radX, double radY, int numSides, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + radX, y);
        int steps = numSides;
        double c = Math.PI * 2 / (double)numSides;
        for (int i = 0; i < steps; ++i) {
            poly.lineTo(x + radX * Math.cos((double)i * c), y + radY * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createSemiCircle(double rad, int numSides, int layer) {
        GArea circ = PrimitiveShapes.createEllipse(0.0, 0.0, rad, rad, numSides, layer);
        GArea box = new GArea(new Rect(-rad, -rad, rad, 0.0, layer), layer);
        circ.subtract(box);
        circ.setDataType(CNSTscriptingController.getDataType());
        return circ;
    }

    public static GArea createArc(double x, double y, double rx, double ry, double angleStart, double angleStop, int numSides, int layer) {
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : 360.0 - Math.abs(angleStart - angleStop);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(rx * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)), ry * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTorus(double x, double y, double rin, double rout, double angleStart, double angleStop, int numSides, int layer) {
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : 360.0 - Math.abs(angleStart - angleStop);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rin * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)), y + rin * Math.sin(PrimitiveShapes.degreeToRadians(angleStart)));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rin * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)), y + rin * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rout * Math.cos((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)), y + rout * Math.sin((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTorusW(double x, double y, double r, double w, double angleStart, double angleStop, int numSides, int layer) {
        double rin = r - w / 2.0;
        double rOut = r + w / 2.0;
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : 360.0 - Math.abs(angleStart - angleStop);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rin * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)), y + rin * Math.sin(PrimitiveShapes.degreeToRadians(angleStart)));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rin * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)), y + rin * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rOut * Math.cos((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)), y + rOut * Math.sin((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTorusEllipseW(double x, double y, double rX, double rY, double w, double angleStart, double angleEnd, int numSides, int layer) {
        double rinX = rX - w / 2.0;
        double rOutX = rX + w / 2.0;
        double rinY = rY - w / 2.0;
        double rOutY = rY + w / 2.0;
        double angle = angleEnd > angleStart ? Math.abs(angleStart - angleEnd) : 360.0 - Math.abs(angleStart - angleEnd);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rinX * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)), y + rinY * Math.sin(PrimitiveShapes.degreeToRadians(angleStart)));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rinX * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)), y + rinY * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rOutX * Math.cos((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)), y + rOutY * Math.sin((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTorusEllipseFocusW(double x, double y, double rX, double rY, double width, double angleStart, double angleEnd, int numSides, int layer) {
        double rho = rY * rY / rX;
        double e = Math.sqrt(1.0 - rY * rY / (rX * rX));
        double F1 = Math.sqrt(Math.abs(rX * rX - rY * rY));
        double angle = angleEnd > angleStart ? Math.abs(angleStart - angleEnd) : 360.0 - Math.abs(angleStart - angleEnd);
        double c = angle * (Math.PI / 180) / (double)numSides;
        Path2D.Double poly = new Path2D.Double();
        double r = rho / (1.0 - e * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)));
        poly.moveTo(r * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)), r * Math.sin(PrimitiveShapes.degreeToRadians(angleStart)));
        for (int i = 0; i <= numSides; ++i) {
            r = rho / (1.0 - e * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
            double xPos = r * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart));
            double yPos = r * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart));
            poly.lineTo(xPos, yPos);
        }
        BasicStroke bs = new BasicStroke((float)width, 1, 1);
        GArea ga = new GArea(bs.createStrokedShape(poly), layer);
        ga.transform(AffineTransform.getTranslateInstance(x, y));
        return ga;
    }

    public static GArea createCircleWave(double radius, int n, double ampSin, int NumSides) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(radius, 0.0);
        int steps = NumSides;
        double c = Math.PI * 2 / (double)NumSides;
        for (int i = 0; i < steps; ++i) {
            poly.lineTo((radius + ampSin * Math.sin((double)i * c * (double)n)) * Math.cos((double)i * c), (radius + ampSin * Math.sin((double)i * c * (double)n)) * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, CNSTscriptingController.getGdsLayer());
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTorusWaveIN(double radInner, double radOuter, int n, double ampSin, int NumSides) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(radInner, 0.0);
        int steps = NumSides;
        double c = Math.PI * 2 / (double)NumSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo((radInner + ampSin * Math.sin((double)i * c * (double)n)) * Math.cos((double)i * c), (radInner + ampSin * Math.sin((double)i * c * (double)n)) * Math.sin((double)i * c));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo((radOuter + ampSin * Math.sin((double)j * c * (double)n)) * Math.cos((double)j * c), (radOuter + ampSin * Math.sin((double)j * c * (double)n)) * Math.sin((double)j * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, CNSTscriptingController.getGdsLayer());
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTorusWaveOUT(double radInner, double radOuter, int n, double ampSin, int NumSides) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(radInner, 0.0);
        int steps = NumSides;
        double c = Math.PI * 2 / (double)NumSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo((radInner + ampSin * Math.sin((double)i * c * (double)n)) * Math.cos((double)i * c), (radInner + ampSin * Math.sin((double)i * c * (double)n)) * Math.sin((double)i * c));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo((radOuter + ampSin * Math.cos((double)j * c * (double)n)) * Math.cos((double)j * c), (radOuter + ampSin * Math.cos((double)j * c * (double)n)) * Math.sin((double)j * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, CNSTscriptingController.getGdsLayer());
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static GArea createCross(double x, double y, double width, double length, int layer) {
        double hW = width / 2.0;
        double hL = length;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(-hW, -hW);
        poly.lineTo(-hW, -hL);
        poly.lineTo(hW, -hL);
        poly.lineTo(hW, -hW);
        poly.lineTo(hL, -hW);
        poly.lineTo(hL, hW);
        poly.lineTo(hW, hW);
        poly.lineTo(hW, hL);
        poly.lineTo(-hW, hL);
        poly.lineTo(-hW, hW);
        poly.lineTo(-hL, hW);
        poly.lineTo(-hL, -hW);
        poly.lineTo(-hW, -hW);
        poly.closePath();
        Area a = new Area(poly);
        a.transform(AffineTransform.getTranslateInstance(x, y));
        GArea v = new GArea(a, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createLshape(double x, double y, double W1, double L1, double W2, double L2, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(L1, 0.0);
        poly.lineTo(L1, W1);
        poly.lineTo(W2, W1);
        poly.lineTo(W2, L2);
        poly.lineTo(0.0, L2);
        poly.closePath();
        Area a = new Area(poly);
        a.transform(AffineTransform.getTranslateInstance(x, y));
        GArea v = new GArea(a, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createRectangularSUshape(double L1, double L2, double L3, double W) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(0.0, L1);
        poly.lineTo(L2, L1);
        poly.lineTo(L2, L1 + L3);
        BasicStroke bs = new BasicStroke((float)W, 0, 0);
        GArea ga = new GArea(bs.createStrokedShape(poly), CNSTscriptingController.getGdsLayer());
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static GArea createRectangle(ArrayList<Double> al, int layer) {
        GArea ga = new GArea(new Rect(al.get(0), al.get(1), al.get(2), al.get(3), layer), layer);
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static GArea createRectangleLH(ArrayList<Double> al, int layer) {
        GArea ga = new GArea(new Rect(al.get(0), al.get(1), al.get(0) + al.get(2), al.get(1) + al.get(3), layer), layer);
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static GArea createRectangleC(ArrayList<Double> al, int layer) {
        double xC = al.get(0);
        double yC = al.get(1);
        double length = al.get(2);
        double height = al.get(3);
        GArea ga = new GArea(new Rect(xC -= length / 2.0, yC -= height / 2.0, xC + length, yC + height, layer), layer);
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static void createGratings(Struct grating, String name, double x, double y, double width, double length, double pitch, int numberOfLines, int layer) {
        GArea v = new GArea(new Rect(0.0, 0.0, width, length, layer), layer);
        v.setDataType(CNSTscriptingController.getDataType());
        Struct s = new Struct(name, v);
        grating.add(new Array(s, x, y, numberOfLines, 1, (double)numberOfLines * pitch, 1.0));
    }

    public static void createPhC(Struct phCsTest, String circleStructName, double x, double y, double radius, double pitchX, int elementsX, int elementsY, int numberOfSides, double arrayPitch, boolean DOUBLEARRAY, boolean ISVECTOR) {
        double pitchY = 2.0 * pitchX * Math.cos(0.5235987755982988);
        Struct circleStruct = new Struct(circleStructName);
        if (ISVECTOR) {
            Ellipse2D.Double s1 = new Ellipse2D.Double(-radius, -radius, 2.0 * radius, 2.0 * radius);
            circleStruct.add(PrimitiveShapes.createVectorShape(s1, CNSTscriptingController.getGdsLayer()));
        } else {
            circleStruct.add(PrimitiveShapes.createEllipse(0.0, 0.0, radius, radius, numberOfSides, CNSTscriptingController.getGdsLayer()));
        }
        phCsTest.add(new Array(circleStruct, x, y, elementsX, elementsY, (double)elementsX * pitchX, (double)elementsY * pitchY));
        phCsTest.add(new Array(circleStruct, x + pitchX / 2.0, y + pitchX * Math.cos(0.5235987755982988), elementsX, elementsY, (double)elementsX * pitchX, (double)elementsY * pitchY));
        if (DOUBLEARRAY) {
            phCsTest.add(new Array(circleStruct, x, y - arrayPitch, elementsX, elementsY, (double)elementsX * pitchX, (double)(-elementsY) * pitchY));
            phCsTest.add(new Array(circleStruct, x + pitchX / 2.0, y - arrayPitch - pitchX * Math.cos(0.5235987755982988), elementsX, elementsY, (double)elementsX * pitchX, (double)(-elementsY) * pitchY));
        }
    }

    public static void createPillarHoleArray(Struct s, String structName, double x, double y, double radX, double radY, int numSides, double pitchX, double pitchY, int elementsX, int elementsY, double THETA, boolean ISVECTOR, boolean ISPILLAR, boolean ISHEX, boolean ISCENTERED) {
        Struct shapeStruct = new Struct(structName);
        GArea ga = new GArea();
        int layer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        GArea shapeArea = new GArea();
        if (ISVECTOR) {
            Ellipse2D.Double s1 = new Ellipse2D.Double(-radX, -radY, 2.0 * radX, 2.0 * radY);
            Area a = new Area(s1);
            ga = new GArea(a, layer);
            ga.transform(AffineTransform.getRotateInstance(PrimitiveShapes.degreeToRadians(THETA)));
            ga.setRenderReso(shapeReso);
            ga.setDataType(CNSTscriptingController.getDataType());
        } else {
            ga = PrimitiveShapes.createEllipse(0.0, 0.0, radX, radY, numSides, layer);
            ga.transform(AffineTransform.getRotateInstance(PrimitiveShapes.degreeToRadians(THETA)));
        }
        if (ISPILLAR) {
            pitchY = ISHEX ? pitchX : pitchY;
            GArea rectInv = new GArea(new Rect(-pitchX / 2.0, -pitchY / 2.0, pitchX / 2.0, pitchY / 2.0, layer), layer);
            rectInv.setDataType(CNSTscriptingController.getDataType());
            if (ISVECTOR) {
                ((DrawnElement)rectInv.subtract(ga)).setRenderReso(shapeReso);
            } else {
                rectInv.subtract(ga);
            }
            shapeStruct.add(rectInv);
        } else {
            shapeStruct.add(ga);
        }
        if (ISHEX) {
            double pitchYhex = 2.0 * pitchX * Math.cos(0.5235987755982988);
            x = ISCENTERED ? x - pitchX * (double)(elementsX - 1) / 2.0 - pitchX / 4.0 : x;
            y = ISCENTERED ? y - (pitchYhex * (double)(elementsY - 1) + pitchX + pitchX * Math.cos(0.5235987755982988)) / 2.0 + pitchX / 2.0 : y;
            s.add(new Array(shapeStruct, x, y, elementsX, elementsY, (double)elementsX * pitchX, (double)elementsY * pitchYhex));
            s.add(new Array(shapeStruct, x + pitchX / 2.0, y + pitchX * Math.cos(0.5235987755982988), elementsX, elementsY, (double)elementsX * pitchX, (double)elementsY * pitchYhex));
        } else {
            x = ISCENTERED ? x - pitchX * (double)(elementsX - 1) / 2.0 : x;
            y = ISCENTERED ? y - pitchY * (double)(elementsY - 1) / 2.0 : y;
            s.add(new Array(shapeStruct, x, y, elementsX, elementsY, (double)elementsX * pitchX, (double)elementsY * pitchY));
        }
    }

    public static GArea rotateGArea(GArea g, double x, double y, double THETA) {
        g.transform(AffineTransform.getRotateInstance(PrimitiveShapes.degreeToRadians(THETA), x, y));
        g.setDataType(CNSTscriptingController.getDataType());
        return g;
    }

    public static GArea createTrapezoid(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x1, y1);
        poly.lineTo(x2, y2);
        poly.lineTo(x3, y3);
        poly.lineTo(x4, y4);
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createVectorShape(Shape s, int gdsLayer) {
        Path2D.Double p2dTemp = new Path2D.Double();
        PathIterator pi = s.getPathIterator(null);
        while (!pi.isDone()) {
            p2dTemp = PrimitiveShapes.describeCurrentSegment(pi, p2dTemp, false);
            pi.next();
        }
        GArea v = new GArea(p2dTemp, gdsLayer);
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static Path2D.Double describeCurrentSegment(PathIterator pi, Path2D.Double p2d, boolean b) {
        double[] coordinate = new double[6];
        int type = pi.currentSegment(coordinate);
        if (b) {
            for (int i = 0; i < coordinate.length; ++i) {
                coordinate[i] = PrimitiveShapes.nm2umConversion((int)coordinate[i]);
            }
        }
        switch (type) {
            case 0: {
                p2d.moveTo(coordinate[0], coordinate[1]);
                return p2d;
            }
            case 1: {
                p2d.lineTo(coordinate[0], coordinate[1]);
                return p2d;
            }
            case 2: {
                p2d.quadTo(coordinate[0], coordinate[1], coordinate[2], coordinate[3]);
                return p2d;
            }
            case 3: {
                p2d.curveTo(coordinate[0], coordinate[1], coordinate[2], coordinate[3], coordinate[4], coordinate[5]);
                return p2d;
            }
            case 4: {
                p2d.closePath();
                return p2d;
            }
        }
        return p2d;
    }

    public static double nm2umConversion(int i) {
        return (double)i / 1000.0;
    }
}

