/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.Array;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class MEMScoupledArrays {
    public static ArrayList<GArea> createRTElectrode(int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, boolean ISELECTRODE) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double d1 = (W1a - W1b) / 2.0;
        double e1 = (1.0 - hOverlap / L1) * d1;
        double d2 = (W2a - W2b) / 2.0;
        double e2 = (1.0 - hOverlap / L2) * d2;
        double LeBot = 4.0 * space + 4.0 * d2 + 2.0 * W2b + W1b - 2.0 * e2;
        double LeTop = ISELECTRODE ? LeBot + lowerSpace : LeBot;
        double pitch = LeBot + lowerSpace;
        double pxLower = 2.0 * space + d2 + W2b - e1;
        double qxTop = LeBot - space - W2a;
        GArea metalDot = MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal);
        GArea leverBottom = MEMScoupledArrays.createTrapezoidalBeam(W1a, W1b, L1, layerFront, false);
        GArea leverTop = MEMScoupledArrays.createTrapezoidalBeam(W2a, W2b, L2, layerFront, true);
        GArea tempMetal = new GArea(metalDot);
        tempMetal.transform(AffineTransform.getTranslateInstance(W1a / 2.0 + pxLower, L1 - hOverlap / 2.0 + hElectrode));
        GArea metal = new GArea(tempMetal);
        tempMetal = new GArea(metalDot);
        tempMetal.transform(AffineTransform.getTranslateInstance(W2a / 2.0 + space, hOverlap / 2.0 - L2 + L1 + L2 - hOverlap + hElectrode));
        metal.or(tempMetal);
        tempMetal = new GArea(metalDot);
        tempMetal.transform(AffineTransform.getTranslateInstance(W2a / 2.0 + qxTop, hOverlap / 2.0 - L2 + L1 + L2 - hOverlap + hElectrode));
        metal.or(tempMetal);
        GArea METAL = new GArea(metal);
        GArea topElectrode = new GArea(new Rect(0.0, 0.0, LeTop, hElectrode, layerFront), layerFront);
        GArea botElectrode = new GArea(new Rect(0.0, 0.0, LeBot, hElectrode, layerFront), layerFront);
        GArea temp = new GArea(leverBottom);
        botElectrode.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(pxLower, hElectrode)));
        temp = new GArea(leverTop);
        topElectrode.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(space, -L2)));
        temp = new GArea(leverTop);
        topElectrode.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(qxTop, -L2)));
        GArea front = new GArea(botElectrode);
        front.or((GDS2)topElectrode.transform(AffineTransform.getTranslateInstance(0.0, L1 + L2 - hOverlap + hElectrode)));
        GArea FRONT = new GArea(front);
        for (int i = 0; i < numElements; ++i) {
            temp = new GArea(front);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch, 0.0)));
            temp = new GArea(metal);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch, 0.0)));
        }
        alGA.add(FRONT);
        alGA.add(METAL);
        double shiftPitch = ISELECTRODE ? 0.0 : lowerSpace;
        GArea BACK = MEMScoupledArrays.createBackSide(L1, L2, hOverlap, (double)numElements * pitch - shiftPitch, hElectrode, LB, HB, layerBack);
        alGA.add(BACK);
        return alGA;
    }

    public static ArrayList<GArea> createRT2CoupledBeams(int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea metalDot = MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal);
        GArea leverBottom = MEMScoupledArrays.createTrapezoidalBeam(W1a, W1b, L1, layerFront, false);
        GArea leverTop = MEMScoupledArrays.createTrapezoidalBeam(W2a, W2b, L2, layerFront, true);
        GArea topElectrode = new GArea(new Rect(0.0, 0.0, 2.0 * lengthSide + W2a, hElectrode, layerFront), layerFront);
        GArea botElectrode = new GArea(new Rect(0.0, 0.0, 2.0 * lengthSide + W1a, hElectrode, layerFront), layerFront);
        GArea temp = new GArea(leverBottom);
        botElectrode.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(lengthSide, hElectrode)));
        temp = new GArea(leverTop);
        topElectrode.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(lengthSide, -L2)));
        double d1 = (W1a - W1b) / 2.0;
        double d2 = (W2a - W2b) / 2.0;
        double x1 = d1 * hOverlap / L1;
        double x2 = d2 * hOverlap / L2;
        double xOffset = x2 <= x1 ? x1 : x2;
        double centerOffset = (W2a - W1a) / 2.0;
        double pitch = 2.0 * lengthSide + W1a + lowerSpace;
        double botOffset = W2b / 2.0 + W1b / 2.0 + space + centerOffset + xOffset;
        GArea tempMetal = new GArea(metalDot);
        tempMetal.transform(AffineTransform.getTranslateInstance(W1a / 2.0 + lengthSide + botOffset, L1 - hOverlap / 2.0 + hElectrode));
        GArea metal = new GArea(tempMetal);
        tempMetal = new GArea(metalDot);
        tempMetal.transform(AffineTransform.getTranslateInstance(W2a / 2.0 + lengthSide, hOverlap / 2.0 - L2 + L1 + L2 - hOverlap + hElectrode));
        metal.or(tempMetal);
        GArea METAL = new GArea(metal);
        GArea front = new GArea((GArea)botElectrode.transform(AffineTransform.getTranslateInstance(botOffset, 0.0)));
        front.or((GDS2)topElectrode.transform(AffineTransform.getTranslateInstance(0.0, L1 + L2 - hOverlap + hElectrode)));
        GArea FRONT = new GArea(front);
        for (int i = 0; i < numElements; ++i) {
            temp = new GArea(front);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch, 0.0)));
            temp = new GArea(metal);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch, 0.0)));
        }
        GArea BACK = MEMScoupledArrays.createBackSide(L1, L2, hOverlap, (double)numElements * pitch - lowerSpace + botOffset, hElectrode, LB, HB, layerBack);
        alGA.add((GArea)FRONT.transform(AffineTransform.getTranslateInstance(-botOffset, 0.0)));
        alGA.add((GArea)METAL.transform(AffineTransform.getTranslateInstance(-botOffset, 0.0)));
        alGA.add((GArea)BACK.transform(AffineTransform.getTranslateInstance(-botOffset, 0.0)));
        return alGA;
    }

    public static ArrayList<GArea> createRectElectrode(int numElements, double L1, double W1, double L2, double W2, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea leverBottom = new GArea(new Rect(0.0, 0.0, W1, L1, layerFront), layerFront);
        GArea leverTop = new GArea(new Rect(0.0, 0.0, W2, L2, layerFront), layerFront);
        GArea sideElectrode = new GArea(new Rect(0.0, 0.0, lengthSide, hOverlap, layerFront), layerFront);
        double electrodeLength = (double)numElements * (2.0 * space + W1 + W2) + space;
        GArea electrode = new GArea(new Rect(0.0, 0.0, electrodeLength, hElectrode, layerFront), layerFront);
        GArea metalDot = new GArea(MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        GArea temp = new GArea(electrode);
        temp.transform(AffineTransform.getTranslateInstance(0.0, hElectrode + L1 + L2 - hOverlap));
        GArea FRONT = new GArea(electrode);
        FRONT.or(temp);
        temp = new GArea(metalDot);
        GArea METAL = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(2.0 * space + W2 + W1 / 2.0, hElectrode + L1 - hOverlap / 2.0)));
        for (int i = 0; i < numElements; ++i) {
            temp = new GArea(leverBottom);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * (2.0 * space + W1 + W2) + 2.0 * space + W2, hElectrode)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * (2.0 * space + W1 + W2) + 2.0 * space + W2 + W1 / 2.0, hElectrode + L1 - hOverlap / 2.0)));
            temp = new GArea(leverTop);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * (2.0 * space + W1 + W2) + space, L1 - hOverlap + hElectrode)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * (2.0 * space + W1 + W2) + space + W2 / 2.0, L1 - hOverlap / 2.0 + hElectrode)));
        }
        temp = new GArea(sideElectrode);
        FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(electrodeLength, L1 - hOverlap + hElectrode)));
        temp = new GArea(sideElectrode);
        FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-lengthSide, L1 - hOverlap + hElectrode)));
        alGA.add(FRONT);
        alGA.add(METAL);
        GArea BACK = MEMScoupledArrays.createBackSide(L1, L2, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack);
        alGA.add(BACK);
        return alGA;
    }

    public static ArrayList<GArea> createRectVaryingElectrode(int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, boolean LINEAR) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double pitch = 2.0 * space + W + W;
        double electrodeLength = (double)numElements * pitch + space;
        GArea sideElectrode = new GArea(new Rect(0.0, 0.0, lengthSide, hOverlap, layerFront), layerFront);
        GArea FRONT = new GArea(MEMScoupledArrays.createVaryingElectrode(numElements, L, dL, W, W, space, hOverlap, electrodeLength, hElectrode, layerFront, LINEAR, true));
        FRONT.or(MEMScoupledArrays.createVaryingElectrode(numElements, L, dL, W, W, space, hOverlap, electrodeLength, hElectrode, layerFront, LINEAR, false));
        GArea metalDot = new GArea(MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        GArea METAL = new GArea(metalDot);
        GArea temp = new GArea(metalDot);
        for (int i = 0; i < numElements; ++i) {
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + 2.0 * space + W + W / 2.0, hElectrode + L - hOverlap / 2.0)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + space + W / 2.0, L - hOverlap / 2.0 + hElectrode)));
        }
        temp = new GArea(sideElectrode);
        FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(electrodeLength, L - hOverlap + hElectrode)));
        temp = new GArea(sideElectrode);
        FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-lengthSide, L - hOverlap + hElectrode)));
        alGA.add(FRONT);
        alGA.add(METAL);
        GArea BACK = MEMScoupledArrays.createBackSide(L, L, dL, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack, LINEAR);
        alGA.add(BACK);
        return alGA;
    }

    public static ArrayList<GArea> createTrapElectrodesVLW(int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea leverBottom = new GArea(MEMScoupledArrays.createTrapezoidalBeam(W1a, W1b, L1, layerFront, false));
        GArea leverTop = new GArea(MEMScoupledArrays.createTrapezoidalBeam(W2a, W2b, L2, layerFront, true));
        double d = (L1 - hOverlap) * (W1a - W1b) / (2.0 * L1);
        double pitch = W1a + W2b + 2.0 * space - 2.0 * d;
        double electrodeLength = space + (double)(numElements - 1) * pitch + W1a - d + space + W2b + (W2a - W2b) / 2.0 + space;
        GArea electrode = new GArea(new Rect(0.0, 0.0, electrodeLength, hElectrode, layerFront), layerFront);
        GArea sideElectrodeBottom = new GArea(MEMScoupledArrays.createTrapezoidSideElectrodes(L1, W1a, W1b, hOverlap, lengthSide, layerFront, false));
        GArea sideElectrodeTop = new GArea(MEMScoupledArrays.createTrapezoidSideElectrodes(L2, W2a, W2b, hOverlap, lengthSide, layerFront, true));
        GArea metalDot = new GArea(MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        GArea temp = new GArea(electrode);
        temp.transform(AffineTransform.getTranslateInstance(0.0, L1 + L2 - hOverlap + hElectrode));
        GArea FRONT = new GArea(electrode);
        FRONT.or(temp);
        temp = new GArea(metalDot);
        GArea METAL = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(space + W1a / 2.0, hElectrode + L1 - hOverlap / 2.0)));
        double e = electrodeLength - W2a - space - (double)(numElements - 1) * pitch;
        for (int i = 0; i < numElements; ++i) {
            temp = new GArea(leverBottom);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + space, hElectrode)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + space + W1a / 2.0, hElectrode + L1 - hOverlap / 2.0)));
            temp = new GArea(leverTop);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + e, L1 - hOverlap + hElectrode)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + e + W2a / 2.0, L1 - hOverlap / 2.0 + hElectrode)));
        }
        double dPrime = (W2a - W2b) / 2.0;
        FRONT.or((GDS2)sideElectrodeBottom.transform(AffineTransform.getTranslateInstance(d, L1 - hOverlap + hElectrode)));
        FRONT.or((GDS2)sideElectrodeTop.transform(AffineTransform.getTranslateInstance(electrodeLength - dPrime, L1 - hOverlap + hElectrode)));
        alGA.add(FRONT);
        alGA.add(METAL);
        GArea BACK = MEMScoupledArrays.createBackSide(L1, L2, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack);
        alGA.add(BACK);
        return alGA;
    }

    public static ArrayList<GArea> createTrapElectrodesCONST(int numElements, double L, double Wa, double Wb, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea leverBottom = new GArea(MEMScoupledArrays.createTrapezoidalBeam(Wa, Wb, L, layerFront, false));
        GArea leverTop = new GArea(MEMScoupledArrays.createTrapezoidalBeam(Wa, Wb, L, layerFront, true));
        double d = (L - hOverlap) * (Wa - Wb) / (2.0 * L);
        double pitch = Wa + Wb + 2.0 * space - 2.0 * d;
        double electrodeLength = space + (double)(numElements - 1) * pitch + Wa - d + space + Wb + (Wa - Wb) / 2.0 + space;
        GArea electrode = new GArea(new Rect(0.0, 0.0, electrodeLength, hElectrode, layerFront), layerFront);
        GArea sideElectrodeBottom = new GArea(MEMScoupledArrays.createTrapezoidSideElectrodes(L, Wa, Wb, hOverlap, lengthSide, layerFront, false));
        GArea sideElectrodeTop = new GArea(MEMScoupledArrays.createTrapezoidSideElectrodes(L, Wa, Wb, hOverlap, lengthSide, layerFront, true));
        GArea metalDot = new GArea(MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        GArea temp = new GArea(electrode);
        temp.transform(AffineTransform.getTranslateInstance(0.0, L + L - hOverlap + hElectrode));
        GArea FRONT = new GArea(electrode);
        FRONT.or(temp);
        temp = new GArea(metalDot);
        GArea METAL = new GArea((GArea)temp.transform(AffineTransform.getTranslateInstance(space + Wa / 2.0, hElectrode + L - hOverlap / 2.0)));
        double e = electrodeLength - Wa - space - (double)(numElements - 1) * pitch;
        for (int i = 0; i < numElements; ++i) {
            temp = new GArea(leverBottom);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + space, hElectrode)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + space + Wa / 2.0, hElectrode + L - hOverlap / 2.0)));
            temp = new GArea(leverTop);
            FRONT.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + e, L - hOverlap + hElectrode)));
            temp = new GArea(metalDot);
            METAL.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)i * pitch + e + Wa / 2.0, L - hOverlap / 2.0 + hElectrode)));
        }
        double dPrime = (Wa - Wb) / 2.0;
        FRONT.or((GDS2)sideElectrodeBottom.transform(AffineTransform.getTranslateInstance(d, L - hOverlap + hElectrode)));
        FRONT.or((GDS2)sideElectrodeTop.transform(AffineTransform.getTranslateInstance(electrodeLength - dPrime, L - hOverlap + hElectrode)));
        alGA.add(FRONT);
        alGA.add(METAL);
        GArea BACK = MEMScoupledArrays.createBackSide(L, L, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack);
        alGA.add(BACK);
        return alGA;
    }

    public static void createRTElectrodeSTR(Struct s, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA, boolean ISELECTRODE) {
        double d1 = (W1a - W1b) / 2.0;
        double e1 = (1.0 - hOverlap / L1) * d1;
        double d2 = (W2a - W2b) / 2.0;
        double e2 = (1.0 - hOverlap / L2) * d2;
        double LeBot = 4.0 * space + 4.0 * d2 + 2.0 * W2b + W1b - 2.0 * e2;
        double LeTop = ISELECTRODE ? LeBot + lowerSpace : LeBot;
        double pitch = LeBot + lowerSpace;
        double pxLower = 2.0 * space + d2 + W2b - e1;
        double qxTop = LeBot - space - W2a;
        Struct metalDot = new Struct(id + "Dot", MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        Struct leverBottom = new Struct(id + "BeamBot", MEMScoupledArrays.createTrapezoidalBeam(W1a, W1b, L1, layerFront, false));
        Struct leverTop = new Struct(id + "BeamTop", MEMScoupledArrays.createTrapezoidalBeam(W2a, W2b, L2, layerFront, true));
        leverBottom.add(new Ref(metalDot, W1a / 2.0, L1 - hOverlap / 2.0));
        leverTop.add(new Ref(metalDot, W2a / 2.0, hOverlap / 2.0));
        Struct topElectrode = new Struct(id + "TopElectrode", new Rect(0.0, 0.0, LeTop, hElectrode, layerFront));
        Struct botElectrode = new Struct(id + "BotElectrode", new Rect(0.0, 0.0, LeBot, hElectrode, layerFront));
        botElectrode.add(new Ref(leverBottom, pxLower, hElectrode));
        topElectrode.add(new Ref(leverTop, space, -L2));
        topElectrode.add(new Ref(leverTop, qxTop, -L2));
        Struct frontSide = new Struct(id + "FrontSide");
        frontSide.add(new Array(botElectrode, 0.0, 0.0, numElements, 1, (double)numElements * pitch, 1.0));
        frontSide.add(new Array(topElectrode, 0.0, L1 + L2 - hOverlap + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        Struct backSide = new Struct(id + "BackSide");
        double shiftPitch = ISELECTRODE ? 0.0 : lowerSpace;
        backSide.add(MEMScoupledArrays.createBackSide(L1, L2, hOverlap, (double)numElements * pitch - shiftPitch, hElectrode, LB, HB, layerBack));
        s.add(new Ref(frontSide, x, y, 0, THETA));
        s.add(new Ref(backSide, x, y, 0, THETA));
    }

    public static void createRT2CoupledBeamsSTR(Struct s, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double lowerSpace, double hOverlap, double hElectrode, double lengthSide, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Struct metalDot = new Struct(id + "Dot", MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        Struct leverBottom = new Struct(id + "BeamBot", MEMScoupledArrays.createTrapezoidalBeam(W1a, W1b, L1, layerFront, false));
        Struct leverTop = new Struct(id + "BeamTop", MEMScoupledArrays.createTrapezoidalBeam(W2a, W2b, L2, layerFront, true));
        leverBottom.add(new Ref(metalDot, W1a / 2.0, L1 - hOverlap / 2.0));
        leverTop.add(new Ref(metalDot, W2a / 2.0, hOverlap / 2.0));
        Struct topElectrode = new Struct(id + "TopElectrode", new Rect(0.0, 0.0, 2.0 * lengthSide + W2a, hElectrode, layerFront));
        Struct botElectrode = new Struct(id + "BotElectrode", new Rect(0.0, 0.0, 2.0 * lengthSide + W1a, hElectrode, layerFront));
        botElectrode.add(new Ref(leverBottom, lengthSide, hElectrode));
        topElectrode.add(new Ref(leverTop, lengthSide, -L2));
        Struct frontSide = new Struct(id + "FrontSide");
        double d1 = (W1a - W1b) / 2.0;
        double d2 = (W2a - W2b) / 2.0;
        double x1 = d1 * hOverlap / L1;
        double x2 = d2 * hOverlap / L2;
        double xOffset = x2 <= x1 ? x1 : x2;
        double centerOffset = (W2a - W1a) / 2.0;
        double pitch = 2.0 * lengthSide + W1a + lowerSpace;
        double botOffset = W2b / 2.0 + W1b / 2.0 + space + centerOffset + xOffset;
        frontSide.add(new Array(botElectrode, botOffset, 0.0, numElements, 1, (double)numElements * pitch, 1.0));
        frontSide.add(new Array(topElectrode, 0.0, L1 + L2 - hOverlap + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        Struct backSide = new Struct(id + "BackSide");
        backSide.add(MEMScoupledArrays.createBackSide(L1, L2, hOverlap, (double)numElements * pitch - lowerSpace + botOffset, hElectrode, LB, HB, layerBack));
        s.add(new Ref(frontSide, x - botOffset, y, 0, THETA));
        s.add(new Ref(backSide, x - botOffset, y, 0, THETA));
    }

    public static void createRectElectrodeSTR(Struct s, String id, double x, double y, int numElements, double L1, double W1, double L2, double W2, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Struct leverBottom = new Struct(id + "BeamBot", new Rect(0.0, 0.0, W1, L1, layerFront));
        Struct leverTop = new Struct(id + "BeamTop", new Rect(0.0, 0.0, W2, L2, layerFront));
        Struct sideElectrode = new Struct(id + "Side", new Rect(0.0, 0.0, lengthSide, hOverlap, layerFront));
        double electrodeLength = (double)numElements * (2.0 * space + W1 + W2) + space;
        Struct electrode = new Struct(id + "Electrode", new Rect(0.0, 0.0, electrodeLength, hElectrode, layerFront));
        Struct metalDot = new Struct(id + "Dot", MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        Struct frontSide = new Struct(id + "FrontSide");
        frontSide.add(new Ref(electrode, 0.0, 0.0));
        frontSide.add(new Ref(electrode, 0.0, hElectrode + L1 + L2 - hOverlap));
        frontSide.add(new Array(leverBottom, 2.0 * space + W2, hElectrode, numElements, 1, (double)numElements * (2.0 * space + W1 + W2), 1.0));
        frontSide.add(new Array(metalDot, 2.0 * space + W2 + W1 / 2.0, hElectrode + L1 - hOverlap / 2.0, numElements, 1, (double)numElements * (2.0 * space + W1 + W2), 1.0));
        frontSide.add(new Array(leverTop, space, L1 - hOverlap + hElectrode, numElements, 1, (double)numElements * (2.0 * space + W1 + W2), 1.0));
        frontSide.add(new Array(metalDot, space + W2 / 2.0, L1 - hOverlap / 2.0 + hElectrode, numElements, 1, (double)numElements * (2.0 * space + W1 + W2), 1.0));
        frontSide.add(new Ref(sideElectrode, electrodeLength, L1 - hOverlap + hElectrode));
        frontSide.add(new Ref(sideElectrode, -lengthSide, L1 - hOverlap + hElectrode));
        Struct backSide = new Struct(id + "BackSide");
        backSide.add(MEMScoupledArrays.createBackSide(L1, L2, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack));
        s.add(new Ref(frontSide, x, y, 0, THETA));
        s.add(new Ref(backSide, x, y, 0, THETA));
    }

    public static void createRectVaryingElectrodeSTR(Struct s, String id, double x, double y, int numElements, double L, double dL, double W, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA, boolean LINEAR) {
        double pitch = 2.0 * space + W + W;
        double electrodeLength = (double)numElements * pitch + space;
        Struct sideElectrode = new Struct(id + "Side", new Rect(0.0, 0.0, lengthSide, hOverlap, layerFront));
        Struct electrodeVaryingBeams = new Struct(id + "Beams");
        electrodeVaryingBeams.add(MEMScoupledArrays.createVaryingElectrode(numElements, L, dL, W, W, space, hOverlap, electrodeLength, hElectrode, layerFront, LINEAR, true));
        electrodeVaryingBeams.add(MEMScoupledArrays.createVaryingElectrode(numElements, L, dL, W, W, space, hOverlap, electrodeLength, hElectrode, layerFront, LINEAR, false));
        Struct metalDot = new Struct(id + "Dot", MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        electrodeVaryingBeams.add(new Array(metalDot, 2.0 * space + W + W / 2.0, hElectrode + L - hOverlap / 2.0, numElements, 1, (double)numElements * pitch, 1.0));
        electrodeVaryingBeams.add(new Array(metalDot, space + W / 2.0, L - hOverlap / 2.0 + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        electrodeVaryingBeams.add(new Ref(sideElectrode, electrodeLength, L - hOverlap + hElectrode));
        electrodeVaryingBeams.add(new Ref(sideElectrode, -lengthSide, L - hOverlap + hElectrode));
        Struct backSide = new Struct(id + "BackSide");
        backSide.add(MEMScoupledArrays.createBackSide(L, L, dL, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack, LINEAR));
        s.add(new Ref(electrodeVaryingBeams, x, y, 0, THETA));
        s.add(new Ref(backSide, x, y, 0, THETA));
    }

    public static void createTrapElectrodesVLWSTR(Struct s, String id, double x, double y, int numElements, double L1, double W1a, double W1b, double L2, double W2a, double W2b, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Struct leverBottom = new Struct(id + "BeamBot", MEMScoupledArrays.createTrapezoidalBeam(W1a, W1b, L1, layerFront, false));
        Struct leverTop = new Struct(id + "BeamTop", MEMScoupledArrays.createTrapezoidalBeam(W2a, W2b, L2, layerFront, true));
        double d = (L1 - hOverlap) * (W1a - W1b) / (2.0 * L1);
        double pitch = W1a + W2b + 2.0 * space - 2.0 * d;
        double electrodeLength = space + (double)(numElements - 1) * pitch + W1a - d + space + W2b + (W2a - W2b) / 2.0 + space;
        Struct electrode = new Struct(id + "Electrode", new Rect(0.0, 0.0, electrodeLength, hElectrode, layerFront));
        Struct sideElectrodeBottom = new Struct(id + "SideBot", MEMScoupledArrays.createTrapezoidSideElectrodes(L1, W1a, W1b, hOverlap, lengthSide, layerFront, false));
        Struct sideElectrodeTop = new Struct(id + "SideTop", MEMScoupledArrays.createTrapezoidSideElectrodes(L2, W2a, W2b, hOverlap, lengthSide, layerFront, true));
        Struct metalDot = new Struct(id + "Dot", MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        Struct frontSide = new Struct(id + "FrontSide");
        frontSide.add(new Ref(electrode, 0.0, 0.0));
        frontSide.add(new Ref(electrode, 0.0, L1 + L2 - hOverlap + hElectrode));
        frontSide.add(new Array(leverBottom, space, hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        frontSide.add(new Array(metalDot, space + W1a / 2.0, hElectrode + L1 - hOverlap / 2.0, numElements, 1, (double)numElements * pitch, 1.0));
        double e = electrodeLength - W2a - space - (double)(numElements - 1) * pitch;
        frontSide.add(new Array(leverTop, e, L1 - hOverlap + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        frontSide.add(new Array(metalDot, e + W2a / 2.0, L1 - hOverlap / 2.0 + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        double dPrime = (W2a - W2b) / 2.0;
        frontSide.add(new Ref(sideElectrodeBottom, d, L1 - hOverlap + hElectrode));
        frontSide.add(new Ref(sideElectrodeTop, electrodeLength - dPrime, L1 - hOverlap + hElectrode));
        Struct backSide = new Struct(id + "BackSide");
        backSide.add(MEMScoupledArrays.createBackSide(L1, L2, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack));
        s.add(new Ref(frontSide, x, y, 0, THETA));
        s.add(new Ref(backSide, x, y, 0, THETA));
    }

    public static void createTrapElectrodesCONSTSTR(Struct s, String id, double x, double y, int numElements, double L, double Wa, double Wb, double space, double hOverlap, double lengthSide, double hElectrode, double LB, double HB, double diameter, int numSides, int layerFront, int layerBack, int layerMetal, double THETA) {
        Struct leverBottom = new Struct(id + "BeamBot", MEMScoupledArrays.createTrapezoidalBeam(Wa, Wb, L, layerFront, false));
        Struct leverTop = new Struct(id + "BeamTop", MEMScoupledArrays.createTrapezoidalBeam(Wa, Wb, L, layerFront, true));
        double d = (L - hOverlap) * (Wa - Wb) / (2.0 * L);
        double pitch = Wa + Wb + 2.0 * space - 2.0 * d;
        double electrodeLength = space + (double)(numElements - 1) * pitch + Wa - d + space + Wb + (Wa - Wb) / 2.0 + space;
        Struct electrode = new Struct(id + "Electrode", new Rect(0.0, 0.0, electrodeLength, hElectrode, layerFront));
        Struct sideElectrodeBottom = new Struct(id + "SideBot", MEMScoupledArrays.createTrapezoidSideElectrodes(L, Wa, Wb, hOverlap, lengthSide, layerFront, false));
        Struct sideElectrodeTop = new Struct(id + "SideTop", MEMScoupledArrays.createTrapezoidSideElectrodes(L, Wa, Wb, hOverlap, lengthSide, layerFront, true));
        Struct metalDot = new Struct(id + "Dot", MEMScoupledArrays.createCircle(diameter / 2.0, numSides, layerMetal));
        Struct frontSide = new Struct(id + "FrontSide");
        frontSide.add(new Ref(electrode, 0.0, 0.0));
        frontSide.add(new Ref(electrode, 0.0, L + L - hOverlap + hElectrode));
        frontSide.add(new Array(leverBottom, space, hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        frontSide.add(new Array(metalDot, space + Wa / 2.0, hElectrode + L - hOverlap / 2.0, numElements, 1, (double)numElements * pitch, 1.0));
        double e = electrodeLength - Wa - space - (double)(numElements - 1) * pitch;
        frontSide.add(new Array(leverTop, e, L - hOverlap + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        frontSide.add(new Array(metalDot, e + Wa / 2.0, L - hOverlap / 2.0 + hElectrode, numElements, 1, (double)numElements * pitch, 1.0));
        double dPrime = (Wa - Wb) / 2.0;
        frontSide.add(new Ref(sideElectrodeBottom, d, L - hOverlap + hElectrode));
        frontSide.add(new Ref(sideElectrodeTop, electrodeLength - dPrime, L - hOverlap + hElectrode));
        Struct backSide = new Struct(id + "BackSide");
        backSide.add(MEMScoupledArrays.createBackSide(L, L, hOverlap, electrodeLength, hElectrode, LB, HB, layerBack));
        s.add(new Ref(frontSide, x, y, 0, THETA));
        s.add(new Ref(backSide, x, y, 0, THETA));
    }

    public static GArea createCircle(double rad, int numSides, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(rad, 0.0);
        int steps = numSides;
        double c = Math.PI * 2 / (double)numSides;
        for (int i = 0; i < steps; ++i) {
            poly.lineTo(rad * Math.cos((double)i * c), rad * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTrapezoidalBeam(double Wa, double Wb, double L, int layer, boolean TOP) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(Wa, 0.0);
        poly.lineTo(Wa / 2.0 + Wb / 2.0, L);
        poly.lineTo(Wa / 2.0 - Wb / 2.0, L);
        poly.lineTo(0.0, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, layer);
        if (TOP) {
            v.transform(AffineTransform.getRotateInstance(Math.PI, Wa / 2.0, L / 2.0));
        }
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createTrapezoidSideElectrodes(double L, double Wa, double Wb, double hOverlap, double lengthSide, int layer, boolean TOP) {
        double d = hOverlap * (Wa - Wb) / (2.0 * L);
        lengthSide = TOP ? lengthSide + d : -lengthSide;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(d, hOverlap);
        poly.lineTo(lengthSide, hOverlap);
        poly.lineTo(lengthSide, 0.0);
        poly.lineTo(0.0, 0.0);
        poly.closePath();
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createBackSide(double L1, double L2, double hOverlap, double electrodeLength, double hElectrode, double LB, double HB, int layerBackside) {
        double top = L1 + L2 - hOverlap;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(electrodeLength, 0.0);
        poly.curveTo(electrodeLength + LB / 2.0, 0.0, electrodeLength + LB, HB / 2.0, electrodeLength + LB, HB);
        poly.lineTo(electrodeLength + LB, top + HB);
        poly.curveTo(electrodeLength + LB, top + 1.5 * HB, electrodeLength + LB / 2.0, top + 2.0 * HB, electrodeLength, top + 2.0 * HB);
        poly.lineTo(0.0, top + 2.0 * HB);
        poly.curveTo(-LB / 2.0, top + 2.0 * HB, -LB, top + 1.5 * HB, -LB, top + HB);
        poly.lineTo(-LB, HB);
        poly.curveTo(-LB, HB / 2.0, -LB / 2.0, 0.0, 0.0, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, layerBackside);
        v.transform(AffineTransform.getTranslateInstance(0.0, hElectrode - HB));
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createBackSide(double L1, double L2, double dL, double hOverlap, double electrodeLength, double hElectrode, double LB, double HB, int layerBackside, boolean LINEAR) {
        double top = L1 + L2 - hOverlap;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        double offsetY = LINEAR ? 0.0 : dL;
        poly.curveTo(0.0, offsetY, electrodeLength, dL, electrodeLength, dL);
        poly.curveTo(electrodeLength + LB / 2.0, dL, electrodeLength + LB, dL + HB / 2.0, electrodeLength + LB, dL + HB);
        poly.lineTo(electrodeLength + LB, top + HB);
        poly.curveTo(electrodeLength + LB, top + 1.5 * HB, electrodeLength + LB / 2.0, top + 2.0 * HB, electrodeLength, top + 2.0 * HB);
        poly.curveTo(electrodeLength, top + 2.0 * HB, 0.0, top + 2.0 * HB - dL + offsetY, 0.0, top + 2.0 * HB - dL);
        poly.curveTo(-LB / 2.0, top + 2.0 * HB - dL, -LB, top + 1.5 * HB - dL, -LB, top + HB - dL);
        poly.lineTo(-LB, HB);
        poly.curveTo(-LB, HB / 2.0, -LB / 2.0, 0.0, 0.0, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, layerBackside);
        v.transform(AffineTransform.getTranslateInstance(0.0, hElectrode - HB));
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createVaryingElectrode(int numElements, double L, double dL, double W1, double W2, double space, double hOverlap, double electrodeLength, double hElectrode, int layer, boolean LINEAR, boolean BOTTOM) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        if (LINEAR) {
            poly.lineTo(electrodeLength, dL);
        } else {
            poly.curveTo(0.0, dL, electrodeLength, dL, electrodeLength, dL);
        }
        Point2D.Double p2d = BOTTOM ? new Point2D.Double(electrodeLength, 0.0) : new Point2D.Double(0.0, dL);
        poly.lineTo(p2d.x, p2d.y);
        poly.closePath();
        GArea varying = new GArea(poly, layer);
        GArea electrode = new GArea(new Rect(0.0, 0.0, electrodeLength, hElectrode, layer), layer);
        double rectOffset = BOTTOM ? -hElectrode : dL;
        electrode.transform(AffineTransform.getTranslateInstance(0.0, rectOffset));
        electrode.or(varying);
        double pitch = 2.0 * space + W1 + W2;
        double delX = BOTTOM ? 2.0 * space + W2 : space;
        Point2D.Double p2dTranslate = BOTTOM ? new Point2D.Double(delX, 0.0) : new Point2D.Double(delX, dL - L);
        GArea beam = new GArea(new Rect(0.0, 0.0, W1, L, layer), layer);
        beam.transform(AffineTransform.getTranslateInstance(p2dTranslate.x, p2dTranslate.y));
        electrode.or(beam);
        for (int i = 0; i < numElements - 1; ++i) {
            beam.transform(AffineTransform.getTranslateInstance(pitch, 0.0));
            electrode.or(beam);
        }
        double yOffset = BOTTOM ? hElectrode : hElectrode + L + (L - dL) - hOverlap;
        electrode.transform(AffineTransform.getTranslateInstance(0.0, yOffset));
        electrode.setDataType(CNSTscriptingController.getDataType());
        return electrode;
    }
}

