/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class FunctionPlot {
    public static ArrayList<GArea> createFunctionPlot(boolean funcXY, String func, String[] parameters) throws ScriptException {
        double lowerLimit = Double.parseDouble(parameters[2]);
        double upperLimit = Double.parseDouble(parameters[3]);
        int numSegments = Integer.parseInt(parameters[4]);
        double width = Double.parseDouble(parameters[5]);
        int CAP = Integer.parseInt(parameters[6]);
        int JOIN = Integer.parseInt(parameters[7]);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        ArrayList<GArea> gaAL = new ArrayList();
        ArrayList<Point2D.Double> xyVal = new ArrayList();
        if (funcXY) {
            xyVal = FunctionPlot.calculatePointsDX(engine, func, lowerLimit, upperLimit, numSegments);
            gaAL = FunctionPlot.fractureShape(FunctionPlot.createShape(xyVal, width));
            return gaAL;
        }
        xyVal = FunctionPlot.calculatePointsRT(engine, func, lowerLimit, upperLimit, numSegments);
        gaAL = FunctionPlot.fractureShape(FunctionPlot.createShape(xyVal, width));
        return gaAL;
    }

    public static ArrayList<Point2D.Double> calculatePointsDX(ScriptEngine engine, String func, double lowerLimit, double upperLimit, int numPoints) throws ScriptException {
        ArrayList<Point2D.Double> xy = new ArrayList<Point2D.Double>();
        double deltaX = (upperLimit - lowerLimit) / (double)(numPoints - 1);
        for (int i = 0; i < numPoints; ++i) {
            engine.put("x", lowerLimit);
            xy.add(new Point2D.Double(lowerLimit, Double.parseDouble(engine.eval(func).toString())));
            lowerLimit += deltaX;
        }
        return xy;
    }

    public static ArrayList<Point2D.Double> calculatePointsRT(ScriptEngine engine, String func, double lowerLimit, double upperLimit, int numPoints) throws ScriptException {
        ArrayList<Point2D.Double> xy = new ArrayList<Point2D.Double>();
        double delta = (upperLimit - lowerLimit) / (double)(numPoints - 1);
        for (int i = 0; i < numPoints; ++i) {
            engine.put("t", lowerLimit);
            double rVal = Double.parseDouble(engine.eval(func).toString());
            xy.add(new Point2D.Double(rVal * Math.cos(lowerLimit), rVal * Math.sin(lowerLimit)));
            lowerLimit += delta;
        }
        return xy;
    }

    public static GArea createShape(ArrayList<Point2D.Double> xy, double width) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(xy.get((int)0).x, xy.get((int)0).y);
        for (int i = 1; i < xy.size(); ++i) {
            path.lineTo(xy.get((int)i).x, xy.get((int)i).y);
        }
        BasicStroke bs = new BasicStroke((float)width, 1, 0);
        GArea fa = new GArea(bs.createStrokedShape(path), CNSTscriptingController.getGdsLayer());
        return fa;
    }

    public static ArrayList<GArea> fractureShape(GArea ga) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        Area a = new Area(ga.getArea());
        Rectangle2D rec = a.getBounds2D();
        Rect rLL = new Rect(rec.getMinX(), rec.getMinY(), rec.getCenterX(), rec.getCenterY(), 4);
        Rect rLR = new Rect(rec.getCenterX(), rec.getMinY(), rec.getMaxX(), rec.getCenterY(), 14);
        Rect rUL = new Rect(rec.getMinX(), rec.getCenterY(), rec.getCenterX(), rec.getMaxY(), 24);
        Rect rUR = new Rect(rec.getCenterX(), rec.getCenterY(), rec.getMaxX(), rec.getMaxY(), 44);
        alGA.add((GArea)new GArea(ga).and(rLL));
        alGA.add((GArea)new GArea(ga).and(rLR));
        alGA.add((GArea)new GArea(ga).and(rUL));
        alGA.add((GArea)new GArea(ga).and(rUR));
        return alGA;
    }
}

