/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.BasicStroke;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class Fractals {
    public static Struct createSierpinskiTriangle(int iterations, double length, int layer, String name) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(length /= 2.0, 2.0 * length);
        poly.lineTo(2.0 * length, 0.0);
        poly.lineTo(0.0, 0.0);
        poly.closePath();
        GArea va = new GArea(poly, layer);
        va.setDataType(CNSTscriptingController.getDataType());
        ArrayList<Struct> v = new ArrayList<Struct>();
        v.add(new Struct(name + "0", va));
        for (int i = 1; i < iterations; ++i) {
            Struct temp = new Struct(name + i);
            Ref r = new Ref((Struct)v.get(i - 1), 0.0, 0.0);
            r.setMag(0.5);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length / 2.0, length);
            r.setMag(0.5);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, 0.0);
            r.setMag(0.5);
            temp.add(r);
            v.add(temp);
        }
        return (Struct)v.get(iterations - 1);
    }

    public static Struct createSierpinskiCarpet(int iterations, double length, int layer, String name) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(-length / 2.0, -length / 2.0);
        poly.lineTo(length / 2.0, -length / 2.0);
        poly.lineTo(length / 2.0, length / 2.0);
        poly.lineTo(-length / 2.0, length / 2.0);
        poly.lineTo(-length / 2.0, -length / 2.0);
        poly.closePath();
        GArea va = new GArea(poly, layer);
        va.setDataType(CNSTscriptingController.getDataType());
        ArrayList<Struct> v = new ArrayList<Struct>();
        v.add(new Struct(name + "0", va));
        for (int i = 1; i < iterations; ++i) {
            Struct temp = new Struct(name + i);
            temp.add(new Ref((Struct)v.get(0), 0.0, 0.0));
            Ref r = new Ref((Struct)v.get(i - 1), -length, -length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), 0.0, -length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, -length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, 0.0);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), 0.0, length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), -length, length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), -length, 0.0);
            r.setMag(0.33333333);
            temp.add(r);
            v.add(temp);
        }
        return (Struct)v.get(iterations - 1);
    }

    public static Struct createCurvedTree(String name, double width, double length, int iterations, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(width / 2.0, 0.0);
        poly.curveTo(width / 2.0, length / 2.0, length + width / 2.0, length / 2.0, length + width / 2.0, length);
        BasicStroke bs = new BasicStroke((float)width, 0, 0, 2.5f);
        GArea fa = new GArea(bs.createStrokedShape(poly), layer);
        fa.setDataType(CNSTscriptingController.getDataType());
        Struct s = new Struct(name, fa);
        Struct d = new Struct(name + "0", new Ref(s, 0.0, 0.0));
        d.add(new Ref(s, 0.0, 0.0, 32768, 180.0));
        ArrayList<Struct> n = new ArrayList<Struct>();
        n.add(d);
        for (int i = 1; i < iterations; ++i) {
            Struct temp = new Struct(name + i);
            Ref r = new Ref((Struct)n.get(i - 1), -length - width / 2.0, length);
            r.setMag(0.5);
            temp.add(r);
            r = new Ref((Struct)n.get(i - 1), length + width / 2.0, length);
            r.setMag(0.5);
            temp.add(r);
            r = new Ref((Struct)n.get(0), 0.0, 0.0);
            temp.add(r);
            n.add(temp);
        }
        return (Struct)n.get(iterations - 1);
    }

    public static Struct createVicsekSaltire(int iterations, double length, int layer, String name) {
        double hl = length / 2.0;
        Rect rect1 = new Rect(-hl, -hl, hl, hl, layer);
        Rect rect2 = new Rect(-3.0 * hl, -3.0 * hl, -hl, -hl, layer);
        Rect rect3 = new Rect(hl, -3.0 * hl, 3.0 * hl, -hl, layer);
        Rect rect4 = new Rect(hl, hl, 3.0 * hl, 3.0 * hl, layer);
        Rect rect5 = new Rect(-3.0 * hl, hl, -hl, 3.0 * hl, layer);
        ArrayList<Struct> v = new ArrayList<Struct>();
        v.add(new Struct(name + "0", rect1));
        ((Struct)v.get(0)).add(rect2);
        ((Struct)v.get(0)).add(rect3);
        ((Struct)v.get(0)).add(rect4);
        ((Struct)v.get(0)).add(rect5);
        for (int i = 1; i < iterations; ++i) {
            Struct temp = new Struct(name + i);
            Ref r = new Ref((Struct)v.get(i - 1), 0.0, 0.0);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), -length, -length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, -length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), -length, length);
            r.setMag(0.33333333);
            temp.add(r);
            v.add(temp);
        }
        return (Struct)v.get(iterations - 1);
    }

    public static Struct createVicsekCross(int iterations, double length, int layer, String name) {
        double hl = length / 2.0;
        Rect rect1 = new Rect(-hl, -hl, hl, hl, layer);
        Rect rect2 = new Rect(-3.0 * hl, -hl, -hl, hl, layer);
        Rect rect3 = new Rect(-hl, -3.0 * hl, hl, -hl, layer);
        Rect rect4 = new Rect(hl, -hl, 3.0 * hl, hl, layer);
        Rect rect5 = new Rect(-hl, hl, hl, 3.0 * hl, layer);
        ArrayList<Struct> v = new ArrayList<Struct>();
        v.add(new Struct(name + "0", rect1));
        ((Struct)v.get(0)).add(rect2);
        ((Struct)v.get(0)).add(rect3);
        ((Struct)v.get(0)).add(rect4);
        ((Struct)v.get(0)).add(rect5);
        for (int i = 1; i < iterations; ++i) {
            Struct temp = new Struct(name + i);
            Ref r = new Ref((Struct)v.get(i - 1), 0.0, 0.0);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), -length, 0.0);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), 0.0, -length);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), length, 0.0);
            r.setMag(0.33333333);
            temp.add(r);
            r = new Ref((Struct)v.get(i - 1), 0.0, length);
            r.setMag(0.33333333);
            temp.add(r);
            v.add(temp);
        }
        return (Struct)v.get(iterations - 1);
    }

    public static Struct createAnotherTree(String name, int iterations, int layer) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(0.25, 2.0);
        poly.lineTo(0.5, 2.0);
        poly.lineTo(0.35, 0.0);
        poly.lineTo(0.0, 0.0);
        poly.closePath();
        GArea tr = new GArea(poly, layer);
        tr.setDataType(CNSTscriptingController.getDataType());
        ArrayList<Struct> t = new ArrayList<Struct>();
        t.add(new Struct(name + "0", tr));
        for (i = 1; i < 12; ++i) {
            Struct temp = new Struct(name + i);
            Ref r = new Ref((Struct)t.get(i - 1), 0.25, 2.0);
            r.setMag(0.75);
            r.setAngle(355.0);
            temp.add(r);
            r = new Ref((Struct)t.get(i - 1), 0.21, 1.7);
            r.setMag(0.44);
            r.setAngle(60.0);
            temp.add(r);
            r = new Ref((Struct)t.get(i - 1), 0.35, 1.0);
            r.setMag(0.37);
            r.setAngle(300.0);
            temp.add(r);
            r = new Ref((Struct)t.get(0), 0.0, 0.0);
            temp.add(r);
            t.add(temp);
        }
        return (Struct)t.get(i - 1);
    }

    public static Struct tree(double d, double ang, double ratio, int depth, String name, int layer) {
        int i;
        double rd = 0.25;
        double p = ratio / (ratio + 1.0);
        Path2D.Double poly3 = new Path2D.Double();
        poly3.moveTo(d / 2.0, 0.0);
        poly3.curveTo(d / 2.0, 0.5 - rd * Math.cos(ang), 0.5 - rd * Math.sin(ang), 0.5 - rd * Math.cos(ang), 0.5, 0.5);
        BasicStroke bs = new BasicStroke((float)d, 0, 0, 2.5f);
        GArea fa = new GArea(bs.createStrokedShape(poly3), layer);
        fa.setDataType(CNSTscriptingController.getDataType());
        ang = ang * 180.0 / Math.PI;
        Struct s = new Struct(name + "s" + "_" + GDS2.val(d * 11.0 + ang * 13.0 + ratio * 17.0), fa);
        Struct w = new Struct(name + "d0" + "_" + GDS2.val(d * 11.0 + ang * 13.0 + ratio * 17.0), new Ref(s, -(0.5 - p) * d, 0.0, 0, 1.0 - p, 0.0));
        w.add(new Ref(s, d * (p - 0.5), 0.0, 32768, p, 180.0));
        ArrayList<Struct> n = new ArrayList<Struct>();
        n.add(w);
        for (i = 1; i < depth; ++i) {
            boolean odd = i % 2 == 0;
            Struct temp = new Struct(name + i + "_" + GDS2.val(d * 11.0 + ang * 13.0 + ratio * 17.0));
            Ref r = new Ref((Struct)n.get(i - 1), -0.5 * p + d * (p - 0.5), 0.5 * p, odd ? 32768 : 0);
            r.setMag(p);
            r.setAngle(ang + (double)(odd ? 180 : 0));
            temp.add(r);
            r = new Ref((Struct)n.get(i - 1), 0.5 * (1.0 - p) - (0.5 - p) * d, 0.5 * (1.0 - p), odd ? 0 : 32768);
            r.setMag(1.0 - p);
            r.setAngle(360.0 - ang - (double)(odd ? 0 : 180));
            temp.add(r);
            r = new Ref((Struct)n.get(0), 0.0, 0.0);
            temp.add(r);
            n.add(temp);
        }
        return (Struct)n.get(i - 1);
    }
}

