/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import JGDS2.GArea;
import JGDS2.Rect;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class AlignmentMarks {
    public static GArea createAlignCross(double L, double W, int layer) {
        GArea gH = new GArea(new Rect(-L, -W / 2.0, L, W / 2.0, layer), layer);
        GArea gV = new GArea(new Rect(-W / 2.0, -L, W / 2.0, L, layer), layer);
        return gH.or(gV);
    }

    public static GArea createAlignCross(double L1, double W1, double L2, double W2, int layer) {
        GArea gH = new GArea(new Rect(-L1, -W1 / 2.0, L1, W1 / 2.0, layer), layer);
        GArea gV = new GArea(new Rect(-W2 / 2.0, -L2, W2 / 2.0, L2, layer), layer);
        return gH.or(gV);
    }

    public static ArrayList<GArea> createAlignVernLb1(int layer1, int layer2, double vernReso) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        layer1 = layer1 < 0 || layer1 > 255 ? 1 : layer1;
        layer2 = layer2 < 0 || layer2 > 255 ? 2 : layer2;
        double L1 = 100.0;
        double W1 = 10.0;
        double L2 = 102.0;
        double W2 = 14.0;
        GArea crossL1 = AlignmentMarks.createAlignCross(L2, W2, layer1);
        GArea boxL1 = new GArea(new Rect(-L1 - 15.0, -L1 - 15.0, L1 + 15.0, L1 + 15.0, layer1), layer1);
        GArea crossL2 = AlignmentMarks.createAlignCross(L1, W1, layer2);
        GArea boxL2 = new GArea(new Rect(-1000.0, -1000.0, 1000.0, 1000.0, layer2), layer2);
        double wVern = 4.0;
        double pitch1 = 4.0;
        double pitch2 = 4.0 + vernReso;
        double space = 5.0;
        GArea vernier1L = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, -1.5707963267948966);
        vernier1L.transform(AffineTransform.getTranslateInstance(-L1 - 85.0, 0.0));
        GArea vernier1R = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, 0.0);
        vernier1R.transform(AffineTransform.getTranslateInstance(0.0, -L1 - 90.0 + space));
        GArea vernier2L = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer2, 1.5707963267948966);
        vernier2L.transform(AffineTransform.getTranslateInstance(-L1 - 85.0 - space, 0.0));
        GArea vernier2R = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer2, Math.PI);
        vernier2R.transform(AffineTransform.getTranslateInstance(0.0, -L1 - 90.0));
        GArea label1 = AlignmentMarks.createAlignLabel(layer1, L2 / 2.0, 140.0);
        GArea label2 = AlignmentMarks.createAlignLabel(layer2, -L2 / 2.0, 140.0);
        boxL1.subtract(crossL1);
        boxL1.or(vernier1L);
        boxL1.or(vernier1R);
        boxL1.or(label1);
        alGA.add(boxL1);
        boxL2.subtract(crossL2);
        boxL2.subtract(vernier2L);
        boxL2.subtract(vernier2R);
        boxL2.subtract(label2);
        alGA.add(boxL2);
        return alGA;
    }

    public static ArrayList<GArea> createAlignVernLb2(int layer1, int layer2, double vernReso) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double L1 = 100.0;
        double W1 = 10.0;
        double L2 = 102.0;
        double W2 = 14.0;
        layer1 = layer1 < 0 || layer1 > 255 ? 1 : layer1;
        layer2 = layer2 < 0 || layer2 > 255 ? 2 : layer2;
        GArea crossL1 = AlignmentMarks.createAlignCross(L1, W1, layer1);
        GArea crossL2 = AlignmentMarks.createAlignCross(L2, W2, layer2);
        GArea boxL2 = new GArea(new Rect(-L2 - 15.0, -L2 - 15.0, L2 + 15.0, L2 + 15.0, layer2), layer2);
        double wVern = 4.0;
        double pitch1 = 4.0;
        double pitch2 = 4.0 + vernReso;
        double space = 5.0;
        GArea vernier1L = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, -1.5707963267948966);
        vernier1L.transform(AffineTransform.getTranslateInstance(-L1 - 85.0, 0.0));
        GArea vernier1R = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, 0.0);
        vernier1R.transform(AffineTransform.getTranslateInstance(0.0, -L1 - 90.0 + space));
        GArea vernier2L = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer2, 1.5707963267948966);
        vernier2L.transform(AffineTransform.getTranslateInstance(-L1 - 85.0 - space, 0.0));
        GArea vernier2R = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer2, Math.PI);
        vernier2R.transform(AffineTransform.getTranslateInstance(0.0, -L1 - 90.0));
        GArea label1 = AlignmentMarks.createAlignLabel(layer1, L2 / 2.0, 140.0);
        GArea label2 = AlignmentMarks.createAlignLabel(layer2, -L2 / 2.0, 140.0);
        alGA.add(crossL1);
        alGA.add(vernier1L);
        alGA.add(vernier1R);
        alGA.add(label1);
        boxL2.subtract(crossL2);
        boxL2.or(vernier2L);
        boxL2.or(vernier2R);
        boxL2.or(label2);
        alGA.add(boxL2);
        return alGA;
    }

    public static ArrayList<GArea> createAlign3Level(int layer1, int layer2, int layer3) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        layer1 = layer1 < 0 || layer1 > 255 ? 1 : layer1;
        layer2 = layer2 < 0 || layer2 > 255 ? 2 : layer2;
        layer3 = layer2 < 0 || layer3 > 255 ? 2 : layer3;
        Rect r1A = new Rect(20.0, 20.0, 150.0, 150.0, layer1);
        Rect r1B = new Rect(15.0, 15.0, 100.0, 100.0, layer1);
        Rect r1C = new Rect(12.0, 12.0, 50.0, 50.0, layer1);
        GArea g1 = new GArea(r1A, layer1);
        g1.or(r1B);
        g1.or(r1C);
        GArea g1tmp = new GArea(g1);
        for (int i = 1; i < 4; ++i) {
            g1tmp.transform(AffineTransform.getRotateInstance((double)i * Math.PI / 2.0, 0.0, 0.0));
            g1.or(g1tmp);
        }
        Rect r2A = new Rect(-1000.0, -1000.0, 1000.0, 1000.0, layer2);
        Rect r2B = new Rect(22.0, 22.0, 140.0, 140.0, layer2);
        GArea cross2 = AlignmentMarks.createAlignCross(300.0, 20.0, 200.0, 20.0, layer2);
        GArea g2 = new GArea(r2A, layer2);
        GArea g2tmp = new GArea(r2B, layer2);
        g2.subtract(cross2);
        g2.subtract(g2tmp);
        for (int i = 1; i < 4; ++i) {
            g2tmp.transform(AffineTransform.getRotateInstance((double)i * Math.PI / 2.0, 0.0, 0.0));
            g2.subtract(g2tmp);
        }
        GArea g3 = AlignmentMarks.createAlignCross(300.0, 20.0, 200.0, 20.0, layer3);
        Rect r3 = new Rect(22.0, 22.0, 140.0, 140.0, layer3);
        GArea g3tmp = new GArea(r3, layer3);
        g3.or(g3tmp);
        for (int i = 1; i < 4; ++i) {
            g3tmp.transform(AffineTransform.getRotateInstance((double)i * Math.PI / 2.0, 0.0, 0.0));
            g3.or(g3tmp);
        }
        alGA.add(g1);
        alGA.add(g2);
        alGA.add(g3);
        return alGA;
    }

    public static ArrayList<GArea> createAlignVern(int layer1, int layer2, double vernReso, boolean L1INV, boolean L2INV, double invL, double invW) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        layer1 = layer1 < 0 || layer1 > 255 ? 1 : layer1;
        layer2 = layer2 < 0 || layer2 > 255 ? 2 : layer2;
        double L1 = 70.0;
        double W1 = 30.0;
        double lineL1 = 600.0;
        double lineW1 = 5.0;
        double lineL2 = 700.0;
        double lineW2 = 10.0;
        double wVern = 4.0;
        double pitch1 = 4.0;
        double pitch2 = 4.0 + vernReso;
        GArea g1 = AlignmentMarks.createAlignCross(L1, W1, layer1);
        GArea gtmp = new GArea(new Rect(200.0, -lineW1 / 2.0, 200.0 + lineL1, lineW1 / 2.0, layer1), layer1);
        g1.or(AlignmentMarks.createAlignRotate90GAreas(gtmp));
        GArea vernier1L = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, 1.5707963267948966);
        vernier1L.transform(AffineTransform.getTranslateInstance(-L1 - 85.0, 0.0));
        GArea vernier1R = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, -1.5707963267948966);
        vernier1R.transform(AffineTransform.getTranslateInstance(L1 + 85.0, 0.0));
        GArea vernier1U = AlignmentMarks.createAlignVerniers(wVern, pitch1, layer1, 0.0);
        vernier1U.transform(AffineTransform.getTranslateInstance(0.0, L1 + 85.0));
        g1.or(vernier1L);
        g1.or(vernier1R);
        g1.or(vernier1U);
        gtmp = new GArea(new Rect(20.0, 20.0, 70.0, 70.0, layer2), layer2);
        GArea g2 = new GArea(AlignmentMarks.createAlignRotate90GAreas(gtmp));
        gtmp = new GArea(new Rect(200.0, -lineW2 / 2.0, 200.0 + lineL2, lineW2 / 2.0, layer1), layer1);
        g2.or(AlignmentMarks.createAlignRotate90GAreas(gtmp));
        GArea vernier2L = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer1, -1.5707963267948966);
        vernier2L.transform(AffineTransform.getTranslateInstance(-L1 - 80.0, 0.0));
        GArea vernier2R = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer1, 1.5707963267948966);
        vernier2R.transform(AffineTransform.getTranslateInstance(L1 + 80.0, 0.0));
        GArea vernier2U = AlignmentMarks.createAlignVerniers(wVern, pitch2, layer1, Math.PI);
        vernier2U.transform(AffineTransform.getTranslateInstance(0.0, L1 + 80.0));
        g2.or(vernier2L);
        g2.or(vernier2R);
        g2.or(vernier2U);
        GArea g1Tot = L1INV ? AlignmentMarks.createAlignInverse(invL, invW, g1, layer1) : g1;
        GArea g2Tot = L2INV ? AlignmentMarks.createAlignInverse(invL, invW, g2, layer2) : g2;
        alGA.add(g1Tot);
        alGA.add(g2Tot);
        return alGA;
    }

    public static ArrayList<GArea> createAlignFFFB1(int layerCross, int layerSquare) {
        ArrayList<GArea> gaAL = new ArrayList<GArea>();
        layerCross = layerCross < 0 || layerCross > 255 ? 1 : layerCross;
        layerSquare = layerSquare < 0 || layerSquare > 255 ? 2 : layerSquare;
        double backL1 = 60.0;
        double backShort = 20.0;
        double backW = 10.0;
        GArea crossB = AlignmentMarks.createAlignCross(backL1, backW, layerCross);
        Rect rBH = new Rect(backW / 4.0, backW / 4.0, backShort, backShort, layerCross);
        crossB.subtract(rBH);
        GArea gTmp = new GArea(rBH, layerCross);
        gTmp.transform(AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0));
        crossB.subtract(gTmp);
        gTmp.transform(AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0));
        crossB.subtract(gTmp);
        gTmp.transform(AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0));
        crossB.subtract(gTmp);
        double frontL = 10.0;
        double frontW = 5.0;
        double frontBoxBig = 160.0;
        double frontBoxBigW = 5.0;
        GArea crossF = AlignmentMarks.createAlignCross(frontL, frontW, layerSquare);
        GArea boxFbig1 = new GArea(new Rect(-frontBoxBig / 2.0, -frontBoxBig / 2.0, frontBoxBig / 2.0, frontBoxBig / 2.0, layerSquare), layerSquare);
        Rect boxFsmall1 = new Rect(frontBoxBigW - frontBoxBig / 2.0, frontBoxBigW - frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, layerSquare);
        GArea boxFbig2 = new GArea(new Rect(-(frontBoxBig -= 4.0 * frontBoxBigW) / 2.0, -frontBoxBig / 2.0, frontBoxBig / 2.0, frontBoxBig / 2.0, layerSquare), layerSquare);
        Rect boxFsmall2 = new Rect(frontBoxBigW - frontBoxBig / 2.0, frontBoxBigW - frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, layerSquare);
        boxFbig1.subtract(boxFsmall1);
        boxFbig2.subtract(boxFsmall2);
        gaAL.add(crossB);
        gaAL.add(crossF);
        gaAL.add(boxFbig1);
        gaAL.add(boxFbig2);
        return gaAL;
    }

    public static ArrayList<GArea> createAlignFFFB2(int layerCross, int layerSquare) {
        ArrayList<GArea> gaAL = new ArrayList<GArea>();
        layerCross = layerCross < 0 || layerCross > 255 ? 1 : layerCross;
        layerSquare = layerSquare < 0 || layerSquare > 255 ? 2 : layerSquare;
        double backL1 = 60.0;
        double backMid = 20.0;
        double backW = 10.0;
        GArea crossB = AlignmentMarks.createAlignCross(backL1, backW / 2.0, layerCross);
        Rect rBH = new Rect(20.0, -backW / 2.0, 50.0, backW / 2.0, layerCross);
        crossB.or(rBH);
        GArea gTmp = new GArea(rBH, layerCross);
        gTmp.transform(AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0));
        crossB.or(gTmp);
        gTmp.transform(AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0));
        crossB.or(gTmp);
        gTmp.transform(AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0));
        crossB.or(gTmp);
        double frontL = 10.0;
        double frontW = 5.0;
        double frontBoxBig = 160.0;
        double frontBoxBigW = 10.0;
        GArea crossF = AlignmentMarks.createAlignCross(frontL, frontW, layerSquare);
        GArea boxFbig1 = new GArea(new Rect(-frontBoxBig / 2.0, -frontBoxBig / 2.0, frontBoxBig / 2.0, frontBoxBig / 2.0, layerSquare), layerSquare);
        Rect boxFsmall1 = new Rect(frontBoxBigW - frontBoxBig / 2.0, frontBoxBigW - frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, layerSquare);
        GArea boxFbig2 = new GArea(new Rect(-(frontBoxBig -= 4.0 * frontBoxBigW) / 2.0, -frontBoxBig / 2.0, frontBoxBig / 2.0, frontBoxBig / 2.0, layerSquare), layerSquare);
        Rect boxFsmall2 = new Rect(frontBoxBigW - frontBoxBig / 2.0, frontBoxBigW - frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, -frontBoxBigW + frontBoxBig / 2.0, layerSquare);
        GArea crossBoxSmall = AlignmentMarks.createAlignCross(frontBoxBig / 2.0, 2.0 * frontBoxBigW, layerSquare);
        boxFbig1.subtract(boxFsmall1);
        boxFbig2.subtract(boxFsmall2);
        boxFbig2.subtract(crossBoxSmall);
        gaAL.add(crossB);
        gaAL.add(crossF);
        gaAL.add(boxFbig1);
        gaAL.add(boxFbig2);
        return gaAL;
    }

    public static GArea createAlignVerniers(double w, double pitch, int layerVern, double rotate) {
        double Llong = 40.0;
        double Lmid = 30.0;
        double Lshort = 20.0;
        GArea g1 = new GArea();
        Area tmpA = new Area();
        Area a = new Area();
        for (int i = -10; i <= 10; ++i) {
            double tmpL = i % 5 == 0 ? Lmid : Lshort;
            tmpL = i == 0 ? Llong : tmpL;
            g1.or(new Rect((double)i * (w + pitch), 0.0, (double)i * (w + pitch) + w, tmpL, 4), 4);
            tmpA = new Area(g1.getArea());
            a.add(tmpA);
        }
        g1 = new GArea(a, layerVern);
        g1.transform(AffineTransform.getTranslateInstance(-w / 2.0, 0.0));
        g1.transform(AffineTransform.getRotateInstance(rotate, 0.0, 0.0));
        return g1;
    }

    public static GArea createAlignLabel(int labelLayer, double xT, double yT) {
        String s = "" + labelLayer;
        Font f = new Font("Serif", 0, 1000);
        Text lb = new Text(s, labelLayer, f);
        lb.setFontSize(40.0);
        lb.setRenderReso(0.1);
        Area a = new Area(lb.getArea());
        Rectangle2D rec = a.getBounds2D();
        a.transform(AffineTransform.getTranslateInstance(xT - rec.getCenterX(), yT - rec.getCenterY()));
        GArea g = new GArea(a, labelLayer);
        return g;
    }

    public static void addAlignGAreas(Struct s, ArrayList<GArea> alGA) {
        for (int i = 0; i < alGA.size(); ++i) {
            s.add(alGA.get(i));
        }
    }

    public static GArea createAlignRotate90GAreas(GArea g) {
        GArea gTmp = new GArea(g);
        for (int i = 1; i < 4; ++i) {
            gTmp.transform(AffineTransform.getRotateInstance((double)i * Math.PI / 2.0, 0.0, 0.0));
            g.or(gTmp);
        }
        return g;
    }

    public static GArea createAlignInverse(double L, double W, GArea g, int layerA) {
        GArea gtmp = new GArea(new Rect(-L / 2.0, -W / 2.0, L / 2.0, W / 2.0, layerA), layerA);
        gtmp.subtract(g);
        return gtmp;
    }
}

