/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.basicShapes;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.processShapes.ShapeProcessor;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.Spirals;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class SpiralsController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfS;
    @FXML
    private TextField tfA;
    @FXML
    private TextField tfB;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfTurns;
    @FXML
    private TextField tfIncrement;
    @FXML
    private ComboBox<String> cbSpiralType;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Spirals Module", "Spirals module is used to create Archimedes, Fermat and Logarithmic spirals.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(SpiralsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double x = Double.parseDouble(this.tfPosX.getText());
        double y = Double.parseDouble(this.tfPosY.getText());
        double w = Double.parseDouble(this.tfWidth.getText());
        double s = Double.parseDouble(this.tfS.getText());
        double a = Double.parseDouble(this.tfA.getText());
        double b = Double.parseDouble(this.tfB.getText());
        double increment = Double.parseDouble(this.tfIncrement.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        int turns = Integer.parseInt(this.tfTurns.getText());
        String fileName = this.tfFileName.getText();
        String spiralType = (String)this.cbSpiralType.getValue();
        Lib lib = new Lib();
        Struct top = new Struct("top");
        switch (spiralType) {
            case "Archimedes": {
                top.add(new Ref(ShapeProcessor.createStruct(Spirals.spiralArchimedes(w, turns, s, increment, layer), spiralType), x, y));
                break;
            }
            case "Fermat": {
                top.add(new Ref(ShapeProcessor.createStruct(Spirals.spiralFermat(w, turns, a, increment, layer), spiralType), x, y));
                break;
            }
            case "Logarithmic": {
                top.add(new Ref(ShapeProcessor.createStruct(Spirals.spiralLogarithmic(w, turns, a, b, increment, layer), spiralType), x, y));
            }
        }
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        System.out.println(" Saved to " + f.getAbsolutePath());
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

