/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.basicShapes;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class BullsEyeController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfSides;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfRadMid;
    @FXML
    private TextField tfPitch;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfAngStart;
    @FXML
    private TextField tfAngEnd;
    @FXML
    private TextField tfPosX;
    @FXML
    private TextField tfPosY;
    @FXML
    private TextField tfRings;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Grating Coupler - Bulls Eye Module", "Grating coupler (limited sweep angle) - bulls eye (0 to 360 degree sweep angle) module employs a torus method to generate arrays of ring structures. Vertices of the inner andouter periphery of the structures is defined by the 'Sides' parameter. Shapes are generated and stored into the 'top' cell centered at a user defined position. The module is useful for creating grating couplers most commonly encountered in nanophotonic applications.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(BullsEyeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double x = Double.parseDouble(this.tfPosX.getText());
        double y = Double.parseDouble(this.tfPosY.getText());
        double r = Double.parseDouble(this.tfRadMid.getText());
        double w = Double.parseDouble(this.tfWidth.getText());
        double pitch = Double.parseDouble(this.tfPitch.getText());
        double angleStart = Double.parseDouble(this.tfAngStart.getText());
        double angleEnd = Double.parseDouble(this.tfAngEnd.getText());
        int rings = Integer.parseInt(this.tfRings.getText());
        int numSides = Integer.parseInt(this.tfSides.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        Struct top = new Struct("top");
        GArea ga = new GArea();
        for (int i = 0; i < rings; ++i) {
            ga = new GArea(PrimitiveShapes.createTorusW(x, y, r + (double)i * pitch, w, angleStart, angleEnd, numSides, layer));
            top.add(ga);
        }
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) throws IOException {
        AboutActions.showAbout(this.about);
    }
}

