/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class BinaryZonePlatesController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfWavelength;
    @FXML
    private TextField tfFocalLength;
    @FXML
    private TextField tfNumberOfZones;
    @FXML
    private TextField tfSides;
    @FXML
    private TextField tfLayer;
    @FXML
    private CheckBox chbLayers;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Binary Zone Plate Module", "This module creates a binary zone plates using the user defined wavelength and focal length parameters.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(BinaryZonePlatesController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        int i;
        double wavelength = Double.parseDouble(this.tfWavelength.getText());
        wavelength *= 1.0E-9;
        double focalLength = Double.parseDouble(this.tfFocalLength.getText());
        int sides = Integer.parseInt(this.tfSides.getText());
        int numZones = Integer.parseInt(this.tfNumberOfZones.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String fileName = this.tfFileName.getText();
        double[] zPlateArray = new double[numZones * 2];
        Lib lib = new Lib();
        Struct top = new Struct("top");
        for (i = 0; i < zPlateArray.length; ++i) {
            double rn = Math.sqrt((double)i * wavelength * focalLength + (double)(i * i) * wavelength * wavelength / 4.0);
            zPlateArray[i] = rn / 1.0E-6;
        }
        top.add(new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, zPlateArray[1], zPlateArray[1], sides, this.chbLayers.isSelected() ? 0 : layer)));
        for (i = 0; i < numZones; ++i) {
            top.add(new GArea(PrimitiveShapes.createTorus(0.0, 0.0, zPlateArray[i * 2], zPlateArray[i * 2 + 1], 0.0, 360.0, sides, this.chbLayers.isSelected() ? i % 256 : layer)));
        }
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

