/*
 * Decompiled with CFR 0.152.
 */
package PartLib;

import JGDS2.Array;
import JGDS2.BarCode;
import JGDS2.Const;
import JGDS2.Constants;
import JGDS2.GArea;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PartsLib
implements Const,
Constants {
    public static Struct Vern(int layer1, int layer2, double reso, int ticks, String label1, String label2) {
        Struct vern = new Struct("$v" + layer1 + "to" + layer2 + label1 + label2 + Struct.val(reso) + ticks);
        Struct vernHv = new Struct("$vHv" + layer1 + "to" + layer2 + Struct.val(reso) + ticks);
        Struct vb1 = new Struct("$vb" + layer1, new RectArea(-0.5, 0.0, 0.5, 5.0, layer1));
        Struct vb2 = new Struct("$vb" + layer2, new RectArea(-0.5, 0.0, 0.5, 5.0, layer2));
        vernHv.add(new Array(vb1, 0.0, 0.0, ticks, 1, 2 * ticks, 1.0));
        vernHv.add(new Array(vb2, 0.0, -5.0, ticks, 1, (double)(2 * ticks) * (1.0 - reso), 1.0));
        for (int i = 0; i < ticks - 1; ++i) {
            double offset = (i % 2 == 0 ? 1 : 0) + (i % 4 == 0 ? 1 : 0) + (i % 8 == 0 ? 1 : 0) + (i % 16 == 0 ? 2 : 0) + (i % 32 == 0 ? 2 : 0);
            vernHv.add(new Ref(vb1, i * 2, offset));
            vernHv.add(new Ref(vb2, (double)(i * 2) * (1.0 - reso), -5.0 - offset));
        }
        vern.add(new Ref(vernHv, 0.0, 0.0));
        vern.add(new Ref(vernHv, 0.0, 0.0, 32768, 0.0, 180.0));
        vern.add(new Ref(new Struct("$vt" + layer1 + label1 + label2 + Struct.val(reso) + ticks, new Text(label1, layer1, 10.0)), 4.0, 10.0));
        vern.add(new Ref(new Struct("$vt" + layer2 + label1 + label2 + Struct.val(reso) + ticks, new Text(label2, layer2, 10.0)), 4.0, -16.0));
        return vern;
    }

    public static Struct frame(int tool, String barcode, String label, String font) {
        return PartsLib.frame(tool, barcode, label, font, false);
    }

    public static Struct frame(int tool, String barcode, String label, String font, boolean rotatable, boolean barcodeText) {
        String[] bc = new String[]{barcode + "r1", barcode + "r2", barcode + "r3", barcode + "r4"};
        String[] lb = new String[]{label + "r1", label + "r2", label + "r3", label + "r4"};
        return PartsLib.frame(tool, bc, lb, font, rotatable, barcodeText);
    }

    public static Struct frame(int tool, String[] barcode, String[] label, String font, boolean rotatable, boolean barcodeText) {
        Struct top;
        if (tool != 1) {
            rotatable = false;
        }
        if (rotatable) {
            top = new Struct("$frameTop");
            top.add(new Ref(PartsLib.frame(tool, barcode[0], label[0], font, barcodeText), 0.0, -1750.0));
            top.add(new Ref(PartsLib.frame(tool, barcode[1], label[1], font, barcodeText), 1750.0, 0.0, 0, 90.0));
            top.add(new Ref(PartsLib.frame(tool, barcode[2], label[2], font, barcodeText), 0.0, 1750.0, 0, 180.0));
            top.add(new Ref(PartsLib.frame(tool, barcode[3], label[3], font, barcodeText), -1750.0, 0.0, 0, 270.0));
        } else {
            top = PartsLib.frame(tool, barcode[0], label[0], font, barcodeText);
        }
        return top;
    }

    public static Struct frame(int tool, String barcode, String label, String font, boolean barcodeText) {
        Struct f = new Struct("$frame" + label);
        switch (tool) {
            case 1: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("$preAlign", pr);
                Struct line = new Struct("$l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("$l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("$al", new Array(line, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("$al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("$Mx", m);
                String bcText = barcode.substring(0, barcode.length() < 12 ? barcode.length() : 12);
                BarCode bc = new BarCode(bcText, 1, 1, barcodeText);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -BARCODE[tool][67] / 2L));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("$barcode" + bc, new GArea(a, 1));
                Text lb = new Text(label.substring(0, label.length() < 14 ? label.length() : 14), 1, 3500.0);
                lb.setFont(font);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                GArea lab = new GArea(a, 1);
                lab.setRenderReso(35.0);
                Struct lbl = new Struct("$label" + label, lab);
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
                break;
            }
            case 0: {
                Struct line = new Struct("$l", new RectArea(30.0, 10.0, 285.0, 20.0, 1));
                Struct al = new Struct("$al", new Array(line, 0.0, 0.0, 1, 10, 1.0, 300.0));
                Struct sqr = new Struct("$sqr", new RectArea(-1000.0, -1000.0, 1000.0, 1000.0, 1));
                Struct mx = new Struct("$Mx");
                mx.add(new Ref(al, 0.0, 0.0));
                mx.add(new Ref(al, 0.0, 0.0, 0, 90.0));
                mx.add(new Ref(al, 0.0, 0.0, 0, 180.0));
                mx.add(new Ref(al, 0.0, 0.0, 0, 270.0));
                Struct sqr2 = new Struct("$sqr2", new RectArea(12.5, 12.5, 312.5, 312.5, 1));
                Struct m2 = new Struct("$M2");
                m2.add(new Ref(sqr2, 0.0, 0.0));
                m2.add(new Ref(sqr2, 0.0, 0.0, 0, 90.0));
                m2.add(new Ref(sqr2, 0.0, 0.0, 0, 180.0));
                m2.add(new Ref(sqr2, 0.0, 0.0, 0, 270.0));
                BarCode bc = new BarCode(barcode.substring(0, barcode.length() < 10 ? barcode.length() : 10), 0, 1, barcodeText);
                Struct brcd = new Struct("$barcode", bc);
                Text lb = new Text(label.substring(0, label.length() < 10 ? label.length() : 10), 1, 2500.0);
                lb.setFont(font);
                Struct lbl = new Struct("$label", lb);
                f.add(new Ref(mx, -48000.0, 0.0));
                f.add(new Ref(mx, 48000.0, 0.0));
                f.add(new Ref(mx, 0.0, 48000.0));
                f.add(new Ref(mx, 0.0, -48000.0));
                f.add(new Ref(m2, 51500.0, 0.0));
                f.add(new Ref(m2, -51500.0, 0.0));
                f.add(new Ref(sqr, 0.0, 57500.0));
                f.add(new Ref(sqr, 0.0, -57500.0));
                f.add(new Ref(sqr, -11000.0, 57500.0));
                f.add(new Ref(brcd, -50000.0, 56000.0));
                f.add(new Ref(lbl, -50000.0, -58500.0));
                break;
            }
            case 2: {
                Text lb = new Text(label, 1, 3500.0);
                lb.setFont(font);
                Struct lbl = new Struct("$label", lb);
                Area a = new Area(lbl.getArea());
                Rectangle2D rec = a.getBounds2D();
                f.add(new Ref(lbl, -rec.getCenterX(), -58500.0));
            }
        }
        return f;
    }

    static GArea arc(double startAng, double delAng, double inRad, double outRad, int pointsPerRev) {
        double points = Math.ceil((double)pointsPerRev * delAng / 360.0);
        startAng = startAng * Math.PI / 180.0;
        delAng = delAng * Math.PI / 180.0;
        double incr = delAng / points;
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        int i = 0;
        while ((double)i <= points) {
            double x1 = outRad * Math.cos(startAng + incr * (double)i);
            double y1 = outRad * Math.sin(startAng + incr * (double)i);
            double x2 = inRad * Math.cos(startAng + incr * (double)i);
            double y2 = inRad * Math.sin(startAng + incr * (double)i);
            if (i == 0) {
                pathOut.moveTo(x1, y1);
                pathBack.moveTo(x2, y2);
            } else {
                pathOut.lineTo(x1, y1);
                pathBack.lineTo(x2, y2);
            }
            ++i;
        }
        pathOut.append(GArea.reversePath(pathBack), true);
        pathOut.closePath();
        return new GArea(pathOut, 1);
    }

    static Struct arcStruct(double startAng, double delAng, double inRad, double outRad, int pointsPerRev) {
        double points = Math.ceil((double)pointsPerRev * delAng / 360.0);
        startAng = startAng * Math.PI / 180.0;
        delAng = delAng * Math.PI / 180.0;
        double incr = delAng / points;
        System.out.println("point " + points + " incr " + incr);
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        Struct spr = new Struct("$arc" + Math.ceil((startAng * 7.0 + delAng * 13.0 + inRad * 11.0 + outRad * 17.0 + (double)pointsPerRev) * 100.0));
        int i = 0;
        while ((double)i <= points) {
            double x1 = outRad * Math.cos(startAng + incr * (double)i);
            double y1 = outRad * Math.sin(startAng + incr * (double)i);
            double x2 = inRad * Math.cos(startAng + incr * (double)i);
            double y2 = inRad * Math.sin(startAng + incr * (double)i);
            if (i == 0) {
                pathOut.moveTo(x1, y1);
                pathBack.moveTo(x2, y2);
            } else {
                pathOut.lineTo(x1, y1);
                pathBack.lineTo(x2, y2);
            }
            ++i;
        }
        pathOut.append(GArea.reversePath(pathBack), true);
        pathOut.closePath();
        spr.add(new GArea(pathOut, 1));
        return spr;
    }

    public static GArea torus(Point2D.Double loc, double inSize, double outSize, int points, int layer) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(loc.x + inSize, loc.y);
        double delta = Math.PI * 2 / (double)points;
        for (i = 1; i < points; ++i) {
            poly.lineTo(loc.x + inSize * Math.cos((double)i * delta), loc.y + inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(loc.x + inSize, loc.y);
        poly.moveTo(loc.x + outSize, loc.y);
        for (i = points - 1; i > 0; --i) {
            poly.lineTo(loc.x + outSize * Math.cos((double)i * delta), loc.y + outSize * Math.sin((double)i * delta));
        }
        poly.moveTo(loc.x + outSize, loc.y);
        poly.moveTo(loc.x + inSize, loc.y);
        poly.closePath();
        return new GArea(poly, layer);
    }

    public static GArea torus(double inSize, double outSize, int points, int layer) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(inSize, 0.0);
        double delta = Math.PI * 2 / (double)points;
        for (i = 1; i < points; ++i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(inSize, 0.0);
        poly.moveTo(outSize, 0.0);
        for (i = points - 1; i > 0; --i) {
            poly.lineTo(outSize * Math.cos((double)i * delta), outSize * Math.sin((double)i * delta));
        }
        poly.moveTo(outSize, 0.0);
        poly.moveTo(inSize, 0.0);
        poly.closePath();
        return new GArea(poly, layer);
    }

    public static GArea circle(double outSize, int points, int layer) {
        Path2D.Double poly = new Path2D.Double();
        double delta = Math.PI * 2 / (double)points;
        poly.moveTo(outSize, 0.0);
        for (int i = points - 1; i > 0; --i) {
            poly.lineTo(outSize * Math.cos((double)i * delta), outSize * Math.sin((double)i * delta));
        }
        poly.moveTo(outSize, 0.0);
        poly.closePath();
        return new GArea(poly, layer);
    }
}

